/*
  Copyright (C) 2000-2007

  Code contributed by Greg Collecutt, Joseph Hope and the xmds-devel team

  This file is part of xmds.

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

/*
  $Id: xmds_integrate_si.h 1507 2007-08-15 09:47:34Z paultcochrane $
*/

/*! @file xmds_integrate_si.h
  @brief 

  More detailed explanation...
*/

#ifndef XMDS_INTEGRATE_SI_H
#define XMDS_INTEGRATE_SI_H

#include <xmds_integrate.h>

// *****************************************************************************
// *****************************************************************************
//                              xmdsIntegrateSI
// *****************************************************************************
// *****************************************************************************

//! Class to integrate equations using the semi-implicit method
class xmdsIntegrateSI : public virtual xmdsIntegrate {

  public :

    //! Constructor of xmdsIntegrateSI object
    xmdsIntegrateSI(
        const xmdsSimulation *const yourSimulation,
        const bool& yourVerboseMode);

  //! Destructor
  ~xmdsIntegrateSI();

  //! Processes the element
  void processElement(
                      const Element *const yourElement);

  protected :

    //! Returns the number of iterations
    unsigned long nIterations() const;

  private :

    unsigned long mynIterations;  //!< The number of iterations to be performed
};


#endif // XMDS_INTEGRATE_SI_H
