#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <glib.h>

int main(int argc, char **argv) {
  GOptionContext *context;
  GError *error = NULL;

  char *display = NULL;
  int screen = 0;
  char **filenames = NULL;

  Display *dpy;
  Atom icc_atom;
  char *profile;
  gsize length;


  const GOptionEntry entries[] = {
    { "display", 'd', 0, G_OPTION_ARG_STRING, &display, "X display to use", "DISPLAY" },
    { "screen", 's', 0, G_OPTION_ARG_INT, &screen, "X screen to use", "SCREEN" },
    { G_OPTION_REMAINING, '\0', 0, G_OPTION_ARG_FILENAME_ARRAY, &filenames, "ICC profile to set", "PROFILE" },
    { NULL }
  };

  context = g_option_context_new ("- set an ICC profile on a screen");
  g_option_context_add_main_entries (context, entries, NULL /*GETTEXT_PACKAGE*/);
  g_option_context_parse (context, &argc, &argv, &error);

  if (filenames == NULL || g_strv_length (filenames) != 1) {
    g_printerr("Specify a single ICC profile to set\n");
    return 1;
  }

  dpy = XOpenDisplay(display);
  if (dpy == NULL) {
    g_printerr("Cannot open display\n");
    return 2;
  }

  icc_atom = XInternAtom (dpy, "_ICC_PROFILE", False);
  if (icc_atom == None) {
    g_printerr("Cannot intern atom\n");
    return 3;
  }

  if (!g_file_get_contents (filenames[0], &profile, &length, &error)) {
    g_printerr("Cannot read profile: %s\n", error->message);
    g_error_free (error);
    return 4;
  }

  XChangeProperty (dpy, RootWindow (dpy, screen), icc_atom, XA_CARDINAL, 8, PropModeReplace, profile, length);

  XCloseDisplay (dpy);
  return 0;
}
