/**
 * PreImage.java
 *
 * Created on Jul 10, 2006
 */
package maths;

/**
 * Cette classe implemente la preimage d'un ensemble <code>A</code> par une
 * application <code>f</code>.
 *
 * @author Nicolae
 */
public class PreImage extends DefaultSet {

	private Set A;
	private Map f;
	private double val[] = new double[2];
	
	/**
	 * Cache le constructor standard.
	 */
	private PreImage() {}
	
	
	/**
	 * Constructor qui initialise l'application et l'ensemble.
	 *
	 * @param A ensemble.
	 * @param B ensemble.
	 */
	public PreImage(Map f, Set A) {
		this.f = f;
		this.A = A;
	}
	
	/* (non-Javadoc)
	 * @see maths.DefaultSet#contains(double, double)
	 */
	public boolean contains(double re, double im) {
		f.value(re, im, val);
		
		return A.contains(val[0], val[1]);
	}
}
