/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.packet;

import java.io.IOException;
import net.tinyos.packet.PacketSource;
import net.tinyos.util.Messenger;

public abstract class AbstractSource
implements PacketSource {
    protected String name;
    protected boolean opened = false;
    protected Messenger messages;

    protected void message(String string) {
        if (this.messages != null) {
            this.messages.message(string);
        }
    }

    protected AbstractSource(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void open(Messenger messenger) throws IOException {
        if (this.opened) {
            throw new IOException("already open");
        }
        this.messages = messenger;
        this.openSource();
        this.opened = true;
    }

    public synchronized void close() throws IOException {
        if (this.opened) {
            this.opened = false;
            this.closeSource();
        }
    }

    protected void failIfClosed() throws IOException {
        if (!this.opened) {
            throw new IOException("closed");
        }
    }

    public byte[] readPacket() throws IOException {
        this.failIfClosed();
        try {
            return this.check(this.readSourcePacket());
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    public synchronized boolean writePacket(byte[] byArray) throws IOException {
        this.failIfClosed();
        try {
            return this.writeSourcePacket(this.check(byArray));
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    protected byte[] check(byte[] byArray) throws IOException {
        return byArray;
    }

    protected abstract void openSource() throws IOException;

    protected abstract void closeSource() throws IOException;

    protected abstract byte[] readSourcePacket() throws IOException;

    protected boolean writeSourcePacket(byte[] byArray) throws IOException {
        return true;
    }
}

