package cc

import "encoding/binary"

// abiByteOrders contains byte order information for known architectures.
var abiByteOrders = map[string]binary.ByteOrder{
	"amd64": binary.LittleEndian,
	"386":   binary.LittleEndian,
	"arm":   binary.LittleEndian,
	"arm64": binary.LittleEndian,
}

// abiTypes contains size and alignment information for known OS/arch pairs.
//
// The content is generated by ./cmd/cabi/main.c.
var abiTypes = map[[2]string]map[Kind]ABIType{
	// Linux, generated by GCC 8.3.0
	{"linux", "amd64"}: {
		Void:       {1, 1, 1},
		Bool:       {1, 1, 1},
		Char:       {1, 1, 1},
		SChar:      {1, 1, 1},
		UChar:      {1, 1, 1},
		Short:      {2, 2, 2},
		UShort:     {2, 2, 2},
		Enum:       {4, 4, 4},
		Int:        {4, 4, 4},
		UInt:       {4, 4, 4},
		Long:       {8, 8, 8},
		ULong:      {8, 8, 8},
		LongLong:   {8, 8, 8},
		ULongLong:  {8, 8, 8},
		Ptr:        {8, 8, 8},
		Function:   {8, 8, 8},
		Float:      {4, 4, 4},
		Double:     {8, 8, 8},
		LongDouble: {16, 16, 16},
		Int8:       {1, 1, 1},
		UInt8:      {1, 1, 1},
		Int16:      {2, 2, 2},
		UInt16:     {2, 2, 2},
		Int32:      {4, 4, 4},
		UInt32:     {4, 4, 4},
		Int64:      {8, 8, 8},
		UInt64:     {8, 8, 8},
		Int128:     {16, 16, 16},
		UInt128:    {16, 16, 16},
		Float32:    {4, 4, 4},
		Float32x:   {8, 8, 8},
		Float64:    {8, 8, 8},
		Float64x:   {16, 16, 16},
		Float128:   {16, 16, 16},
		Decimal32:  {4, 4, 4},
		Decimal64:  {8, 8, 8},
		Decimal128: {16, 16, 16},
	},
	{"linux", "386"}: {
		Void:       {1, 1, 1},
		Bool:       {1, 1, 1},
		Char:       {1, 1, 1},
		SChar:      {1, 1, 1},
		UChar:      {1, 1, 1},
		Short:      {2, 2, 2},
		UShort:     {2, 2, 2},
		Enum:       {4, 4, 4},
		Int:        {4, 4, 4},
		UInt:       {4, 4, 4},
		Long:       {4, 4, 4},
		ULong:      {4, 4, 4},
		LongLong:   {8, 4, 4},
		ULongLong:  {8, 4, 4},
		Ptr:        {4, 4, 4},
		Function:   {4, 4, 4},
		Float:      {4, 4, 4},
		Double:     {8, 4, 4},
		LongDouble: {12, 4, 4},
		Int8:       {1, 1, 1},
		UInt8:      {1, 1, 1},
		Int16:      {2, 2, 2},
		UInt16:     {2, 2, 2},
		Int32:      {4, 4, 4},
		UInt32:     {4, 4, 4},
		Int64:      {8, 4, 4},
		UInt64:     {8, 4, 4},
		Float32:    {4, 4, 4},
		Float32x:   {8, 4, 4},
		Float64:    {8, 4, 4},
		Float64x:   {12, 4, 4},
		Float128:   {16, 16, 16},
		Decimal32:  {4, 4, 4},
		Decimal64:  {8, 8, 8},
		Decimal128: {16, 16, 16},
	},
	{"linux", "arm"}: {
		Void:       {1, 1, 1},
		Bool:       {1, 1, 1},
		Char:       {1, 1, 1},
		SChar:      {1, 1, 1},
		UChar:      {1, 1, 1},
		Short:      {2, 2, 2},
		UShort:     {2, 2, 2},
		Enum:       {4, 4, 4},
		Int:        {4, 4, 4},
		UInt:       {4, 4, 4},
		Long:       {4, 4, 4},
		ULong:      {4, 4, 4},
		LongLong:   {8, 8, 8},
		ULongLong:  {8, 8, 8},
		Ptr:        {4, 4, 4},
		Function:   {4, 4, 4},
		Float:      {4, 4, 4},
		Double:     {8, 8, 8},
		LongDouble: {8, 8, 8},
		Int8:       {1, 1, 1},
		UInt8:      {1, 1, 1},
		Int16:      {2, 2, 2},
		UInt16:     {2, 2, 2},
		Int32:      {4, 4, 4},
		UInt32:     {4, 4, 4},
		Int64:      {8, 8, 8},
		UInt64:     {8, 8, 8},
	},
	{"linux", "arm64"}: {
		Void:       {1, 1, 1},
		Bool:       {1, 1, 1},
		Char:       {1, 1, 1},
		SChar:      {1, 1, 1},
		UChar:      {1, 1, 1},
		Short:      {2, 2, 2},
		UShort:     {2, 2, 2},
		Enum:       {4, 4, 4},
		Int:        {4, 4, 4},
		UInt:       {4, 4, 4},
		Long:       {8, 8, 8},
		ULong:      {8, 8, 8},
		LongLong:   {8, 8, 8},
		ULongLong:  {8, 8, 8},
		Ptr:        {8, 8, 8},
		Function:   {8, 8, 8},
		Float:      {4, 4, 4},
		Double:     {8, 8, 8},
		LongDouble: {16, 16, 16},
		Int8:       {1, 1, 1},
		UInt8:      {1, 1, 1},
		Int16:      {2, 2, 2},
		UInt16:     {2, 2, 2},
		Int32:      {4, 4, 4},
		UInt32:     {4, 4, 4},
		Int64:      {8, 8, 8},
		UInt64:     {8, 8, 8},
		Int128:     {16, 16, 16},
		UInt128:    {16, 16, 16},
	},
	// $ x86_64-w64-mingw32-gcc main.c && wine a.exe
	{"windows", "amd64"}: {
		Void:       {1, 1, 1},
		Bool:       {1, 1, 1},
		Char:       {1, 1, 1},
		SChar:      {1, 1, 1},
		UChar:      {1, 1, 1},
		Short:      {2, 2, 2},
		UShort:     {2, 2, 2},
		Enum:       {4, 4, 4},
		Int:        {4, 4, 4},
		UInt:       {4, 4, 4},
		Long:       {4, 4, 4},
		ULong:      {4, 4, 4},
		LongLong:   {8, 8, 8},
		ULongLong:  {8, 8, 8},
		Ptr:        {8, 8, 8},
		Function:   {8, 8, 8},
		Float:      {4, 4, 4},
		Double:     {8, 8, 8},
		LongDouble: {16, 16, 16},
		Int8:       {1, 1, 1},
		UInt8:      {1, 1, 1},
		Int16:      {2, 2, 2},
		UInt16:     {2, 2, 2},
		Int32:      {4, 4, 4},
		UInt32:     {4, 4, 4},
		Int64:      {8, 8, 8},
		UInt64:     {8, 8, 8},
		Int128:     {16, 16, 16},
		UInt128:    {16, 16, 16},
		Float32:    {4, 4, 4},
		Float32x:   {8, 8, 8},
		Float64:    {8, 8, 8},
		Float64x:   {16, 16, 16},
		Float128:   {16, 16, 16},
		Decimal32:  {4, 4, 4},
		Decimal64:  {8, 8, 8},
		Decimal128: {16, 16, 16},
	},
	// $ i686-w64-mingw32-gcc main.c && wine a.exe
	{"windows", "386"}: {
		Void:       {1, 1, 1},
		Bool:       {1, 1, 1},
		Char:       {1, 1, 1},
		SChar:      {1, 1, 1},
		UChar:      {1, 1, 1},
		Short:      {2, 2, 2},
		UShort:     {2, 2, 2},
		Enum:       {4, 4, 4},
		Int:        {4, 4, 4},
		UInt:       {4, 4, 4},
		Long:       {4, 4, 4},
		ULong:      {4, 4, 4},
		LongLong:   {8, 8, 8},
		ULongLong:  {8, 8, 8},
		Ptr:        {4, 4, 4},
		Function:   {4, 4, 4},
		Float:      {4, 4, 4},
		Double:     {8, 8, 8},
		LongDouble: {12, 4, 4},
		Int8:       {1, 1, 1},
		UInt8:      {1, 1, 1},
		Int16:      {2, 2, 2},
		UInt16:     {2, 2, 2},
		Int32:      {4, 4, 4},
		UInt32:     {4, 4, 4},
		Int64:      {8, 8, 8},
		UInt64:     {8, 8, 8},
		Float32:    {4, 4, 4},
		Float32x:   {8, 8, 8},
		Float64:    {8, 8, 8},
		Float64x:   {12, 4, 4},
		Float128:   {16, 16, 16},
		Decimal32:  {4, 4, 4},
		Decimal64:  {8, 8, 8},
		Decimal128: {16, 16, 16},
	},
	{"darwin", "amd64"}: {
		Void:       {1, 1, 1},
		Bool:       {1, 1, 1},
		Char:       {1, 1, 1},
		SChar:      {1, 1, 1},
		UChar:      {1, 1, 1},
		Short:      {2, 2, 2},
		UShort:     {2, 2, 2},
		Enum:       {4, 4, 4},
		Int:        {4, 4, 4},
		UInt:       {4, 4, 4},
		Long:       {8, 8, 8},
		ULong:      {8, 8, 8},
		LongLong:   {8, 8, 8},
		ULongLong:  {8, 8, 8},
		Ptr:        {8, 8, 8},
		Function:   {8, 8, 8},
		Float:      {4, 4, 4},
		Double:     {8, 8, 8},
		LongDouble: {16, 16, 16},
		Int8:       {1, 1, 1},
		UInt8:      {1, 1, 1},
		Int16:      {2, 2, 2},
		UInt16:     {2, 2, 2},
		Int32:      {4, 4, 4},
		UInt32:     {4, 4, 4},
		Int64:      {8, 8, 8},
		UInt64:     {8, 8, 8},
		Int128:     {16, 16, 16},
		UInt128:    {16, 16, 16},
	},
	{"darwin", "arm64"}: {
		Void:       {1, 1, 1},
		Bool:       {1, 1, 1},
		Char:       {1, 1, 1},
		SChar:      {1, 1, 1},
		UChar:      {1, 1, 1},
		Short:      {2, 2, 2},
		UShort:     {2, 2, 2},
		Enum:       {4, 4, 4},
		Int:        {4, 4, 4},
		UInt:       {4, 4, 4},
		Long:       {8, 8, 8},
		ULong:      {8, 8, 8},
		LongLong:   {8, 8, 8},
		ULongLong:  {8, 8, 8},
		Ptr:        {8, 8, 8},
		Function:   {8, 8, 8},
		Float:      {4, 4, 4},
		Double:     {8, 8, 8},
		LongDouble: {8, 8, 8},
		Int8:       {1, 1, 1},
		UInt8:      {1, 1, 1},
		Int16:      {2, 2, 2},
		UInt16:     {2, 2, 2},
		Int32:      {4, 4, 4},
		UInt32:     {4, 4, 4},
		Int64:      {8, 8, 8},
		UInt64:     {8, 8, 8},
		Int128:     {16, 16, 16},
		UInt128:    {16, 16, 16},
	},
}
