///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// animations using gnuplot
//
// author: Pierre.Saramito@imag.fr
//
// date: 17 november 2002
//
/*
    From gnuplot-FAQ:
    Q6.8: How do I call gnuplot from my own programs?
          Here's code which works for a UNIX system, using (efficient) named pipes.

   	In gnuplot 3.7, this can be greatly simplified, since data can
	be fed 'inline, as in

	plot '-' w l
		1 1
		2 3
		3 4
		e
*/

#include "rheolef/branch.h"
#include "rheolef/pstream.h"
namespace rheolef {
using namespace std;

// ====================================================
// yet hard-coded ! TODO: use a -select-contour option
// ====================================================
static int coutour_index = 0;

void
branch::put_header_gnuplot (ostream& out) const
{
    delete_macro (_p_data_out);
    string basename = iorheo::getbasename(out);
    if (basename == "") basename = "output";
    bool verbose = iorheo::getverbose(clog);
    bool execute = iorheo::getexecute(clog);
    if (execute) {
	_p_data_out = new_macro (opstream("gnuplot -persist"));
        verbose && clog << "! pipe `gnuplot -persist' created" << endl;
    } else {
	string file_name = basename + ".plot";
	_p_data_out = new_macro (ofstream(file_name.c_str()));
        verbose && clog << "! file `" << file_name << "' created" << endl;
    }
    *_p_data_out << setbasename(basename)
                 << setprecision(numeric_limits<Float>::digits10);
}
void 
branch::put_event_gnuplot (ostream& out) const
{
    const string& uname  = operator[](coutour_index).first;
    const field&  u      = operator[](coutour_index).second;
    check_macro (u.get_approx() == "P1", "unsupported " << u.get_approx()
	<< " field");

    // TODO: P0, P1d, P2... recycler field::gnuplo1d() dans "field-mtv.cc"
    // P1 is buggy if edges are not ordered from left to right...
    geo::const_iterator_node x  = u.get_geo().begin_node();
    geo::size_type           nx = u.get_geo().n_node();

    *_p_data_out << "plot '-' w l" << endl;
    for (size_type i = 0; i < nx; i++) {
        *_p_data_out << x[i][0] << " " << u.at(i) << endl;
    }
    *_p_data_out << "e" << endl
                 << "pause 1" << endl
                 << flush;
}
void 
branch::put_finalize_gnuplot (ostream& out) const
{
    // is the destructor virtual : ofstream::~ofstream() or opstream::~opstream() ?
    delete_macro (_p_data_out);
    _p_data_out = 0;
    string basename = iorheo::getbasename(out);
    if (basename == "") basename = "output";
    bool verbose = iorheo::getverbose(clog);
    bool execute = iorheo::getexecute(clog);
    bool clean   = iorheo::getclean(clog);
    if (!execute && clean) {
	string command = "/bin/rm -f " + basename + ".plot";
        verbose && clog << "! " << command << endl;
	int status = system (command.c_str());
    }
}

} // namespace rheolef
