#ifndef _RHEO_GEOREP_BUILD_H
#define _RHEO_GEOREP_BUILD_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

#include "rheolef/geo-connectivity.h"
namespace rheolef { 

template <class ElementContainer, class VertexContainer>
void
georep::build (const ElementContainer& e, const VertexContainer& v) 
{
  resize    (e.size());
  _x.resize (v.size());
  iterator j = begin();
  size_t idx = 0;
  for (typename ElementContainer::const_iterator i = e.begin(); i != e.end(); i++, j++, idx++) {
    (*j).copy (*i);
    (*j).set_index (idx);
  } 
  copy (v.begin(), v.end(), _x.begin());
  _number = std::numeric_limits<size_type>::max();
  _serial_number = std::numeric_limits<size_type>::max();
  // _coord_sys : unchanged
#ifdef HAVE_BUG
  _domlist.resize (0);
#else // HAVE_BUG
  _domlist = domlist_type();
#endif // HAVE_BUG
  domlist_type();
  _save_double_precision = false;
  _version = 1;
  _localizer_initialized = false;
  _boundary.resize(0);
  _boundary_initialized = false;

  // update bbox
  _dim = 3; // will be set from coordinates
  for (size_type j = 0; j < _dim; j++) {
    _xmin[j] =  std::numeric_limits<Float>::max();
    _xmax[j] = -std::numeric_limits<Float>::max();
  }
  for (size_type j = _dim+1; j < 3; j++) {
    _xmin [j] = _xmax [j] = 0;
  }
  for (nodelist_type::const_iterator iter_p = _x.begin(); iter_p != _x.end(); iter_p++) {
    const point& p = *iter_p;
    for (size_type j = 0 ; j < _dim; j++) {
      _xmin[j] = std::min(p[j], _xmin[j]);
      _xmax[j] = std::max(p[j], _xmax[j]);
    }
  }
  if (_xmax[2] == 0 && _xmin[2] == 0) {
    if (_xmax[1] == 0 && _xmin[1] == 0) {
      _dim = 1;
    } else {
      _dim = 2;
    }
  } 
  // update counters
  reset_counters ();
  _count_geo     [0] = n_node();
  _count_element [0] = n_node();
  size_type K_idx = 0;
  for (iterator iter_elt = begin(); iter_elt != end(); iter_elt++, K_idx++) { 
      geo_element& K = *iter_elt;
      K.set_index (K_idx);
      _count_geo    [K.dimension()]++;
      _count_element[K.variant()]++;
  }
  upgrade();
}
}// namespace rheolef
#endif // _RHEO_GEOREP_BUILD_H
