# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2020 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "PeripheralDeviceSlot.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.peripheral

import raritan.rpc.sensors


# enumeration
class PortType(Enumeration):
    idlType = "peripheral.PortType:1.0.0"
    values = ["ONEWIRE_ONBOARD", "ONEWIRE_DEV_PORT", "ONEWIRE_HUB_PORT", "ONEWIRE_CHAIN_POS"]

PortType.ONEWIRE_ONBOARD = PortType(0)
PortType.ONEWIRE_DEV_PORT = PortType(1)
PortType.ONEWIRE_HUB_PORT = PortType(2)
PortType.ONEWIRE_CHAIN_POS = PortType(3)

# structure
class PosElement(Structure):
    idlType = "peripheral.PosElement:1.0.0"
    elements = ["portType", "port"]

    def __init__(self, portType, port):
        typecheck.is_enum(portType, raritan.rpc.peripheral.PortType, AssertionError)
        typecheck.is_string(port, AssertionError)

        self.portType = portType
        self.port = port

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            portType = raritan.rpc.peripheral.PortType.decode(json['portType']),
            port = json['port'],
        )
        return obj

    def encode(self):
        json = {}
        json['portType'] = raritan.rpc.peripheral.PortType.encode(self.portType)
        json['port'] = self.port
        return json

# structure
class DeviceID(Structure):
    idlType = "peripheral.DeviceID:4.0.0"
    elements = ["serial", "type", "isActuator", "channel"]

    def __init__(self, serial, type, isActuator, channel):
        typecheck.is_string(serial, AssertionError)
        typecheck.is_struct(type, raritan.rpc.sensors.Sensor.TypeSpec, AssertionError)
        typecheck.is_bool(isActuator, AssertionError)
        typecheck.is_int(channel, AssertionError)

        self.serial = serial
        self.type = type
        self.isActuator = isActuator
        self.channel = channel

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            serial = json['serial'],
            type = raritan.rpc.sensors.Sensor.TypeSpec.decode(json['type'], agent),
            isActuator = json['isActuator'],
            channel = json['channel'],
        )
        return obj

    def encode(self):
        json = {}
        json['serial'] = self.serial
        json['type'] = raritan.rpc.sensors.Sensor.TypeSpec.encode(self.type)
        json['isActuator'] = self.isActuator
        json['channel'] = self.channel
        return json

# structure
class Address(Structure):
    idlType = "peripheral.Address:4.0.0"
    elements = ["position", "type", "isActuator", "channel"]

    def __init__(self, position, type, isActuator, channel):
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        typecheck.is_struct(type, raritan.rpc.sensors.Sensor.TypeSpec, AssertionError)
        typecheck.is_bool(isActuator, AssertionError)
        typecheck.is_int(channel, AssertionError)

        self.position = position
        self.type = type
        self.isActuator = isActuator
        self.channel = channel

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            position = [raritan.rpc.peripheral.PosElement.decode(x0, agent) for x0 in json['position']],
            type = raritan.rpc.sensors.Sensor.TypeSpec.decode(json['type'], agent),
            isActuator = json['isActuator'],
            channel = json['channel'],
        )
        return obj

    def encode(self):
        json = {}
        json['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in self.position]
        json['type'] = raritan.rpc.sensors.Sensor.TypeSpec.encode(self.type)
        json['isActuator'] = self.isActuator
        json['channel'] = self.channel
        return json

# value object
class Device(ValueObject):
    idlType = "peripheral.Device:3.0.2"

    def __init__(self, deviceID, position, packageClass, device):
        typecheck.is_struct(deviceID, raritan.rpc.peripheral.DeviceID, AssertionError)
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        typecheck.is_string(packageClass, AssertionError)
        typecheck.is_interface(device, raritan.rpc.sensors.Sensor, AssertionError)

        self.deviceID = deviceID
        self.position = position
        self.packageClass = packageClass
        self.device = device

    def encode(self):
        json = {}
        json['deviceID'] = raritan.rpc.peripheral.DeviceID.encode(self.deviceID)
        json['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in self.position]
        json['packageClass'] = self.packageClass
        json['device'] = Interface.encode(self.device)
        return json

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            deviceID = raritan.rpc.peripheral.DeviceID.decode(json['deviceID'], agent),
            position = [raritan.rpc.peripheral.PosElement.decode(x0, agent) for x0 in json['position']],
            packageClass = json['packageClass'],
            device = Interface.decode(json['device'], agent),
        )
        return obj

    def listElements(self):
        elements = ["deviceID", "position", "packageClass", "device"]
        return elements

# interface
class DeviceSlot(Interface):
    idlType = "peripheral.DeviceSlot:2.0.3"

    ERR_INVALID_PARAMS = 1

    ERR_NOT_SUPPORTED = 2

    CHANNEL_INVALID = -1

    # structure
    class Location(Structure):
        idlType = "peripheral.DeviceSlot_2_0_3.Location:1.0.0"
        elements = ["x", "y", "z"]

        def __init__(self, x, y, z):
            typecheck.is_string(x, AssertionError)
            typecheck.is_string(y, AssertionError)
            typecheck.is_string(z, AssertionError)

            self.x = x
            self.y = y
            self.z = z

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                x = json['x'],
                y = json['y'],
                z = json['z'],
            )
            return obj

        def encode(self):
            json = {}
            json['x'] = self.x
            json['y'] = self.y
            json['z'] = self.z
            return json

    # structure
    class Settings(Structure):
        idlType = "peripheral.DeviceSlot_2_0_3.Settings:1.0.0"
        elements = ["name", "description", "location", "useDefaultThresholds", "properties"]

        def __init__(self, name, description, location, useDefaultThresholds, properties):
            typecheck.is_string(name, AssertionError)
            typecheck.is_string(description, AssertionError)
            typecheck.is_struct(location, raritan.rpc.peripheral.DeviceSlot.Location, AssertionError)
            typecheck.is_bool(useDefaultThresholds, AssertionError)

            self.name = name
            self.description = description
            self.location = location
            self.useDefaultThresholds = useDefaultThresholds
            self.properties = properties

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                name = json['name'],
                description = json['description'],
                location = raritan.rpc.peripheral.DeviceSlot.Location.decode(json['location'], agent),
                useDefaultThresholds = json['useDefaultThresholds'],
                properties = dict([(
                    elem['key'],
                    elem['value'])
                    for elem in json['properties']]),
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            json['description'] = self.description
            json['location'] = raritan.rpc.peripheral.DeviceSlot.Location.encode(self.location)
            json['useDefaultThresholds'] = self.useDefaultThresholds
            json['properties'] = [dict(
                key = k,
                value = v)
                for k, v in self.properties.items()]
            return json

    # value object
    class DeviceChangedEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DeviceSlot_2_0_3.DeviceChangedEvent:1.0.0"

        def __init__(self, oldDevice, newDevice, source):
            super(raritan.rpc.peripheral.DeviceSlot.DeviceChangedEvent, self).__init__(source)
            typecheck.is_valobj(oldDevice, raritan.rpc.peripheral.Device, AssertionError)
            typecheck.is_valobj(newDevice, raritan.rpc.peripheral.Device, AssertionError)

            self.oldDevice = oldDevice
            self.newDevice = newDevice

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceSlot.DeviceChangedEvent, self).encode()
            json['oldDevice'] = ValueObject.encode(self.oldDevice)
            json['newDevice'] = ValueObject.encode(self.newDevice)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldDevice = ValueObject.decode(json['oldDevice'], agent),
                newDevice = ValueObject.decode(json['newDevice'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldDevice", "newDevice"]
            elements = elements + super(raritan.rpc.peripheral.DeviceSlot.DeviceChangedEvent, self).listElements()
            return elements

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "peripheral.DeviceSlot_2_0_3.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings, newSettings, actUserName, actIpAddr, source):
            super(raritan.rpc.peripheral.DeviceSlot.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_struct(oldSettings, raritan.rpc.peripheral.DeviceSlot.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.peripheral.DeviceSlot.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceSlot.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.peripheral.DeviceSlot.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.peripheral.DeviceSlot.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.peripheral.DeviceSlot.Settings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.peripheral.DeviceSlot.Settings.decode(json['newSettings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.peripheral.DeviceSlot.SettingsChangedEvent, self).listElements()
            return elements

    class _getDevice(Interface.Method):
        name = 'getDevice'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = ValueObject.decode(rsp['_ret_'], agent)
            typecheck.is_valobj(_ret_, raritan.rpc.peripheral.Device, DecodeException)
            return _ret_

    class _assign(Interface.Method):
        name = 'assign'

        @staticmethod
        def encode(devid):
            typecheck.is_struct(devid, raritan.rpc.peripheral.DeviceID, AssertionError)
            args = {}
            args['devid'] = raritan.rpc.peripheral.DeviceID.encode(devid)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _assignAddress(Interface.Method):
        name = 'assignAddress'

        @staticmethod
        def encode(packageClass, address):
            typecheck.is_string(packageClass, AssertionError)
            typecheck.is_struct(address, raritan.rpc.peripheral.Address, AssertionError)
            args = {}
            args['packageClass'] = packageClass
            args['address'] = raritan.rpc.peripheral.Address.encode(address)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _unassign(Interface.Method):
        name = 'unassign'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.peripheral.DeviceSlot.Settings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.peripheral.DeviceSlot.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.peripheral.DeviceSlot.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.peripheral.DeviceSlot.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(DeviceSlot, self).__init__(target, agent)
        self.getDevice = DeviceSlot._getDevice(self)
        self.assign = DeviceSlot._assign(self)
        self.assignAddress = DeviceSlot._assignAddress(self)
        self.unassign = DeviceSlot._unassign(self)
        self.getSettings = DeviceSlot._getSettings(self)
        self.setSettings = DeviceSlot._setSettings(self)

#
# Section generated by IdlC from "PeripheralDevicePackage.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.peripheral


# structure
class PackageInfo(Structure):
    idlType = "peripheral.PackageInfo:2.0.1"
    elements = ["state", "position", "hwInfo", "fwInfo"]

    def __init__(self, state, position, hwInfo, fwInfo):
        typecheck.is_enum(state, raritan.rpc.peripheral.PackageInfo.State, AssertionError)
        for x0 in position:
            typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)
        typecheck.is_struct(hwInfo, raritan.rpc.peripheral.PackageInfo.HardwareInfo, AssertionError)
        typecheck.is_struct(fwInfo, raritan.rpc.peripheral.PackageInfo.FirmwareInfo, AssertionError)

        self.state = state
        self.position = position
        self.hwInfo = hwInfo
        self.fwInfo = fwInfo

    @classmethod
    def decode(cls, json, agent):
        obj = cls(
            state = raritan.rpc.peripheral.PackageInfo.State.decode(json['state']),
            position = [raritan.rpc.peripheral.PosElement.decode(x0, agent) for x0 in json['position']],
            hwInfo = raritan.rpc.peripheral.PackageInfo.HardwareInfo.decode(json['hwInfo'], agent),
            fwInfo = raritan.rpc.peripheral.PackageInfo.FirmwareInfo.decode(json['fwInfo'], agent),
        )
        return obj

    def encode(self):
        json = {}
        json['state'] = raritan.rpc.peripheral.PackageInfo.State.encode(self.state)
        json['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in self.position]
        json['hwInfo'] = raritan.rpc.peripheral.PackageInfo.HardwareInfo.encode(self.hwInfo)
        json['fwInfo'] = raritan.rpc.peripheral.PackageInfo.FirmwareInfo.encode(self.fwInfo)
        return json

    # enumeration
    class State(Enumeration):
        idlType = "peripheral.PackageInfo_2_0_1.State:1.0.0"
        values = ["NORMAL", "FW_UPDATE", "INTERNAL_ERROR", "CONFIG_ERROR"]

    State.NORMAL = State(0)
    State.FW_UPDATE = State(1)
    State.INTERNAL_ERROR = State(2)
    State.CONFIG_ERROR = State(3)

    # structure
    class HardwareInfo(Structure):
        idlType = "peripheral.PackageInfo_2_0_1.HardwareInfo:1.0.0"
        elements = ["serial", "packageClass", "model", "minDowngradeVersion", "revision"]

        def __init__(self, serial, packageClass, model, minDowngradeVersion, revision):
            typecheck.is_string(serial, AssertionError)
            typecheck.is_string(packageClass, AssertionError)
            typecheck.is_string(model, AssertionError)
            typecheck.is_int(minDowngradeVersion, AssertionError)
            typecheck.is_string(revision, AssertionError)

            self.serial = serial
            self.packageClass = packageClass
            self.model = model
            self.minDowngradeVersion = minDowngradeVersion
            self.revision = revision

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                serial = json['serial'],
                packageClass = json['packageClass'],
                model = json['model'],
                minDowngradeVersion = json['minDowngradeVersion'],
                revision = json['revision'],
            )
            return obj

        def encode(self):
            json = {}
            json['serial'] = self.serial
            json['packageClass'] = self.packageClass
            json['model'] = self.model
            json['minDowngradeVersion'] = self.minDowngradeVersion
            json['revision'] = self.revision
            return json

    # structure
    class FirmwareInfo(Structure):
        idlType = "peripheral.PackageInfo_2_0_1.FirmwareInfo:1.0.0"
        elements = ["compileDate", "version", "updateDate"]

        def __init__(self, compileDate, version, updateDate):
            typecheck.is_time(compileDate, AssertionError)
            typecheck.is_struct(version, raritan.rpc.peripheral.PackageInfo.FirmwareInfo.Version, AssertionError)
            typecheck.is_time(updateDate, AssertionError)

            self.compileDate = compileDate
            self.version = version
            self.updateDate = updateDate

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                compileDate = raritan.rpc.Time.decode(json['compileDate']),
                version = raritan.rpc.peripheral.PackageInfo.FirmwareInfo.Version.decode(json['version'], agent),
                updateDate = raritan.rpc.Time.decode(json['updateDate']),
            )
            return obj

        def encode(self):
            json = {}
            json['compileDate'] = raritan.rpc.Time.encode(self.compileDate)
            json['version'] = raritan.rpc.peripheral.PackageInfo.FirmwareInfo.Version.encode(self.version)
            json['updateDate'] = raritan.rpc.Time.encode(self.updateDate)
            return json

        # structure
        class Version(Structure):
            idlType = "peripheral.PackageInfo_2_0_1.FirmwareInfo.Version:1.0.0"
            elements = ["majorNumber", "minorNumber", "bootloaderVersion"]

            def __init__(self, majorNumber, minorNumber, bootloaderVersion):
                typecheck.is_int(majorNumber, AssertionError)
                typecheck.is_int(minorNumber, AssertionError)
                typecheck.is_int(bootloaderVersion, AssertionError)

                self.majorNumber = majorNumber
                self.minorNumber = minorNumber
                self.bootloaderVersion = bootloaderVersion

            @classmethod
            def decode(cls, json, agent):
                obj = cls(
                    majorNumber = json['majorNumber'],
                    minorNumber = json['minorNumber'],
                    bootloaderVersion = json['bootloaderVersion'],
                )
                return obj

            def encode(self):
                json = {}
                json['majorNumber'] = self.majorNumber
                json['minorNumber'] = self.minorNumber
                json['bootloaderVersion'] = self.bootloaderVersion
                return json

# interface
class Package(Interface):
    idlType = "peripheral.Package:1.0.1"

    class _getPackageInfo(Interface.Method):
        name = 'getPackageInfo'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.peripheral.PackageInfo.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.peripheral.PackageInfo, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Package, self).__init__(target, agent)
        self.getPackageInfo = Package._getPackageInfo(self)

# interface
class DoorHandleControllerPackage(Package):
    idlType = "peripheral.DoorHandleControllerPackage:1.0.1"

    SUCCESS = 0

    ERR_NOT_SUPPORTED = 1

    ERR_OPERATION_FAILED = 2

    class _getSupportedHandleTypes(Interface.Method):
        name = 'getSupportedHandleTypes'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_string(x0, DecodeException)
            return _ret_

    class _getHandleType(Interface.Method):
        name = 'getHandleType'

        @staticmethod
        def encode(channel):
            typecheck.is_int(channel, AssertionError)
            args = {}
            args['channel'] = channel
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_string(_ret_, DecodeException)
            return _ret_

    class _setHandleType(Interface.Method):
        name = 'setHandleType'

        @staticmethod
        def encode(channel, handleType):
            typecheck.is_int(channel, AssertionError)
            typecheck.is_string(handleType, AssertionError)
            args = {}
            args['channel'] = channel
            args['handleType'] = handleType
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(DoorHandleControllerPackage, self).__init__(target, agent)
        self.getSupportedHandleTypes = DoorHandleControllerPackage._getSupportedHandleTypes(self)
        self.getHandleType = DoorHandleControllerPackage._getHandleType(self)
        self.setHandleType = DoorHandleControllerPackage._setHandleType(self)

#
# Section generated by IdlC from "PeripheralDeviceManager.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.idl

import raritan.rpc.peripheral

import raritan.rpc.portsmodel

import raritan.rpc.sensors


# interface
class DeviceManager(Interface):
    idlType = "peripheral.DeviceManager:3.0.2"

    ERR_INVALID_PARAMS = 1

    # enumeration
    class ZCoordMode(Enumeration):
        idlType = "peripheral.DeviceManager_3_0_2.ZCoordMode:1.0.0"
        values = ["RACKUNITS", "FREEFORM"]

    ZCoordMode.RACKUNITS = ZCoordMode(0)
    ZCoordMode.FREEFORM = ZCoordMode(1)

    # structure
    class Settings(Structure):
        idlType = "peripheral.DeviceManager_3_0_2.Settings:1.0.0"
        elements = ["zCoordMode", "autoManageNewDevices", "deviceAltitude", "presenceDetectionTimeout", "defaultThresholdsMap", "maxActivePoweredDryContacts"]

        def __init__(self, zCoordMode, autoManageNewDevices, deviceAltitude, presenceDetectionTimeout, defaultThresholdsMap, maxActivePoweredDryContacts):
            typecheck.is_enum(zCoordMode, raritan.rpc.peripheral.DeviceManager.ZCoordMode, AssertionError)
            typecheck.is_bool(autoManageNewDevices, AssertionError)
            typecheck.is_float(deviceAltitude, AssertionError)
            typecheck.is_int(presenceDetectionTimeout, AssertionError)
            typecheck.is_int(maxActivePoweredDryContacts, AssertionError)

            self.zCoordMode = zCoordMode
            self.autoManageNewDevices = autoManageNewDevices
            self.deviceAltitude = deviceAltitude
            self.presenceDetectionTimeout = presenceDetectionTimeout
            self.defaultThresholdsMap = defaultThresholdsMap
            self.maxActivePoweredDryContacts = maxActivePoweredDryContacts

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                zCoordMode = raritan.rpc.peripheral.DeviceManager.ZCoordMode.decode(json['zCoordMode']),
                autoManageNewDevices = json['autoManageNewDevices'],
                deviceAltitude = json['deviceAltitude'],
                presenceDetectionTimeout = json['presenceDetectionTimeout'],
                defaultThresholdsMap = dict([(
                    elem['key'],
                    raritan.rpc.sensors.NumericSensor.Thresholds.decode(elem['value'], agent))
                    for elem in json['defaultThresholdsMap']]),
                maxActivePoweredDryContacts = json['maxActivePoweredDryContacts'],
            )
            return obj

        def encode(self):
            json = {}
            json['zCoordMode'] = raritan.rpc.peripheral.DeviceManager.ZCoordMode.encode(self.zCoordMode)
            json['autoManageNewDevices'] = self.autoManageNewDevices
            json['deviceAltitude'] = self.deviceAltitude
            json['presenceDetectionTimeout'] = self.presenceDetectionTimeout
            json['defaultThresholdsMap'] = [dict(
                key = k,
                value = raritan.rpc.sensors.NumericSensor.Thresholds.encode(v))
                for k, v in self.defaultThresholdsMap.items()]
            json['maxActivePoweredDryContacts'] = self.maxActivePoweredDryContacts
            return json

    # structure
    class MetaData(Structure):
        idlType = "peripheral.DeviceManager_3_0_2.MetaData:1.0.0"
        elements = ["oneWirePortCount", "onboardDeviceCount"]

        def __init__(self, oneWirePortCount, onboardDeviceCount):
            typecheck.is_int(oneWirePortCount, AssertionError)
            typecheck.is_int(onboardDeviceCount, AssertionError)

            self.oneWirePortCount = oneWirePortCount
            self.onboardDeviceCount = onboardDeviceCount

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oneWirePortCount = json['oneWirePortCount'],
                onboardDeviceCount = json['onboardDeviceCount'],
            )
            return obj

        def encode(self):
            json = {}
            json['oneWirePortCount'] = self.oneWirePortCount
            json['onboardDeviceCount'] = self.onboardDeviceCount
            return json

    # structure
    class DeviceTypeInfo(Structure):
        idlType = "peripheral.DeviceManager_3_0_2.DeviceTypeInfo:1.0.0"
        elements = ["type", "isActuator", "identifier", "name", "defaultRange", "defaultDecDigits"]

        def __init__(self, type, isActuator, identifier, name, defaultRange, defaultDecDigits):
            typecheck.is_struct(type, raritan.rpc.sensors.Sensor.TypeSpec, AssertionError)
            typecheck.is_bool(isActuator, AssertionError)
            typecheck.is_string(identifier, AssertionError)
            typecheck.is_string(name, AssertionError)
            typecheck.is_struct(defaultRange, raritan.rpc.sensors.NumericSensor.Range, AssertionError)
            typecheck.is_int(defaultDecDigits, AssertionError)

            self.type = type
            self.isActuator = isActuator
            self.identifier = identifier
            self.name = name
            self.defaultRange = defaultRange
            self.defaultDecDigits = defaultDecDigits

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                type = raritan.rpc.sensors.Sensor.TypeSpec.decode(json['type'], agent),
                isActuator = json['isActuator'],
                identifier = json['identifier'],
                name = json['name'],
                defaultRange = raritan.rpc.sensors.NumericSensor.Range.decode(json['defaultRange'], agent),
                defaultDecDigits = json['defaultDecDigits'],
            )
            return obj

        def encode(self):
            json = {}
            json['type'] = raritan.rpc.sensors.Sensor.TypeSpec.encode(self.type)
            json['isActuator'] = self.isActuator
            json['identifier'] = self.identifier
            json['name'] = self.name
            json['defaultRange'] = raritan.rpc.sensors.NumericSensor.Range.encode(self.defaultRange)
            json['defaultDecDigits'] = self.defaultDecDigits
            return json

    # structure
    class FirmwareUpdateState(Structure):
        idlType = "peripheral.DeviceManager_3_0_2.FirmwareUpdateState:1.0.0"
        elements = ["active", "remaining"]

        def __init__(self, active, remaining):
            typecheck.is_bool(active, AssertionError)
            typecheck.is_int(remaining, AssertionError)

            self.active = active
            self.remaining = remaining

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                active = json['active'],
                remaining = json['remaining'],
            )
            return obj

        def encode(self):
            json = {}
            json['active'] = self.active
            json['remaining'] = self.remaining
            return json

    # value object
    class SettingsChangedEvent(raritan.rpc.event.UserEvent):
        idlType = "peripheral.DeviceManager_3_0_2.SettingsChangedEvent:1.0.0"

        def __init__(self, oldSettings, newSettings, actUserName, actIpAddr, source):
            super(raritan.rpc.peripheral.DeviceManager.SettingsChangedEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_struct(oldSettings, raritan.rpc.peripheral.DeviceManager.Settings, AssertionError)
            typecheck.is_struct(newSettings, raritan.rpc.peripheral.DeviceManager.Settings, AssertionError)

            self.oldSettings = oldSettings
            self.newSettings = newSettings

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.SettingsChangedEvent, self).encode()
            json['oldSettings'] = raritan.rpc.peripheral.DeviceManager.Settings.encode(self.oldSettings)
            json['newSettings'] = raritan.rpc.peripheral.DeviceManager.Settings.encode(self.newSettings)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldSettings = raritan.rpc.peripheral.DeviceManager.Settings.decode(json['oldSettings'], agent),
                newSettings = raritan.rpc.peripheral.DeviceManager.Settings.decode(json['newSettings'], agent),
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldSettings", "newSettings"]
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.SettingsChangedEvent, self).listElements()
            return elements

    # value object
    class DeviceEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DeviceManager_3_0_2.DeviceEvent:2.0.0"

        def __init__(self, devices, allDevices, source):
            super(raritan.rpc.peripheral.DeviceManager.DeviceEvent, self).__init__(source)
            for x0 in devices:
                typecheck.is_valobj(x0, raritan.rpc.peripheral.Device, AssertionError)
            for x0 in allDevices:
                typecheck.is_valobj(x0, raritan.rpc.peripheral.Device, AssertionError)

            self.devices = devices
            self.allDevices = allDevices

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.DeviceEvent, self).encode()
            json['devices'] = [ValueObject.encode(x0) for x0 in self.devices]
            json['allDevices'] = [ValueObject.encode(x0) for x0 in self.allDevices]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                devices = [ValueObject.decode(x0, agent) for x0 in json['devices']],
                allDevices = [ValueObject.decode(x0, agent) for x0 in json['allDevices']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["devices", "allDevices"]
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.DeviceEvent, self).listElements()
            return elements

    # value object
    class DeviceAddedEvent(DeviceEvent):
        idlType = "peripheral.DeviceManager_3_0_2.DeviceAddedEvent:2.0.0"

        def __init__(self, devices, allDevices, source):
            super(raritan.rpc.peripheral.DeviceManager.DeviceAddedEvent, self).__init__(devices, allDevices, source)

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.DeviceAddedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.DeviceManager_3_0_2.DeviceEvent_2_0_0
                devices = [ValueObject.decode(x0, agent) for x0 in json['devices']],
                allDevices = [ValueObject.decode(x0, agent) for x0 in json['allDevices']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.DeviceAddedEvent, self).listElements()
            return elements

    # value object
    class DeviceRemovedEvent(DeviceEvent):
        idlType = "peripheral.DeviceManager_3_0_2.DeviceRemovedEvent:2.0.0"

        def __init__(self, devices, allDevices, source):
            super(raritan.rpc.peripheral.DeviceManager.DeviceRemovedEvent, self).__init__(devices, allDevices, source)

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.DeviceRemovedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.DeviceManager_3_0_2.DeviceEvent_2_0_0
                devices = [ValueObject.decode(x0, agent) for x0 in json['devices']],
                allDevices = [ValueObject.decode(x0, agent) for x0 in json['allDevices']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.DeviceRemovedEvent, self).listElements()
            return elements

    # value object
    class UnknownDeviceAttachedEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DeviceManager_3_0_2.UnknownDeviceAttachedEvent:1.0.0"

        def __init__(self, romCode, position, source):
            super(raritan.rpc.peripheral.DeviceManager.UnknownDeviceAttachedEvent, self).__init__(source)
            typecheck.is_string(romCode, AssertionError)
            for x0 in position:
                typecheck.is_struct(x0, raritan.rpc.peripheral.PosElement, AssertionError)

            self.romCode = romCode
            self.position = position

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.UnknownDeviceAttachedEvent, self).encode()
            json['romCode'] = self.romCode
            json['position'] = [raritan.rpc.peripheral.PosElement.encode(x0) for x0 in self.position]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                romCode = json['romCode'],
                position = [raritan.rpc.peripheral.PosElement.decode(x0, agent) for x0 in json['position']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["romCode", "position"]
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.UnknownDeviceAttachedEvent, self).listElements()
            return elements

    # enumeration
    class DeviceFirmwareUpdateState(Enumeration):
        idlType = "peripheral.DeviceManager_3_0_2.DeviceFirmwareUpdateState:1.0.0"
        values = ["UPDATE_STARTED", "UPDATE_SUCCESSFUL", "UPDATE_FAILED"]

    DeviceFirmwareUpdateState.UPDATE_STARTED = DeviceFirmwareUpdateState(0)
    DeviceFirmwareUpdateState.UPDATE_SUCCESSFUL = DeviceFirmwareUpdateState(1)
    DeviceFirmwareUpdateState.UPDATE_FAILED = DeviceFirmwareUpdateState(2)

    # value object
    class DeviceFirmwareUpdateStateChangedEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DeviceManager_3_0_2.DeviceFirmwareUpdateStateChangedEvent:1.0.0"

        def __init__(self, oldVersion, newVersion, serial, state, source):
            super(raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateStateChangedEvent, self).__init__(source)
            typecheck.is_string(oldVersion, AssertionError)
            typecheck.is_string(newVersion, AssertionError)
            typecheck.is_string(serial, AssertionError)
            typecheck.is_enum(state, raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateState, AssertionError)

            self.oldVersion = oldVersion
            self.newVersion = newVersion
            self.serial = serial
            self.state = state

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateStateChangedEvent, self).encode()
            json['oldVersion'] = self.oldVersion
            json['newVersion'] = self.newVersion
            json['serial'] = self.serial
            json['state'] = raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateState.encode(self.state)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldVersion = json['oldVersion'],
                newVersion = json['newVersion'],
                serial = json['serial'],
                state = raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateState.decode(json['state']),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldVersion", "newVersion", "serial", "state"]
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.DeviceFirmwareUpdateStateChangedEvent, self).listElements()
            return elements

    # value object
    class FirmwareUpdateStateChangedEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DeviceManager_3_0_2.FirmwareUpdateStateChangedEvent:1.0.0"

        def __init__(self, newState, source):
            super(raritan.rpc.peripheral.DeviceManager.FirmwareUpdateStateChangedEvent, self).__init__(source)
            typecheck.is_struct(newState, raritan.rpc.peripheral.DeviceManager.FirmwareUpdateState, AssertionError)

            self.newState = newState

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.FirmwareUpdateStateChangedEvent, self).encode()
            json['newState'] = raritan.rpc.peripheral.DeviceManager.FirmwareUpdateState.encode(self.newState)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                newState = raritan.rpc.peripheral.DeviceManager.FirmwareUpdateState.decode(json['newState'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["newState"]
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.FirmwareUpdateStateChangedEvent, self).listElements()
            return elements

    # value object
    class PackageEvent(raritan.rpc.idl.Event):
        idlType = "peripheral.DeviceManager_3_0_2.PackageEvent:2.0.0"

        def __init__(self, packageInfos, allPackages, source):
            super(raritan.rpc.peripheral.DeviceManager.PackageEvent, self).__init__(source)
            for x0 in packageInfos:
                typecheck.is_struct(x0, raritan.rpc.peripheral.PackageInfo, AssertionError)
            for x0 in allPackages:
                typecheck.is_struct(x0, raritan.rpc.peripheral.PackageInfo, AssertionError)

            self.packageInfos = packageInfos
            self.allPackages = allPackages

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.PackageEvent, self).encode()
            json['packageInfos'] = [raritan.rpc.peripheral.PackageInfo.encode(x0) for x0 in self.packageInfos]
            json['allPackages'] = [raritan.rpc.peripheral.PackageInfo.encode(x0) for x0 in self.allPackages]
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                packageInfos = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in json['packageInfos']],
                allPackages = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in json['allPackages']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["packageInfos", "allPackages"]
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.PackageEvent, self).listElements()
            return elements

    # value object
    class PackageAddedEvent(PackageEvent):
        idlType = "peripheral.DeviceManager_3_0_2.PackageAddedEvent:2.0.0"

        def __init__(self, packageInfos, allPackages, source):
            super(raritan.rpc.peripheral.DeviceManager.PackageAddedEvent, self).__init__(packageInfos, allPackages, source)

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.PackageAddedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.DeviceManager_3_0_2.PackageEvent_2_0_0
                packageInfos = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in json['packageInfos']],
                allPackages = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in json['allPackages']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.PackageAddedEvent, self).listElements()
            return elements

    # value object
    class PackageRemovedEvent(PackageEvent):
        idlType = "peripheral.DeviceManager_3_0_2.PackageRemovedEvent:2.0.0"

        def __init__(self, packageInfos, allPackages, source):
            super(raritan.rpc.peripheral.DeviceManager.PackageRemovedEvent, self).__init__(packageInfos, allPackages, source)

        def encode(self):
            json = super(raritan.rpc.peripheral.DeviceManager.PackageRemovedEvent, self).encode()
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                # for peripheral.DeviceManager_3_0_2.PackageEvent_2_0_0
                packageInfos = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in json['packageInfos']],
                allPackages = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in json['allPackages']],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = []
            elements = elements + super(raritan.rpc.peripheral.DeviceManager.PackageRemovedEvent, self).listElements()
            return elements

    # structure
    class Statistics(Structure):
        idlType = "peripheral.DeviceManager_3_0_2.Statistics:1.0.0"
        elements = ["cSumErrCnt"]

        def __init__(self, cSumErrCnt):
            typecheck.is_int(cSumErrCnt, AssertionError)

            self.cSumErrCnt = cSumErrCnt

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                cSumErrCnt = json['cSumErrCnt'],
            )
            return obj

        def encode(self):
            json = {}
            json['cSumErrCnt'] = self.cSumErrCnt
            return json

    class _getDeviceSlots(Interface.Method):
        name = 'getDeviceSlots'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.peripheral.DeviceSlot, DecodeException)
            return _ret_

    class _getDeviceSlot(Interface.Method):
        name = 'getDeviceSlot'

        @staticmethod
        def encode(idx):
            typecheck.is_int(idx, AssertionError)
            args = {}
            args['idx'] = idx
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.peripheral.DeviceSlot, DecodeException)
            return _ret_

    class _getDiscoveredDevices(Interface.Method):
        name = 'getDiscoveredDevices'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [ValueObject.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_valobj(x0, raritan.rpc.peripheral.Device, DecodeException)
            return _ret_

    class _getDiscoveredPackageInfos(Interface.Method):
        name = 'getDiscoveredPackageInfos'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.peripheral.PackageInfo.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.peripheral.PackageInfo, DecodeException)
            return _ret_

    class _getSettings(Interface.Method):
        name = 'getSettings'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.peripheral.DeviceManager.Settings.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.peripheral.DeviceManager.Settings, DecodeException)
            return _ret_

    class _setSettings(Interface.Method):
        name = 'setSettings'

        @staticmethod
        def encode(settings):
            typecheck.is_struct(settings, raritan.rpc.peripheral.DeviceManager.Settings, AssertionError)
            args = {}
            args['settings'] = raritan.rpc.peripheral.DeviceManager.Settings.encode(settings)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getMetaData(Interface.Method):
        name = 'getMetaData'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.peripheral.DeviceManager.MetaData.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.peripheral.DeviceManager.MetaData, DecodeException)
            return _ret_

    class _getDeviceTypeInfos(Interface.Method):
        name = 'getDeviceTypeInfos'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [raritan.rpc.peripheral.DeviceManager.DeviceTypeInfo.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_struct(x0, raritan.rpc.peripheral.DeviceManager.DeviceTypeInfo, DecodeException)
            return _ret_

    class _getFirmwareUpdateState(Interface.Method):
        name = 'getFirmwareUpdateState'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.peripheral.DeviceManager.FirmwareUpdateState.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.peripheral.DeviceManager.FirmwareUpdateState, DecodeException)
            return _ret_

    class _getStatistics(Interface.Method):
        name = 'getStatistics'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.peripheral.DeviceManager.Statistics.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.peripheral.DeviceManager.Statistics, DecodeException)
            return _ret_

    class _getDiscoveredPackages(Interface.Method):
        name = 'getDiscoveredPackages'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [Interface.decode(x0, agent) for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_interface(x0, raritan.rpc.peripheral.Package, DecodeException)
            return _ret_

    class _getPortFuse(Interface.Method):
        name = 'getPortFuse'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.portsmodel.PortFuse, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(DeviceManager, self).__init__(target, agent)
        self.getDeviceSlots = DeviceManager._getDeviceSlots(self)
        self.getDeviceSlot = DeviceManager._getDeviceSlot(self)
        self.getDiscoveredDevices = DeviceManager._getDiscoveredDevices(self)
        self.getDiscoveredPackageInfos = DeviceManager._getDiscoveredPackageInfos(self)
        self.getSettings = DeviceManager._getSettings(self)
        self.setSettings = DeviceManager._setSettings(self)
        self.getMetaData = DeviceManager._getMetaData(self)
        self.getDeviceTypeInfos = DeviceManager._getDeviceTypeInfos(self)
        self.getFirmwareUpdateState = DeviceManager._getFirmwareUpdateState(self)
        self.getStatistics = DeviceManager._getStatistics(self)
        self.getDiscoveredPackages = DeviceManager._getDiscoveredPackages(self)
        self.getPortFuse = DeviceManager._getPortFuse(self)

#
# Section generated by IdlC from "PeripheralG2Production.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException

# interface
class G2Production(Interface):
    idlType = "peripheral.G2Production:4.0.0"

    SUCCESS = 0

    ERR_INVALID_PARAMS = 1

    ERR_NO_CONFIG_MODE = 2

    ERR_NO_DEVICE = 3

    ERR_OPERATION_FAILED = 4

    class _programSerialNumber(Interface.Method):
        name = 'programSerialNumber'

        @staticmethod
        def encode(romcode, serial):
            typecheck.is_string(romcode, AssertionError)
            typecheck.is_string(serial, AssertionError)
            args = {}
            args['romcode'] = romcode
            args['serial'] = serial
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(G2Production, self).__init__(target, agent)
        self.programSerialNumber = G2Production._programSerialNumber(self)
