// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from LdapServerSettings.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.auth.ldapsrv {

  public class ServerSettings_2_0_0 : ICloneable {
    public object Clone() {
      ServerSettings_2_0_0 copy = new ServerSettings_2_0_0();
      copy.id = this.id;
      copy.server = this.server;
      copy.adoptSettingsId = this.adoptSettingsId;
      copy.type = this.type;
      copy.secProto = this.secProto;
      copy.port = this.port;
      copy.sslPort = this.sslPort;
      copy.forceTrustedCert = this.forceTrustedCert;
      copy.allowOffTimeRangeCerts = this.allowOffTimeRangeCerts;
      copy.certificate = this.certificate;
      copy.adsDomain = this.adsDomain;
      copy.useAnonymousBind = this.useAnonymousBind;
      copy.bindDN = this.bindDN;
      copy.bindPwd = this.bindPwd;
      copy.searchBaseDN = this.searchBaseDN;
      copy.loginNameAttr = this.loginNameAttr;
      copy.userEntryObjClass = this.userEntryObjClass;
      copy.userSearchFilter = this.userSearchFilter;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["id"] = this.id;
      json["server"] = this.server;
      json["adoptSettingsId"] = this.adoptSettingsId;
      json["type"] = (int)this.type;
      json["secProto"] = (int)this.secProto;
      json["port"] = this.port;
      json["sslPort"] = this.sslPort;
      json["forceTrustedCert"] = this.forceTrustedCert;
      json["allowOffTimeRangeCerts"] = this.allowOffTimeRangeCerts;
      json["certificate"] = this.certificate;
      json["adsDomain"] = this.adsDomain;
      json["useAnonymousBind"] = this.useAnonymousBind;
      json["bindDN"] = this.bindDN;
      json["bindPwd"] = this.bindPwd;
      json["searchBaseDN"] = this.searchBaseDN;
      json["loginNameAttr"] = this.loginNameAttr;
      json["userEntryObjClass"] = this.userEntryObjClass;
      json["userSearchFilter"] = this.userSearchFilter;
      return json;
    }

    public static ServerSettings_2_0_0 Decode(LightJson.JsonObject json, Agent agent) {
      ServerSettings_2_0_0 inst = new ServerSettings_2_0_0();
      inst.id = (string)json["id"];
      inst.server = (string)json["server"];
      inst.adoptSettingsId = (string)json["adoptSettingsId"];
      inst.type = (Com.Raritan.Idl.auth.ldapsrv.ServerType)(int)json["type"];
      inst.secProto = (Com.Raritan.Idl.auth.ldapsrv.SecurityProtocol)(int)json["secProto"];
      inst.port = (int)json["port"];
      inst.sslPort = (int)json["sslPort"];
      inst.forceTrustedCert = (bool)json["forceTrustedCert"];
      inst.allowOffTimeRangeCerts = (bool)json["allowOffTimeRangeCerts"];
      inst.certificate = (string)json["certificate"];
      inst.adsDomain = (string)json["adsDomain"];
      inst.useAnonymousBind = (bool)json["useAnonymousBind"];
      inst.bindDN = (string)json["bindDN"];
      inst.bindPwd = (string)json["bindPwd"];
      inst.searchBaseDN = (string)json["searchBaseDN"];
      inst.loginNameAttr = (string)json["loginNameAttr"];
      inst.userEntryObjClass = (string)json["userEntryObjClass"];
      inst.userSearchFilter = (string)json["userSearchFilter"];
      return inst;
    }

    public string id = "";
    public string server = "";
    public string adoptSettingsId = "";
    public Com.Raritan.Idl.auth.ldapsrv.ServerType type = Com.Raritan.Idl.auth.ldapsrv.ServerType.ACTIVE_DIRECTORY;
    public Com.Raritan.Idl.auth.ldapsrv.SecurityProtocol secProto = Com.Raritan.Idl.auth.ldapsrv.SecurityProtocol.SEC_PROTO_NONE;
    public int port = 0;
    public int sslPort = 0;
    public bool forceTrustedCert = false;
    public bool allowOffTimeRangeCerts = false;
    public string certificate = "";
    public string adsDomain = "";
    public bool useAnonymousBind = false;
    public string bindDN = "";
    public string bindPwd = "";
    public string searchBaseDN = "";
    public string loginNameAttr = "";
    public string userEntryObjClass = "";
    public string userSearchFilter = "";
  }
}
