\name{Dualtree}
\alias{dualtree}
\alias{idualtree}
\alias{dualtree2D}
\alias{idualtree2D}
\title{Dual-tree Complex Discrete Wavelet Transform}
\description{
  One- and two-dimensional dual-tree complex discrete wavelet transforms
  developed by Kingsbury and Selesnick \emph{et al.}
}
\usage{
dualtree(x, J, Faf, af)
idualtree(w, J, Fsf, sf)
dualtree2D(x, J, Faf, af)
idualtree2D(w, J, Fsf, sf)
}
\arguments{
  \item{x}{\eqn{N}-point vector or \eqn{M{\times}N}{MxN} matrix.}
  \item{w}{DWT coefficients.}
  \item{J}{number of stages.}
  \item{Faf}{analysis filters for the first stage.}
  \item{af}{analysis filters for the remaining stages.}
  \item{Fsf}{synthesis filters for the last stage.}
  \item{sf}{synthesis filters for the preceeding stages.}
}
\value{
  For the analysis of \code{x}, the output is
  \item{w}{DWT coefficients.  Each wavelet scale is a list containing
    the real and imaginary parts.  The final scale (\eqn{J+1}) contains
    the low-pass filter coefficients.}
  For the synthesis of \code{w}, the output is 
  \item{y}{output signal}
}
\details{
  In one dimension \eqn{N} is divisible by \eqn{2^J} and
  \eqn{N\ge2^{J-1}\cdot\mbox{length}(\mbox{\code{af}})}.

  In two dimensions, these two conditions must hold for both \eqn{M} and 
  \eqn{N}.
}
\references{
  WAVELET SOFTWARE AT POLYTECHNIC UNIVERSITY, BROOKLYN, NY\cr
  \url{http://taco.poly.edu/WaveletSoftware/}
}
\seealso{
  \code{\link{FSfarras}}, \code{\link{farras}}, \code{\link{convolve}},
  \code{\link{cshift}}, \code{\link{afb}}, \code{\link{sfb}}.
}
\examples{
## EXAMPLE: dualtree
x = rnorm(512)
J = 4
Faf = FSfarras()$af
Fsf = FSfarras()$sf
af = dualfilt1()$af
sf = dualfilt1()$sf
w = dualtree(x, J, Faf, af)
y = idualtree(w, J, Fsf, sf)
err = x - y
max(abs(err))

## Example: dualtree2D
x = matrix(rnorm(64*64), 64, 64)
J = 3
Faf = FSfarras()$af
Fsf = FSfarras()$sf
af = dualfilt1()$af
sf = dualfilt1()$sf
w = dualtree2D(x, J, Faf, af)
y = idualtree2D(w, J, Fsf, sf)
err = x - y
max(abs(err))

## Display 2D wavelets of dualtree2D.m

J <- 4
L <- 3 * 2^(J+1)
N <- L / 2^J
Faf <- FSfarras()$af
Fsf <- FSfarras()$sf
af <- dualfilt1()$af
sf <- dualfilt1()$sf
x <- matrix(0, 2*L, 3*L)
w <- dualtree2D(x, J, Faf, af)
w[[J]][[1]][[1]][N/2, N/2+0*N] <- 1
w[[J]][[1]][[2]][N/2, N/2+1*N] <- 1
w[[J]][[1]][[3]][N/2, N/2+2*N] <- 1
w[[J]][[2]][[1]][N/2+N, N/2+0*N] <- 1
w[[J]][[2]][[2]][N/2+N, N/2+1*N] <- 1
w[[J]][[2]][[3]][N/2+N, N/2+2*N] <- 1
y <- idualtree2D(w, J, Fsf, sf)
image(t(y), col=grey(0:64/64), axes=FALSE)
}
\author{Matlab: S. Cai, K. Li and I. Selesnick; R port: B. Whitcher}
\keyword{ts}
