% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectangle.R
\name{hoist}
\alias{hoist}
\alias{unnest_longer}
\alias{unnest_wider}
\alias{unnest_auto}
\title{Rectangle a nested list into a tidy tibble}
\usage{
hoist(.data, .col, ..., .remove = TRUE, .simplify = TRUE, .ptype = list())

unnest_longer(
  data,
  col,
  values_to = NULL,
  indices_to = NULL,
  indices_include = NULL,
  names_repair = "check_unique",
  simplify = TRUE,
  ptype = list()
)

unnest_wider(
  data,
  col,
  names_sep = NULL,
  simplify = TRUE,
  names_repair = "check_unique",
  ptype = list()
)

unnest_auto(data, col)
}
\arguments{
\item{.data, data}{A data frame.}

\item{.col, col}{List-column to extract components from.}

\item{...}{Components of \code{.col} to turn into columns in the form
\code{col_name = "pluck_specification"}. You can pluck by name with a character
vector, by position with an integer vector, or with a combination of the
two with a list. See \code{\link[purrr:pluck]{purrr::pluck()}} for details.}

\item{.remove}{If \code{TRUE}, the default, will remove extracted components
from \code{.col}. This ensures that each value lives only in one place.}

\item{.simplify}{If \code{TRUE}, will attempt to simplify lists of length-1
vectors to an atomic vector}

\item{.ptype}{Optionally, a named list of prototypes declaring the desired
output type of each component.}

\item{values_to}{Name of column to store vector values. Defaults to \code{col}.}

\item{indices_to}{A string giving the name of column which will contain the
inner names or position (if not named) of the values. Defaults to \code{col}
with \verb{_id} suffix}

\item{indices_include}{Add an index column? Defaults to \code{TRUE} when \code{col}
has inner names.}

\item{names_repair}{Used to check that output data frame has valid
names. Must be one of the following options:
\itemize{
\item "minimal": no name repair or checks, beyond basic existence,
\item "unique": make sure names are unique and not empty,
\item "check_unique": (the default), no name repair, but check they are unique,
\item "universal": make the names unique and syntactic
\item a function: apply custom name repair.
\item \link{tidyr_legacy}: use the name repair from tidyr 0.8.
\item a formula: a purrr-style anonymous function (see \code{\link[rlang:as_function]{rlang::as_function()}})
}

See \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}} for more details on these terms and the
strategies used to enforce them.}

\item{simplify}{If \code{TRUE}, will attempt to simplify lists of length-1
vectors to an atomic vector}

\item{ptype}{Optionally, supply a data frame prototype for the output \code{cols},
overriding the default that will be guessed from the combination of
individual values.}

\item{names_sep}{If \code{NULL}, the default, the names of new columns will
come directly from the inner data frame.

If a string, the names of the new columns will be formed by pasting
together the outer column name with the inner names, separated by
\code{names_sep}.}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("maturing")}

\code{hoist()}, \code{unnest_longer()}, and \code{unnest_wider()} provide tools for
rectangling, collapsing deeply nested lists into regular columns.
\code{hoist()} allows you to selectively pull components of a list-column out
in to their own top-level columns, using the same syntax as \code{\link[purrr:pluck]{purrr::pluck()}}.
\code{unnest_wider()} turns each element of a list-column into a column, and
\code{unnest_longer()} turns each element of a list-column into a row.
\code{unnest_auto()} picks between \code{unnest_wider()} or \code{unnest_longer()}
based heuristics described below.

Learn more in \code{vignette("rectangle")}.
}
\section{Unnest variants}{


The three \code{unnest()} functions differ in how they change the shape of the
output data frame:
\itemize{
\item \code{unnest_wider()} preserves the rows, but changes the columns.
\item \code{unnest_longer()} preserves the columns, but changes the rows
\item \code{unnest()} can change both rows and columns.
}

These principles guide their behaviour when they are called with a
non-primary data type. For example, if you \code{unnest_wider()} a list of data
frames, the number of rows must be preserved, so each column is turned into
a list column of length one. Or if you \code{unnest_longer()} a list of data
frame, the number of columns must be preserved so it creates a packed
column. I'm not sure how if these behaviours are useful in practice, but
they are theoretically pleasing.
}

\section{\code{unnest_auto()} heuristics}{

\code{unnest_auto()} inspects the inner names of the list-col:
\itemize{
\item If all elements are unnamed, it uses \code{unnest_longer()}
\item If all elements are named, and there's at least one name in
common acros all components, it uses \code{unnest_wider()}
\item Otherwise, it falls back to \code{unnest_longer(indices_include = TRUE)}.
}
}

\examples{
df <- tibble(
  character = c("Toothless", "Dory"),
  metadata = list(
    list(
      species = "dragon",
      color = "black",
      films = c(
        "How to Train Your Dragon",
        "How to Train Your Dragon 2",
        "How to Train Your Dragon: The Hidden World"
       )
    ),
    list(
      species = "clownfish",
      color = "blue",
      films = c("Finding Nemo", "Finding Dory")
    )
  )
)
df

# Turn all components of metadata into columns
df \%>\% unnest_wider(metadata)

# Extract only specified components
df \%>\% hoist(metadata,
  species = "species",
  first_film = list("films", 1L),
  third_film = list("films", 3L)
)

df \%>\%
  unnest_wider(metadata) \%>\%
  unnest_longer(films)
# unnest_longer() is useful when each component of the list should
# form a row
df <- tibble(
  x = 1:3,
  y = list(NULL, 1:3, 4:5)
)
df \%>\% unnest_longer(y)
# Automatically creates names if widening
df \%>\% unnest_wider(y)

# And similarly if the vectors are named
df <- tibble(
  x = 1:2,
  y = list(c(a = 1, b = 2), c(a = 10, b = 11, c = 12))
)
df \%>\% unnest_wider(y)
df \%>\% unnest_longer(y)

}
