% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node_measures}
\alias{node_measures}
\alias{node_eccentricity}
\alias{node_constraint}
\alias{node_coreness}
\alias{node_diversity}
\alias{node_bridging_score}
\alias{node_effective_network_size}
\alias{node_connectivity_impact}
\alias{node_closeness_impact}
\alias{node_fareness_impact}
\title{Querying node measures}
\usage{
node_eccentricity(mode = "out")

node_constraint(weights = NULL)

node_coreness(mode = "out")

node_diversity(weights = NULL)

node_bridging_score()

node_effective_network_size()

node_connectivity_impact()

node_closeness_impact()

node_fareness_impact()
}
\arguments{
\item{mode}{The way edges should be followed in the case of directed graphs.}

\item{weights}{The weights to use for each node during calculation}
}
\value{
A numeric vector of the same length as the number of nodes in the
graph.
}
\description{
These functions are a collection of node measures that do not really fall
into the class of \link{centrality} measures. For lack of a better place they are
collected under the \code{node_*} umbrella of functions.
}
\section{Functions}{
\itemize{
\item \code{node_eccentricity}: measure the maximum shortest path to all other nodes in the graph

\item \code{node_constraint}: measures Burts constraint of the node. See \code{\link[igraph:constraint]{igraph::constraint()}}

\item \code{node_coreness}: measures the coreness of each node. See \code{\link[igraph:coreness]{igraph::coreness()}}

\item \code{node_diversity}: measures the diversity of the node. See \code{\link[igraph:diversity]{igraph::diversity()}}

\item \code{node_bridging_score}: measures Valente's Bridging measures for detecting structural bridges (\code{influenceR})

\item \code{node_effective_network_size}: measures Burt's Effective Network Size indicating access to structural holes in the network (\code{influenceR})

\item \code{node_connectivity_impact}: measures the impact on connectivity when removing the node (\code{NetSwan})

\item \code{node_closeness_impact}: measures the impact on closeness when removing the node (\code{NetSwan})

\item \code{node_fareness_impact}: measures the impact on fareness (distance between all node pairs) when removing the node (\code{NetSwan})
}}

\examples{
# Calculate Burt's Constraint for each node
create_notable('meredith') \%>\%
  mutate(b_constraint = node_constraint())
}
