% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_stan.R
\name{tidy_stan}
\alias{tidy_stan}
\title{Tidy summary output for stan models}
\usage{
tidy_stan(
  x,
  prob = 0.89,
  typical = "median",
  trans = NULL,
  effects = c("all", "fixed", "random"),
  component = c("all", "conditional", "zero_inflated", "zi"),
  digits = 2
)
}
\arguments{
\item{x}{A \code{stanreg}, \code{stanfit} or \code{brmsfit} object.}

\item{prob}{Vector of scalars between 0 and 1, indicating the mass within
the credible interval that is to be estimated.}

\item{typical}{The typical value that will represent the Bayesian point estimate.
By default, the posterior median is returned. See \code{\link[sjmisc]{typical_value}}
for possible values for this argument.}

\item{trans}{Name of a function or character vector naming a function, used
to apply transformations on the estimates and uncertainty intervals. The
values for standard errors are \emph{not} transformed! If \code{trans}
is not \code{NULL}, \emph{credible intervals} instead of \emph{HDI}
are computed, due to the possible asymmetry of the HDI.}

\item{effects}{Should results for fixed effects, random effects or both be returned?
Only applies to mixed models. May be abbreviated.}

\item{component}{Should results for all parameters, parameters for the conditional model
or the zero-inflated part of the model be returned? May be abbreviated. Only
applies to \pkg{brms}-models.}

\item{digits}{Amount of digits to round numerical values in the output.}
}
\value{
A data frame, summarizing \code{x}, with consistent column names.
        To distinguish multiple HDI values, column names for the HDI get a suffix
        when \code{prob} has more than one element.
}
\description{
Returns a tidy summary output for stan models.
}
\details{
The returned data frame has an additonal class-attribute,
   \code{tidy_stan}, to pass the result to its own \code{print()}-method.
   The \code{print()}-method creates a cleaner output, especially for multilevel,
   zero-inflated or multivariate response models, where - for instance -
   the conditional part of a model is printed separately from the zero-inflated
   part, or random and fixed effects are printed separately.
   \cr \cr
   The returned data frame gives information on:
   \itemize{
     \item{The Bayesian point estimate (column \emph{estimate}, which is by
           default the posterior median; other statistics are also possible,
           see argument \code{typical}).}
     \item{
       The standard error (which is actually the \emph{median absolute deviation}).
     }
     \item{
       The HDI. Computation for HDI is based on the
       code from Kruschke 2015, pp. 727f.
     }
     \item{
       The Probability of Direction (pd), which is an index for "effect significance"
       (see \cite{Makowski et al. 2019}). A value of 95\% or higher indicates a
       "significant" (i.e. statistically clear) effect.
     }
     \item{
       The effective numbers of samples, \emph{ESS}.
     }
     \item{
       The Rhat statistics. When Rhat is above 1, it usually indicates that
       the chain has not yet converged, indicating that the drawn samples
       might not be trustworthy. Drawing more iteration may solve this issue.
     }
     \item{
       The Monte Carlo standard error (see \code{\link{mcse}}). It is defined
       as standard deviation of the chains divided by their effective sample
       size and \dQuote{provides a quantitative suggestion of how big the
       estimation noise is} (\emph{Kruschke 2015, p.187}).
     }
   }
}
\examples{
\dontrun{
if (require("rstanarm")) {
  fit <- stan_glm(mpg ~ wt + am, data = mtcars, chains = 1)
  tidy_stan(fit)
  tidy_stan(fit, prob = c(.89, .5))
}}

}
\references{
Kruschke JK. \emph{Doing Bayesian Data Analysis: A Tutorial with R, JAGS, and Stan} 2nd edition. Academic Press, 2015
\cr \cr
Gelman A, Carlin JB, Stern HS, Dunson DB, Vehtari A, Rubin DB. \emph{Bayesian data analysis} 3rd ed. Boca Raton: Chapman and Hall/CRC, 2013
\cr \cr
Gelman A, Rubin DB. \emph{Inference from iterative simulation using multiple sequences} Statistical Science 1992;7: 457-511
\cr \cr
Makowski D, Ben-Shachar MS, Lüdecke D. bayestestR: Describing Effects and their Uncertainty, Existence and Significance within the Bayesian Framework. Journal of Open Source Software 2019;4:1541. \doi{10.21105/joss.01541}
\cr \cr
McElreath R. \emph{Statistical Rethinking. A Bayesian Course with Examples in R and Stan} Chapman and Hall, 2015
}
