% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/integration.R
\name{ProjectCellEmbeddings}
\alias{ProjectCellEmbeddings}
\alias{ProjectCellEmbeddings.Seurat}
\alias{ProjectCellEmbeddings.Assay}
\alias{ProjectCellEmbeddings.SCTAssay}
\alias{ProjectCellEmbeddings.StdAssay}
\alias{ProjectCellEmbeddings.default}
\alias{ProjectCellEmbeddings.IterableMatrix}
\title{Project query data to the reference dimensional reduction}
\usage{
ProjectCellEmbeddings(query, ...)

\method{ProjectCellEmbeddings}{Seurat}(
  query,
  reference,
  query.assay = NULL,
  reference.assay = NULL,
  reduction = "pca",
  dims = 1:50,
  normalization.method = c("LogNormalize", "SCT"),
  scale = TRUE,
  verbose = TRUE,
  nCount_UMI = NULL,
  feature.mean = NULL,
  feature.sd = NULL,
  ...
)

\method{ProjectCellEmbeddings}{Assay}(
  query,
  reference,
  reference.assay = NULL,
  reduction = "pca",
  dims = 1:50,
  scale = TRUE,
  normalization.method = NULL,
  verbose = TRUE,
  nCount_UMI = NULL,
  feature.mean = NULL,
  feature.sd = NULL,
  ...
)

\method{ProjectCellEmbeddings}{SCTAssay}(
  query,
  reference,
  reference.assay = NULL,
  reduction = "pca",
  dims = 1:50,
  scale = TRUE,
  normalization.method = NULL,
  verbose = TRUE,
  nCount_UMI = NULL,
  feature.mean = NULL,
  feature.sd = NULL,
  ...
)

\method{ProjectCellEmbeddings}{StdAssay}(
  query,
  reference,
  reference.assay = NULL,
  reduction = "pca",
  dims = 1:50,
  scale = TRUE,
  normalization.method = NULL,
  verbose = TRUE,
  nCount_UMI = NULL,
  feature.mean = NULL,
  feature.sd = NULL,
  ...
)

\method{ProjectCellEmbeddings}{default}(
  query,
  reference,
  reference.assay = NULL,
  reduction = "pca",
  dims = 1:50,
  scale = TRUE,
  normalization.method = NULL,
  verbose = TRUE,
  features = NULL,
  nCount_UMI = NULL,
  feature.mean = NULL,
  feature.sd = NULL,
  ...
)

\method{ProjectCellEmbeddings}{IterableMatrix}(
  query,
  reference,
  reference.assay = NULL,
  reduction = "pca",
  dims = 1:50,
  scale = TRUE,
  normalization.method = NULL,
  verbose = TRUE,
  features = features,
  nCount_UMI = NULL,
  feature.mean = NULL,
  feature.sd = NULL,
  block.size = 10000,
  ...
)
}
\arguments{
\item{query}{An object for query cells}

\item{reference}{An object for reference cells}

\item{query.assay}{Assay name for query object}

\item{reference.assay}{Assay name for reference object}

\item{reduction}{Name of dimensional reduction from reference object}

\item{dims}{Dimensions used for reference dimensional reduction}

\item{scale}{Determine if scale query data based on reference data variance}

\item{verbose}{Print progress}

\item{feature.mean}{Mean of features in reference}

\item{feature.sd}{Standard variance of features in reference}
}
\value{
A matrix with projected cell embeddings
}
\description{
Project query data to the reference dimensional reduction
}
\keyword{internal}
