% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SDMXDimension.R,
%   R/SDMXDimension-methods.R
\docType{class}
\name{SDMXDimension}
\alias{SDMXDimension}
\alias{SDMXDimension-class}
\alias{SDMXDimension,SDMXDimension-method}
\title{Class "SDMXDimension"}
\usage{
SDMXDimension(xmlObj, namespaces)
}
\arguments{
\item{xmlObj}{object of class "XMLInternalDocument derived from XML package}

\item{namespaces}{object of class "data.frame" given the list of namespace URIs}
}
\value{
an object of class "SDMXDimension"
}
\description{
A basic class to handle a SDMX Dimension
}
\section{Slots}{

\describe{
\item{\code{conceptRef}}{Object of class "character" giving the dimension conceptRef (required)}

\item{\code{conceptVersion}}{Object of class "character" giving the dimension concept version}

\item{\code{conceptAgency}}{Object of class "character" giving the dimension concept agency}

\item{\code{conceptSchemeRef}}{Object of class "character" giving the dimension conceptScheme ref}

\item{\code{conceptSchemeAgency}}{Object of class "character" giving the dimension conceptScheme agency}

\item{\code{codelist}}{Object of class "character" giving the codelist ref name}

\item{\code{codelistVersion}}{Object of class "character" giving the codelist ref version}

\item{\code{codelistAgency}}{Object of class "character" giving the codelist ref agency}

\item{\code{isMeasureDimension}}{Object of class "logical" indicating if the dimension is a measure dimension. Default value is FALSE}

\item{\code{isFrequencyDimension}}{Object of class "logical" indicating if the dimension is a frequency dimension. Default value is FALSE}

\item{\code{isEntityDimension}}{Object of class "logical" indicating if the dimension is an entity dimension. Default value is FALSE}

\item{\code{isCountDimension}}{Object of class "logical" indicating if the dimension is a count dimension. Default value is FALSE}

\item{\code{isNonObservationTimeDimension}}{Object of class "logical" indicating if the dimension is a non-observation dimension. Default value is FALSE}

\item{\code{isIdentityDimension}}{Object of class "logical" indicating if the dimension is an identity dimension. Default value is FALSE}

\item{\code{crossSectionalAttachDataset}}{Object of class "logical"}

\item{\code{crossSectionalAttachGroup}}{Object of class "logical"}

\item{\code{crossSectionalAttachSection}}{Object of class "logical"}

\item{\code{crossSectionalAttachObservation}}{Object of class "logical"}
}}

\section{Warning}{

This class is not useful in itself, but all SDMX non-abstract classes will 
encapsulate it as slot, when parsing an SDMX-ML document (Concepts, or 
DataStructureDefinition)
}

\seealso{
\link{readSDMX}
}
\author{
Emmanuel Blondel, \email{emmanuel.blondel1@gmail.com}
}
