% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-new.R
\name{new-vector-along}
\alias{new-vector-along}
\alias{new_logical_along}
\alias{new_integer_along}
\alias{new_double_along}
\alias{new_character_along}
\alias{new_complex_along}
\alias{new_raw_along}
\alias{new_list_along}
\alias{rep_along}
\title{Create vectors matching the length of a given vector}
\usage{
new_logical_along(x, names = base::names(x))

new_integer_along(x, names = base::names(x))

new_double_along(x, names = base::names(x))

new_character_along(x, names = base::names(x))

new_complex_along(x, names = base::names(x))

new_raw_along(x, names = base::names(x))

new_list_along(x, names = base::names(x))

rep_along(.x, .y)
}
\arguments{
\item{x, .x}{A vector.}

\item{names}{Names for the new vector. Defaults to the names of
\code{x}. This can be a function to apply to the names of \code{x} as in
\code{\link[=set_names]{set_names()}}.}

\item{.y}{Values to repeat.}
}
\description{
These functions take the idea of \code{\link[=seq_along]{seq_along()}} and generalise it to
creating lists (\code{new_list_along}) and repeating values (\code{rep_along}).
Except for \code{new_list_along()} and \code{new_raw_along()}, the empty
vectors are filled with typed \code{missing} values.
}
\examples{
x <- 0:5
rep_along(x, 1:2)
rep_along(x, 1)
new_list_along(x)

# The default names are picked up from the input vector
x <- c(a = "foo", b = "bar")
new_character_along(x)
}
\seealso{
new-vector
}
