% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinalscore.R
\name{step_ordinalscore}
\alias{step_ordinalscore}
\title{Convert Ordinal Factors to Numeric Scores}
\usage{
step_ordinalscore(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = NULL,
  convert = as.numeric,
  skip = FALSE,
  id = rand_id("ordinalscore")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variables that will be
converted. This is \code{NULL} until computed by
\code{\link[=prep.recipe]{prep.recipe()}}.}

\item{convert}{A function that takes an ordinal factor vector
as an input and outputs a single numeric variable.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_ordinalscore} creates a \emph{specification} of a
recipe step that will convert ordinal factor variables into
numeric scores.
}
\details{
Dummy variables from ordered factors with \code{C}
levels will create polynomial basis functions with \code{C-1}
terms. As an alternative, this step can be used to translate the
ordered levels into a single numeric vector of values that
represent (subjective) scores. By default, the translation uses
a linear scale (1, 2, 3, ... \code{C}) but custom score
functions can also be used (see the example below).

When you \code{\link[=tidy]{tidy()}} this step, a tibble with column \code{terms} (the
columns that will be affected) is returned.
}
\examples{
fail_lvls <- c("meh", "annoying", "really_bad")

ord_data <-
  data.frame(item = c("paperclip", "twitter", "airbag"),
             fail_severity = factor(fail_lvls,
                                    levels = fail_lvls,
                                    ordered = TRUE))

model.matrix(~fail_severity, data = ord_data)

linear_values <- recipe(~ item + fail_severity, data = ord_data) \%>\%
  step_dummy(item) \%>\%
  step_ordinalscore(fail_severity)

linear_values <- prep(linear_values, training = ord_data)

bake(linear_values, new_data = NULL, everything())

custom <- function(x) {
  new_values <- c(1, 3, 7)
  new_values[as.numeric(x)]
}

nonlin_scores <- recipe(~ item + fail_severity, data = ord_data) \%>\%
  step_dummy(item) \%>\%
  step_ordinalscore(fail_severity, convert = custom)

tidy(nonlin_scores, number = 2)

nonlin_scores <- prep(nonlin_scores, training = ord_data)

bake(nonlin_scores, new_data = NULL, everything())

tidy(nonlin_scores, number = 2)
}
\seealso{
Other dummy variable and encoding steps: 
\code{\link{step_bin2factor}()},
\code{\link{step_count}()},
\code{\link{step_date}()},
\code{\link{step_dummy_multi_choice}()},
\code{\link{step_dummy}()},
\code{\link{step_factor2string}()},
\code{\link{step_holiday}()},
\code{\link{step_indicate_na}()},
\code{\link{step_integer}()},
\code{\link{step_novel}()},
\code{\link{step_num2factor}()},
\code{\link{step_other}()},
\code{\link{step_regex}()},
\code{\link{step_relevel}()},
\code{\link{step_string2factor}()},
\code{\link{step_unknown}()},
\code{\link{step_unorder}()}
}
\concept{dummy variable and encoding steps}
