% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvar-print.R
\encoding{UTF-8}
\name{print.rvar}
\alias{print.rvar}
\alias{format.rvar}
\alias{str.rvar}
\title{Print or format a random variable}
\usage{
\method{print}{rvar}(x, ..., summary = NULL, digits = 2, color = TRUE)

\method{format}{rvar}(x, ..., summary = NULL, digits = 2, color = FALSE)

\method{str}{rvar}(
  object,
  ...,
  summary = NULL,
  vec.len = NULL,
  indent.str = paste(rep.int(" ", max(0, nest.lev + 1)), collapse = ".."),
  nest.lev = 0,
  give.attr = TRUE
)
}
\arguments{
\item{x, object}{(rvar) The \code{\link{rvar}} to print.}

\item{...}{Further arguments passed to the underlying \code{\link[=print]{print()}} methods.}

\item{summary}{(string) The style of summary to display: \code{"mean_sd"} displays
\verb{mean±sd}, \code{"median_mad"} displays \verb{median±mad}. If \code{NULL},
\code{getOption("posterior.rvar_summary")} is used (default \verb{"mean_sd}).}

\item{digits}{(nonnegative integer) The minimum number of significant digits
to print.}

\item{color}{(logical) Whether or not to use color when formatting the
output. If \code{TRUE}, the \code{\link[pillar:style_subtle]{pillar::style_num()}} functions may be used to
produce strings containing control sequences to produce colored output on
the terminal.}

\item{vec.len}{(nonnegative integer) How many 'first few' elements are
displayed of each vector. If \code{NULL}, defaults to
\code{getOption("str")$vec.len}, which defaults to 4.}

\item{indent.str}{(string) The indentation string to use.}

\item{nest.lev}{(nonnegative integer) Current nesting level in the recursive
calls to \code{str()}.}

\item{give.attr}{(logical) If \code{TRUE} (default), show attributes as sub
structures.}
}
\value{
For \code{print()}, an invisible version of the input object.

For \code{str()}, nothing; i.e. \code{invisible(NULL)}.

For \code{format()}, a character vector of the same dimensions as \code{x} where each
entry is of the form \code{"mean±sd"} or \code{"median±mad"}, depending on the value
of \code{summary}.
}
\description{
Printing and formatting methods for \code{\link{rvar}}s.
}
\details{
\code{print()} and \code{str()} print out \code{\link{rvar}} objects by summarizing each element
in the random variable with either its mean±sd or median±mad, depending on
the value of \code{summary}. Both functions use the \code{format()} implementation for
\code{\link{rvar}} objects under the hood, which returns a character vector in the
mean±sd or median±mad form.
}
\examples{

set.seed(5678)
x = rbind(
  cbind(rvar(rnorm(1000, 1)), rvar(rnorm(1000, 2))),
  cbind(rvar(rnorm(1000, 3)), rvar(rnorm(1000, 4)))
)

print(x)
print(x, summary = "median_mad")

str(x)

format(x)

}
