% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/todo_comment_linter.R
\name{todo_comment_linter}
\alias{todo_comment_linter}
\title{TODO comment linter}
\usage{
todo_comment_linter(todo = c("todo", "fixme"), except_regex = NULL)
}
\arguments{
\item{todo}{Vector of case-insensitive strings that identify TODO comments.}

\item{except_regex}{Vector of case-sensitive regular expressions that identify
\emph{valid} TODO comments.}
}
\description{
Check that the source contains no TODO comments (case-insensitive).
}
\examples{
# will produce lints
lint(
  text = "x + y # TOODOO",
  linters = todo_comment_linter(todo = "toodoo")
)

lint(
  text = "pi <- 1.0 # FIIXMEE",
  linters = todo_comment_linter(todo = "fiixmee")
)

lint(
  text = "x <- TRUE # TOODOO(#1234): Fix this hack.",
  linters = todo_comment_linter()
)

# okay
lint(
  text = "x + y # my informative comment",
  linters = todo_comment_linter()
)

lint(
  text = "pi <- 3.14",
  linters = todo_comment_linter()
)

lint(
  text = "x <- TRUE",
  linters = todo_comment_linter()
)

lint(
  text = "x <- TRUE # TODO(#1234): Fix this hack.",
  linters = todo_comment_linter(except_regex = "TODO\\\\(#[0-9]+\\\\):")
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=configurable_linters]{configurable}, \link[=style_linters]{style}
}
