% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createOA.R
\name{createBose}
\alias{createBose}
\title{Create an orthogonal array using the Bose algorithm.}
\usage{
createBose(q, ncol, bRandom = TRUE)
}
\arguments{
\item{q}{the number of symbols in the array}

\item{ncol}{number of parameters or columns}

\item{bRandom}{should the array be randomized}
}
\value{
an orthogonal array
}
\description{
The \code{bose} program
produces \code{OA( q^2, k, q, 2 )},  \code{k <= q+1} for prime powers \code{q}.
}
\details{
From Owen: An orthogonal array \code{A} is a matrix of \code{n} rows, \code{k}
columns with every element being one of \code{q} symbols
\code{0,...,q-1}.  The array has strength \code{t} if, in every \code{n} by \code{t}
submatrix, the \code{q^t} possible distinct rows, all appear
the same number of times.  This number is the index
of the array, commonly denoted \code{lambda}.  Clearly,
\code{lambda*q^t=n}. The notation for such an array is \code{OA( n, k, q, t )}.
}
\examples{
A <- createBose(3, 3, FALSE)
B <- createBose(5, 4, TRUE)
}
\references{
Owen, Art.  Orthogonal Arrays for: Computer Experiments, Visualizations, and
Integration in high dimensions. \url{https://lib.stat.cmu.edu/designs/oa.c}. 1994
R.C. Bose (1938) Sankhya Vol 3 pp 323-338
}
\seealso{
Other methods to create orthogonal arrays [createBush()],
[createBoseBush()], [createAddelKemp()], [createAddelKemp3()],
[createAddelKempN()], [createBusht()], [createBoseBushl()]
}
