% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{extract_raw_output}
\alias{extract_raw_output}
\alias{restore_raw_output}
\alias{raw_output}
\title{Mark character strings as raw output that should not be converted}
\usage{
extract_raw_output(text, markers = raw_markers)

restore_raw_output(text, chunks, markers = raw_markers)

raw_output(x, markers = raw_markers, ...)
}
\arguments{
\item{text}{For \code{extract_raw_output()}, the content of the input file
(e.g. Markdown); for \code{restore_raw_output()}, the content of the output
file (e.g. HTML generated by Pandoc from Markdown).}

\item{markers}{A length-2 character vector to be used to wrap \code{x};
see \code{knitr:::raw_markers} for the default value.}

\item{chunks}{A named character vector returned from
\code{extract_raw_output()}.}

\item{x}{The character vector to be protected.}

\item{...}{Arguments to be passed to \code{\link{asis_output}()}.}
}
\value{
For \code{extract_raw_output()}, a list of two components:
  \code{value} (the \code{text} with raw output replaced by MD5 digests) and
  \code{chunks} (a named character vector, of which the names are MD5 digests
  and values are the raw output). For \code{restore_raw_output()}, the
  restored \code{text}.
}
\description{
These functions provide a mechanism to protect the character output of R code
chunks. The output is annotated with special markers in \code{raw_output};
\code{extract_raw_output()} will extract raw output wrapped in the markers,
and replace the raw output with its MD5 digest; \code{restore_raw_output()}
will restore the MD5 digest with the original raw output.
}
\details{
This mechanism is designed primarily for R Markdown pre/post-processors. In
an R code chunk, you generate \code{raw_output()} to the Markdown output. In
the pre-processor, you can \code{extract_raw_output()} from the Markdown
file, store the raw output and MD5 digests, and remove the actual raw output
from Markdown so Pandoc will never see it. In the post-processor, you can
read the Pandoc output (e.g., an HTML or RTF file), and restore the raw
output.
}
\examples{
library(knitr)
out = c("*hello*", raw_output("<special>content</special> *protect* me!"),
    "*world*")
pre = extract_raw_output(out)
str(pre)
pre$value = gsub("[*]([^*]+)[*]", "<em>\\\\1</em>",
    pre$value)  # think this as Pandoc conversion
pre$value
# raw output was protected from the conversion
# (e.g. *protect* was not converted)
restore_raw_output(pre$value, pre$chunks)
}
