#
# fields  is a package for analysis of spatial data written for
# the R software environment.
# Copyright (C) 2021 Colorado School of Mines
# 1500 Illinois St., Golden, CO 80401
# Contact: Douglas Nychka,  douglasnychka@gmail.edu,
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the R software environment if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
# or see http://www.r-project.org/Licenses/GPL-2
##END HEADER
"set.panel" <- function(m = 1, n = 1, relax = FALSE) {
    temp <- par()
    single.plot <- (temp$mfg[3] == 1 & temp$mfg[4] == 1)
    if (!relax | single.plot | ((m == 1) & (n == 1))) {
        par(mfrow = c(m, n))
        cat("plot window will lay out plots in a", m, "by", n, 
            "matrix ", fill = TRUE)
    }
    invisible()
}
