% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emmeans.R, R/emm-list.R
\name{as.list.emmGrid}
\alias{as.list.emmGrid}
\alias{as.emm_list}
\alias{as.emmGrid}
\title{Convert to and from \code{emmGrid} objects}
\usage{
\method{as.list}{emmGrid}(x, model.info.slot = FALSE, ...)

as.emm_list(object, ...)

as.emmGrid(object, ...)
}
\arguments{
\item{x}{An \code{emmGrid} object}

\item{model.info.slot}{Logical value: Include the \code{model.info} slot?
Set this to \code{TRUE} if you want to preserve the original call and 
information needed by the \code{submodel} option.
If \code{FALSE}, only the nesting information (if any) is saved}

\item{...}{In \code{as.emmGrid}, additional arguments passed to 
\code{\link{update.emmGrid}} before returning the object. This
argument is ignored in \code{as.list.emmGrid}}

\item{object}{Object to be converted to class \code{emmGrid}. It may
be a \code{list} returned by \code{as.list.emmGrid}, or a \code{ref.grid}
or \code{lsmobj} object created by \pkg{emmeans}'s predecessor, the 
\pkg{lsmeans} package. An error is thrown if \code{object} cannot
be converted.}
}
\value{
\code{as.list.emmGrid} returns an object of class \code{list}.

\code{as.emm_list} returns an object of class \code{emm_list}.

\code{as.emmGrid} returns an object of class \code{emmGrid}. 
    However, in fact, both \code{as.emmGrid} and \code{as.emm_list} check for an
    attribute in \code{object} to decide whether to return an \code{emmGrid} 
    or \code{emm_list)} object.
}
\description{
These are useful utility functions for creating a compact version of an
\code{emmGrid} object that may be saved and later reconstructed, or for
converting old \code{ref.grid} or \code{lsmobj} objects into \code{emmGrid}
objects.
}
\details{
An \code{emmGrid} object is an S4 object, and as such cannot be saved in a
text format or saved without a lot of overhead. By using \code{as.list},
the essential parts of the object are converted to a list format that can be
easily and compactly saved for use, say, in another session or by another user.
Providing this list as the arguments for \code{\link{emmobj}} allows the user 
to restore a working \code{emmGrid} object.
}
\examples{
pigs.lm <- lm(log(conc) ~ source + factor(percent), data = pigs)
pigs.sav <- as.list(ref_grid(pigs.lm))

pigs.anew <- as.emmGrid(pigs.sav)
emmeans(pigs.anew, "source")
}
\seealso{
\code{\link{emmobj}}
}
