% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql-expr.R
\name{sql_expr}
\alias{sql_expr}
\title{Generate SQL from R expressions}
\usage{
sql_expr(x, con = sql_current_con())
}
\arguments{
\item{x}{A quasiquoted expression}

\item{con}{An optional database connection to control the details of
the translation. The default, \code{NULL}, generates ANSI SQL.}
}
\description{
Low-level building block for generating SQL from R expressions.
Strings are escaped; names become bare SQL identifiers. User infix
functions have \code{\\\%} stripped.
}
\examples{
sql_expr(f(x + 1))

sql_expr(f("x", "y"))
sql_expr(f(x, y))

sql_expr(cast("x" \%as\% DECIMAL))
sql_expr(round(x) \%::\% numeric)
}
