% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bic_to_bf.R
\name{bic_to_bf}
\alias{bic_to_bf}
\title{Convert BIC indices to Bayes Factors via the BIC-approximation method.}
\usage{
bic_to_bf(bic, denominator, log = FALSE)
}
\arguments{
\item{bic}{A vector of BIC values.}

\item{denominator}{The BIC value to use as a denominator (to test against).}

\item{log}{Return the \code{log(BF)}?}
}
\value{
The Bayes Factors corresponding to the BIC values against the denominator.
}
\description{
Convert BIC indices to Bayes Factors via the BIC-approximation method.
}
\examples{
bic1 <- BIC(lm(Sepal.Length ~ 1, data = iris))
bic2 <- BIC(lm(Sepal.Length ~ Species, data = iris))
bic3 <- BIC(lm(Sepal.Length ~ Species + Petal.Length, data = iris))
bic4 <- BIC(lm(Sepal.Length ~ Species * Petal.Length, data = iris))

bic_to_bf(c(bic1, bic2, bic3, bic4), denominator = bic1)
}
