% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/methods_row.R
\name{colRanks,dgCMatrix-method}
\alias{colRanks,dgCMatrix-method}
\alias{rowRanks,dgCMatrix-method}
\title{Calculates the rank of the elements for each row (column) of a matrix-like
object}
\usage{
\S4method{colRanks}{dgCMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  ties.method = c("max", "average", "min"),
  preserveShape = FALSE,
  na.handling = c("keep", "last"),
  ...,
  useNames = TRUE
)

\S4method{rowRanks}{dgCMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  ties.method = c("max", "average", "min"),
  preserveShape = TRUE,
  na.handling = c("keep", "last"),
  ...,
  useNames = TRUE
)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{ties.method}{A character string specifying how ties are treated. Note
that the default specifies fewer options than the original matrixStats
package.}

\item{preserveShape}{a boolean that specifies if the returned matrix has the same
dimensions as the input matrix. By default this is true for `rowRanks()`, but false for
`colRanks()`.}

\item{na.handling}{string specifying how `NA`s are handled. They can either be preserved with an `NA` rank
('keep') or sorted in at the end ('last'). Default is 'keep' derived from the behavior of the equivalent}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{TRUE}} (default), names attributes of result are set. Else if \code{\link{FALSE}}, no naming support is done.}
}
\value{
a matrix of type \code{\link{integer}} is returned unless
\code{ties.method = "average"}. Ithas dimensions` \code{NxJ} (\code{KxJ})
\code{\link{matrix}}, where N (K) is the number of rows (columns) of the
input x.
}
\description{
Calculates the rank of the elements for each row (column) of a matrix-like
object.
}
\details{
There are three different methods available for handling ties:
   \describe{
     \item{`max`}{for values with identical values the maximum rank is returned}
     \item{`average`}{for values with identical values the average of the ranks they cover
     is returned. Note, that in this case the return value is of type `numeric`.}
     \item{`min`}{for values with identical values the minimum rank is returned.}
   }
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)

rowRanks(mat)
colRanks(mat)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowRanks}()} and
\code{matrixStats::\link[matrixStats:rowRanks]{colRanks}()} which are used
when the input is a \code{matrix} or \code{numeric} vector.
\item \link[base:rank]{base::rank}
}
}
