% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictSomatic.R
\name{predictSomatic}
\alias{predictSomatic}
\title{Predict germline vs. somatic status}
\usage{
predictSomatic(res, id = 1, return.vcf = FALSE)
}
\arguments{
\item{res}{Return object of the \code{\link{runAbsoluteCN}} function.}

\item{id}{Candidate solutions to be analyzed. \code{id=1} will analyze the
maximum likelihood solution.}

\item{return.vcf}{Returns an annotated \code{CollapsedVCF} object. Note that
this VCF will only contain variants not filtered out by the \code{filterVcf}
functions. Variants outside segments or intervals might be included or not
depending on \code{\link{runAbsoluteCN}} arguments.}
}
\value{
A \code{data.frame} or \code{CollapsedVCF} with SNV state posterior
probabilities.
}
\description{
This function takes as input the output of a \code{\link{runAbsoluteCN}} run
and provides SNV posterior probabilities for all possible states.
}
\examples{

data(purecn.example.output)
# the output data was created using a matched normal sample, but in case
# no matched normal is available, this will help predicting somatic vs. 
# germline status
purecnSnvs <- predictSomatic(purecn.example.output)

# Prefer GRanges?
purecnSnvs <- GRanges(predictSomatic(purecn.example.output))

# write a VCF file
purecnVcf <- predictSomatic(purecn.example.output, return.vcf=TRUE)
writeVcf(purecnVcf, file = "Sample1_PureCN.vcf")

}
\seealso{
\code{\link{runAbsoluteCN}}
}
\author{
Markus Riester
}
