% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfamAnalyzeR.R
\name{pfamAnalyzeR}
\alias{pfamAnalyzeR}
\title{Read in and analyze pfam domains isotypes}
\usage{
pfamAnalyzeR(path, fracCutoff = 0.1)
}
\arguments{
\item{path}{A string indicating the full path to the Pfam result file}

\item{fracCutoff}{The fraction of a protein domain that must be affected before classifying it a truncation or indel.}
}
\value{
The data.frame with the Pfam results now augmented with info about domain structural variation
}
\description{
Read in and analyze pfam domains isotypes
}
\examples{
### Predict domain isotypes in pfam results
pfamResultFile <- system.file("extdata/pfam_results.txt", package = "pfamAnalyzeR")
pfamRes <- pfamAnalyzeR(pfamResultFile)
}
