% File src/library/utils/man/process.events.Rd
% Part of the R package, https://www.R-project.org
% Copyright 2012 R Core Team
% Distributed under GPL 2 or later

\name{process.events}
\alias{process.events}
\title{
Trigger event handling
}
\description{
R front ends like the Windows GUI handle key presses and mouse clicks
through \dQuote{events} generated by the OS. These are processed
automatically by R at intervals during computations, but in some cases
it may be desirable to trigger immediate event handling.  The
\code{process.events} function does that.
}
\usage{
process.events()
}
\details{
This is a simple wrapper for the C API function
\code{R_ProcessEvents}.  As such, it is possible that it will not
return if the user has signalled to interrupt the calculation.
}
\value{
\code{NULL} is returned invisibly.
}
\author{
Duncan Murdoch
}
\seealso{
See \sQuote{Writing R Extensions} and the \sQuote{R for Windows FAQ}
for more discussion of the \code{R_ProcessEvents} function.
}
\keyword{ utilities }
