/***************************************************************************
 *   Copyright (C) 2008-2011 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KOSD.                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "kosd/kosd.h"

#include "configuration.h"
#include "configurationwidget.h"

#include <KPluginFactory>

K_PLUGIN_FACTORY(ConfigurationWidgetFactory, registerPlugin<ConfigurationWidget>();)
K_EXPORT_PLUGIN(ConfigurationWidgetFactory("kcm_kosd", "kosd")) 

ConfigurationWidget::ConfigurationWidget(QWidget* parent, const QVariantList&)
    : KCModule(ConfigurationWidgetFactory::componentData(), parent)
{
    m_ui.setupUi(this);
    connect(m_ui.kcfg_Type, SIGNAL(changed(int)), this, SLOT(changed()));
    connect(m_ui.kcfg_HPos, SIGNAL(valueChanged(int)), this, SLOT(changed()));
    connect(m_ui.kcfg_VPos, SIGNAL(valueChanged(int)), this, SLOT(changed()));
    connect(m_ui.kcfg_Opacity, SIGNAL(valueChanged(int)), this, SLOT(changed()));

    addConfig(Configuration::self(), this);
}


ConfigurationWidget::~ConfigurationWidget()
{
}


void ConfigurationWidget::save()
{
    KCModule::save();
    KOsd::parseConfiguration();
}

#include "configurationwidget.moc"
