/*
 *		Copyright (C) 2013-2015, 2019 by the Konclude Developer Team.
 *
 *		This file is part of the reasoning system Konclude.
 *		For details and support, see <http://konclude.com/>.
 *
 *		Konclude is free software: you can redistribute it and/or modify
 *		it under the terms of version 3 of the GNU Lesser General Public
 *		License (LGPLv3) as published by the Free Software Foundation.
 *
 *		Konclude is distributed in the hope that it will be useful,
 *		but WITHOUT ANY WARRANTY; without even the implied warranty of
 *		MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *		GNU (Lesser) General Public License for more details.
 *
 *		You should have received a copy of the GNU (Lesser) General Public
 *		License along with Konclude. If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef KONCLUDE_TEST_COWLRECURSIONTESTDATAGENERATOR_H
#define KONCLUDE_TEST_COWLRECURSIONTESTDATAGENERATOR_H

// Libraries includes
#include <QXmlStreamWriter>

// Namespace includes
#include "Utilities/UtilitiesSettings.h"

// Other includes
#include <cmath>


// Logger includes
#include "Logger/CLogger.h"
#include "Logger/CLogIdentifier.h"



namespace Konclude {

	using namespace Logger;
	using namespace Utilities;

	namespace Test {


		/*! 
		 *
		 *		\class		COWLRecursionTestDataGenerator
		 *		\author		Andreas Steigmiller
		 *		\version	0.1
		 *		\brief		TODO
		 *
		 */
		class COWLRecursionTestDataGenerator : public CLogIdentifier {

			// public methods
			public:
				//! Constructor
				COWLRecursionTestDataGenerator();

				//! Destructor
				virtual ~COWLRecursionTestDataGenerator();

				void generateData(cint64 size, double rate, const QString& filename);

			// protected methods
			protected:
				void createLargeJoinData(cint64 size, double rate);
				void createIndividualDeclarations(cint64 size);
				void createPropertyDeclarations();
				void createPropertyAssertions(const QString& propertyName, cint64 count, cint64 maxNumber);
				void createPropertyCycleAssertions(const QString& propertyName, cint64 maxNumber);


				void writePropertyDeclaration(const QString& propertyName);
				void writeIndividualDeclaration(const QString& indiviualName);
				void writeIndividualPropertyAssertion(const QString& propertyName, const QString& indiviualName1, const QString& indiviualName2);

				QString getIndividualName(cint64 indiNumber);

			// protected variables
			protected:
				QString owllinkNS;
				QString owlNS;

				cint64 mIndividualsNumberSize;
				QString mIndividualBaseName;
				QString mPropertyBaseName;
				QXmlStreamWriter* mXMLWriter;

				QSet< QPair<cint64,cint64> > mPropPairSet;



			// private methods
			private:

			// private variables
			private:

		};

	}; // end namespace Test

}; // end namespace Konclude

#endif // KONCLUDE_TEST_COWLRECURSIONTESTDATAGENERATOR_H
