
import sys
import antlr

import logging
l = logging.getLogger(__name__)

def parseString(text):
    import StringIO
    l.debug("parse " + repr(text))
    fileHandle = StringIO.StringIO(text)
    ast = parse(fileHandle)
    fileHandle.close() 
    return ast

def parse(readObject):
   import MaximaLexer
   import MaximaParser

   L = MaximaLexer.Lexer(readObject)
   P = MaximaParser.Parser(L)

   ### Parse the input expression
   res = P.sentence()
   l.debug(repr(res))

   ast = P.getAST()
   l.debug("Root AST is " + repr(ast))

   if not ast:
      l.debug("no AST generated.")

   ###show tree
   l.debug("List: " + ast.toStringList())
   
   return ast



if __name__ == "__main__":
   parse("maxima.in")
