/*
 * AM64X Clocks Info
 *
 * Copyright (C) 2020 Texas Instruments Incorporated - https://www.ti.com/
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <tisci.h>
#include <socinfo.h>

struct ti_sci_clocks_info am64x_clocks_info[] = {
	{137, 0, "DEV_A53SS0_COREPAC_ARM_CLK_CLK", "Input clock"},
	{137, 1, "DEV_A53SS0_PLL_CTRL_CLK", "Input clock"},
	{137, 2, "DEV_A53SS0_A53_DIVH_CLK4_OBSCLK_OUT_CLK", "Output clock"},
	{135, 0, "DEV_A53SS0_CORE_0_A53_CORE0_ARM_CLK_CLK", "Input clock"},
	{136, 0, "DEV_A53SS0_CORE_1_A53_CORE1_ARM_CLK_CLK", "Input clock"},
	{0, 0, "DEV_ADC0_ADC_CLK", "Input muxed clock"},
	{0, 1, "DEV_ADC0_ADC_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_ADC0_ADC_CLK"},
	{0, 2, "DEV_ADC0_ADC_CLK_PARENT_POSTDIV1_16FFT_MAIN_1_HSDIVOUT6_CLK", "Parent input clock option to DEV_ADC0_ADC_CLK"},
	{0, 3, "DEV_ADC0_ADC_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT8_CLK", "Parent input clock option to DEV_ADC0_ADC_CLK"},
	{0, 4, "DEV_ADC0_ADC_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_ADC0_ADC_CLK"},
	{0, 5, "DEV_ADC0_SYS_CLK", "Input clock"},
	{0, 6, "DEV_ADC0_VBUS_CLK", "Input clock"},
	{157, 0, "DEV_BOARD0_FSI_TX0_CLK_IN", "Input clock"},
	{157, 1, "DEV_BOARD0_FSI_TX1_CLK_IN", "Input clock"},
	{157, 2, "DEV_BOARD0_GPMC0_CLKLB_IN", "Input clock"},
	{157, 3, "DEV_BOARD0_GPMC0_CLK_IN", "Input clock"},
	{157, 4, "DEV_BOARD0_GPMC0_FCLK_MUX_IN", "Input muxed clock"},
	{157, 5, "DEV_BOARD0_GPMC0_FCLK_MUX_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_BOARD0_GPMC0_FCLK_MUX_IN"},
	{157, 6, "DEV_BOARD0_GPMC0_FCLK_MUX_IN_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT7_CLK", "Parent input clock option to DEV_BOARD0_GPMC0_FCLK_MUX_IN"},
	{157, 7, "DEV_BOARD0_I2C0_SCL_IN", "Input clock"},
	{157, 8, "DEV_BOARD0_I2C1_SCL_IN", "Input clock"},
	{157, 9, "DEV_BOARD0_I2C2_SCL_IN", "Input clock"},
	{157, 10, "DEV_BOARD0_I2C3_SCL_IN", "Input clock"},
	{157, 11, "DEV_BOARD0_MCU_I2C0_SCL_IN", "Input clock"},
	{157, 12, "DEV_BOARD0_MCU_I2C1_SCL_IN", "Input clock"},
	{157, 13, "DEV_BOARD0_MCU_OBSCLK0_IN", "Input muxed clock"},
	{157, 14, "DEV_BOARD0_MCU_OBSCLK0_IN_PARENT_MCU_OBSCLK_DIV_OUT0", "Parent input clock option to DEV_BOARD0_MCU_OBSCLK0_IN"},
	{157, 15, "DEV_BOARD0_MCU_OBSCLK0_IN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_BOARD0_MCU_OBSCLK0_IN"},
	{157, 16, "DEV_BOARD0_MCU_SPI0_CLK_IN", "Input clock"},
	{157, 17, "DEV_BOARD0_MCU_SPI1_CLK_IN", "Input clock"},
	{157, 18, "DEV_BOARD0_MCU_SYSCLKOUT0_IN", "Input clock"},
	{157, 19, "DEV_BOARD0_MCU_TIMER_IO0_IN", "Input clock"},
	{157, 20, "DEV_BOARD0_MCU_TIMER_IO1_IN", "Input clock"},
	{157, 21, "DEV_BOARD0_MCU_TIMER_IO2_IN", "Input clock"},
	{157, 22, "DEV_BOARD0_MCU_TIMER_IO3_IN", "Input clock"},
	{157, 23, "DEV_BOARD0_MMC1_CLK_IN", "Input clock"},
	{157, 24, "DEV_BOARD0_OBSCLK0_IN", "Input clock"},
	{157, 25, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 26, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 27, "DEV_BOARD0_OBSCLK0_IN_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 28, "DEV_BOARD0_OBSCLK0_IN_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 29, "DEV_BOARD0_OBSCLK0_IN_PARENT_K3_CPTS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 30, "DEV_BOARD0_OBSCLK0_IN_PARENT_K3_CPTS_MAIN_0_CPTS_GENF2", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 31, "DEV_BOARD0_OBSCLK0_IN_PARENT_K3_CPTS_MAIN_0_CPTS_GENF3", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 32, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV1_16FFT_MAIN_14_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 33, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 34, "DEV_BOARD0_OBSCLK0_IN_PARENT_SAM64_A53_256KB_WRAP_MAIN_0_ARM_COREPACK_0_A53_DIVH_CLK4_OBSCLK_OUT_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 35, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MAIN_12_HSDIVOUT0_CLK", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 36, "DEV_BOARD0_OBSCLK0_IN_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 37, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 38, "DEV_BOARD0_OBSCLK0_IN_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT0_CLK_DUP0", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 39, "DEV_BOARD0_OBSCLK0_IN_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 40, "DEV_BOARD0_OBSCLK0_IN_PARENT_GLUELOGIC_RCOSC_CLK_1P0V_97P65K3", "Parent input clock option to DEV_BOARD0_OBSCLK0_IN"},
	{157, 41, "DEV_BOARD0_OSPI0_LBCLKO_IN", "Input clock"},
	{157, 42, "DEV_BOARD0_PRG0_MDIO0_MDC_IN", "Input clock"},
	{157, 43, "DEV_BOARD0_PRG0_RGMII1_TXC_IN", "Input clock"},
	{157, 44, "DEV_BOARD0_PRG0_RGMII2_TXC_IN", "Input clock"},
	{157, 45, "DEV_BOARD0_PRG1_MDIO0_MDC_IN", "Input clock"},
	{157, 46, "DEV_BOARD0_PRG1_RGMII1_TXC_IN", "Input clock"},
	{157, 47, "DEV_BOARD0_PRG1_RGMII2_TXC_IN", "Input clock"},
	{157, 48, "DEV_BOARD0_RGMII1_TXC_IN", "Input clock"},
	{157, 49, "DEV_BOARD0_RGMII2_TXC_IN", "Input clock"},
	{157, 50, "DEV_BOARD0_SPI0_CLK_IN", "Input clock"},
	{157, 51, "DEV_BOARD0_SPI1_CLK_IN", "Input clock"},
	{157, 52, "DEV_BOARD0_SPI2_CLK_IN", "Input clock"},
	{157, 53, "DEV_BOARD0_SPI3_CLK_IN", "Input clock"},
	{157, 54, "DEV_BOARD0_SPI4_CLK_IN", "Input clock"},
	{157, 55, "DEV_BOARD0_SYSCLKOUT0_IN", "Input clock"},
	{157, 56, "DEV_BOARD0_TIMER_IO0_IN", "Input clock"},
	{157, 57, "DEV_BOARD0_TIMER_IO10_IN", "Input clock"},
	{157, 58, "DEV_BOARD0_TIMER_IO11_IN", "Input clock"},
	{157, 59, "DEV_BOARD0_TIMER_IO1_IN", "Input clock"},
	{157, 60, "DEV_BOARD0_TIMER_IO2_IN", "Input clock"},
	{157, 61, "DEV_BOARD0_TIMER_IO3_IN", "Input clock"},
	{157, 62, "DEV_BOARD0_TIMER_IO4_IN", "Input clock"},
	{157, 63, "DEV_BOARD0_TIMER_IO5_IN", "Input clock"},
	{157, 64, "DEV_BOARD0_TIMER_IO6_IN", "Input clock"},
	{157, 65, "DEV_BOARD0_TIMER_IO7_IN", "Input clock"},
	{157, 66, "DEV_BOARD0_TIMER_IO8_IN", "Input clock"},
	{157, 67, "DEV_BOARD0_TIMER_IO9_IN", "Input clock"},
	{157, 68, "DEV_BOARD0_CPTS0_RFT_CLK_OUT", "Output clock"},
	{157, 69, "DEV_BOARD0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Output clock"},
	{157, 70, "DEV_BOARD0_EXT_REFCLK1_OUT", "Output clock"},
	{157, 71, "DEV_BOARD0_FSI_RX0_CLK_OUT", "Output clock"},
	{157, 72, "DEV_BOARD0_FSI_RX1_CLK_OUT", "Output clock"},
	{157, 73, "DEV_BOARD0_FSI_RX2_CLK_OUT", "Output clock"},
	{157, 74, "DEV_BOARD0_FSI_RX3_CLK_OUT", "Output clock"},
	{157, 75, "DEV_BOARD0_FSI_RX4_CLK_OUT", "Output clock"},
	{157, 76, "DEV_BOARD0_FSI_RX5_CLK_OUT", "Output clock"},
	{157, 77, "DEV_BOARD0_GPMC0_CLKLB_OUT", "Output clock"},
	{157, 78, "DEV_BOARD0_I2C0_SCL_OUT", "Output clock"},
	{157, 79, "DEV_BOARD0_I2C1_SCL_OUT", "Output clock"},
	{157, 80, "DEV_BOARD0_I2C2_SCL_OUT", "Output clock"},
	{157, 81, "DEV_BOARD0_I2C3_SCL_OUT", "Output clock"},
	{157, 82, "DEV_BOARD0_LED_CLK_OUT", "Output clock"},
	{157, 83, "DEV_BOARD0_MCU_EXT_REFCLK0_OUT", "Output clock"},
	{157, 84, "DEV_BOARD0_MCU_I2C0_SCL_OUT", "Output clock"},
	{157, 85, "DEV_BOARD0_MCU_I2C1_SCL_OUT", "Output clock"},
	{157, 86, "DEV_BOARD0_MCU_SPI0_CLK_OUT", "Output clock"},
	{157, 87, "DEV_BOARD0_MCU_SPI1_CLK_OUT", "Output clock"},
	{157, 88, "DEV_BOARD0_MMC1_CLKLB_OUT", "Output clock"},
	{157, 89, "DEV_BOARD0_OSPI0_DQS_OUT", "Output clock"},
	{157, 90, "DEV_BOARD0_OSPI0_LBCLKO_OUT", "Output clock"},
	{157, 91, "DEV_BOARD0_PRG0_RGMII1_RXC_OUT", "Output clock"},
	{157, 92, "DEV_BOARD0_PRG0_RGMII1_TXC_OUT", "Output clock"},
	{157, 93, "DEV_BOARD0_PRG0_RGMII2_RXC_OUT", "Output clock"},
	{157, 94, "DEV_BOARD0_PRG0_RGMII2_TXC_OUT", "Output clock"},
	{157, 95, "DEV_BOARD0_PRG1_RGMII1_RXC_OUT", "Output clock"},
	{157, 96, "DEV_BOARD0_PRG1_RGMII1_TXC_OUT", "Output clock"},
	{157, 97, "DEV_BOARD0_PRG1_RGMII2_RXC_OUT", "Output clock"},
	{157, 98, "DEV_BOARD0_PRG1_RGMII2_TXC_OUT", "Output clock"},
	{157, 99, "DEV_BOARD0_RGMII1_RXC_OUT", "Output clock"},
	{157, 100, "DEV_BOARD0_RGMII1_TXC_OUT", "Output clock"},
	{157, 101, "DEV_BOARD0_RGMII2_RXC_OUT", "Output clock"},
	{157, 102, "DEV_BOARD0_RGMII2_TXC_OUT", "Output clock"},
	{157, 103, "DEV_BOARD0_RMII_REF_CLK_OUT", "Output clock"},
	{157, 104, "DEV_BOARD0_SPI0_CLK_OUT", "Output clock"},
	{157, 105, "DEV_BOARD0_SPI1_CLK_OUT", "Output clock"},
	{157, 106, "DEV_BOARD0_SPI2_CLK_OUT", "Output clock"},
	{157, 107, "DEV_BOARD0_SPI3_CLK_OUT", "Output clock"},
	{157, 108, "DEV_BOARD0_SPI4_CLK_OUT", "Output clock"},
	{157, 109, "DEV_BOARD0_TCK_OUT", "Output clock"},
	{1, 0, "DEV_CMP_EVENT_INTROUTER0_INTR_CLK", "Input clock"},
	{13, 0, "DEV_CPSW0_CPPI_CLK_CLK", "Input clock"},
	{13, 1, "DEV_CPSW0_CPTS_RFT_CLK", "Input muxed clock"},
	{13, 2, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT5_CLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{13, 3, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{13, 4, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{13, 5, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{13, 6, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{13, 7, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{13, 8, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_WIZ16B2M4CT_MAIN_0_IP1_LN0_TXMCLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{13, 9, "DEV_CPSW0_CPTS_RFT_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_CPSW0_CPTS_RFT_CLK"},
	{13, 10, "DEV_CPSW0_GMII1_MR_CLK", "Input clock"},
	{13, 11, "DEV_CPSW0_GMII1_MT_CLK", "Input clock"},
	{13, 12, "DEV_CPSW0_GMII2_MR_CLK", "Input clock"},
	{13, 13, "DEV_CPSW0_GMII2_MT_CLK", "Input clock"},
	{13, 14, "DEV_CPSW0_GMII_RFT_CLK", "Input clock"},
	{13, 15, "DEV_CPSW0_RGMII1_RXC_I", "Input clock"},
	{13, 16, "DEV_CPSW0_RGMII1_TXC_I", "Input clock"},
	{13, 17, "DEV_CPSW0_RGMII2_RXC_I", "Input clock"},
	{13, 18, "DEV_CPSW0_RGMII2_TXC_I", "Input clock"},
	{13, 19, "DEV_CPSW0_RGMII_MHZ_250_CLK", "Input clock"},
	{13, 20, "DEV_CPSW0_RGMII_MHZ_50_CLK", "Input clock"},
	{13, 21, "DEV_CPSW0_RGMII_MHZ_5_CLK", "Input clock"},
	{13, 22, "DEV_CPSW0_RMII_MHZ_50_CLK", "Input clock"},
	{13, 23, "DEV_CPSW0_CPTS_GENF0", "Output clock"},
	{13, 24, "DEV_CPSW0_CPTS_GENF1", "Output clock"},
	{13, 25, "DEV_CPSW0_RGMII1_TXC_O", "Output clock"},
	{13, 26, "DEV_CPSW0_RGMII2_TXC_O", "Output clock"},
	{14, 0, "DEV_CPT2_AGGR0_VCLK_CLK", "Input clock"},
	{84, 0, "DEV_CPTS0_CPTS_RFT_CLK", "Input muxed clock"},
	{84, 1, "DEV_CPTS0_CPTS_RFT_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT5_CLK", "Parent input clock option to DEV_CPTS0_CPTS_RFT_CLK"},
	{84, 2, "DEV_CPTS0_CPTS_RFT_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_CPTS0_CPTS_RFT_CLK"},
	{84, 3, "DEV_CPTS0_CPTS_RFT_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_CPTS0_CPTS_RFT_CLK"},
	{84, 4, "DEV_CPTS0_CPTS_RFT_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_CPTS0_CPTS_RFT_CLK"},
	{84, 5, "DEV_CPTS0_CPTS_RFT_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_CPTS0_CPTS_RFT_CLK"},
	{84, 6, "DEV_CPTS0_CPTS_RFT_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_CPTS0_CPTS_RFT_CLK"},
	{84, 7, "DEV_CPTS0_CPTS_RFT_CLK_PARENT_WIZ16B2M4CT_MAIN_0_IP1_LN0_TXMCLK", "Parent input clock option to DEV_CPTS0_CPTS_RFT_CLK"},
	{84, 8, "DEV_CPTS0_CPTS_RFT_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_CPTS0_CPTS_RFT_CLK"},
	{84, 9, "DEV_CPTS0_VBUSP_CLK", "Input clock"},
	{84, 10, "DEV_CPTS0_CPTS_GENF1", "Output clock"},
	{84, 11, "DEV_CPTS0_CPTS_GENF2", "Output clock"},
	{84, 12, "DEV_CPTS0_CPTS_GENF3", "Output clock"},
	{84, 13, "DEV_CPTS0_CPTS_GENF4", "Output clock"},
	{2, 0, "DEV_DBGSUSPENDROUTER0_INTR_CLK", "Input clock"},
	{16, 0, "DEV_DCC0_DCC_CLKSRC0_CLK", "Input clock"},
	{16, 1, "DEV_DCC0_DCC_CLKSRC1_CLK", "Input clock"},
	{16, 2, "DEV_DCC0_DCC_CLKSRC2_CLK", "Input clock"},
	{16, 3, "DEV_DCC0_DCC_CLKSRC3_CLK", "Input clock"},
	{16, 4, "DEV_DCC0_DCC_CLKSRC4_CLK", "Input clock"},
	{16, 5, "DEV_DCC0_DCC_CLKSRC5_CLK", "Input clock"},
	{16, 6, "DEV_DCC0_DCC_CLKSRC6_CLK", "Input clock"},
	{16, 7, "DEV_DCC0_DCC_CLKSRC7_CLK", "Input clock"},
	{16, 8, "DEV_DCC0_DCC_INPUT00_CLK", "Input clock"},
	{16, 9, "DEV_DCC0_DCC_INPUT01_CLK", "Input clock"},
	{16, 10, "DEV_DCC0_DCC_INPUT02_CLK", "Input clock"},
	{16, 11, "DEV_DCC0_DCC_INPUT10_CLK", "Input clock"},
	{16, 12, "DEV_DCC0_VBUS_CLK", "Input clock"},
	{17, 0, "DEV_DCC1_DCC_CLKSRC0_CLK", "Input clock"},
	{17, 1, "DEV_DCC1_DCC_CLKSRC1_CLK", "Input clock"},
	{17, 2, "DEV_DCC1_DCC_CLKSRC2_CLK", "Input clock"},
	{17, 3, "DEV_DCC1_DCC_CLKSRC3_CLK", "Input clock"},
	{17, 4, "DEV_DCC1_DCC_CLKSRC4_CLK", "Input clock"},
	{17, 5, "DEV_DCC1_DCC_CLKSRC5_CLK", "Input clock"},
	{17, 6, "DEV_DCC1_DCC_CLKSRC6_CLK", "Input clock"},
	{17, 7, "DEV_DCC1_DCC_CLKSRC7_CLK", "Input clock"},
	{17, 8, "DEV_DCC1_DCC_INPUT00_CLK", "Input clock"},
	{17, 9, "DEV_DCC1_DCC_INPUT01_CLK", "Input clock"},
	{17, 10, "DEV_DCC1_DCC_INPUT02_CLK", "Input clock"},
	{17, 11, "DEV_DCC1_DCC_INPUT10_CLK", "Input clock"},
	{17, 12, "DEV_DCC1_VBUS_CLK", "Input clock"},
	{18, 0, "DEV_DCC2_DCC_CLKSRC0_CLK", "Input clock"},
	{18, 1, "DEV_DCC2_DCC_CLKSRC1_CLK", "Input clock"},
	{18, 2, "DEV_DCC2_DCC_CLKSRC2_CLK", "Input clock"},
	{18, 3, "DEV_DCC2_DCC_CLKSRC3_CLK", "Input clock"},
	{18, 4, "DEV_DCC2_DCC_CLKSRC4_CLK", "Input clock"},
	{18, 5, "DEV_DCC2_DCC_CLKSRC5_CLK", "Input clock"},
	{18, 6, "DEV_DCC2_DCC_CLKSRC6_CLK", "Input clock"},
	{18, 7, "DEV_DCC2_DCC_CLKSRC7_CLK", "Input clock"},
	{18, 8, "DEV_DCC2_DCC_INPUT00_CLK", "Input clock"},
	{18, 9, "DEV_DCC2_DCC_INPUT01_CLK", "Input clock"},
	{18, 10, "DEV_DCC2_DCC_INPUT02_CLK", "Input clock"},
	{18, 11, "DEV_DCC2_DCC_INPUT10_CLK", "Input clock"},
	{18, 12, "DEV_DCC2_VBUS_CLK", "Input clock"},
	{19, 0, "DEV_DCC3_DCC_CLKSRC0_CLK", "Input clock"},
	{19, 1, "DEV_DCC3_DCC_CLKSRC1_CLK", "Input clock"},
	{19, 2, "DEV_DCC3_DCC_CLKSRC2_CLK", "Input clock"},
	{19, 3, "DEV_DCC3_DCC_CLKSRC3_CLK", "Input clock"},
	{19, 4, "DEV_DCC3_DCC_CLKSRC4_CLK", "Input clock"},
	{19, 5, "DEV_DCC3_DCC_CLKSRC5_CLK", "Input clock"},
	{19, 6, "DEV_DCC3_DCC_CLKSRC6_CLK", "Input clock"},
	{19, 7, "DEV_DCC3_DCC_CLKSRC7_CLK", "Input clock"},
	{19, 8, "DEV_DCC3_DCC_INPUT00_CLK", "Input clock"},
	{19, 9, "DEV_DCC3_DCC_INPUT01_CLK", "Input clock"},
	{19, 10, "DEV_DCC3_DCC_INPUT02_CLK", "Input clock"},
	{19, 11, "DEV_DCC3_DCC_INPUT10_CLK", "Input clock"},
	{19, 12, "DEV_DCC3_VBUS_CLK", "Input clock"},
	{20, 0, "DEV_DCC4_DCC_CLKSRC0_CLK", "Input muxed clock"},
	{20, 1, "DEV_DCC4_DCC_CLKSRC0_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_DCC4_DCC_CLKSRC0_CLK"},
	{20, 2, "DEV_DCC4_DCC_CLKSRC0_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT7_CLK", "Parent input clock option to DEV_DCC4_DCC_CLKSRC0_CLK"},
	{20, 3, "DEV_DCC4_DCC_CLKSRC1_CLK", "Input clock"},
	{20, 4, "DEV_DCC4_DCC_CLKSRC2_CLK", "Input clock"},
	{20, 5, "DEV_DCC4_DCC_CLKSRC3_CLK", "Input clock"},
	{20, 6, "DEV_DCC4_DCC_CLKSRC4_CLK", "Input clock"},
	{20, 7, "DEV_DCC4_DCC_CLKSRC5_CLK", "Input clock"},
	{20, 8, "DEV_DCC4_DCC_CLKSRC6_CLK", "Input clock"},
	{20, 9, "DEV_DCC4_DCC_CLKSRC7_CLK", "Input clock"},
	{20, 10, "DEV_DCC4_DCC_INPUT00_CLK", "Input clock"},
	{20, 11, "DEV_DCC4_DCC_INPUT01_CLK", "Input clock"},
	{20, 12, "DEV_DCC4_DCC_INPUT02_CLK", "Input clock"},
	{20, 13, "DEV_DCC4_DCC_INPUT10_CLK", "Input clock"},
	{20, 14, "DEV_DCC4_VBUS_CLK", "Input clock"},
	{21, 0, "DEV_DCC5_DCC_CLKSRC0_CLK", "Input clock"},
	{21, 1, "DEV_DCC5_DCC_CLKSRC1_CLK", "Input clock"},
	{21, 2, "DEV_DCC5_DCC_CLKSRC2_CLK", "Input clock"},
	{21, 3, "DEV_DCC5_DCC_CLKSRC3_CLK", "Input clock"},
	{21, 4, "DEV_DCC5_DCC_CLKSRC4_CLK", "Input clock"},
	{21, 5, "DEV_DCC5_DCC_CLKSRC5_CLK", "Input clock"},
	{21, 6, "DEV_DCC5_DCC_CLKSRC6_CLK", "Input clock"},
	{21, 7, "DEV_DCC5_DCC_CLKSRC7_CLK", "Input clock"},
	{21, 8, "DEV_DCC5_DCC_INPUT00_CLK", "Input clock"},
	{21, 9, "DEV_DCC5_DCC_INPUT01_CLK", "Input clock"},
	{21, 10, "DEV_DCC5_DCC_INPUT02_CLK", "Input clock"},
	{21, 11, "DEV_DCC5_DCC_INPUT10_CLK", "Input clock"},
	{21, 12, "DEV_DCC5_VBUS_CLK", "Input clock"},
	{85, 0, "DEV_DDPA0_DDPA_CLK", "Input clock"},
	{138, 0, "DEV_DDR16SS0_DDRSS_DDR_PLL_CLK", "Input clock"},
	{138, 1, "DEV_DDR16SS0_PLL_CTRL_CLK", "Input clock"},
	{24, 0, "DEV_DEBUGSS_WRAP0_ATB_CLK", "Input clock"},
	{24, 1, "DEV_DEBUGSS_WRAP0_CORE_CLK", "Input clock"},
	{24, 2, "DEV_DEBUGSS_WRAP0_JTAG_TCK", "Input clock"},
	{24, 3, "DEV_DEBUGSS_WRAP0_TREXPT_CLK", "Input clock"},
	{26, 0, "DEV_DMASS0_BCDMA_0_CLK", "Input clock"},
	{27, 0, "DEV_DMASS0_CBASS_0_CLK", "Input clock"},
	{28, 0, "DEV_DMASS0_INTAGGR_0_CLK", "Input clock"},
	{29, 0, "DEV_DMASS0_IPCSS_0_CLK", "Input clock"},
	{30, 0, "DEV_DMASS0_PKTDMA_0_CLK", "Input clock"},
	{31, 0, "DEV_DMASS0_PSILCFG_0_CLK", "Input clock"},
	{32, 0, "DEV_DMASS0_PSILSS_0_PDMA_MAIN0_CLK", "Input clock"},
	{32, 1, "DEV_DMASS0_PSILSS_0_PDMA_MAIN1_CLK", "Input clock"},
	{32, 2, "DEV_DMASS0_PSILSS_0_VD2CLK", "Input clock"},
	{33, 0, "DEV_DMASS0_RINGACC_0_CLK", "Input clock"},
	{51, 0, "DEV_ECAP0_VBUS_CLK", "Input clock"},
	{52, 0, "DEV_ECAP1_VBUS_CLK", "Input clock"},
	{53, 0, "DEV_ECAP2_VBUS_CLK", "Input clock"},
	{54, 0, "DEV_ELM0_VBUSP_CLK", "Input clock"},
	{86, 0, "DEV_EPWM0_VBUSP_CLK", "Input clock"},
	{87, 0, "DEV_EPWM1_VBUSP_CLK", "Input clock"},
	{88, 0, "DEV_EPWM2_VBUSP_CLK", "Input clock"},
	{89, 0, "DEV_EPWM3_VBUSP_CLK", "Input clock"},
	{90, 0, "DEV_EPWM4_VBUSP_CLK", "Input clock"},
	{91, 0, "DEV_EPWM5_VBUSP_CLK", "Input clock"},
	{92, 0, "DEV_EPWM6_VBUSP_CLK", "Input clock"},
	{93, 0, "DEV_EPWM7_VBUSP_CLK", "Input clock"},
	{94, 0, "DEV_EPWM8_VBUSP_CLK", "Input clock"},
	{59, 0, "DEV_EQEP0_VBUS_CLK", "Input clock"},
	{60, 0, "DEV_EQEP1_VBUS_CLK", "Input clock"},
	{62, 0, "DEV_EQEP2_VBUS_CLK", "Input clock"},
	{63, 0, "DEV_ESM0_CLK", "Input clock"},
	{65, 0, "DEV_FSIRX0_FSI_RX_CK", "Input clock"},
	{65, 1, "DEV_FSIRX0_FSI_RX_LPBK_CK", "Input clock"},
	{65, 2, "DEV_FSIRX0_FSI_RX_VBUS_CLK", "Input clock"},
	{66, 0, "DEV_FSIRX1_FSI_RX_CK", "Input clock"},
	{66, 1, "DEV_FSIRX1_FSI_RX_LPBK_CK", "Input clock"},
	{66, 2, "DEV_FSIRX1_FSI_RX_VBUS_CLK", "Input clock"},
	{67, 0, "DEV_FSIRX2_FSI_RX_CK", "Input clock"},
	{67, 1, "DEV_FSIRX2_FSI_RX_LPBK_CK", "Input clock"},
	{67, 2, "DEV_FSIRX2_FSI_RX_VBUS_CLK", "Input clock"},
	{68, 0, "DEV_FSIRX3_FSI_RX_CK", "Input clock"},
	{68, 1, "DEV_FSIRX3_FSI_RX_LPBK_CK", "Input clock"},
	{68, 2, "DEV_FSIRX3_FSI_RX_VBUS_CLK", "Input clock"},
	{69, 0, "DEV_FSIRX4_FSI_RX_CK", "Input clock"},
	{69, 1, "DEV_FSIRX4_FSI_RX_LPBK_CK", "Input clock"},
	{69, 2, "DEV_FSIRX4_FSI_RX_VBUS_CLK", "Input clock"},
	{70, 0, "DEV_FSIRX5_FSI_RX_CK", "Input clock"},
	{70, 1, "DEV_FSIRX5_FSI_RX_LPBK_CK", "Input clock"},
	{70, 2, "DEV_FSIRX5_FSI_RX_VBUS_CLK", "Input clock"},
	{71, 0, "DEV_FSITX0_FSI_TX_PLL_CLK", "Input clock"},
	{71, 1, "DEV_FSITX0_FSI_TX_VBUS_CLK", "Input clock"},
	{71, 2, "DEV_FSITX0_FSI_TX_CK", "Output clock"},
	{72, 0, "DEV_FSITX1_FSI_TX_PLL_CLK", "Input clock"},
	{72, 1, "DEV_FSITX1_FSI_TX_VBUS_CLK", "Input clock"},
	{72, 2, "DEV_FSITX1_FSI_TX_CK", "Output clock"},
	{74, 0, "DEV_FSS0_FSAS_0_GCLK", "Input clock"},
	{75, 0, "DEV_FSS0_OSPI_0_OSPI_DQS_CLK", "Input clock"},
	{75, 1, "DEV_FSS0_OSPI_0_OSPI_HCLK_CLK", "Input clock"},
	{75, 2, "DEV_FSS0_OSPI_0_OSPI_ICLK_CLK", "Input muxed clock"},
	{75, 3, "DEV_FSS0_OSPI_0_OSPI_ICLK_CLK_PARENT_BOARD_0_OSPI0_DQS_OUT", "Parent input clock option to DEV_FSS0_OSPI_0_OSPI_ICLK_CLK"},
	{75, 4, "DEV_FSS0_OSPI_0_OSPI_ICLK_CLK_PARENT_BOARD_0_OSPI0_LBCLKO_OUT", "Parent input clock option to DEV_FSS0_OSPI_0_OSPI_ICLK_CLK"},
	{75, 5, "DEV_FSS0_OSPI_0_OSPI_PCLK_CLK", "Input clock"},
	{75, 6, "DEV_FSS0_OSPI_0_OSPI_RCLK_CLK", "Input muxed clock"},
	{75, 7, "DEV_FSS0_OSPI_0_OSPI_RCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT1_CLK", "Parent input clock option to DEV_FSS0_OSPI_0_OSPI_RCLK_CLK"},
	{75, 8, "DEV_FSS0_OSPI_0_OSPI_RCLK_CLK_PARENT_POSTDIV1_16FFT_MAIN_1_HSDIVOUT5_CLK", "Parent input clock option to DEV_FSS0_OSPI_0_OSPI_RCLK_CLK"},
	{75, 9, "DEV_FSS0_OSPI_0_OSPI_OCLK_CLK", "Output clock"},
	{76, 0, "DEV_GICSS0_VCLK_CLK", "Input clock"},
	{77, 0, "DEV_GPIO0_MMR_CLK", "Input clock"},
	{78, 0, "DEV_GPIO1_MMR_CLK", "Input clock"},
	{80, 0, "DEV_GPMC0_FUNC_CLK", "Input muxed clock"},
	{80, 1, "DEV_GPMC0_FUNC_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{80, 2, "DEV_GPMC0_FUNC_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT7_CLK", "Parent input clock option to DEV_GPMC0_FUNC_CLK"},
	{80, 3, "DEV_GPMC0_PI_GPMC_RET_CLK", "Input clock"},
	{80, 4, "DEV_GPMC0_VBUSM_CLK", "Input clock"},
	{80, 5, "DEV_GPMC0_PO_GPMC_DEV_CLK", "Output clock"},
	{61, 0, "DEV_GTC0_GTC_CLK", "Input muxed clock"},
	{61, 1, "DEV_GTC0_GTC_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT5_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 2, "DEV_GTC0_GTC_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 3, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 4, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 5, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 6, "DEV_GTC0_GTC_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 7, "DEV_GTC0_GTC_CLK_PARENT_WIZ16B2M4CT_MAIN_0_IP1_LN0_TXMCLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 8, "DEV_GTC0_GTC_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_GTC0_GTC_CLK"},
	{61, 9, "DEV_GTC0_VBUSP_CLK", "Input clock"},
	{102, 0, "DEV_I2C0_CLK", "Input clock"},
	{102, 1, "DEV_I2C0_PISCL", "Input clock"},
	{102, 2, "DEV_I2C0_PISYS_CLK", "Input clock"},
	{102, 3, "DEV_I2C0_PORSCL", "Output clock"},
	{103, 0, "DEV_I2C1_CLK", "Input clock"},
	{103, 1, "DEV_I2C1_PISCL", "Input clock"},
	{103, 2, "DEV_I2C1_PISYS_CLK", "Input clock"},
	{103, 3, "DEV_I2C1_PORSCL", "Output clock"},
	{104, 0, "DEV_I2C2_CLK", "Input clock"},
	{104, 1, "DEV_I2C2_PISCL", "Input clock"},
	{104, 2, "DEV_I2C2_PISYS_CLK", "Input clock"},
	{104, 3, "DEV_I2C2_PORSCL", "Output clock"},
	{105, 0, "DEV_I2C3_CLK", "Input clock"},
	{105, 1, "DEV_I2C3_PISCL", "Input clock"},
	{105, 2, "DEV_I2C3_PISYS_CLK", "Input clock"},
	{105, 3, "DEV_I2C3_PORSCL", "Output clock"},
	{83, 0, "DEV_LED0_LED_CLK", "Input clock"},
	{83, 1, "DEV_LED0_VBUSP_CLK", "Input clock"},
	{3, 0, "DEV_MAIN_GPIOMUX_INTROUTER0_INTR_CLK", "Input clock"},
	{98, 0, "DEV_MCAN0_MCANSS_CCLK_CLK", "Input muxed clock"},
	{98, 1, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{98, 2, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{98, 3, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{98, 4, "DEV_MCAN0_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN0_MCANSS_CCLK_CLK"},
	{98, 5, "DEV_MCAN0_MCANSS_HCLK_CLK", "Input clock"},
	{99, 0, "DEV_MCAN1_MCANSS_CCLK_CLK", "Input muxed clock"},
	{99, 1, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_0_HSDIVOUT2_CLK", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{99, 2, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{99, 3, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{99, 4, "DEV_MCAN1_MCANSS_CCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCAN1_MCANSS_CCLK_CLK"},
	{99, 5, "DEV_MCAN1_MCANSS_HCLK_CLK", "Input clock"},
	{141, 0, "DEV_MCSPI0_CLKSPIREF_CLK", "Input clock"},
	{141, 1, "DEV_MCSPI0_IO_CLKSPII_CLK", "Input muxed clock"},
	{141, 2, "DEV_MCSPI0_IO_CLKSPII_CLK_PARENT_BOARD_0_SPI0_CLK_OUT", "Parent input clock option to DEV_MCSPI0_IO_CLKSPII_CLK"},
	{141, 3, "DEV_MCSPI0_IO_CLKSPII_CLK_PARENT_SPI_MAIN_0_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI0_IO_CLKSPII_CLK"},
	{141, 4, "DEV_MCSPI0_VBUSP_CLK", "Input clock"},
	{141, 5, "DEV_MCSPI0_IO_CLKSPIO_CLK", "Output clock"},
	{142, 0, "DEV_MCSPI1_CLKSPIREF_CLK", "Input clock"},
	{142, 1, "DEV_MCSPI1_IO_CLKSPII_CLK", "Input muxed clock"},
	{142, 2, "DEV_MCSPI1_IO_CLKSPII_CLK_PARENT_BOARD_0_SPI1_CLK_OUT", "Parent input clock option to DEV_MCSPI1_IO_CLKSPII_CLK"},
	{142, 3, "DEV_MCSPI1_IO_CLKSPII_CLK_PARENT_SPI_MAIN_1_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI1_IO_CLKSPII_CLK"},
	{142, 4, "DEV_MCSPI1_VBUSP_CLK", "Input clock"},
	{142, 5, "DEV_MCSPI1_IO_CLKSPIO_CLK", "Output clock"},
	{143, 0, "DEV_MCSPI2_CLKSPIREF_CLK", "Input clock"},
	{143, 1, "DEV_MCSPI2_IO_CLKSPII_CLK", "Input muxed clock"},
	{143, 2, "DEV_MCSPI2_IO_CLKSPII_CLK_PARENT_BOARD_0_SPI2_CLK_OUT", "Parent input clock option to DEV_MCSPI2_IO_CLKSPII_CLK"},
	{143, 3, "DEV_MCSPI2_IO_CLKSPII_CLK_PARENT_SPI_MAIN_2_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI2_IO_CLKSPII_CLK"},
	{143, 4, "DEV_MCSPI2_VBUSP_CLK", "Input clock"},
	{143, 5, "DEV_MCSPI2_IO_CLKSPIO_CLK", "Output clock"},
	{144, 0, "DEV_MCSPI3_CLKSPIREF_CLK", "Input clock"},
	{144, 1, "DEV_MCSPI3_IO_CLKSPII_CLK", "Input muxed clock"},
	{144, 2, "DEV_MCSPI3_IO_CLKSPII_CLK_PARENT_BOARD_0_SPI3_CLK_OUT", "Parent input clock option to DEV_MCSPI3_IO_CLKSPII_CLK"},
	{144, 3, "DEV_MCSPI3_IO_CLKSPII_CLK_PARENT_SPI_MAIN_3_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI3_IO_CLKSPII_CLK"},
	{144, 4, "DEV_MCSPI3_VBUSP_CLK", "Input clock"},
	{144, 5, "DEV_MCSPI3_IO_CLKSPIO_CLK", "Output clock"},
	{145, 0, "DEV_MCSPI4_CLKSPIREF_CLK", "Input clock"},
	{145, 1, "DEV_MCSPI4_IO_CLKSPII_CLK", "Input muxed clock"},
	{145, 2, "DEV_MCSPI4_IO_CLKSPII_CLK_PARENT_BOARD_0_SPI4_CLK_OUT", "Parent input clock option to DEV_MCSPI4_IO_CLKSPII_CLK"},
	{145, 3, "DEV_MCSPI4_IO_CLKSPII_CLK_PARENT_SPI_MAIN_4_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCSPI4_IO_CLKSPII_CLK"},
	{145, 4, "DEV_MCSPI4_VBUSP_CLK", "Input clock"},
	{145, 5, "DEV_MCSPI4_IO_CLKSPIO_CLK", "Output clock"},
	{23, 0, "DEV_MCU_DCC0_DCC_CLKSRC0_CLK", "Input clock"},
	{23, 1, "DEV_MCU_DCC0_DCC_CLKSRC1_CLK", "Input clock"},
	{23, 2, "DEV_MCU_DCC0_DCC_CLKSRC2_CLK", "Input clock"},
	{23, 3, "DEV_MCU_DCC0_DCC_CLKSRC3_CLK", "Input clock"},
	{23, 4, "DEV_MCU_DCC0_DCC_CLKSRC4_CLK", "Input clock"},
	{23, 5, "DEV_MCU_DCC0_DCC_CLKSRC5_CLK", "Input clock"},
	{23, 6, "DEV_MCU_DCC0_DCC_CLKSRC6_CLK", "Input clock"},
	{23, 7, "DEV_MCU_DCC0_DCC_CLKSRC7_CLK", "Input clock"},
	{23, 8, "DEV_MCU_DCC0_DCC_INPUT00_CLK", "Input clock"},
	{23, 9, "DEV_MCU_DCC0_DCC_INPUT01_CLK", "Input clock"},
	{23, 10, "DEV_MCU_DCC0_DCC_INPUT02_CLK", "Input clock"},
	{23, 11, "DEV_MCU_DCC0_DCC_INPUT10_CLK", "Input clock"},
	{23, 12, "DEV_MCU_DCC0_VBUS_CLK", "Input clock"},
	{64, 0, "DEV_MCU_ESM0_CLK", "Input clock"},
	{79, 0, "DEV_MCU_GPIO0_MMR_CLK", "Input clock"},
	{106, 0, "DEV_MCU_I2C0_CLK", "Input clock"},
	{106, 1, "DEV_MCU_I2C0_PISCL", "Input clock"},
	{106, 2, "DEV_MCU_I2C0_PISYS_CLK", "Input clock"},
	{106, 3, "DEV_MCU_I2C0_PORSCL", "Output clock"},
	{107, 0, "DEV_MCU_I2C1_CLK", "Input clock"},
	{107, 1, "DEV_MCU_I2C1_PISCL", "Input clock"},
	{107, 2, "DEV_MCU_I2C1_PISYS_CLK", "Input clock"},
	{107, 3, "DEV_MCU_I2C1_PORSCL", "Output clock"},
	{9, 0, "DEV_MCU_M4FSS0_CORE0_DAP_CLK", "Input clock"},
	{9, 1, "DEV_MCU_M4FSS0_CORE0_VBUS_CLK", "Input muxed clock"},
	{9, 2, "DEV_MCU_M4FSS0_CORE0_VBUS_CLK_PARENT_K3_PLL_CTRL_WRAP_MCU_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_MCU_M4FSS0_CORE0_VBUS_CLK"},
	{9, 3, "DEV_MCU_M4FSS0_CORE0_VBUS_CLK_PARENT_K3_PLL_CTRL_WRAP_MCU_0_CHIP_DIV1_CLK_CLK2", "Parent input clock option to DEV_MCU_M4FSS0_CORE0_VBUS_CLK"},
	{100, 0, "DEV_MCU_MCRC64_0_CLK", "Input clock"},
	{147, 0, "DEV_MCU_MCSPI0_CLKSPIREF_CLK", "Input clock"},
	{147, 1, "DEV_MCU_MCSPI0_IO_CLKSPII_CLK", "Input muxed clock"},
	{147, 2, "DEV_MCU_MCSPI0_IO_CLKSPII_CLK_PARENT_BOARD_0_MCU_SPI0_CLK_OUT", "Parent input clock option to DEV_MCU_MCSPI0_IO_CLKSPII_CLK"},
	{147, 3, "DEV_MCU_MCSPI0_IO_CLKSPII_CLK_PARENT_SPI_MCU_0_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCU_MCSPI0_IO_CLKSPII_CLK"},
	{147, 4, "DEV_MCU_MCSPI0_VBUSP_CLK", "Input clock"},
	{147, 5, "DEV_MCU_MCSPI0_IO_CLKSPIO_CLK", "Output clock"},
	{148, 0, "DEV_MCU_MCSPI1_CLKSPIREF_CLK", "Input clock"},
	{148, 1, "DEV_MCU_MCSPI1_IO_CLKSPII_CLK", "Input muxed clock"},
	{148, 2, "DEV_MCU_MCSPI1_IO_CLKSPII_CLK_PARENT_BOARD_0_MCU_SPI1_CLK_OUT", "Parent input clock option to DEV_MCU_MCSPI1_IO_CLKSPII_CLK"},
	{148, 3, "DEV_MCU_MCSPI1_IO_CLKSPII_CLK_PARENT_SPI_MCU_1_IO_CLKSPIO_CLK", "Parent input clock option to DEV_MCU_MCSPI1_IO_CLKSPII_CLK"},
	{148, 4, "DEV_MCU_MCSPI1_VBUSP_CLK", "Input clock"},
	{148, 5, "DEV_MCU_MCSPI1_IO_CLKSPIO_CLK", "Output clock"},
	{5, 0, "DEV_MCU_MCU_GPIOMUX_INTROUTER0_INTR_CLK", "Input clock"},
	{140, 0, "DEV_MCU_PSC0_CLK", "Input clock"},
	{140, 1, "DEV_MCU_PSC0_SLOW_CLK", "Input clock"},
	{132, 0, "DEV_MCU_RTI0_RTI_CLK", "Input muxed clock"},
	{132, 1, "DEV_MCU_RTI0_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{132, 2, "DEV_MCU_RTI0_RTI_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{132, 3, "DEV_MCU_RTI0_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{132, 4, "DEV_MCU_RTI0_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLK_1P0V_97P65K3", "Parent input clock option to DEV_MCU_RTI0_RTI_CLK"},
	{132, 5, "DEV_MCU_RTI0_VBUSP_CLK", "Input clock"},
	{35, 0, "DEV_MCU_TIMER0_TIMER_HCLK_CLK", "Input clock"},
	{35, 1, "DEV_MCU_TIMER0_TIMER_TCLK_CLK", "Input muxed clock"},
	{35, 2, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 3, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_MCU_0_CHIP_DIV1_CLK_CLK4", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 4, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 5, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 6, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 7, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 8, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 9, "DEV_MCU_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLK_1P0V_97P65K3", "Parent input clock option to DEV_MCU_TIMER0_TIMER_TCLK_CLK"},
	{35, 10, "DEV_MCU_TIMER0_TIMER_PWM", "Output clock"},
	{48, 0, "DEV_MCU_TIMER1_TIMER_HCLK_CLK", "Input clock"},
	{48, 1, "DEV_MCU_TIMER1_TIMER_TCLK_CLK", "Input muxed clock"},
	{48, 2, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{48, 3, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_MCU_0_CHIP_DIV1_CLK_CLK4", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{48, 4, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{48, 5, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{48, 6, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{48, 7, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{48, 8, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{48, 9, "DEV_MCU_TIMER1_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLK_1P0V_97P65K3", "Parent input clock option to DEV_MCU_TIMER1_TIMER_TCLK_CLK"},
	{48, 10, "DEV_MCU_TIMER1_TIMER_PWM", "Output clock"},
	{49, 0, "DEV_MCU_TIMER2_TIMER_HCLK_CLK", "Input clock"},
	{49, 1, "DEV_MCU_TIMER2_TIMER_TCLK_CLK", "Input muxed clock"},
	{49, 2, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{49, 3, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_MCU_0_CHIP_DIV1_CLK_CLK4", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{49, 4, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{49, 5, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{49, 6, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{49, 7, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{49, 8, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{49, 9, "DEV_MCU_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLK_1P0V_97P65K3", "Parent input clock option to DEV_MCU_TIMER2_TIMER_TCLK_CLK"},
	{49, 10, "DEV_MCU_TIMER2_TIMER_PWM", "Output clock"},
	{50, 0, "DEV_MCU_TIMER3_TIMER_HCLK_CLK", "Input clock"},
	{50, 1, "DEV_MCU_TIMER3_TIMER_TCLK_CLK", "Input muxed clock"},
	{50, 2, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{50, 3, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_MCU_0_CHIP_DIV1_CLK_CLK4", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{50, 4, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{50, 5, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MCU_0_HSDIVOUT3_CLK", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{50, 6, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{50, 7, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{50, 8, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{50, 9, "DEV_MCU_TIMER3_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLK_1P0V_97P65K3", "Parent input clock option to DEV_MCU_TIMER3_TIMER_TCLK_CLK"},
	{50, 10, "DEV_MCU_TIMER3_TIMER_PWM", "Output clock"},
	{149, 0, "DEV_MCU_UART0_FCLK_CLK", "Input clock"},
	{149, 1, "DEV_MCU_UART0_VBUSP_CLK", "Input clock"},
	{160, 0, "DEV_MCU_UART1_FCLK_CLK", "Input clock"},
	{160, 1, "DEV_MCU_UART1_VBUSP_CLK", "Input clock"},
	{57, 0, "DEV_MMCSD0_EMMCSS_VBUS_CLK", "Input clock"},
	{57, 1, "DEV_MMCSD0_EMMCSS_XIN_CLK", "Input muxed clock"},
	{57, 2, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT5_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{57, 3, "DEV_MMCSD0_EMMCSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD0_EMMCSS_XIN_CLK"},
	{58, 0, "DEV_MMCSD1_EMMCSDSS_IO_CLK_I", "Input muxed clock"},
	{58, 1, "DEV_MMCSD1_EMMCSDSS_IO_CLK_I_PARENT_BOARD_0_MMC1_CLKLB_OUT", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_IO_CLK_I"},
	{58, 2, "DEV_MMCSD1_EMMCSDSS_IO_CLK_I_PARENT_EMMCSD4SS_MAIN_0_EMMCSDSS_IO_CLK_O", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_IO_CLK_I"},
	{58, 3, "DEV_MMCSD1_EMMCSDSS_VBUS_CLK", "Input clock"},
	{58, 4, "DEV_MMCSD1_EMMCSDSS_XIN_CLK", "Input muxed clock"},
	{58, 5, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT5_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{58, 6, "DEV_MMCSD1_EMMCSDSS_XIN_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT2_CLK", "Parent input clock option to DEV_MMCSD1_EMMCSDSS_XIN_CLK"},
	{58, 7, "DEV_MMCSD1_EMMCSDSS_IO_CLK_O", "Output clock"},
	{108, 0, "DEV_MSRAM_256K0_CCLK_CLK", "Input clock"},
	{108, 1, "DEV_MSRAM_256K0_VCLK_CLK", "Input clock"},
	{109, 0, "DEV_MSRAM_256K1_CCLK_CLK", "Input clock"},
	{109, 1, "DEV_MSRAM_256K1_VCLK_CLK", "Input clock"},
	{110, 0, "DEV_MSRAM_256K2_CCLK_CLK", "Input clock"},
	{110, 1, "DEV_MSRAM_256K2_VCLK_CLK", "Input clock"},
	{111, 0, "DEV_MSRAM_256K3_CCLK_CLK", "Input clock"},
	{111, 1, "DEV_MSRAM_256K3_VCLK_CLK", "Input clock"},
	{112, 0, "DEV_MSRAM_256K4_CCLK_CLK", "Input clock"},
	{112, 1, "DEV_MSRAM_256K4_VCLK_CLK", "Input clock"},
	{113, 0, "DEV_MSRAM_256K5_CCLK_CLK", "Input clock"},
	{113, 1, "DEV_MSRAM_256K5_VCLK_CLK", "Input clock"},
	{163, 0, "DEV_PBIST0_CLK8_CLK", "Input clock"},
	{164, 0, "DEV_PBIST1_CLK8_CLK", "Input clock"},
	{165, 0, "DEV_PBIST2_CLK8_CLK", "Input clock"},
	{166, 0, "DEV_PBIST3_CLK8_CLK", "Input clock"},
	{114, 0, "DEV_PCIE0_PCIE_CBA_CLK", "Input clock"},
	{114, 1, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK", "Input muxed clock"},
	{114, 2, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT5_CLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{114, 3, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{114, 4, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{114, 5, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{114, 6, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{114, 7, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{114, 8, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_WIZ16B2M4CT_MAIN_0_IP1_LN0_TXMCLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{114, 9, "DEV_PCIE0_PCIE_CPTS_RCLK_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_PCIE0_PCIE_CPTS_RCLK_CLK"},
	{114, 10, "DEV_PCIE0_PCIE_LANE0_REFCLK", "Input clock"},
	{114, 11, "DEV_PCIE0_PCIE_LANE0_RXCLK", "Input clock"},
	{114, 12, "DEV_PCIE0_PCIE_LANE0_RXFCLK", "Input clock"},
	{114, 13, "DEV_PCIE0_PCIE_LANE0_TXFCLK", "Input clock"},
	{114, 14, "DEV_PCIE0_PCIE_LANE0_TXMCLK", "Input clock"},
	{114, 15, "DEV_PCIE0_PCIE_PM_CLK", "Input clock"},
	{114, 16, "DEV_PCIE0_PCIE_LANE0_TXCLK", "Output clock"},
	{115, 0, "DEV_POSTDIV1_16FFT1_FREF_CLK", "Input clock"},
	{115, 1, "DEV_POSTDIV1_16FFT1_POSTDIV_CLKIN_CLK", "Input clock"},
	{115, 2, "DEV_POSTDIV1_16FFT1_HSDIVOUT5_CLK", "Output clock"},
	{115, 3, "DEV_POSTDIV1_16FFT1_HSDIVOUT6_CLK", "Output clock"},
	{116, 0, "DEV_POSTDIV4_16FF0_FREF_CLK", "Input clock"},
	{116, 1, "DEV_POSTDIV4_16FF0_POSTDIV_CLKIN_CLK", "Input clock"},
	{116, 2, "DEV_POSTDIV4_16FF0_HSDIVOUT5_CLK", "Output clock"},
	{116, 3, "DEV_POSTDIV4_16FF0_HSDIVOUT6_CLK", "Output clock"},
	{116, 4, "DEV_POSTDIV4_16FF0_HSDIVOUT7_CLK", "Output clock"},
	{116, 5, "DEV_POSTDIV4_16FF0_HSDIVOUT8_CLK", "Output clock"},
	{116, 6, "DEV_POSTDIV4_16FF0_HSDIVOUT9_CLK", "Output clock"},
	{117, 0, "DEV_POSTDIV4_16FF2_FREF_CLK", "Input clock"},
	{117, 1, "DEV_POSTDIV4_16FF2_POSTDIV_CLKIN_CLK", "Input clock"},
	{117, 2, "DEV_POSTDIV4_16FF2_HSDIVOUT5_CLK", "Output clock"},
	{117, 3, "DEV_POSTDIV4_16FF2_HSDIVOUT6_CLK", "Output clock"},
	{117, 4, "DEV_POSTDIV4_16FF2_HSDIVOUT7_CLK", "Output clock"},
	{117, 5, "DEV_POSTDIV4_16FF2_HSDIVOUT8_CLK", "Output clock"},
	{117, 6, "DEV_POSTDIV4_16FF2_HSDIVOUT9_CLK", "Output clock"},
	{81, 0, "DEV_PRU_ICSSG0_CORE_CLK", "Input muxed clock"},
	{81, 1, "DEV_PRU_ICSSG0_CORE_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT0_CLK", "Parent input clock option to DEV_PRU_ICSSG0_CORE_CLK"},
	{81, 2, "DEV_PRU_ICSSG0_CORE_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT9_CLK", "Parent input clock option to DEV_PRU_ICSSG0_CORE_CLK"},
	{81, 3, "DEV_PRU_ICSSG0_IEP_CLK", "Input muxed clock"},
	{81, 4, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT5_CLK", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{81, 5, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{81, 6, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{81, 7, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{81, 8, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{81, 9, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{81, 10, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_WIZ16B2M4CT_MAIN_0_IP1_LN0_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{81, 11, "DEV_PRU_ICSSG0_IEP_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_PRU_ICSSG0_IEP_CLK"},
	{81, 12, "DEV_PRU_ICSSG0_PR1_RGMII0_RXC_I", "Input clock"},
	{81, 13, "DEV_PRU_ICSSG0_PR1_RGMII0_TXC_I", "Input clock"},
	{81, 14, "DEV_PRU_ICSSG0_PR1_RGMII1_RXC_I", "Input clock"},
	{81, 15, "DEV_PRU_ICSSG0_PR1_RGMII1_TXC_I", "Input clock"},
	{81, 16, "DEV_PRU_ICSSG0_RGMII_MHZ_250_CLK", "Input clock"},
	{81, 17, "DEV_PRU_ICSSG0_RGMII_MHZ_50_CLK", "Input clock"},
	{81, 18, "DEV_PRU_ICSSG0_RGMII_MHZ_5_CLK", "Input clock"},
	{81, 19, "DEV_PRU_ICSSG0_UCLK_CLK", "Input clock"},
	{81, 20, "DEV_PRU_ICSSG0_VCLK_CLK", "Input clock"},
	{81, 21, "DEV_PRU_ICSSG0_PR1_MDIO_MDCLK_O", "Output clock"},
	{81, 22, "DEV_PRU_ICSSG0_PR1_RGMII0_TXC_O", "Output clock"},
	{81, 23, "DEV_PRU_ICSSG0_PR1_RGMII1_TXC_O", "Output clock"},
	{82, 0, "DEV_PRU_ICSSG1_CORE_CLK", "Input muxed clock"},
	{82, 1, "DEV_PRU_ICSSG1_CORE_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT0_CLK", "Parent input clock option to DEV_PRU_ICSSG1_CORE_CLK"},
	{82, 2, "DEV_PRU_ICSSG1_CORE_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT9_CLK", "Parent input clock option to DEV_PRU_ICSSG1_CORE_CLK"},
	{82, 3, "DEV_PRU_ICSSG1_IEP_CLK", "Input muxed clock"},
	{82, 4, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT5_CLK", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{82, 5, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT6_CLK", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{82, 6, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{82, 7, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{82, 8, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{82, 9, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{82, 10, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_WIZ16B2M4CT_MAIN_0_IP1_LN0_TXMCLK", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{82, 11, "DEV_PRU_ICSSG1_IEP_CLK_PARENT_K3_PLL_CTRL_WRAP_MAIN_0_CHIP_DIV1_CLK_CLK", "Parent input clock option to DEV_PRU_ICSSG1_IEP_CLK"},
	{82, 12, "DEV_PRU_ICSSG1_PR1_RGMII0_RXC_I", "Input clock"},
	{82, 13, "DEV_PRU_ICSSG1_PR1_RGMII0_TXC_I", "Input clock"},
	{82, 14, "DEV_PRU_ICSSG1_PR1_RGMII1_RXC_I", "Input clock"},
	{82, 15, "DEV_PRU_ICSSG1_PR1_RGMII1_TXC_I", "Input clock"},
	{82, 16, "DEV_PRU_ICSSG1_RGMII_MHZ_250_CLK", "Input clock"},
	{82, 17, "DEV_PRU_ICSSG1_RGMII_MHZ_50_CLK", "Input clock"},
	{82, 18, "DEV_PRU_ICSSG1_RGMII_MHZ_5_CLK", "Input clock"},
	{82, 19, "DEV_PRU_ICSSG1_UCLK_CLK", "Input clock"},
	{82, 20, "DEV_PRU_ICSSG1_VCLK_CLK", "Input clock"},
	{82, 21, "DEV_PRU_ICSSG1_PR1_MDIO_MDCLK_O", "Output clock"},
	{82, 22, "DEV_PRU_ICSSG1_PR1_RGMII0_TXC_O", "Output clock"},
	{82, 23, "DEV_PRU_ICSSG1_PR1_RGMII1_TXC_O", "Output clock"},
	{139, 0, "DEV_PSC0_CLK", "Input clock"},
	{139, 1, "DEV_PSC0_SLOW_CLK", "Input clock"},
	{118, 0, "DEV_PSRAMECC0_CLK_CLK", "Input clock"},
	{121, 0, "DEV_R5FSS0_CORE0_CPU_CLK", "Input clock"},
	{121, 1, "DEV_R5FSS0_CORE0_INTERFACE_CLK", "Input clock"},
	{122, 0, "DEV_R5FSS0_CORE1_CPU_CLK", "Input clock"},
	{122, 1, "DEV_R5FSS0_CORE1_INTERFACE_CLK", "Input clock"},
	{123, 0, "DEV_R5FSS1_CORE0_CPU_CLK", "Input clock"},
	{123, 1, "DEV_R5FSS1_CORE0_INTERFACE_CLK", "Input clock"},
	{124, 0, "DEV_R5FSS1_CORE1_CPU_CLK", "Input clock"},
	{124, 1, "DEV_R5FSS1_CORE1_INTERFACE_CLK", "Input clock"},
	{125, 0, "DEV_RTI0_RTI_CLK", "Input muxed clock"},
	{125, 1, "DEV_RTI0_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{125, 2, "DEV_RTI0_RTI_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{125, 3, "DEV_RTI0_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{125, 4, "DEV_RTI0_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLK_1P0V_97P65K3", "Parent input clock option to DEV_RTI0_RTI_CLK"},
	{125, 5, "DEV_RTI0_VBUSP_CLK", "Input clock"},
	{126, 0, "DEV_RTI1_RTI_CLK", "Input muxed clock"},
	{126, 1, "DEV_RTI1_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{126, 2, "DEV_RTI1_RTI_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{126, 3, "DEV_RTI1_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{126, 4, "DEV_RTI1_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLK_1P0V_97P65K3", "Parent input clock option to DEV_RTI1_RTI_CLK"},
	{126, 5, "DEV_RTI1_VBUSP_CLK", "Input clock"},
	{130, 0, "DEV_RTI10_RTI_CLK", "Input muxed clock"},
	{130, 1, "DEV_RTI10_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI10_RTI_CLK"},
	{130, 2, "DEV_RTI10_RTI_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_RTI10_RTI_CLK"},
	{130, 3, "DEV_RTI10_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_RTI10_RTI_CLK"},
	{130, 4, "DEV_RTI10_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLK_1P0V_97P65K3", "Parent input clock option to DEV_RTI10_RTI_CLK"},
	{130, 5, "DEV_RTI10_VBUSP_CLK", "Input clock"},
	{131, 0, "DEV_RTI11_RTI_CLK", "Input muxed clock"},
	{131, 1, "DEV_RTI11_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI11_RTI_CLK"},
	{131, 2, "DEV_RTI11_RTI_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_RTI11_RTI_CLK"},
	{131, 3, "DEV_RTI11_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_RTI11_RTI_CLK"},
	{131, 4, "DEV_RTI11_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLK_1P0V_97P65K3", "Parent input clock option to DEV_RTI11_RTI_CLK"},
	{131, 5, "DEV_RTI11_VBUSP_CLK", "Input clock"},
	{127, 0, "DEV_RTI8_RTI_CLK", "Input muxed clock"},
	{127, 1, "DEV_RTI8_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI8_RTI_CLK"},
	{127, 2, "DEV_RTI8_RTI_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_RTI8_RTI_CLK"},
	{127, 3, "DEV_RTI8_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_RTI8_RTI_CLK"},
	{127, 4, "DEV_RTI8_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLK_1P0V_97P65K3", "Parent input clock option to DEV_RTI8_RTI_CLK"},
	{127, 5, "DEV_RTI8_VBUSP_CLK", "Input clock"},
	{128, 0, "DEV_RTI9_RTI_CLK", "Input muxed clock"},
	{128, 1, "DEV_RTI9_RTI_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_RTI9_RTI_CLK"},
	{128, 2, "DEV_RTI9_RTI_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_RTI9_RTI_CLK"},
	{128, 3, "DEV_RTI9_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_RTI9_RTI_CLK"},
	{128, 4, "DEV_RTI9_RTI_CLK_PARENT_GLUELOGIC_RCOSC_CLK_1P0V_97P65K3", "Parent input clock option to DEV_RTI9_RTI_CLK"},
	{128, 5, "DEV_RTI9_VBUSP_CLK", "Input clock"},
	{133, 0, "DEV_SA2_UL0_PKA_IN_CLK", "Input clock"},
	{133, 1, "DEV_SA2_UL0_X1_CLK", "Input clock"},
	{133, 2, "DEV_SA2_UL0_X2_CLK", "Input clock"},
	{162, 0, "DEV_SERDES_10G0_CLK", "Input clock"},
	{162, 1, "DEV_SERDES_10G0_CORE_REF_CLK", "Input muxed clock"},
	{162, 2, "DEV_SERDES_10G0_CORE_REF_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_SERDES_10G0_CORE_REF_CLK"},
	{162, 3, "DEV_SERDES_10G0_CORE_REF_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_SERDES_10G0_CORE_REF_CLK"},
	{162, 4, "DEV_SERDES_10G0_CORE_REF_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT8_CLK", "Parent input clock option to DEV_SERDES_10G0_CORE_REF_CLK"},
	{162, 5, "DEV_SERDES_10G0_CORE_REF_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_SERDES_10G0_CORE_REF_CLK"},
	{162, 6, "DEV_SERDES_10G0_IP1_LN0_TXCLK", "Input clock"},
	{162, 7, "DEV_SERDES_10G0_IP2_LN0_TXCLK", "Input clock"},
	{162, 8, "DEV_SERDES_10G0_IP1_LN0_REFCLK", "Output clock"},
	{162, 9, "DEV_SERDES_10G0_IP1_LN0_RXCLK", "Output clock"},
	{162, 10, "DEV_SERDES_10G0_IP1_LN0_RXFCLK", "Output clock"},
	{162, 11, "DEV_SERDES_10G0_IP1_LN0_TXFCLK", "Output clock"},
	{162, 12, "DEV_SERDES_10G0_IP1_LN0_TXMCLK", "Output clock"},
	{162, 13, "DEV_SERDES_10G0_IP2_LN0_REFCLK", "Output clock"},
	{162, 14, "DEV_SERDES_10G0_IP2_LN0_RXCLK", "Output clock"},
	{162, 15, "DEV_SERDES_10G0_IP2_LN0_RXFCLK", "Output clock"},
	{162, 16, "DEV_SERDES_10G0_IP2_LN0_TXFCLK", "Output clock"},
	{162, 17, "DEV_SERDES_10G0_IP2_LN0_TXMCLK", "Output clock"},
	{162, 18, "DEV_SERDES_10G0_REF_OUT_CLK", "Output clock"},
	{150, 0, "DEV_SPINLOCK0_VCLK_CLK", "Input clock"},
	{15, 0, "DEV_STM0_ATB_CLK", "Input clock"},
	{15, 1, "DEV_STM0_CORE_CLK", "Input clock"},
	{15, 2, "DEV_STM0_VBUSP_CLK", "Input clock"},
	{36, 0, "DEV_TIMER0_TIMER_HCLK_CLK", "Input clock"},
	{36, 1, "DEV_TIMER0_TIMER_TCLK_CLK", "Input muxed clock"},
	{36, 2, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 3, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 4, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 5, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 6, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 7, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF2", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 8, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF3", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 9, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF4", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 10, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 11, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 12, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 13, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 14, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 15, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 16, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 17, "DEV_TIMER0_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER0_TIMER_TCLK_CLK"},
	{36, 18, "DEV_TIMER0_TIMER_PWM", "Output clock"},
	{37, 0, "DEV_TIMER1_TIMER_HCLK_CLK", "Input clock"},
	{37, 1, "DEV_TIMER1_TIMER_TCLK_CLK", "Input muxed clock"},
	{37, 2, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 3, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 4, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 5, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 6, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 7, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF2", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 8, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF3", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 9, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF4", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 10, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 11, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 12, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 13, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 14, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 15, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 16, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 17, "DEV_TIMER1_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER1_TIMER_TCLK_CLK"},
	{37, 18, "DEV_TIMER1_TIMER_PWM", "Output clock"},
	{46, 0, "DEV_TIMER10_TIMER_HCLK_CLK", "Input clock"},
	{46, 1, "DEV_TIMER10_TIMER_TCLK_CLK", "Input muxed clock"},
	{46, 2, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{46, 3, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{46, 4, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{46, 5, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{46, 6, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{46, 7, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF2", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{46, 8, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF3", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{46, 9, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF4", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{46, 10, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{46, 11, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{46, 12, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{46, 13, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{46, 14, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{46, 15, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{46, 16, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{46, 17, "DEV_TIMER10_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER10_TIMER_TCLK_CLK"},
	{46, 18, "DEV_TIMER10_TIMER_PWM", "Output clock"},
	{47, 0, "DEV_TIMER11_TIMER_HCLK_CLK", "Input clock"},
	{47, 1, "DEV_TIMER11_TIMER_TCLK_CLK", "Input muxed clock"},
	{47, 2, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{47, 3, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{47, 4, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{47, 5, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{47, 6, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{47, 7, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF2", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{47, 8, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF3", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{47, 9, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF4", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{47, 10, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{47, 11, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{47, 12, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{47, 13, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{47, 14, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{47, 15, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{47, 16, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{47, 17, "DEV_TIMER11_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER11_TIMER_TCLK_CLK"},
	{47, 18, "DEV_TIMER11_TIMER_PWM", "Output clock"},
	{38, 0, "DEV_TIMER2_TIMER_HCLK_CLK", "Input clock"},
	{38, 1, "DEV_TIMER2_TIMER_TCLK_CLK", "Input muxed clock"},
	{38, 2, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 3, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 4, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 5, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 6, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 7, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF2", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 8, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF3", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 9, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF4", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 10, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 11, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 12, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 13, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 14, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 15, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 16, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 17, "DEV_TIMER2_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER2_TIMER_TCLK_CLK"},
	{38, 18, "DEV_TIMER2_TIMER_PWM", "Output clock"},
	{39, 0, "DEV_TIMER3_TIMER_HCLK_CLK", "Input clock"},
	{39, 1, "DEV_TIMER3_TIMER_TCLK_CLK", "Input muxed clock"},
	{39, 2, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 3, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 4, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 5, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 6, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 7, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF2", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 8, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF3", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 9, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF4", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 10, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 11, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 12, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 13, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 14, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 15, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 16, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 17, "DEV_TIMER3_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER3_TIMER_TCLK_CLK"},
	{39, 18, "DEV_TIMER3_TIMER_PWM", "Output clock"},
	{40, 0, "DEV_TIMER4_TIMER_HCLK_CLK", "Input clock"},
	{40, 1, "DEV_TIMER4_TIMER_TCLK_CLK", "Input muxed clock"},
	{40, 2, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 3, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 4, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 5, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 6, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 7, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF2", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 8, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF3", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 9, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF4", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 10, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 11, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 12, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 13, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 14, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 15, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 16, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 17, "DEV_TIMER4_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER4_TIMER_TCLK_CLK"},
	{40, 18, "DEV_TIMER4_TIMER_PWM", "Output clock"},
	{41, 0, "DEV_TIMER5_TIMER_HCLK_CLK", "Input clock"},
	{41, 1, "DEV_TIMER5_TIMER_TCLK_CLK", "Input muxed clock"},
	{41, 2, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 3, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 4, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 5, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 6, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 7, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF2", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 8, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF3", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 9, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF4", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 10, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 11, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 12, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 13, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 14, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 15, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 16, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 17, "DEV_TIMER5_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER5_TIMER_TCLK_CLK"},
	{41, 18, "DEV_TIMER5_TIMER_PWM", "Output clock"},
	{42, 0, "DEV_TIMER6_TIMER_HCLK_CLK", "Input clock"},
	{42, 1, "DEV_TIMER6_TIMER_TCLK_CLK", "Input muxed clock"},
	{42, 2, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 3, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 4, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 5, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 6, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 7, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF2", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 8, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF3", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 9, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF4", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 10, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 11, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 12, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 13, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 14, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 15, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 16, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 17, "DEV_TIMER6_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER6_TIMER_TCLK_CLK"},
	{42, 18, "DEV_TIMER6_TIMER_PWM", "Output clock"},
	{43, 0, "DEV_TIMER7_TIMER_HCLK_CLK", "Input clock"},
	{43, 1, "DEV_TIMER7_TIMER_TCLK_CLK", "Input muxed clock"},
	{43, 2, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 3, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 4, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 5, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 6, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 7, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF2", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 8, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF3", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 9, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF4", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 10, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 11, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 12, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 13, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 14, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 15, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 16, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 17, "DEV_TIMER7_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER7_TIMER_TCLK_CLK"},
	{43, 18, "DEV_TIMER7_TIMER_PWM", "Output clock"},
	{44, 0, "DEV_TIMER8_TIMER_HCLK_CLK", "Input clock"},
	{44, 1, "DEV_TIMER8_TIMER_TCLK_CLK", "Input muxed clock"},
	{44, 2, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{44, 3, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{44, 4, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{44, 5, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{44, 6, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{44, 7, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF2", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{44, 8, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF3", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{44, 9, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF4", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{44, 10, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{44, 11, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{44, 12, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{44, 13, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{44, 14, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{44, 15, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{44, 16, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{44, 17, "DEV_TIMER8_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER8_TIMER_TCLK_CLK"},
	{44, 18, "DEV_TIMER8_TIMER_PWM", "Output clock"},
	{45, 0, "DEV_TIMER9_TIMER_HCLK_CLK", "Input clock"},
	{45, 1, "DEV_TIMER9_TIMER_TCLK_CLK", "Input muxed clock"},
	{45, 2, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{45, 3, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_HSDIV0_16FFT_MCU_32KHZ_GEN_0_HSDIVOUT0_CLK8", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{45, 4, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF0", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{45, 5, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_CPSW_3GUSS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{45, 6, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF1", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{45, 7, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF2", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{45, 8, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF3", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{45, 9, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_K3_CPTS_MAIN_0_CPTS_GENF4", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{45, 10, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_0_HSDIVOUT7_CLK", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{45, 11, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_GLUELOGIC_RCOSC_CLKOUT", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{45, 12, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_BOARD_0_MCU_EXT_REFCLK0_OUT", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{45, 13, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_BOARD_0_EXT_REFCLK1_OUT", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{45, 14, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_BOARD_0_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{45, 15, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_BOARD_0_CP_GEMAC_CPTS0_RFT_CLK_OUT", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{45, 16, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT3_CLK", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{45, 17, "DEV_TIMER9_TIMER_TCLK_CLK_PARENT_POSTDIV4_16FF_MAIN_2_HSDIVOUT6_CLK", "Parent input clock option to DEV_TIMER9_TIMER_TCLK_CLK"},
	{45, 18, "DEV_TIMER9_TIMER_PWM", "Output clock"},
	{151, 0, "DEV_TIMERMGR0_VCLK_CLK", "Input clock"},
	{6, 0, "DEV_TIMESYNC_EVENT_INTROUTER0_INTR_CLK", "Input clock"},
	{146, 0, "DEV_UART0_FCLK_CLK", "Input muxed clock"},
	{146, 1, "DEV_UART0_FCLK_CLK_PARENT_USART_PROGRAMMABLE_CLOCK_DIVIDER_OUT0", "Parent input clock option to DEV_UART0_FCLK_CLK"},
	{146, 2, "DEV_UART0_FCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_UART0_FCLK_CLK"},
	{146, 3, "DEV_UART0_VBUSP_CLK", "Input clock"},
	{152, 0, "DEV_UART1_FCLK_CLK", "Input muxed clock"},
	{152, 1, "DEV_UART1_FCLK_CLK_PARENT_USART_PROGRAMMABLE_CLOCK_DIVIDER_OUT1", "Parent input clock option to DEV_UART1_FCLK_CLK"},
	{152, 2, "DEV_UART1_FCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_UART1_FCLK_CLK"},
	{152, 3, "DEV_UART1_VBUSP_CLK", "Input clock"},
	{153, 0, "DEV_UART2_FCLK_CLK", "Input muxed clock"},
	{153, 1, "DEV_UART2_FCLK_CLK_PARENT_USART_PROGRAMMABLE_CLOCK_DIVIDER_OUT2", "Parent input clock option to DEV_UART2_FCLK_CLK"},
	{153, 2, "DEV_UART2_FCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_UART2_FCLK_CLK"},
	{153, 3, "DEV_UART2_VBUSP_CLK", "Input clock"},
	{154, 0, "DEV_UART3_FCLK_CLK", "Input muxed clock"},
	{154, 1, "DEV_UART3_FCLK_CLK_PARENT_USART_PROGRAMMABLE_CLOCK_DIVIDER_OUT3", "Parent input clock option to DEV_UART3_FCLK_CLK"},
	{154, 2, "DEV_UART3_FCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_UART3_FCLK_CLK"},
	{154, 3, "DEV_UART3_VBUSP_CLK", "Input clock"},
	{155, 0, "DEV_UART4_FCLK_CLK", "Input muxed clock"},
	{155, 1, "DEV_UART4_FCLK_CLK_PARENT_USART_PROGRAMMABLE_CLOCK_DIVIDER_OUT4", "Parent input clock option to DEV_UART4_FCLK_CLK"},
	{155, 2, "DEV_UART4_FCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_UART4_FCLK_CLK"},
	{155, 3, "DEV_UART4_VBUSP_CLK", "Input clock"},
	{156, 0, "DEV_UART5_FCLK_CLK", "Input muxed clock"},
	{156, 1, "DEV_UART5_FCLK_CLK_PARENT_USART_PROGRAMMABLE_CLOCK_DIVIDER_OUT5", "Parent input clock option to DEV_UART5_FCLK_CLK"},
	{156, 2, "DEV_UART5_FCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_UART5_FCLK_CLK"},
	{156, 3, "DEV_UART5_VBUSP_CLK", "Input clock"},
	{158, 0, "DEV_UART6_FCLK_CLK", "Input muxed clock"},
	{158, 1, "DEV_UART6_FCLK_CLK_PARENT_USART_PROGRAMMABLE_CLOCK_DIVIDER_OUT6", "Parent input clock option to DEV_UART6_FCLK_CLK"},
	{158, 2, "DEV_UART6_FCLK_CLK_PARENT_HSDIV4_16FFT_MAIN_1_HSDIVOUT1_CLK", "Parent input clock option to DEV_UART6_FCLK_CLK"},
	{158, 3, "DEV_UART6_VBUSP_CLK", "Input clock"},
	{161, 0, "DEV_USB0_ACLK_CLK", "Input clock"},
	{161, 1, "DEV_USB0_CLK_LPM_CLK", "Input clock"},
	{161, 2, "DEV_USB0_PCLK_CLK", "Input clock"},
	{161, 3, "DEV_USB0_PIPE_REFCLK", "Input clock"},
	{161, 4, "DEV_USB0_PIPE_RXCLK", "Input clock"},
	{161, 5, "DEV_USB0_PIPE_RXFCLK", "Input clock"},
	{161, 6, "DEV_USB0_PIPE_TXFCLK", "Input clock"},
	{161, 7, "DEV_USB0_PIPE_TXMCLK", "Input clock"},
	{161, 8, "DEV_USB0_USB2_APB_PCLK_CLK", "Input clock"},
	{161, 9, "DEV_USB0_USB2_REFCLOCK_CLK", "Input muxed clock"},
	{161, 10, "DEV_USB0_USB2_REFCLOCK_CLK_PARENT_GLUELOGIC_HFOSC0_CLKOUT", "Parent input clock option to DEV_USB0_USB2_REFCLOCK_CLK"},
	{161, 11, "DEV_USB0_USB2_REFCLOCK_CLK_PARENT_HSDIV4_16FFT_MAIN_2_HSDIVOUT4_CLK", "Parent input clock option to DEV_USB0_USB2_REFCLOCK_CLK"},
	{161, 12, "DEV_USB0_PIPE_TXCLK", "Output clock"},
	{95, 0, "DEV_VTM0_FIX_REF2_CLK", "Input clock"},
	{95, 1, "DEV_VTM0_FIX_REF_CLK", "Input clock"},
	{95, 2, "DEV_VTM0_VBUSP_CLK", "Input clock"},
};
