{- This module was generated from data in the Kate syntax
   highlighting file matlab.xml, version 1.31, by  -}

module Text.Highlighting.Kate.Syntax.Matlab
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Matlab"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.m;*.M"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Matlab","_normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Matlab","_normal") -> return ()
      ("Matlab","_adjoint") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_KeywordsList = Set.fromList $ words $ "break case catch classdef continue else elseif end for function global if otherwise parfor persistent return spmd switch try while methods properties events"

regex_'5ba'2dzA'2dZ'5d'5cw'2a'28'3f'3d'27'29 = compileRegex "[a-zA-Z]\\w*(?=')"
regex_'28'5cd'2b'28'5c'2e'5cd'2b'29'3f'7c'5c'2e'5cd'2b'29'28'5beE'5d'5b'2b'2d'5d'3f'5cd'2b'29'3f'5bij'5d'3f'28'3f'3d'27'29 = compileRegex "(\\d+(\\.\\d+)?|\\.\\d+)([eE][+-]?\\d+)?[ij]?(?=')"
regex_'5b'5c'29'5c'5d'7d'5d'28'3f'3d'27'29 = compileRegex "[\\)\\]}](?=')"
regex_'5c'2e'27'28'3f'3d'27'29 = compileRegex "\\.'(?=')"
regex_'27'5b'5e'27'5d'2a'28'27'27'5b'5e'27'5d'2a'29'2a'27'28'3f'3d'5b'5e'27'5d'7c'24'29 = compileRegex "'[^']*(''[^']*)*'(?=[^']|$)"
regex_'27'5b'5e'27'5d'2a'28'27'27'5b'5e'27'5d'2a'29'2a = compileRegex "'[^']*(''[^']*)*"
regex_'25'2e'2a'24 = compileRegex "%.*$"
regex_'21'2e'2a'24 = compileRegex "!.*$"
regex_'5ba'2dzA'2dZ'5d'5cw'2a = compileRegex "[a-zA-Z]\\w*"
regex_'28'5cd'2b'28'5c'2e'5cd'2b'29'3f'7c'5c'2e'5cd'2b'29'28'5beE'5d'5b'2b'2d'5d'3f'5cd'2b'29'3f'5bij'5d'3f = compileRegex "(\\d+(\\.\\d+)?|\\.\\d+)([eE][+-]?\\d+)?[ij]?"
regex_'27'2b = compileRegex "'+"

parseRules ("Matlab","_normal") =
  (((pRegExpr regex_'5ba'2dzA'2dZ'5d'5cw'2a'28'3f'3d'27'29 >>= withAttribute NormalTok) >>~ pushContext ("Matlab","_adjoint"))
   <|>
   ((pRegExpr regex_'28'5cd'2b'28'5c'2e'5cd'2b'29'3f'7c'5c'2e'5cd'2b'29'28'5beE'5d'5b'2b'2d'5d'3f'5cd'2b'29'3f'5bij'5d'3f'28'3f'3d'27'29 >>= withAttribute FloatTok) >>~ pushContext ("Matlab","_adjoint"))
   <|>
   ((pRegExpr regex_'5b'5c'29'5c'5d'7d'5d'28'3f'3d'27'29 >>= withAttribute NormalTok) >>~ pushContext ("Matlab","_adjoint"))
   <|>
   ((pRegExpr regex_'5c'2e'27'28'3f'3d'27'29 >>= withAttribute NormalTok) >>~ pushContext ("Matlab","_adjoint"))
   <|>
   ((pRegExpr regex_'27'5b'5e'27'5d'2a'28'27'27'5b'5e'27'5d'2a'29'2a'27'28'3f'3d'5b'5e'27'5d'7c'24'29 >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'27'5b'5e'27'5d'2a'28'27'27'5b'5e'27'5d'2a'29'2a >>= withAttribute CharTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_KeywordsList >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'25'2e'2a'24 >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'21'2e'2a'24 >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ'5d'5cw'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'28'5cd'2b'28'5c'2e'5cd'2b'29'3f'7c'5c'2e'5cd'2b'29'28'5beE'5d'5b'2b'2d'5d'3f'5cd'2b'29'3f'5bij'5d'3f >>= withAttribute FloatTok))
   <|>
   ((pAnyChar "()[]{}" >>= withAttribute NormalTok))
   <|>
   ((pString False "..." >>= withAttribute NormalTok))
   <|>
   ((pString False "==" >>= withAttribute NormalTok))
   <|>
   ((pString False "~=" >>= withAttribute NormalTok))
   <|>
   ((pString False "<=" >>= withAttribute NormalTok))
   <|>
   ((pString False ">=" >>= withAttribute NormalTok))
   <|>
   ((pString False "&&" >>= withAttribute NormalTok))
   <|>
   ((pString False "||" >>= withAttribute NormalTok))
   <|>
   ((pString False ".*" >>= withAttribute NormalTok))
   <|>
   ((pString False ".^" >>= withAttribute NormalTok))
   <|>
   ((pString False "./" >>= withAttribute NormalTok))
   <|>
   ((pString False ".'" >>= withAttribute NormalTok))
   <|>
   ((pAnyChar "*+-/\\&|<>~^=,;:@" >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Matlab","_normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Matlab","_adjoint") =
  (((pRegExpr regex_'27'2b >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Matlab","_adjoint")) >> pDefault >>= withAttribute NormalTok))


parseRules x = parseRules ("Matlab","_normal") <|> fail ("Unknown context" ++ show x)
