# XChat ChangeLog

To see more details of bugs, go to this URL:

http://sf.net/tracker/?func=detail&atid=100239&group_id=239&aid=NUMBER

Where "NUMBER" is the bug number.

This log DOES NOT apply to XChat for Windows.

There are always more changes than listed here, these are just the
highlights. The full CVS log is available at [www.xchat.org/cvslog/](http://www.xchat.org/cvslog/)

***

## 2.8.10 - dd/mm/yyyy

 - Emit the Topic Change event before setting the topic internally so plugins
   can access the old topic inside the callback.
 - Add two options url\_grabber and url\_grabber\_limit.
   * url\_grabber is a boolean for enabling/disabling the url grabber
   * url\_grabber\_limit is an integer controlling the number of URLs the
     URL Grabber will keep around. Setting it to 0 leaves it unlimited as in
     previous versions.
 - Fixed a bug with the URL Grabber where it fails to grab a URL if the URL
   is the first thing in the message.
 - Change /ignore &lt;nick> to always add !*@* if &lt;nick> does not contain ? or *
 - Perl (Lian Wan Situ)
  * Added two new options to hook\_print, run\_after\_event and filter. See
    documentation for details.
  * When building on Windows, generate the name of the DLL for the Perl
    library based on information from the header files instead of hardcoding
    the value.
  * Fixed a bug in the reinit handling code. The bug prevented the plugin from
    cleaning up properly. Which includes unloading scripts and removing
	 their GUI entries.
  * Remove the restriction on having only 1 package per script. Any inner
    packages declared will also be unloaded when the script is unload. If
    multiple script declare an inner package with the same name then unloading
    or reloading one of those scripts will cause problems.

***

## 2.8.8 - 30/May/2010

 - Made balloon time adjustable via /set input\_balloon\_time (Nicoleau Fabien).
 - Fixed a crash in the /SET command if a boolean value was loaded from config
   file that isn't set to 0 or 1.
 - Added -on and -off parameters to the /SET command. This can be used to set
   bits, for example gui\_tweaks.
 - Made scrolling backwards for the search window act better (Richard Hitt).
 - [2045483] Made ESC key close the search window (Richard Rowell).
 - Improved the reconnect logic. If a network is already open but disconnected,
   it'll now get re-used if you use the Network List and connect to that same
   network.
 - Improved scrollback reloading speed significantly (Soeren Sandmann Pedersen).
 - [2957047] Handle CTCPs when IDmsg is used correctly (Lian Wan Situ).
 - [2987626] Allow /GHOST's password arg to be optional (Ori Avtalion).
 - Added networks: 7-indonesia, ChattingAway, GeekShed, TURLINet.
 - When switching tabs, make the treeview only scroll if the selected item
   isn't visible [treeview-less-jumping.diff] (Brian Evans).
 - Selecting an item in the nickmenu will now copy it to clipboard (Alex
   Kutepow).
 - New icons for notification area (systray): file offer, message and highlight
   (Brian Evans).
 - Defined a comparison routine for contexts in Python (Brian Evans).
 - For the auto-join command, added an 'x' filler for empty keys. This works
   around a bug in ircd-seven.
 - When a single channel MODE changes, xchat will no longer re-issue a MODE
   request for the titlebar display, but figure the new modes intelligently
   (Brian Evans).
 - Various text event changes (Brian Evans):
   1. Added "Private Action", "Private Action to Dialog", "SSL Message".
   2. Added "Identified text" parameter all the 'action' events.
   3. Added a $3 parameter to "Server Text".
 - Perl (Lian Wan Situ)
  * Fixed a bug that resulted in timer hooks being leaked because
    "return REMOVE" from a timer callback was not unhooking like it was
    supposed to
  * Reverted the unintentional change to how the server argument of print()
    and command() is interepreted when it is undef
  * Add hook\_fd to the 'hooks' export tag
  * Fixed a leak in XS\_Xchat\_get\_list(Vincent Pit)
  * Change Xchat::register so that scripts calling it without a name or
    version will still show up in the plugins and scripts window.
  * Added calls to PERL\_SYS\_INIT3 and PERL\_SYS\_TERM which are required on
    some platforms
  * Added some additional guards to prevents bits of scripts from spilling
    into each other
  * Added "modes", "win\_ptr" and "xchatdirfs" to the list of keys that are
    returned by context\_info()
  * Changed the information displayed in the "Plugins & Scripts" for scripts
    that do not call register() to show up as "" for the name and description
    and "unknown" for the version
  * /reloadall will now reload scripts in the same order they were loaded
  * Make xchat\_send\_modes available as Xchat::send\_modes
  * Add support for getting the network list using Xchat::get\_list( "networks" )
  * Xchat::strip\_code will now strip off ANSI escape codes as well

***

## 2.8.6 - 11/Jun/2008

 - Updated translations (de, fi, fr, hu, lt, nb, ru, th, zh\_CN).
 - Fixed creation of ~/.xchat2/scrollback/ paths (xc284-scrollbmkdir.diff).
 - Fixed a leak of file descriptors related to the scrollback feature
   (resource leak) (xc284-fix-scrollbfdleak.diff).
 - Stopped scrollback files growing too large by fixing the file-shrink code.
 - Put a "Display scrollback from previous session" into the Setup GUI
   (logging section) so people can turn this off without typing commands.
 - Made /away work even when the reason setting is empty.
 - Using /part on a channel that contains a quotation mark now works [1800855].
 - Changed the default encoding to "IRC" (CP1252/Unicode Hybrid) for both Unix
   and Windows.
 - Fixed a possible Channel List crash if you searched many times while the
   download was still going.
 - Fixed alert balloons failing if the text contained "<" characters [1827629].
 - The Drag&Drop files to userlist feature has been enabled again.
 - Removed the /set tab\_icons setting and made it automatic (see FAQ for more
   info about icons).
 - Fixed a bug in creating files (save channel list, rawlog etc) that would set
   the wrong permissions.
 - Added command line argument --command=COMMAND which can be used in
   conjuction with --existing (E.K.L.). This sends any xchat command to an
   existing (running) client.
 - A private SSL key/certificate can now be loaded from ~/.xchat2/client.pem.
 - The Alerts settings now accept wildcards, instead of partitial string match
   [1807563].
 - Changing away status during reconnect/disconnect will now remember it.
 - You can now change your Away/Back status (all networks) in the tray menu. 
 - Favorite Channels / Auto-Join-List management:
   * Network List window now has a "..." button to edit the auto-join-list in
     a more friendly way.
   * Channel(text area), Tree/Tab and Channel-List right-click menus now have a
     "Add to Favorites" function.
   * Previous limit of 300 bytes has been overcome. Now up to 2 KB worth of
     channels/keys can be joined and it will be automatically split into
     multiple lines, if necessary.
   * Per-Channel settings now save to disk, including Logging and Scrollback
     settings.
   * /ChanOpt has been re-worked to be more like /Set.
 - 'hostname:port' syntax is now accepted, if it's not an IPv6 address.
 - The Userlist right-click menu now has icons and an option to add to friends
   list. If you've edited this menu before you'll still get the old one. To get
   the new one delete ~/.xchat2/popup.conf while XChat isn't running.
 - ~/.xchat2/startup.txt is now loaded on launch (like /LOAD -e). Put any
   commands you want executed at startup here.
 - The lag-o-meter now has a full scale of 1.0 seconds.
 - libnotify is now opened directly instead of using 'notify-send' to open
   tray/balloon alerts.
 - Added support for QuakeNet's /AUTH for nick password, when numeric 005
   NETWORK=QuakeNet is detected.
 - You can now copy with IRC attributes and mIRC colors if CTRL key is down
   when a selection is finished (on mouse release). This replaces the old
   "Color paste" feature.
 - Added a 'compact' flag to gui\_tweaks. This'll make the userlist and tree
   spacing smaller. E.g. type /set -or gui\_tweaks 32 and restart to turn it on.
 - The /CLEAR command takes a number as paramater (how many lines to clear).
 - When there's missing information in the Userlist right-click menu, it'll
   issue a silent /WHOIS and fill it in. This includes retrieving a person's
   away-reason.
 - Perl (Lian Wan Situ)
  * /reloadall will now reload all the scripts that are currently load instead
    of simply reruning the autoload routine
  * gtk/glib/gdk errors and warnings have been redirected back to stderr so
    they will no longer show up in the text box as a result of having the Perl
	 plugin loaded
  * Check if the user has perl 5.6 instead of 5.8 and give an warning dialog
    if they do (Peter Zelezny)
  * Changed timer callbacks so that they are executed in the context that they
    were created in
  * Modified Xchat::print and Xchat::command to accept array references in
    addition to strings for the channel and server parameters
 - Plugin API:
  * xchat\_emit_print() will now trigger Sound, Blink, Icon etc type events,
    depending on user's settings. 
  * Fixed a bug where not all 32 elements were available in word[]/word\_eol[].

***

## 2.8.4 - 01/Jul/2007

 - Updated translations (cs, de, ko, mk, sv, vi).
 - System-Tray balloons now get the xchat icon instead of a generic one.
 - Fixed the notify-send zombies (released as xc282-fixtrayzombies.diff).
 - Fixed underscore ('\_') in real names in the nick-name right-click menu being
   drawn as a underline.
 - ut2004:// URLs are now underlined too.
 - /set gui\_tray\_flags 4 will now enable a "Minimize to tray" feature. Clicking
   the window minimize button will minimize to tray instead of the task-bar.
 - Fixed bug: [1680762] Notify fails if network name contains spaces.
 - Extended tclConfig.sh search paths so it hopefully works on Ubuntu now.
 - Added a feature that reloads conversations from last time you used XChat
   (type /set text\_replay 0 to disable it).
 - Fixed /LASTLOG printing everything twice if you had Indented Nicks off.
 - The CTRL-F keybinding (Find) is now disabled when using Emacs keys.
 - Added /SET gui\_tweaks. See http://forum.xchat.org/viewtopic.php?p=13766
 - Fixed opening URLs on KDE that didn't begin with http:// or other protocol.
 - A better quit dialog which warns you if you're connected to IRC or have
   active file transfers.
 - Fixed: [1741525] Cycle selected channel (Luca Falavigna).
 - Fixed: [1737249] Doesn't recognize nicks with halfop mode on hovering.
 - The userlist and treeview can now be placed on the same side, with a resize
   handle in between them. They can also be dragged and dropped into place.
 - When you hide the userlist using the View menu, the resize handle now
   disappears too. It also disappears when you have a server tab in focus.
 - If you have a tree on one side and userlist on the other, they'll both now
   have a resize handle, previously the tree's size was fixed.
 - The userlist can be hidden and shown with CTRL+F7.
 - [1735116] Channel List's minimum users spin-button can now be set downward
   even on networks that sent a list of channels of only a larger size. In this
   case the Download button will flash to indicate you need to download a new
   list.
 - Changing the channel switcher type (Tree or Tabs) is also possible in the
   setup dialog.
 - The Ban List window now lists exceptions too (mode +e).
 - Script and Plugin related changes:
  * /SETTEXT with no argument now clears the input box.
  * Python: Added a xchat.strip method for stripping IRC attributes and mIRC
    color codes.
  * C-API and Perl: Returning 0 from a FD hook will now remove the hook and
    free all associated memory.
  * /MENU now supports a $CHAN root aswell (see plugin20.html).
  * Fixed GDK warning when using /MENU to add a key binding to a popup menu.

***

## 2.8.2 - 01/Apr/2007

 - Updated translations (be, ca, cs, el, hu, sv, uk, zh\_CN).
 - Fixed the "Save As" function saving to the wrong folder in the URL Grabber.
 - Fixed a bug in the "Copy Selected Link" URL right-click on non-ASCII chars.
 - Fixed small bug: #100239 buffer overflow in setup dialog.
 - Overhauled the Alerts section of the settings and added support for opening
   system-tray balloons (libnotify required).
 - Implemented /TRAY -b command on unix.
 - Nick serv authentication is now sent without the ":" when using the
   /NICKSERV or /NS method. #1655733.
 - Added command line argument:
   --minimize=level         Begin minimized. Level 0=Normal 1=Iconified 2=Tray
 - Plugin API:
  * Added "modes" to xchat\_get_info(). Returns the current channel modes, if
    they are known.
  * Fixed "event\_event name" for xchat\_get\_info() to match the docs exactly,
    but 2.8.0 (mis)behaviour works too.
 - Perl (Lian Wan Situ)
  * Execute the shutdown callback before removing the hooks so commands
    created by the script can be used in the callback.

***

## 2.8.0 - 03/Jan/2007

 - Updated translations (cs, de, gl, hu).
 - XChat now requires at least GTK+ 2.10.
 - Added a system tray icon (aka Notification Area). This is probably the
   biggest feature addition in this series. Also added a /TRAY command so
   scripts can manipulate the icon.
 - Added partial support for numeric 005 token ELIST (min users only).
 - Brand new channel list window: GtkTreeView, nicer layout, less CPU power
   when downloading very large list, uses less memory, supports regexp/
   patternmatch/substring search and supports downloading LIST with minusers to
   save time (only on some networks that support ELIST).
 - Overhauled URL opening on Unix, it now tries xdg-open first, then auto-
   detects Gnome or KDE to run gnome-open or kfmclient. URLs with quotes
   should also work now (changed to execv()).
 - Settings: Warn the user when trying to put the tree on the top/bottom.
 - Fixed DCC ack reading so it doesn't use MSG\_PEEK.
 - Channel modes are no longer shown in the titlebar if they contain a key.
 - Added /GUI APPLY command, which does that same as pressing OK in the
   settings window (e.g use it after /set). Mainly for scripters.
 - Allow changing the logging folder if the log filename is set to a full path
   in the settings window (starts with a '/').
 - Added 'Your Action' text event.
 - Separated out /away and /back commands so it's obvious what they'll do.
 - Changes to /MENU command (See plugin20.html for details):
  * Now works for popup menus too.
  * Allows creation of radio menu items.
  * -p arg can now to be negative to give a position offset from right/bottom.
  * -i arg to specify an icon file.
 - Plugin API:
  * Added event\_text to xchat\_get\_info().
 - Perl (Lian Wan Situ)
  * Fixed hook\_command so that it won't override the help message for builtin
    commands unless a help message was specified.
  * Perl Win32: Warn the user about trying to load 64-bit ActivePerl.

***

# 2.6.8 - 16/Oct/2006

 - Updated translations (be, de, el, es, fi, hu, it, ja, lt, pt, ru, sv, vi).
 - Removed "xchat-remote" and "dbus.so", it's now apart of the "xchat" binary.
   There is now a new dbus interface, see src/common/dbus/README for details.
   (Claessens Xavier).
 - Python: Fixed "restricted mode" errors on win32 [1512076].
 - Special-cased BRASnet for nickserv.
 - Fixed using the /MENU args -p and -e at the same time.
 - Fixed /reconnect and auto-reconnect issue [1525383].
 - Plugin API:
   * Added fields: lag, queue to the "channels" list.
   * Added fields: sizehigh to the "dcc" list.
   * Added fields: networks to the "notify" list.
   * Handle gracefully plugins that try to execute commands with invalid UTF-8.
   * Added /GETFILE command, to open a file dialog.
   * Command hooks that start with a period ('.') will now be hidden from /HELP
     and /HELP -l.
 - Fixed: [1544960] quitting via tabs behaves bad on bncs.
 - Fixed: [1551620] --version flag needs display.
 - Fixed: [1539236] problem with the /url command (irc:// handling).
 - Fixed: [1568931] treeview problem: closing tabs by holding shift and
   clicking.
 - "Clear" button in Ban List window now has a 'Are you sure?' dialog for
   safety.
 - The notify list can now contain entries specific to only one or more IRC
   networks.
 - Userlist popup menu and buttons: added %e for 'current network name'.
 - Added option: 'Flash taskbar on any private messages'.
 - Added a new encoding choice: "IRC (Latin-1/UTF-8 hybrid)".
   How it works is described at: http://forum.xchat.org/viewtopic.php?t=3180
 - Added /LastLog -r <regexp>.
 - The DCC windows have been remodeled and are much nicer now. Ported to
   GtkTreeView, the buttons are context sensitive, the window remembers its
   size and uploads and downloads are combined in one window.
 - Perl (Lian Wan Situ)
  * Changed Xchat::print and Xchat::command to return false if they are called
    with either no arguments or undef
  * Changed Xchat::user\_info so that it works even if the nick parameter
    contains color codes

***

## 2.6.6 - 18/Jul/2006

 - Updated translations (es, fr, sr).
 - Fixed connecting to a IRC server via proxy (bug in 2.6.4 only).
 - Fixed the invisible cursor color when using GTKSpell and a black
   input box (when "Use the text box font & colors" is ON).
 - Allow loading a cert/privatekey file from ~/.xchat2/<NetWorkName>.pem
 - Improved the fallback routine when you receive non-UTF8 messages. It
   can now handle CP1252 from mIRC users and the ISO-8859-15 Euro symbol.
 - Added CHANOPT command for setting channel specific options such as showing
   of joins and part, beep on message and color paste (Lian Wan Situ).
 - /CLEAR HISTORY will clear your command history.
 - Fixed a crash if you left a Ban-List window open after closing the
   associated channel and then clicking Refresh.
 - Added an option of using 'Last-Spoke' nick completion order in Settings >
   Input Box.
 - The /QUERY command now has -nofocus arg, which scripts might find useful.
 - You can now /set gui\_url\_mod 0, to allow left-clicking URLs (default is
   4, for CTRL).
 - XChat will now respect gtk-button-images=0 set in ~/.gtkrc-2.0.
 - Added a ./configure option to use your preferred spelling library:
   --enable-spell=type. Where type can be: none static libsexy gtkspell.
   Note that using gtkspell will force the inputbox to become a GtkTextView.
 - Advanced users can /set tab\_small 2, to get _extra_ small tabs.
 - Added /SPLAY <soundfile>.
 - Plugin API:
  * The second args to xchat\_list_int and xchat\_list\_str can now be NULL as
    a shortcut to "channels" list for current context only.
  * Added bits 6-8 to the field "flags" in the "channels" list.
  * /GUI MSGBOX <text> can now contain Pango markup.
  * Added -m arg to /MENU. See plugin20.html for more.
 - Perl (Lian Wan Situ)
  * Fixed a bug with Xchat::print that prevents printing out a
    single 0(Lian Wan Situ)
  * Fixed a bug in Xchat::get\_prefs that was clobbering the stack(Sergio Luis)
  * Allow scripts that use a non-existent function for the shutdown callback
    to be unloaded(Lian Wan Situ)
  * Added check in set\_context for undef
  * Added the fields from get\_list "channels" for the current context to the
    result of context\_info

***

## 2.6.4 - 08/Jun/2006

 - Updated translations (de, el, es, gl, hu, nl, sv, vi, zh\_TW).
 - Fixed opening a irc:// URL via "xchat -a --url=abc123" command while
   "Skip serverlist on startup" is off. This fix is only relevant when
   opening an initial instance of xchat (i.e not via dbus).
 - Fixed the tree layout "flashing" (redrawing slowly) after you
   switched to tabs and back to tree.
 - Fixed plugin/script get\_list("users") causing a critical GDK warning
   when not executed from the front-most tab.
 - Added spelling support in the input-box via GTKSpell.
 - Improved the error reporting when connecting through a Socks proxy.
 - DCC file transfers via http/socks45/wingate proxy is now supported
   (Damjan Jovanovic & me).
 - Fixed Socks 5 failing on 64-bit CPUs.
 - Added support for connecting through a Microsoft ISA Proxy, requires
   libntlm at build time (Pavel Fedin).
 - You can now mark and copy timestamps if you hold down SHIFT.
 - Timestamps are now preserved in the /lastlog command. Also fixed a
   bug where the separator line disappeared during /lastlog.
 - Added a Browse button to the DCC download folder setting.
 - Made the setup window a little neater and Gnome-like.
 - Improved the notify window a little and fixed a small memory leak.
 - Fixed CTCPs being truncated in the RawLog window.
 - Added an option to open a "Save As..." dialog when receiving a
   DCC file offer.
 - Fixed a crash if you try to remove a network from the list while
   it's in a auto-reconnect delay [debian bug #364858].
 - Python: Fixed some memory usage bugs.
 - Perl: Turned on utf8 flag for things that should have it on.

***

## 2.6.2 - 27/Mar/2006

 - Updated translations (de, fr, ja, sv).
 - Made "/server freenode" send auto-join channels but not
   "/server irc://freenode".
 - Fixed building of xchat-text (although not recommended!).
 - Fixed using Strip mIRC colors & Color nicks at the same time.
 - Fixed a bug in timestamp drawing using non-fixed-width font [1404341].
 - Fixed display of realname in the nick-name right-click menu when it
   contains a '<' or '&' character [1403069].
 - Added support for UniBG's nickserv (ongeboren).
 - The move-to-complete-dir routine now treats encoding/UTF8 correctly.
 - Show help when using wrong args for /DCC, instead of silence.
 - Support receiving 2048 bytes per line from server and dcc-chat, so we
   can support 512 UTF-8 characters that some servers now send.
 - Added /gui detach and /gui attach commands for scripters.
 - The server list window now remembers its size.
 - TCL: Added 'selected' flag to users list.
 - Perl:
  * Fixed strip\_code so that it no longer takes off extra commas (LifeIsPain)
  * Fixed filename checks so that '/load "filenameWithoutSpaces.pl"'
    will also work (Lian Wan Situ).
  * Fixed hook\_fd to work with sockets on Windows (Vince Pit).

***

## 2.6.1 - 06/Jan/2006

 - Updated translations (de, el, fi, fr, gl, hu, ko, nl, pa, sq, vi).
 - Added support for log rotation based on time or date.
 - Double-click in tree layout will now expand/collapse (Lian Wan Situ).
 - Keys to move tabs around now work in Tree layout too (Lian Wan Situ/Me).
 - Largely re-written "Search Text" function with much better
   behaviour and match case on/off and search backwards options 
   (Richard Hitt and Me).
 - The parent row in the tree layout now changes color if you have
   that group collapsed (Lian Wan Situ).
 - Fixed crash when trying to Detach or Close a utility tab via
   right-click, when it's not the currently focused tab.
 - Made DCC resume handle case-insensitive file systems properly.
 - Fixed the flashing when you click on a colored treeview row.
 - Fixed auto-completion during /exec -o [1375530].
 - Added "Join Channel" menu item to the Server menu.
 - Unshade the Disconnect menu item when a connection is in progress.
 - Fixed a possible crash in changing color settings before changing
   to/from the tree layout (SF bug #1349088).
 - Added "Auto accept file offers" to the File Transfer settings.
 - Added support for brackets "<>" around nicknames in cut and paste,
   without displaying them (hidden text) (Camillo Lugaresi).
 - Fixed opening URL irc://NetWork/#channel not joining the channel
   [1362155].
 - Fixed the nickname label becoming small when you're marked Back
   if you have "Small tabs" turned on.
 - The textevents GUI has been re-written to use GtkTreeView.
 - Randomized DNS lookups on Mac OS X on hostnames that return
   multiple IP numbers (SG / CL).
 - Added a dialog window to help newbies join a channel.
 - Opening irc:// URLs will now JOIN only if you are already connected
   to the network.
 - Plugin API (Lian Wan Situ):
  * Added selected flag to "users" list.
  * Added "id" to xchat\_get_prefs.
  * Changed xchat\_find_context (ph, channel, NULL) to return results
    from the same server group as the current context when possible.
 - Perl (Lian Wan Situ):
  * using emit\_print/command/recv will no longer trigger their own
    callbacks.
  * Fix compiling issues with versions older than 5.8.2.
  * Make all scripts appear in the "Plugins and Scripts" window, even
    those that do not call register().

***

## 2.6.0 - 03/Nov/2005

 - Updated translations (nl, zh\_TW).
 - Message boxes are now warning, error or info with appropriate icon.
 - Red marker line feature enabled by default.
 - Added /SEND <nick> [file] which will automatically switch to PSEND
   when detecting a private net address.
 - Simplified default nick-right-click menu.
 - Show "Last Talk" in nick-right-click menu as "minutes ago".
 - Strip mIRC colour from away message in right-click menu.
 - Warn when opening banlist in non-channel.
 - Reorganised and simplified IRC/Server menus and new View menu.
 - The editable Server menu is no more, if you want it type
   /set gui\_usermenu 1 and restart.
 - Option to view channels in tabs or tree structure.
 - Shorter titlebar text for better viewing in taskbar.
 - Disabled key-search in server list, as GTK's auto-find does this
   better.
 - Removed "Connect in new tab" button in server list, it now does it
   intelligently. Use stock Connect icon.
 - Removed "Tint (shade) transparency" item from settings and figure
   it out based on tint values.
 - When closing a tab, re-focus the one near by, instead of always the
   last.
 - Firefox style close button.
 - The lag and throttle metres now have tooltips that give you real
   information (hover the pointer over them).
 - Added workaround to show on-join ChanServ notices in the right tab.
 - Tab scroll buttons are now side-by-side when in vertical mode.
 - Automatically change key shortcut of "Marked Away" if the
   translation already uses ALT-A for the Help menu (e.g \_Aide in
   French).
 - Your nickname in the bottom-left corner now turns gray when you are
   marked away, just like the userlist.
 - Introduced a delay before joining channels, to allow for FreeNode's
   short comings. If a umode +e is received it'll send auto-join
   channels immediately.
 - Plugin API: Added win\_ptr to xchat\_get\_info.
 - Non-irc (utility) tabs can now be detached aswell.
 - Fixed behaviour problems of the userlist pane, which might be set
   incorrectly if the window was resized while a server-tab is focued.
 - Added a confirm-dialog when trying to close a server-tab with
   children.
 - Server list's edit window now gives you an option of a network
   specific "Second choice" nickname.
 - Auto detect RusNet and use /NICKSERV to identify instead of /MSG.
 - Added /Ghost command.
 - Fixed: The WHOIS away-line ignored irc\_whois\_front setting.
 - Scroll-wheel now works while hovering over a tab (Lian Wan Situ).
 - The input box right-click menu now has bold, underline and italic.
 - Added xchat-remote for launching irc:// URLs in existing xchat
   and other functions (Claessens Xavier).
 - WIN32: Auto-loading perl scripts now also works from:
   C:\Program Files\XChat\Plugins\
 - Better command-line parameter parsing via GOption.
 - Tab completion order can now be in "last talk" order if you
   /set completion\_sort 1.
 - "Channel Action" and "Channel Action Hilight" now have a 3rd
   argument of "Mode char", just like normal message events. The last
   talk time is also now updated on actions.
 - Reworked the Character Chart window so you can find your char.
 - Perl:
  - fixed so that printf and commandf are exported
  - print and printf can also be called as prnt and prntf, this is to
    avoid clashing with the builtins.
 - Deprioritized MODE/WHO to reduce join lag.
 - WIN32: Mask out more invalid filename characters when writing to
   log files.

***

## 2.4.5 - 10/Sep/2005

 - Updated translations (cs, el, fr, gl, it, nl, sl, sr, vi, zh\_TW).
 - Fixed incorrect information displayed in Plugins & scripts window
   under unix (xc244-fixpluginns.diff).
 - Added "/set irc\_whois\_front 1" option to show WHOIS in front tab.
 - Lots of speed ups under the hood, mainly in handling of URL
   highlighting during mouse motion. Also now allows underlining
   .name and .info domains [1230265].
 - Moved the "Insert color code" menu into the input box's right-
   click menu.
 - Fixed "Your Message" messing up when starting with a comma
   [1230269].
 - Added /id command to identify yourself to nickserv.
 - Added /gui MSGBOX <text> for scripters.
 - Added /menu command which lets plugins/scripts add their own
   menu items.
 - Added support for passive DCC chat via /DCC PCHAT <nick>.
 - Added support for DCC sending and receiving very large files
   (above 4 GB).
 - Improved layout of "Info" button in the DCC windows.
 - Improved layout of the nick-name right-click menu.
 - Improved /help command's display of plugins/script commands.
 - Fixed two bugs in detaching tabs (or CTRL-I) [1228926].
 - Added /uselect command for scripters to select nick names in the
   channel userlist (Daniel P. Stasinski).
 - Fixed possible crashes while using the SJIS (Japanese) charset.
 - Fixed various memory leaks in right-click menus.

***

## 2.4.4 - 20/Jun/2005

 - Updated translations (hi, ko, lt, pa, ru, vi, zh_TW).
 - People's away message is now shown in the right-click menu, if
   known (Christopher Aillon).
 - The "Bind to:" setting can now be set to 0.0.0.0 [1176256].
 - Plugin API: Don't crash if a print-event closes the current context
   and doesn't eat the event [1175674].
 - Disabled parsing of quotation marks for /JOIN, so you can join
   channels with a quote in them (Dan Fruehauf).
 - Fixed truncation of the URL in the right-click menu. Now handles
   UTF-8 properly [1188229].
 - Fixed use of CP1255 charset, which would chop the last char when
   receiving messages [1122089].
 - The DCC windows now allow multiple selection and the columns auto
   resize (Dan Fruehauf).
 - Added "CTCP Sound to Channel" event [1159445].
 - You can now drag and drop files into dialog windows to start file
   transfers.
 - Perl:
   - Fix to allow fully qualified variable names to work as well.
   - Enabled individual script unloading.
   - Enabled reloading scripts using XS modules.
   - Fixed handling of filenames with spaces in them.
   - Added /reload which works like /load but it will do an unload first
     it is not necessary to use the full path with this command, just
     the file name is enough.
   - Fix print callbacks for cases where there are NULL elements between
     non-NULL elements.
 - Fixed: "XChat can't ban users with long idents" (Dan Fruehauf)
   [1159447].
 - Implemented taskbar flashing on unix. Requires a window manager
   or taskbar that supports XUrgency flag (Adil).

***

## 2.4.3 - 31/Mar/2005

 - Updated translations (de, sq, zh\_CN).
 - Fixed crash of server list connect button when no network is
   selected while using GTK's auto-find feature [1166669].
 - Fixed handling of WhoIs Special event on some networks where it
   could chop off the first character [1164315].
 - Plugin API changes: Added "nickserv" field to xchat\_get\_info.
 - Python: Fixed get\_list() incorrectly failing when the list
   contained a time field [1171525].
 - Perl: Make scripts using calls with fully qualified subs work again
   [1170139] (Lian Wan Situ).
 - Fixed input-box input-method (GTK I.M.) problem [1168239].
 - Fixed: Ignore and Notify windows incorrectly used the stock CLOSE
   button instead of DELETE [1170655].
 - Placed Close/Connect buttons in correct position in server list
   [1165474].

***

## 2.4.2

 - Updated translations (ca, de, lt, nl, ru, sk, sr, vi).
 - Added command line args -u and -p.
 - Fixed handling of "MODE -o+o nick nick" (#1094026).
 - Plugin API changes:
   * Added "Key Press" print event.
   * Added "state\_cursor" for xchat\_get\_prefs.
   * Added xchat\_strip and xchat\_free functions.
   * Added "lasttalk" field to "users" list.
   * Added "charset" field to xchat\_get_info.
 - Perl plugin changes (Lian Wan Situ):
   * Move each script into their own unique package/namespace. Scripts
     containing multiple packages will not be loaded.
   * When warning messages are emitted you will now be told which
     script it came from.
   * Xchat::set\_context will now accept Xchat::set\_context( $channel )
     and Xchat::set\_context( $channel, $server ) in addition to
     Xchat::set\_context( $context ).
   * Fix display of loaded scripts in the Plugins and Scripts window.
 - TCL: Fixed crash with invalidated TCL timer (#1110306) (Daniel P.
   Stasinski).
 - /TIMER now supports timeouts to one decimal place.
 - Fixed possible crash of open-file dialog on 64-bit machines.
 - Pressing CTRL-O in the DCC Receive window will now open your
   downloads folder.
 - Win32: Default download folder changed to "My Documents\Downloads".
 - Added -quiet arg to the /charset command.
 - The /country command now supports a wildcard search.
 - The user is now warned when real/user name is left blank in the
   server list window.
 - Added the /URL command.
 - Added a text event for all unknown WHOIS reply lines.
 - Added /ALLCHANL which sends to the current server only.
 - Actions (/ME) are now treated like PRIV/CHAN for purposes of the
   ignore list.

***

## 2.4.1

 - Updated translations (ca, de, eu, it, ko, mk, nb, nl, pt, ru, sl,
                         sq, uk, zh\_TW).
 - Fixed custom marker-line color not reloading.
 - Brought back the "Connect to selected server only" option in the
   Serverlist edit window (it's like the reverse of "Cycle until
   connected" in 2.0.x).
 - You can now move networks and servers via Shift+Up/Down (in the
   ServerList window).
 - Small efficiency improvements in receiving dcc. It will now not
   send ACKs while the input buffer is non-empty.
 - Python: Fixed crash when a timer callback routine executes
   xchat.unhook() and returns false.
 - Fixed playing sound files with spaces in them.
 - Added support for NickServ on DalNet and FreeNode.
 - Plugin API: Added xchat\_get_info(ph,"inputbox");.
 - Added /settext and /setcursor commands for scripters.
 - You can now scroll tabs with the mouse-wheel while hovering over
   the arrow buttons.
 - Fixed connecting to a SSL server via http proxy (#1054152).
 - Fixed: Opened server tab doesn't count as "requested" (#1044227).

***

## 2.4.0

 - Updated translations (ca, de, eu, it, ko, lt, nl, sk, sr, zh\_CN).
 - Fixed a possible crash in loading pevents.conf.
 - Made default URL handlers work with Firefox 0.9.x by adding the
   "-a firefox" argument.
 - Plugin API: Added xchat\_get_info field "libdirfs".
 - Fixed crash when trying to dcc send a filename which has encoding
   that doesn't match G\_FILENAME\_ENCODING.

***

## 2.1.1

 - Updated translations (de, kr, lt, sk, sr, zh\_CN).
 - Added some rudimentary support for the IDENTIFY-MSG feature.
 - Perl: Added Xchat::context\_info (Lian Situ).
 - TCL: Added support for time fields in getlist (Daniel P.Stasinski).
 - Added "Open Dialog" event, so you can add a sound-file to it.
 - The standard beep can now be overridden with a sound-file.
 - Fixed tab-nick-completion's cycling behaviour.
 - New keyboard shortcut for line up and down (shift-arrow up/down).
 - Fixed: [986958] tab completion with GTK Input-Methods.

***

## 2.1.0

 - Updated translations (eu).
 - Tab nick completion fixes: Crash with space-tab and glib critical
   warning (Ian Kumlien).
 - Heavily reworked the Preferences window. It should be alot clearer
   now, and more gnome-like.
 - 'Pop new tabs to front' setting now has three options (Kyoshiro).
 - New colors and text-events, using a white background.
 - Config files are not saved to disk unless you edit the defaults.
   This makes it easier to change language (for print events, popup
   menu etc).
 - Brand new Server List window. Now much simpler and intuitive. Also
   includes an entry box for NickServ password.
 - The vertical separator line now has its own pointer when you hover
   over it (Richard Gobeille).
 - Alphabetical tab sorting now works and is enabled by default.
 - Added "Small Tabs" option (reduces the font size).
 - Brand new Sound-Events editor in the Preferences window.
 - Added socks5 authentication support (Benjamin Foster).
 - Win32: fixed auto-loading of TCL scripts.

***

## 2.0.10

 - Updated translations (ru, sr).
 - Fixed compiling on systems other than linux/freebsd [969643].
   (Samuel Mimram).
 - Fixed compiling with an old version of GTK (2.0.x).
 - Further BiDi fixes in xtext (Ilya Konstantinov).
 - Brand-new tab completion code (Ian Kumlien). This also fixes:
   Tab expansion not working behind umlauts [956127].
   Plugin commands can now be tab-completed too (Frank Thieme).
 - Fixed parsing URIs on userlist drag-n-drop (Jonas Heylen).
 - Added Sort button to the server list window (David Oftedal and
   Tim-Philipp Mueller).
 - Tab button selection fix (Guillaume Knispel).
 - Added marker-line feature. Shows a red-line to indicate the place
   where you last read up to (Thomas Kockerbauer).
 - The "Get my IP from Server" feature now works on networks that
   hide your hostname too (by using the USERHOST command).
 - Win32: Fixed CPS calculation for file transfers [824934].
 - Fixed: Ping timeout when the system clock changes [789140].
 - Fixed: Private messages delivered to status window when nickname
   is the same as the network [977550].
 - Maximised window-state is now saved.
 - Double middle-clicking a nickname in the text area will now select
   it in the userlist.
 - Included a work-around to stop X-Sys plugin crashing with GTK 2.4.
 - Fixed: /list output going to the current tab [970746].
 - Fixed: Serverlist crash while editing a port-number, and switching
   to another network before pressing enter [968652].
 - Made it possible to execute multiple "Connect Command:"s in the
   ServerList window, when they're separated by ctrl-shift-a.

***

## 2.0.9

 - Updated translations (bg, cs, de, en\_GB, eu, fi, lt, nl, ru, sk,
                         uk, wa).
 - Fixed the Socks5 overflow security bug.
 - DCC IP address setting can now be a hostname too (Flavio
   Chierichetti) [773229].
 - Don't try random DCC ports when a range is set (mib) [889987].
 - Fix: Spurious nick completion (mib) [916944].
 - Serverlist passwd box is now masked (Cristian Peraferrer) [920113].
 - Fix: Sometimes messes up the tab order on reconnect (Gabor Szeder)
   [941773].
 - Fix: Crashes when setting $CHARSET to nonexistant charset [945855].
 - Plugin API: Added some fields to the "channels" list.
 - Plugin API: Added "win\_status" and "xchatdirfs" fields to
   xchat\_get\_info.
 - Plugin API: Added xchat\_send\_modes() function.
 - Fix: Unload, then reload a plugin on FreeBSD fails (Kevin Leung).
 - Plugins should now work on HPUX too.
 - Perl-plugin: Fixes for 3 arg version of emit\_print, unhooking the
   same hook multiple times and get\_list returning correct values for
   address32 field and some memory leaks (Lian Situ).
 - Made menu keybindings work when the menubar is hidden on GTK 2.4.
 - Added support for the new GTK 2.4 file chooser dialog.
 - Fix for BiDi in xtext (Ilya Konstantinov).
 - Smaller bug fixes [962211] [958599] [950353] and
   [945617] (Frederic Krueger).

***

## 2.0.8

 - Updated translations (az, es, fi, lt, mk, nl, ru, sk, sl, sr, sv,
   zh\_CN).
 - Added color, flash and iconify args to /GUI command (this is for
   use in scripts and plugins only).
 - Plugin API: Added "notify" list.
 - Plugin API: Added id, users, flags fields for "channels" list.
 - Win32: Better error messages for file i/o and winsock errors.
 - New Perl interface (with backward compatibility)! (Lian Situ).
 - Fixed command-character buglet [873541].
 - Win32: Improved incorrect CPS display for file transfers.
 - Added "Copy Selected URL" option to URL popupmenu (Mike Battersby).
 - Added work-around for "Get my IP from server" not working on PTNet
   (Mario Freitas).
 - Fixed: Alt+numbers do not work with X Input Method [896968] (Marius
   Gedminas).
 - Added support for "+port" to indicate SSL connections.
 - Fixed non-ASCII chars in time-stamp bug [918445].
 - Smaller bug fixes: [870073] [890891].

***

## 2.0.7

 - Updated translations (fi, nl).
 - Fixed dcc psend crash [858539].
 - Fixed bug where an error message was erroneously displayed while
   transfering files with fast-send turned off. Also, allow fastsend
   to be used with psend (Daniel Dubois).
 - Print more informative messages when Perl scripts fail to load
   (Andy).
 - Win32: Added native sound playing support.
 - Win32: Fixed possible crash upon exit while still connected.
 - Fixed notify's Lastseen column for offline users [864185].
 - Report more informative error when DCC write to disk fails.
 - Fixed crash when xchat.conf contains oversized strings [750403].

***

## 2.0.6

 - Updated translations (de, lt, sl, sr).
 - Fixed detection of Python on amd64 (Mads Martin Joergensen).
 - Don't loose editbox contents when pressing up, then down arrow
   (Ricky Clarkson).
 - Fixed missing dcc flag on new ignores via gui.
 - Fixed missing separator bar on PseudoColor displays.
 - Fixed some 64-bit issues (xc205-fix64bit.diff).
 - Apply tint changes instantly.
 - Fixed DCC resume with mirc >= 6.1.
 - Python plugin changes:
   * Fixed the reentrancy problem which made xchat freeze when some
     python code made xchat trigger a python callback somewhere.
   * Implemented xchat\_emit\_print() and xchat\_get\_prefs() support.
   * Fixed softspace support for python 2.3. This problem was making
     print statements yield an extra space at the next line start.
   * Other minor changes.
     (Gustavo Niemeyer, Gustavo J. A. M. Carneiro, Marko Kreen).
 - Fixed request of a MODE on a channel you're not in changing the
   current titlebar [820998].
 - Restored compatibility with older Perl that lacks call\_pv().
 - Use sigaction inplace of signal() for better compatibility.
 - Win32: Don't try to open logfiles with a "\" in them, windows wont
   allow it. Instead, the "\" is replaced by a "\_".
 - Backported HTTP authentication code from 1.8.11 (you can now
   specify a username and password for HTTP proxies).
 - When beep on highlight is on, beep on channel actions too
   (Christopher A. Aillon)
 - Added active dcc send feature (/dcc PSEND). More info here:
   http://mail.nl.linux.org/xchat-discuss/2003-10/msg00124.html
   (Daniel Dubois and Emmanuel Jeandel).
 - URL Handlers menu now removes programs that arn't in PATH.
 - Added "away" users field for plugin API.
 - Smaller bug fixes: 822199, 786267, 783172, 811971, 756048, 844919.

***

## 2.0.5

 - Updated translations (ca, fi, lt, nl, sk, sv, zh\_CN).
 - Fixed detection of Python 2.3 in configure script (anonymous).
 - DCC Send file-selection dialog now supports multi-select.
 - Reset away status after auto-reconnect from a ping timeout.
 - Perl: Fixed IRC::user\_info always matching the first entry.
 - More C89 fixes for non-gcc compilers (Albert Chin). [781809].
 - xtext: now double buffered and flicker free. Also some efficiency
   tweaks for exposure events and multi-wrapped lines.
 - Removed buggy numeric 338 support [783945].
 - Nick completion in dialogs and channel completion (Jay Cornwall).
 - Print informative error messages when dcc resume isn't possible.
 - Fixed performance of dcc recv, send and chat windows.
 - Fixed tab-arrow buttons show/hide (Lloyd Williams) [783681].
 - Fixed lastlog bugs [791220].
 - win32: Faster tinting, and uses MMX when in 16 or 32bit color.
 - Execute /sigusr2 on receiving SIGUSR2 signal (Michael Guidero).
 - /IGNORE command and window now have an extra "DCC" category.
 - Alert user when logfiles fail to open (Jay Cornwall).
 - Fixed missing underlining of IP numbers (2.0.4 only).
 - Allow accepting DCC sends from ports below 1024.
 - Connect to URL given on commandline even if 'No Serverlist on
   Startup' is off [804648].
 - Fixed problem in allocating colors while in 8bit PseudoColor.
 - xtext: tinting now shades towards your background color, making it
   usable with white backgrounds. Tints can also use XShm for extra
   speed with --enable-shm at ./configure time (experimental).
 - Perl: IRC::add\_print\_handler callbacks now get parameters in
   $\_[1...x], with $\_[0] left for compatibility (Lian wan Situ).
 - Perl: added command\_with\_channel command (Alexander Werth)
   [801711].
 - Smaller bug fixes: [798655].

***

## 2.0.4

 - Updated translations (lt, sv, zh\_CN).
 - Fixed crash on tinted transparency (xc203-fixtint.diff).
 - Fixed incorrect dcc cps calculation (xc203-fix-cps.diff).
 - Allow fullpath and relative filenames for Text Events sound files
   (Anthony Dragunov).
 - Added /GUI command (mainly for use by scripts).
 - Solaris build fixes for ipv6.
 - Added -n, --no-plugins command-line arg.
 - Added a feature to change the color of away users.
 - Moved default dcc and sound dirs inside ~/.xchat2/ (SilvereX).
 - Fixed bug [753742] When server tab and query had the same name,
   private messages could go to the wrong tab.
 - Support others users too, when expanding ~ in filenames (Neox).
   [767514].
 - Underline "ipnumber:port" style urls too (Alex & dobler).
 - Added support for ircu numerics 330 and 338 (phaseburn).
 - C89 fixes, should now compile with HP UX and Sun C Compilers
   (Albert Chin). [777106].
 - Smaller bug fixes: [773245] [779166].
 - Close tabs on shift-leftclick (Jay Cornwall).

***

## 2.0.3

 - Updated translations (ca, fr, ja, sv).
 - Fixed URL grabber not filling up (xc202-fixurlg.diff).
 - Fixed crash when holding down Ctrl-I (xc202-fixdetach.diff).
 - Use Shift-Ctrl-W for Close only when Emacs key theme is enabled.
 - Fixed corrupt left margin with indent-nicks off and timestamp on.
 - Remove invalid chars from inbound text when conversion fails. Fall
   back to ISO-8859-1 when using UTF-8 only (Ilya Konstantinov).
 - Fixed perl IRC::get\_info(3) crash when not connected [732496].
 - Fixed crash on long output lines for /exec -o [731187].
 - Made "Move completed files to:" and "Save nickname in filenames"
   work at the same time (Matthew Gabeler-Lee).
 - xtext: fix redraw when new additions not on current page.
 - win32: Added /set identd 0 switch to turn off built-in identd. 
 - Added 6-8 for perl's IRC::get\_info to retreive network, host and
   topic (Ryan).
 - Iterate in alpha order instead of op-alpha for nickcompletion
   (Gauss\_Z88).
 - Fixed ChannelList crash on invalid regex match string.
 - Added hide join/parts setting to gui (Jason Wies).
 - Added Delete All button to ignore window (Mohammed Sameer).
 - Don't allow adding empty names to notify list [741589].
 - Made message fragmentation code utf8 friendly so it always splits
   on a multibyte char boundary [748653].
 - Support 2 to 4 GB files in DCC (contrary to 1.9.4 changelog, it
   didn't work until now).
 - Python: Fixed crash when returning 0 from a timer (Steve Green).
 - Multihead fixes for popup menus.
 - Added support for numeric 307 and 320 "is an identified user".
 - Allow setting a blank topic via the GUI [720407].

***

## 2.0.2

 - Updated translations (lt, ms, nl, pt, sv, zh\_CN).
 - Fixed a few minor mem leaks in the server and user list.
 - Changes to: UrlGrabber, Notify, Plugins, Ignore and Banlist GUIs.
   Changed GtkCList to GtkTreeview, and general enhancement to these
   guis (Vincent Ho).
 - win32: made it possible to compile with ipv6.
 - Added /MOP.
 - Fixed pageup/pagedown wrong window bug [710784].
 - Fixed no timestamps in top-level windows bug [710787].
 - Fixed first word being skipped in perl add\_command_handler("", cb);
   [711802].
 - Fixed WHOIS away line appearing in different tab [695932].
 - win32: fixed transparency [699425].
 - win32: fixed ssl "Error 2" connection bug.
 - Made all toplevel dialog windows transients of the main window.
 - Show filesize/pos in DCC window as KB and MB (Aaron Chernosky).
 - Added /set tab\_dnd 0/1 option.
 - Fixed userlist insertion/deletion GUI performance problem [704233].
 - Each toplevel window now has a "role".
 - Smaller bugs fixed: [698449] [718851].
 - TCL plugin fixes for context lookups (Daniel P. Stasinski).
 - Changed Close Tab keybinding to Shift-Ctrl-W to avoid conflict with
   emacs editing.
 - Used a new algorithm for Userlist and UrlGrabber. This one does
   insertion, lookup and deletion in O(log n).

***

## 2.0.1

 - Updated translations (am, ca, lt).
 - Save serverlist before connecting (Joe Drew).
 - OpenBSD compile fixes.
 - (Encoding) Fallback outgoing text to "?" for unconvertable chars.
   [674798].
 - Hide tab scrolling buttons when they're not needed.
 - Fixed --disable-xlib compiles.
 - Fixed use of %h in dialog-tab buttons [688937].
 - Fixed printing/logging timestamps that contain invalid utf8
   [688548].
 - Added "Resizable userlist" option (default ON).
 - Strip colors on topic change.
 - Fixed (snotice) and (notice) tabs being swapped [687437].
 - Made more strings translatable.
 - Allow loading empty text events [691191].
 - Fixed xtext race condition [678874].
 - Added ability to show/hide the channel-mode buttons (default OFF).
 - Use the network name in server-tab rather than full hostname.
 - Added keybindings for moving tab-families, default is ctrl-shift
   PageUp and PageDown (Vincent Ho).
 - Added 'Beep on highlighted messages' option (Jirka Kosina).
 - Use DND to detach tabs.
 - Interpret %C, %B etc in quit reasons.
 - Added more items to the right-click tab menu.
 - Some misc UI cleanups.

***

## 2.0.0

 - Updated translations (de, es, lt, nl, sk, sl).
 - Fixed half cut off dates in notify window.
 - Fixed tabs loosing red/blue color when being renamed.
 - Fixed initial query tabs not being truncated.
 - Make tabs red on channel actions too.
 - Configure script python detection fixes (Johan Dahlin).
 - Added /charset command.
 - Don't auto remove stalled DCCs unless dcc\_remove setting is on.
 - Avoid recursive UserCommand buffer overflow.
 - Added xchat\_emit\_print() to plugin interface.
 - Left and Right positioned tabs are possible again (Lloyd Williams).
 - Added /timer -repeat <num> and -quiet args.
 - Possible tcl plugin crash fixes (Daniel P. Stasinski).
 - Group multiple op/voice in one print event.
 - Fixed plugin loading on solaris.
 - Python fixes (Gustavo Niemeyer):
   * Fixed bug which made Python plugins crash randomly.
   * Introduced a new xchat.hook\_unload() function, as requested by
     many people. This will call a given callback at module unload
     time.
   * Now /py load <filename> will succeed if filename is the name of a
     file inside "xchatdir" (~/.xchat2).
   * Fixed some leakings.

***

## 2.0.0pre1

 - Updated translations (sv, es, am, el, lv, no).
 - Fixed possible blank userlist after another tab was detached.
 - Changed default keybinding for next/prev-tab to ctrl-pageup/down,
   as per standard.
 - Added IPAddress field to "DCC SEND Offer" text event.
 - Fixed perl IRC::print\_with\_channel 1.8.x incompatibility.
 - xtext: Fixed bugs in new scrolling code.
 - Use filesystem encoding for log filenames.
 - Focus the inputbox when left-clicking in xtext.
 - Focus the inputbox when typing while the userlist is in focus.
 - Fixed bug where text typed could be sent to the wrong window after
   a detach.
 - New default icon again, this one scales better (Dagmar d'Surreal).
 - Send /LIST args on galaxynet.
 - Added settings to change inputbox and userlist styles to the same
   as the main text area.
 - Don't allow the Perl plugin to be loaded twice (Ian Kumlien).
 - Fixed servlist crash on 'use global' off and empty nick field.
 - Added missing address field to Perl's IRC::dcc\_list.
 - Added irc\_conf_mode setting (via /set only).
 - Save xchat.conf safely (Michael Witrant).
 - Added support for numeric 005 token NAMESX.
 - Added TCL Plugin (Daniel P. Stasinski).
 - Added 'Add' button to serverlist, due to popular demand.
 - Update intl/ to 0.11.4.
 - Win32 fixes/makefile for python plugin (James Potts).
 - Win32: fixed clipboard bugs and dcc receive.
 - Plugin iface: Added dcc-list fields "address32" and "port".
 - Try to use pkg-config to find openssl.
 - Report errno/strerror on dcc failures.
 - Python print buffering fixes (Gustavo Niemeyer).
 - Treat NOTICE +#channel correctly.
 - Check for common unix paths and don't treat them as commands.

***

## 1.9.8

 - Added Amharic translation (Daniel Yacob).
 - Updated Spanish translation (Pablo del Campo).
 - Updated Lithuanian translation (Rimas Kudelis).
 - Updated Latvian translation (Artis Trops).
 - Fixed serverlist entry box text corruption (xc197-fixservlist.diff)
 - Fixed the non-mmx tinted-tranparency code crashing.
 - Fixed interpretation of mIRC color 99 [653094].
 - Use Pango renderer by default, for better i18n.
 - Scroll 1/10 of a page with the mouse wheel (Soeren Sandmann).
 - Reimplemented -a, --no-auto argument.
 - Fixed a bug in entering text with GTK2 IMs [653751].
 - Final fix for filenames' encoding in DCC.
 - New unicode character chart window.
 - xtext: properly recalculate text widths after a font change.
 - Fixed perl IRC::dcc\_list 1.8.x incompatibility (Charles Lopes).
 - xtext: Implemented scrolling instead of full redraws when not using
   a background image or transparency. This improves scrolling on
   machines that draw AA text very slowly.
 - Reimplemented 'Move front tab left/right' keybinding.
 - Provide default usermenu and buttons for translation.
 - New default icon (Dagmar d'Surreal).
 - Report the average KBs when a transfer is finished.
 - Attempt to create dcc-download dir when changed in the setup gui.
 - Apply character set conversions to DCC Chat aswell (Steve Green).
 - xtext: Fixed hilight-text in scrollback after new addition bug.
 - Channellist gui cleanup.
 - Renamed a few defines in xchat-plugin.h to avoid namespace
   pollution.
 - Fixed loading background image crash (from 1.9.7).
 - Fixed broken drawing of mIRC color 0.

***

## 1.9.7

 - Updated Swedish translation (Christian Rose).
 - Updated Spanish translation (Pablo del Campo).
 - Updated Dutch translation (Bart Coppens).
 - Added /GETSTR and /GETINT.
 - Misc. serverlist bug fixes (Shaun Guth).
 - Plugin changes/fixes:
   * Added xchat\_get\_info("network").
   * Added new function: xchat\_hook_fd().
   * Fixed "DCC Chat Text" event (Daniel P. Stasinski).
   * Added "Open Context" print event.
   * Fixed implementation of EAT\_ return codes.
   * Keep the leading ":" in server events passed to plugins.
   * Added hack to make plugins possible on win32.
   * Fixed /unload <plugin\_file\_name> crash.
 - Fixed changing tabs via keyboard.
 - Added a few keyboard accelerators to the menubar.
 - Fixed close-tab-0 crash.
 - Fixed userlist popup menu disappearing on button-release.
 - Fixed color paste.
 - Added a character set selector to the serverlist.
 - Send DCC filenames in system encoding (gets converted if a charset
   is chosen in the serverlist).
 - Fixed possible Search Text crash.
 - Removed --enable-japanese-conv configure option (isn't this
   superseded by the new charset selector?).
 - Use --enable-openssl by default.
 - Fixed your nick not changing in dialog windows.
 - xtext: deal better with invalid utf8.
 - Made it possible to do /server <networkname>.
 - win32: backported tint/transparency code from 1.8.10.

***

## 1.9.6

 - Updated Spanish translation (Pablo del Campo).
 - Added Estonian translation (Ilmar Kerm).
 - Made switching to dialog tabs faster:
   * Draw xtext only once when switching to a dialog tab.
   * Do not recalculate the tinted-transparency.
 - Fixed another text-off-the-bottom bug.
 - Fixed background color other than black not working.
 - Fixed dialog windows not being logged (Joanne Hunter).
 - Fixed topic entry box going blank bug.
 - Added Insert-color-code and encoding submenu in the bottom-right
   button.
 - Apply more settings without needing a restart:
   * Background image.
   * Time stamp text on/off.
   * Palette changes.
 - Implemented %n for log-filename-mask.
 - Reconfigured the menubar a bit.
 - Validate inbound utf8 text to avoid reading beyond buffer and
   fall back to iso-8859-1.
 - win32 compile fixes.
 - Don't convert commas to %2c in urls.
 - Auto open dialog when dcc chat offer connects (Steve Green).
 - Make setting "Open Utilities in: Windows" work.
 - Added a way to reorder networks in the serverlist window (still
   want to add DND later).

***

## 1.9.5

 - Fixed the PL\_perl\_destruct\_level crash (Bernard Blackham).
 - Fixed the perl readdir crash.
 - Added tab scrolling buttons (Lloyd Williams).
 - Added DCC throttle and better CPS calculation (Richard Fuchs).
 - Added three configurable tab-highlight colors (Nehal Mistry and
   Joanne Hunter).
 - Added dynamic support for two levels above Op (red & purple icons).
 - Changed the op/voice icons, now more macosx like.
 - Serverlist progress:
   * Now remembers your last network selection.
   * Non-global User/real/nick are now implemented.
   * Added all 1.8.x default servers.
 - Added Clear Rawlog button.
 - Throttle and Lag meter settings implemented.
 - Fixed /lastlog.
 - xtext: Fixed exposure-before-print crash.
 - xtext: Fixed providing UTF8 selection data.
 - xtext: Fixed text scrolling past the bottom bug.
 - Added DCC-completed-dir setting, which can move completed DCC files
   to a different directory (Chris Morgan).
 - Update build environment to autoconf 2.53.
 - Cleanup various configure.in/Makefile.am scripts. Use libtool to
   build perl and python plugins (John).
 - Added support for numeric 005 options: CHARSET=UTF-8 and
   CASEMAPPING=ascii.
 - Delinking/Relinking IRC windows re-implemented.
 - Dialog window buttons re-implemented.
 - Gnome2-ify the desktop file. Install to $(datadir)/applications.

***

## 1.9.4

 - Make DCC support up to 4GB files (previously 2GB).
 - Fixed possible crash when receiving a message from a channel that
   was already parted.
 - Fixed random /part reasons not working.
 - Fixed compile on RHL 8.0.
 - Fixed xchat-text connect crash.
 - Updated included intl/ to 0.10.38.
 - Update transparency when background image changes.
 - Fixed the progress-connecting-bar appearing in all tabs.
 - More IRC protocol abstractions; tcpsend2 (James D. Taylor).
 - New server list GUI almost complete.
 - Merged some small 1.8.11 fixes.
 - Reopen logfiles on SIGUSR1.
 - Added Tint RGB settings (foser).

***

## 1.9.3

 - Updated Spanish translation (Pablo Gonzalo del Campo).
 - Updated Swedish translation (Christian Rose).
 - Added mIRC's passive dcc support, receiving only (Richard Fuchs).
 - Added InputBox settings to settings GUI.
 - Make DCC support up to 4GB files (previously 2GB). untested.
 - Fix checks for Xft.h in configure script.
 - Fix perl add\_message\_handler() xchat 1.8.x incompatability.
 - Fix default DCCRECV text event using bad $ variable and crashing.
 - Fix /query #foo, /join #foo crash.
 - Fix utf8-conversion-fail sending truncated text.
 - Use $datadir/locale for LOCALEDIR (Albert Chin-A-Young).
 - More work done on Serverlist 2, but not fully functional yet.
 - Pasting from one tab to another now works.

***

## 1.9.2

 - Fixed DCC Chat offer crash (1.9.1 bug only).
 - xtext: Xft tweaks. Included Pango backend for when Xft can't be
   used directly.
 - xtext: improved rendering selections (less unnecessary redrawing).
 - xtext: fixed marking multibyte utf8 chars.
 - Included brand new Python interface plugin (Gustavo Niemeyer).
 - Perl is now a plugin.
 - Plugin API: Changed xchat\_unhook() return value and type.
 - Plugin API: Added "ignore" list.
 - Plugin gui window can now load/unload scripts aswell.
 - Plugins are now autoloaded from $libdir/xchat/plugins. 
 - Double-click userlist works again.
 - Strip spaces from join-channel in serverlist (Mathias Hasselmann).
 - The menu in the bottom right corner now works.

***

## 1.9.1

 - Fixed serverlist and rawlog crashes.
 - Fixed some 64-bit issues (Elliot Lee).
 - Fixed unrealized xtext crashes and warnings (Elliot Lee).
 - Removed --disable-glib configure option.
 - Added Save rawlog button.
 - Auto detect socklen\_t.
 - All new plugin interface. See plugins/plugin20.html.
 - Made perl.c use the new plugin interface.
 - Made the whole system use the cmdchar setting. This means all
   usercommands, popup commands etc mustn't start with a "/" char.
 - Removed the mail checker, it's now a plugin.
 - Cleaned up some text events code. Added/Changed/Removed some
   events too. TextEvents window now lists them alphabetically.
 - Convert inputbox from utf8 to locale before sending (xLoneStar).
 - Use ~/.xchat2/ for all configs (may change to ~/.xchat-2.0
   when stable).
 - Made DCC GUI display KB/s instead of cps.
 - Ignore code cleanups; ignore.conf no longer compatible.
 - Created the start of an IRC protocol abstraction layer.
 - Plugged JCode memory leak.
 - Ask before quiting when some DCCs still active.
 - Rewrote most of the maingui code. Now there's only one virtual
   tab that is re-filled with new information when switching tabs.
 - Added right-click tab menu.
 - Plugged potential /dns security hole.
 - Converted userlist to GtkTreeView.
 - Right-click userlist menu now works with a multi-selection.
 - Drag and drop to userlist no longer requires libgnome.
 - Included an ircII style /timer plugin.
 - Now accepts irc:// URLs on the command line.
 - Tabs are now ordered in server groups.
 - Make gettext use utf8 (teuf).
 - Whole new setup window.
 - Notify gui has an add dialog window.
 - Nickname on the bottom left is clickable.
 - Cleaned up /set variable names.
 - Made scrollwheel work with GTK+ 2.0 (Lloyd Williams).
 - xtext: Added XFT support.
 - xtext: Added UTF8 selection support.

***

## 1.9.0

 - Ported to GTK+ 2.0 (BIG!).

***

## 1.8.7

 - Updated Swedish translation (Christian Rose).
 - Updated Russian translation (Anton Farygin).
 - Added Latvian translation (Artis Trops).
 - Made a work-around for a refresh glitch when delinking a tab under
   gnome (the topic bar was overlapped).
 - Fixed the need for signed chars (e.g. on PPC and s390).
 - Fixed background garbage being drawn when using hidden tabs.
 - Cleaned up alot of the nick completion code. Fixed some behaviour
   too (Mukund, dinkles, me).
 - Connect Cmd is executed again if you get auto-reconnected.
 - Added safe-gaurd to stop duplicate nicks in userlist.
 - Added an option to automatically remove finished/failed dccs
   from the list. Use /set dcc\_remove ON to enable it.
 - Added an option to truncate long channel tabs. Use:
   /set truncchans xx, where xx is the max chars (Jyrki Muukkonen).
 - Made the default popup menu, dialog buttons, userlist buttons,
   usermenu and urlhandlers translatable (via gettext).
 - MMX tinting is now built on any x86 machine (it's checked at
   runtime anyway).
 - Added "Automatic Unmark Away" option in setup->away (Mads Martin).
 - Immediately abort file transfers when out of space.
 - Fixed a serious CTCP reply vulnerability.

***

## 1.8.6

 - Updated Danish translation (Morten Brix Pedersen).
 - Updated Spanish translation (Antonio de la Torre).
 - Updated French translation (Olivier Berger).
 - The server "Connect cmd" is now executed before auto-join-channels,
   so you can use it to authenticate to nickserv etc.
 - Fixed autoresume again, for the last time... no, really.
 - Fixed sending parts for all channels instead of one quit when you
   exit the whole program (helps bncs).
 - Autocomplete in the middle of a sentence won't jump to the end of
   the textbox (Darell Tan).
 - Fixed the buggy 1.8.5 outbound queue. It now sends privmsg/notice
   with a lower priority, but never out-of-order.

***

## 1.8.5

 - Updated Slovak translation (Stano Visnovsky).
 - Updated Swedish translation (Christian Rose).
 - Updated Spanish translation (Antonio de la Torre).
 - Updated Hebrew translation (Dan Fruehauf).
 - Some fixes to the MODE parser.
 - Added ability to customize dialog tab buttons (Oskar Liljeblad).
 - Added an extra field in the EditServer window to enter a command
   to execute after logging in.
 - /load -e <file> can now load a file of commands to execute.
 - Added ability to change the log timestamp format (Jyrki Muukkonen).
 - Fixed default keybinding for Shift-PageUp (Mukund).
 - Changed the outbound throttle behaviour. Now only privmsgs and
   notices go to the back of the queue, everything else goes to the
   front.
 - Made it possible to compile with older than 5.6 perl again.
 - The main window's size and position is now saved on exit. Use
   /set mainwindow\_save OFF to revert to the old behaviour.
 - Avoid auto-resuming the same file from two different people
   (without breaking autoresume this time).
 - Removed /sslserver and added a -ssl arg to /server, /reconnect,
   /servchan and /newserver.
 - Added support for /server irc://host:port/channel.
 - Added some mmx asm code written by Willem Monsuwe for tinting
   transparency. Use --disable-mmx to revert to gdk-pixbuf method.
 - Fixed resetting your away status after an auto-reconnect.

***

## 1.8.4

 - Updated Spanish translation (Antonio de la Torre and Manuel 
   García Aguilar).
 - Updated Russian translation (Valek Filippov).
 - Fixed lockup when a file being offered is shortened before being
   accepted.
 - Fixed ** ERROR **: file python.c: line 743 (pysH\_Eget\_users):
   assertion failed: (cur->hostname).
 - /kickban now deops and bans in one line (-o+b) (Felix Nawothnig).
 - Auto-nickcompletion now uses the nicksuffix setting (Mukund).
 - win32: change log-filenames with a | character to \_.
 - When binding to a set hostname/ip, it would try to bind to port
   65535 - fixed.
 - Fixed crash when closing a dcc chat in a perl-dcc-chat-callback. 
 - Added option "Beep on Channel Messages" and a Beep button to the 
   toolbox ("<" button in the botton right) (Jason Wies).
 - Avoid auto-resuming the same file from two different people.
 - /close -m now closes all dialog/query windows.

***

## 1.8.3

 - xtext: marked text goes to clipboard aswell as primary selection.
 - xtext: some speedup optimizations.
 - xtext: fixed a problem when rendering a fixed-width font with
   missing chars.
 - Fixed hints for "You're kicked" text event, which showed the $ vars
   incorrectly.
 - When a user is seen to quit or join a channel you're in, your
   notify list will be modified instantly. No notify textevent is
   shown if it happened in the front-most tab (Alexander Hvostov).
 - Fixed binding server connects to different interface/address
   (ipv4 only) (Claus Riemann).
 - Avoid negative ping timeout when system clock changes.
 - Updated Italian translation (Stefano Fava).
 - Updated Spanish translation (Antonio de la Torre).
 - Added text event "Channel Notice" so you can differentiate between
   private and channel notices (Fuentes Xavier).
 - Added ability to dcc send filenames with spaces. See "Fill Spaces"
   setting in Setup->File Transfer (Fuentes Xavier).
 - Included some makefiles for ms visual c.

***

## 1.8.2

 - Fixed kick messages showing only the first word of the reason.
 - Fixed GTK warnings thrown up when closing a dialog window.
 - Fixed a bug in sending quit reasons.
 - Fixed a problem with handling op/voice modes that caused halfops to
   appear in the userlist when using bahamut.
 - Kanji conversion is now turned ON when locale is ja (Akira TAGOH).
 - Saved some memory when loading .conf files (about 40k).
 - When changing fonts, it now changes in the inputbox without having
   to restart.
 - Added safeguard to stop recursive user commands.
 - Added two /set variables dialog\_width and dialog\_height. Use these
   to set the default size of dialog windows.
 - Win32: fixed crash of 'Auto Accept DCC Send' menu item.

***

## 1.8.1

 - Fixed crash in having server tabs ON and channel tabs OFF.
 - Fixed crash when closing the channel list window AFTER all its
   server windows were closed.
 - Fixed potential crash of the font dialog in settings.
 - Made /exec read data line-by-line (Richard Fuchs).
 - Disabled the menubar while in shelltabs (it was dangerous to use it
   anyway).
 - Fixed the banlist window's Unban, which selected the wrong rows
   sometimes.
 - The Perl interpreter is now started only when loading the first
   script, to save memory when not using scripts.
 - Fixed lag/throttle meters not updating when set to text-only.
 - Fixed two small memory leaks.
 - Directories in your logmask are now created, so you can use masks
   like "%c/%y.log" in Setup->Logging (Tobias v. Koch).
 - xtext: FontSet rendering speedups.
 - Win32: made word and line selection work in xtext.
 - Win32: added url handler that sends to windows' shell. 
 - Win32: rendering 8bit characters should now work.

***

## 1.8.0

 - Fixed a memory leak in popup menus.
 - Fixed crash in receiving private actions.
 - Added /set variable 'perccolor'. Options effect input box are now:
   perccolor: parse %C,%B,%U etc (default ON).
   percascii: parse %XXX (where XXX is an ascii value) (default OFF).
   Note: if perccolor is OFF, percascii will not work.
 - Win32: Fixed incorrect calculation of ping time.
 - Win32: Server lookup and connect is now threaded.
 - Win32: Server connection error now reported correctly.
 - Win32: A simple identd server is now builtin.
 - Win32: Copying text from xtext to clipboard now works.
 - Updated Swedish translation (Christian Rose).
 - Updated Spanish translation (Antonio de la Torre).

***

## 1.7.8

 - xtext: Fixed parsing of "%C2, " to match mIRC, i.e. bg color is not
   reset, fg changes to 2 and the comma is printed (Fuentes Xavier).
 - xtext: a fix for multibyte text wrapping (Tetsuo YAMAMOTO).
 - Made notify NOT announce everyone offline when you first login.
 - Multiple WATCHes are sent on one line for notifies, to reduce lag.
 - Added an internal /unban command which takes multiple masks. You
   might want to remove the old usercommand (Tobias v. Koch). 
 - Banlist window now sends multiple modes per line.
 - Fixed a memory leak in perl (Martin Persson).
 - Removed the tooltip for userlistinfo, it seemed to cause corruption
   on some gtk+ themes.
 - Made xchat not interpret %C,%B etc when percascii is OFF, .e.g:
   /set percascii OFF
 - Fixed ops/voice counts when networks allow you to voice/op people
   that are already voiced/oped (like EFnet).
 - Fixed building with --disable-glib.
 - IPv6 reverted to off by default, use --enable-ipv6 to enable.
 - Win32 fixes: dcc send/recv now works and fixed a bug in loading
   some .conf files by using the O\_BINARY flag.
 - Changed the xchat icon - old one was a bit too dark.
 - Updated Greek translation (Fanis Dokianakis).

***

## 1.7.7

 - Re-added support for '+' channels when there's no 005 numeric.
 - Made the new $3 null terminated (works better that way).
 - Fixed Doubleclick-user when disabling userlist icons.
 - Fixed SSL build.
 - Win32 port (some code from Alex Badea's 1.5.11win32 port used).
 - More code cleanups, removed all extern prototypes from fe-gtk/.
 - Titlebar text now shows unknown channel modes too.
 - Made persist chans work with /reconnect aswell.
 - Avoid pastes of common unix directories being treated as irc
   commands (Chema Celorio). 
 - Removed the Delete word forward/backward functions from
   KeyBindings. GTK handles these already, why were they ever there?
 - Made %h work for dialog windows' popup menu too.
 - Fixed treeview not setting channels red and blue.
 - The info above the userlist now gets a tooltip which gives you
   some extra info.
 - The nickgad (to the left of your nickname) now gets a text prefix
   char if userlist icons are disabled.
 - Timestamp format is now configurable in Setup->IRC Input/Output.

***

## 1.7.6

 - xtext: tweaks to make url highlights less flickery.
 - Added some support for ircd numeric 005. MODES>=6, CHANTYPES,
   CHANMODES, WATCH and PREFIX are supported. This means dynamic
   support of different channel and user modes. The userlist icons
   only support *@%+ though (admin, op, half op, voice), will have to
   find a way to make these dynamic in the future. Also, made a new
   file modes.c and rewrote mode handling in general to support this,
   so what did I break?
 - Added option 'Userlist icons' (default ON). Lets you turn off
   userlist icons for ops, voice etc and get the plain text @+ (in
   Setup->Interface). Might be useful for ircd's that have weird
   and wacky access levels.
 - Added support for WATCH command for use in notify list. Numeric 005
   must list WATCH for this to work.
 - Added an extra arg $3 for channel message printevents. This is the
   prefix char of the person talking, e.g. '@' for Ops.
 - Resolve irc-server name only if using a non-socks4 proxy. This
   allows you to connect even with a non-working dns. Also made the
   socks5 code more "correct" (Richard Fuchs).
 - Some code cleanups, got rid of most of the extern functions in c
   files and moved them to h files.
 - Perl has a valid context at startup again (broken in 1.7.4).
 - Fixed leak of awaymessages for "Show away once" feature.

***

## 1.7.5

 - Fixed some buggy catalogs for gettext 0.10.37 (OpenBSD users).
   Compiling with 0.10.35 will now break, there's always
   ./configure disable-nls.
 - Fixed python autoloading due to new serverlistcode (Richard Fuchs).
 - Made perl/python/plugins autoload when first irc window is open
   (rather than when serverlist opens), incase they need to print.
 - Changed serverlist opening behaviour. It now obays the
   'No ServerList on startup' setting regardless of auto-connects.
 - Fixed buggy Quit menu item (1.7.4 bug).
 - DCC cleanups, including some endian fixes.
 - DCC windows don't go to front when new xfers appear (1.7.3 bug).
 - Rewrites to a few vital xtext functions. This seems to have speed
   up rendering with a FontSet and fix the -/+1 line bug.
 - Fixed Shelltab not opening sometimes (actually a 1.7.4 ipv6 bug).
 - Added ability to change font for Shelltabs only:
   /set font\_shell <fontname>

***

## 1.7.4

 - On startup, serverlist now opens without any other windows, looks
   neater, less confusing for newbies. If you disable serverlist at
   startup, a normal irc will open instead.
 - Made a few things more userfriendly, "DCC Send" -> "File Send". No
   need to refer to the protocol in the GUI!
 - Fixed a xtext bug rendering a background color of 1 incorrectly.
 - Unprintable characters used to cause problems to xtext (who would
   have thought gdk\_char\_width returns a different value to
   gdk\_text\_width?) - fixed.
 - xtext renders only once when switching tabs (used to render twice
   because gtk gives us 2 expose signals, why?).
 - When you change your nick it changes in the titlebar now too.
   Server name is now reported in dialog windows' titlebar.
 - Having Strip mIRC Color ON will now strip it from dcc chats too.
 - Added (really this time) perl functions add\_user\_list,
   sub\_user\_list, clear\_user\_list for manipulating the userlist of a
   channel (Lloyd Williams).
 - Various code cleanups, including a rewrite of the IPv6 code.
   Removed /6server and 'Use IPv6' check-box in the serverlist. It
   automatically handles IPv6/IPv4 addresses now.
 - Added a check-box in the serverlist edit window for "Use Proxy".

***

## 1.7.3

 - Added server hostname as $3 for quit print event (Bjorn Olievier).
 - Some fixes to the gnomepanel code. Panel no longer asks to restart
   applet on quit, removing the applet doesn't exit xchat (George).
 - Fixed fd leaks in /exec and python (Richard Fuchs).
 - user@host gets logged in query windows (Richard Fuchs).
 - Fixed the 'Marked Away' & 'Save Settings on exit' check menu items
   (when using --disable-gnome).
 - Workaround for ipv6 build failing on some glibcs (Tobias von Koch).
 - DCC won't try to resume if local file is bigger than remote offer.
 - Fixed xtext drawing/wordwrap and textmarking bugs.
 - Horizontal scrollbar appears in channellist window when needed.
 - Fixed color paste. Does this affect multibyte pasting? Please
   report (Darell Tan).
 - Fixed titlebar text for notices/snotices tabs.
 - The topic box gets a tooltip of the current topic.

***

## 1.7.2

 - Fixed some Python mem leaks and signal/event handlers can now
   return non-null integer to tell xchat to stop processing the event
   (like perl handling functions) (Richard Fuchs).
 - Got rid of the Linger timeout. This was a lame solution to stop the
   loss of QUIT messages when closing the socket too early. Now xchat
   just delays closing sockets by 5 seconds (even on quiting the app).
   No more 1 second delay when you close a tab or the whole app!
 - Fixed some memory leaks in the banlist window.
 - Added 'B' channel-mode button to access the banlist.
 - Added Turkish translation (Ozgur Dogan GUNES).
 - Updated Spanish translation (Antonio de la Torre).
 - Fixed the throttle setting (which was reversed! who did that?).
 - Added IRC::notify\_list. (Matthew Gabeler-Lee).
 - Don't crash when bind fails for dcc send.
 - Don't send garbage to server when ban\_type is invalid.
 - Rewrote a whole heap of bad code in maingui.c. When opening a new
   tab/window it always uses the same functions instead of having the
   code repeated a few times. This is pretty big so expect some things
   to break. This also means dcc/chanlist etc tabs get the < > buttons
   too.
 - /KICKBAN now deops users first (Tobias von Koch).

***

## 1.7.1

 - Turning off server tabs should work again (1.7.0 bug).
 - Some ipv6 fixes.
 - Added a few TextEvents that used to be hardcoded.
 - Updated jcode (Takuo Kitame).
 - Fixed possible crash in palette window (1.7.0 bug).
 - Rewrote the EscapeCode->mIRC color conversion for /exec.
 - Added option to explicitly set your dcc IP (Jim Seymour).
 - Added Opera and w3m to default URL Handlers.
 - New serverlist/window icon - just for a change.
 - Updated Korean translation (Kim SeungBaeck).
 - Added hook\_timeout to the XChat.XChat() python class so you can
   XChat.XChat().hook\_timeout(delay, handler). It is a one time
   function like the perl version (Donald Kjer).
 - /RECONNECT can now takes args like /SERVER, the difference
   being that it'll rejoin all your channels (Angel).

***

## 1.7.0

 - Updated German translation (Benedikt Roth).
 - Updated Spanish translation (Antonio de la Torre).
 - Updated Japanese translation (Takuo Kitame).
 - Added Norwegian translation (Kjartan Maraas).
 - Fix for bug in 1.4.x serverlist.conf loading.
 - Away status and reason is re-send to the server if you get
   disconnected (Daniel Rall).
 - Added option to have one tab for notices, configurable under
   Inferface/Window layout (Alex Badea).
 - Added another meter component that measures the server send queue
   from the throttle system (pref: throttlemeter), added UI support
   for showing the lag and throttle as either progress bars, info
   boxes, both, or none (Alex Badea).
 - Added a command to flush the send queue (/FLUSHQ) and one for
   forcing a new lag check (/LAGCHECK) (Alex Badea).
 - Added option 'persist\_chans', when ON once a session is created
   for a channel, no other channel will be assigned to that session,
   regardless of any parts or kicks (Alex Badea).
 - Compile errors while loading a perl script are printed on the main
   window. Warnings issued by perl scripts are also printed on the
   main window. This allows script writers to use the perl command
   'warn' to point out strange things. Perl errors no longer make
   xchat crash. The error message is written on the main window and
   the command execution is stopped (Frodo Baggins).
 - Added IPv6 support for making server connections. See
   ./configure --enable-ipv6 and /6SERVER command (\\bonxo\\@IRCnet).
 - Added Banlist window (Salvatore Insalaco).
 - You can now specify which dir ssl is in, e.g.: ./configure
   --enable-openssl=/usr/local/ssl (Richard Fuchs).
 - Added InterScan proxy traversal support (is this the correct name
   for this proxy? Looks like a httpd proxy to me) (Alex Riesen).
 - Added Japanese code conversion support, see ./configure
   --enable-japanese-conv (Takuo Kitame).
 - xtext: smooth (pixel-based) scrolling.

***

## 1.6.4

 - Fix for using a DCC port range (Lawrence Gold).
 - Fix for building on UnixWare 7 (Ronald Joe Record).
 - Added Chinese translations - zh\_TW.Big5 and zh\_CN (Kevin Peng and
   Anthony Fok Tung-Ling).
 - Added Finnish translation (Jarkko Ranta).
 - Revamped the default URLHandlers to add Galeon and Mozilla.
 - Clicking Accept on a DCC chat that you offered would loop - fixed.
 - Fixed percentage display for DCC receive (Matthew Gabeler-Lee).
 - Fixed bug in indent and timestamps (Dmitriy Zavin).
 - Fixed crash bug in xchat-text and DCC send being aborted remotely.
 - Made /lastlog more efficient for very large scrollback buffers.
 - Beep on private actions too (Richard Fuchs).
 - /MSG'ing a channel or nick will show up in the destination tab
   instead (Richard Fuchs).

***

## 1.6.3

 - Updated Swedish translation (Christian Rose).
 - Updated Spanish translation (Antonio de la Torre).
 - Right-click toggle menu items used to crash under gnome (bug in
   gnome-libs?) - work around.
 - xtext: Efficiency improvements: text mark, word and line select.
 - xtext: fixes for multibyte characters (UNO Takeshi).
 - Fixed bug in resizing a tinted-transparent window (deb bug #79674).
 - Some OS2 compilation fixes (pla).
 - Fixed PONG parsing (Stefano Barbato).
 - Fixed a leak of file descriptors.
 - Fixed /ALLSERV.
 - Fixed /BAN to replace ~ with * in username (Stefan Scholl).
 - Fixed /ME through DCC CHAT while not connected to server (#81031).
 - Work-around for UnrealIRCd's duplicate /NAMES bug.
 - Fixed DCC receiving filenames with spaces.

***

## 1.6.2

 - xtext: Fixed the mark-clear bug (gnome bug #34584).
 - Updated German translation (Tamer Fahmy).
 - Commas are replaced with %2c in URLs, as to not confuse poor old
   Netscape (deb bug #70905).
 - Bluestring to 300 chars (deb bug #79138).
 - Added option /SET percascii, which can disable/enable translation
   of %XXX into an ascii value while typing (deb bug #76122).
 - New hotkey hook: key\_action\_put\_history. Only inserts line into
   history, but doesn't send it to the server (DaP).
 - Lots of SSL updates:
   * Make accept\_invalid\_cert optional on /sslserver (DaP).
   * Print verbose information of SSL session on connect (DaP).
   * Clean up code at X509\_V\_ERR\_DEPTH\_ZERO\_SELF\_SIGNED\_CERT checking
     (DaP).

***

## 1.6.1

 - xtext: Fixed lockup with certain sized fonts.
 - xtext: Made some changes to improve efficiency when using really
   large scrollback buffers (only noticable when doublebuffer off).
 - Fixed a bug in /help crashing on longer than 10 char UserCommands.
 - Fixed autoreconnect while using a proxy server.
 - Never-give-up ReConnect does just that (even more so than before :)
 - Fixed the channelmode buttons mouse-over problem.
 - Fixed percentage display for large files in dcc recv/send gui.
 - StartTime in dcc chat gui no longer Jan 1 1970.
 - Fixed DCC send behind IP-Nat (Bernhard Valenti)
   <bernhard.valenti@gmx.net>.
 - Added Lithuanian translation (Gediminas Paulauskas).
 - The < > buttons arn't shown for non-tab windows (Aaron Lehmann).
 - Fixed the (-1,-1) transparency problem for non-tab windows.

***

## 1.6.0

 - xtext: More efficient handling of expose events, text marking and
   url highlighting when double buffer is OFF.
 - xtext: Fixed a very rare bug that could cause BadGC errors or the
   separator bar not to be drawn.
 - Fixed crash in right-clicking URLs in the URL Grabber window.
 - If Check-For-Replace is in the keybindings for Return, it'll
   actually work again.
 - USER login command now sends your nodename instead of 'localhost'
   to please some IRCNet servers.
 - Updated Swedish translation (Christian Rose).

***

## 1.5.11

 - Updated Slovak translation (Stano Visnovsky).
 - Updated Swedish translation (Christian Rose).
 - Updated Greek translation (Fanis Dokianakis).
 - Updated Spanish translation (Antonio de la Torre).
 - If Never-Give-Up Reconnect is ON, it won't give up on DNS failer.
 - '/me is back' is sent again when Announce Away Messages is ON.
 - If channelmode buttons were OFF and you joined a channel with a
   userlimit xchat would crash - fixed.
 - /sslserver's password arg. is now optional (Daniel Richards).
 - SSL accepts self signed certs (Daniel Richards).
 - Fixed the unnecessary window resizes when opening a new tab.
 - Changed the tinting code a bit (thanks gnapster :). 
 - Transparent shell tabs update too when they are moved.

***

## 1.5.10

 - Added "Enable double buffer" toggle in Setup->Channel windows.
 - Double buffer is now OFF by default (seems to use less CPU).
 - Timestamps didn't turn ON while indent was OFF - fixed.
 - Updated Swedish translation (Christian Rose).
 - Added some extra text events: Channel Msg hilight, Channel
   Action hilight (near top of the list). No more cardcoded color
   codes! Also hilighting in actions works, and you can make the whole
   message hilighted if you change the event text.
 - Initial window size is actually set to your settings (this will
   never be perfect I guess, sometimes to the window still resizes
   itself without warning).
 - Hidemenubar setting didn't work properly for non-tabs and when
   delinking windows - fixed.
 - Notices appear in front tab even when server tabs are enabled.
 - Changed Away behaviour again. No more /back, /away with no args
   brings you back. The menu-item's state is what the server tells
   it, it even changes when you switch tabs to another server. Xchat
   assumes you are not away when you first connect. irc::get\_info(5)
   returns the away state. One day the other UserModes menu items will
   show correct states. Is everyone happy now?
 - Translation tables didn't work for outgoing text - fixed.
 - Cleaned up a few xchat.conf names, a few settings may not load up
   from 1.5.9 - just set them again.

***

## 1.5.9

 - Updated Spanish translation (Antonio de la Torre).
 - Added Hebrew translation (Dan Fruehauf).
 - Fixed crash bug when partreason was not set.
 - Dialog tabs obay the hidetopicbar setting now too (the one in the
   right-click menu).
 - Cleaned up the settings gui: the whole window is more compact now,
   some toggles in two columns, numbers use a spin-button, entry boxes
	are larger and option-menus are more consistant.
 - The "o=xx v=xx t=xx" display is finally changed.
 - Changed most of xtext.c to use gdk instead of Xlib.
 - Added configure option:
        --disable-xlib    disable use of xlib (for non X11 systems)
   This might help compile xchat on other GTK supported systems like
   BeOS and Win32 (havn't tried it though).
 - Neater /set list.
 - You can now set a nickname per server (see serverlist edit window).
 - Changed the behaviour of /away and added /back (James Crawford).
 - Away reason can now be a text file of random reasons too.

***

## 1.5.7 -> 1.5.8

 - Updated Spanish translation (Antonio de la Torre).
 - Updated Swedish translation (Christian Rose).
 - Updated Greek translation (Dokianakis Fanis).
 - Updated German translation (Tamer Fahmy).
 - Added Catalan translation (Pablo Saratxaga).
 - Added option "Always timestamp logs" which timestamps log files
   even if on-screen timestamps are off (Mike Guidero).
 - Added entry "Part Reason: ". Also part and quit reasons can be
   a filename of random reasons (filename relative to ~/.xchat/).
 - Took out /unban as a internal command, add it as a usercommand
   /quote MODE %c -b &2 instead.
 - Added a text event for banlist. Try /banlist and it'll be a bit
   more readable now.
 - Changed output throttle system (undernet style) (Alex Badea).
 - Added 1 second linger socket option to stop QUIT msgs from being
   lost (they still get lost sometimes, why?).

***

## 1.5.6 -> 1.5.7

 - Fixed transparency-leak problems in 1.5.6
 - New code to create shaded transparency, taken from latest zvt.
   (is it better?)
 - URL handlers are now executed without a shell.
   (http://www.securityfocus.com/vdb/bottom.html?vid=1601)
 - Fixed a bug in xchat.conf and serverlist.conf loading.
 - When spliting msgs (longer than the IRC 512 limit), it used to
   loose some chars - fixed.
 - Added feature to choose DCC port range            (Lars Sundqvist).
 - Fixed perl-stack overflow probs in irc::userlist() and others.
   Added perl functions user\_list\_short() and perl\_script\_list()
                                                       (Mike Guidero).
 - MHz is now detected on FreeBSD 4.x/5.x           (Jonathan Perkin).
 - It's now possible to "/dcc close chat nick" within a DCC perl
   input handler without crashing xchat.         (Geoffrey Higginson).
 - Fixed a problem with the usermenu not updating sometimes.

***

## 1.5.5 -> 1.5.6

 - Added option pingtimeout, which pings the server instead. 
   /set pingtimeout 90 is default (small values will malfunction).
   You also need the lagometer enabled for this to work.
 - No longer using fnmatch() for ignore etc (because the way it
   handles [ and ]). Using function from ircu2.10.08.
 - Some fixes to code & configure.in to make it compile using
   Solaris C (Albert Chin).
 - New Spanish translation (Antonio de la Torre).
 - New Russian translation (Alex Samorukov).
 - New Hungarian translation (Horvath Szabolcs).
 - Added Portuguese translation (Vitor Antunes).
 - Added Slovak translation (Martin Pekar).
 - Added /allserv <cmd> and /allchan <cmd>. They send a command to
   all currently connected servers and joined channels. Also added
   usercommands /ame and /amsg which make use of this.
 - Added sock5 traversal, see Setup->Proxy Server (Alex Badea).
   (The numbers for proxy\_type are now 0=disabled, 1=wingate,
    2=socks4, 3=socks5).
 - A few more buffer overflow checks (nick & channel length).
 - Mapped mIRC color 99 to "no background" (mIRC lame!).
 - Some efficiency tweaks to xtext.
 - Added SSL support (see --enable-openssl and /help server) (DaP).
   This seems to be highly experimental, as I don't know of any IRC
   servers that can do SSL yet.
 - Changed history behaviour, more like GNU (DaP).
   i.e. Doesn't wrap and the bottom line is blank.
 - Added option "InputBox Always In Focus" (DaP).
 - Added option "Show Nickgad" (DaP).
 - Added option "Show invites in the active Window" (DaP).
 - Added option "Send /Whois" in notifies section, which sends a
   /whois when someone comes online (DaP).
 - Added an event for numeric 341, you inivited someone (DaP).
 - Title bar text changed/improved a bit (DaP).
 - Added actions for EditKeyBindings: MoveFrontTabLeft and
   MoveFrontTabRight, like the <> buttons, but for keyboard (DaP).
 - Implemented timeout events in the text frontend (Alex Badea and
   fixed by me :).
 - Dcc Recv/Send tabs won't resize the window when open.
 - Added configure option --disable-glib.
 - Transparent windows update when background changes (Aaron Lehmann).
 - serverlist.conf is slightly changed! You WILL be able to load your
   old 1.5.5 or 1.4.x server list, but older versions WON'T load lists
   from 1.5.6, so backup your serverlist.conf if you need to.
 
***

## 1.5.4 -> 1.5.5

 - Fix for show/hide menu under gnome.
 - Added -a and --noauto arg (don't auto connect to any servers).
 - Added internal /list command, which sends the correct args according
   to ircd type (it detects undernet and dalnet to send >0,<10000).
   Remove any old /list usercommands you might have.
 - /op /deop ... etc send up to six modes per line if using undernet.
 - As discussed in the mailinglist, changed DCC resume to send and
   expect to receive ACKs as an absolute, rather than an offset from
   the resume point. It *should* work with mIRC now, but break with
   old versions of xchat and probably BitchX.
 - Added option "Limited Tab Highlighting" (Francis Litterio).

***

## 1.5.3 -> 1.5.4

 - Lack of gdk\_pixbuf is detected correctly now (configure script).
 - textmarking is no longer a timeout event, is this better or worse?
 - Added Turkish translation (Fatih Demir).
 - Added Russian translation (Valek Filippov).
 - Added Ukrainian translation (Yuri Syrota).
 - Added configure option --disable-zvt. Also, zvt shell tab can be
   compiled in even without gnome (and is by default, if gnome-config
   can be found to provide the LDFLAGS).
 - Added "Delete Word Forward" function in Edit Key Bindings. Bind
   this to Alt-d for that emacs feel (Francis Litterio). 
 - Ping times show one extra decimal place.
 - You can now hide the menubar too, click left mouse in the text area
   to get a popup version of the menu (middle mouse in dialogs).
 - Added the proxy settings to the GUI, Setup->IRC->Proxy Server.
 - Added a keyword TOGGLE for usermenu. Delete your old usermenu.conf
   to see the new default one.
 - Configure script now cleans up the CFLAGS & LDFLAGS (removes
   duplicate words), let's hope this doesn't break on some boxses.

***

## 1.5.2 -> 1.5.3

 - Fixed a rare overflow bug in auto\_insert().
 - Pressing OK in the settings window on slow machines (p233?) was
   pretty slow, maybe it's faster now.
 - Corrected some inputgad behaviour (Aaron Lehmann).
 - Fix for 64bit machines (alpha) in xtext (word clicks).
 - Updated German translation (Benedikt Roth).
 - Updated Danish translation (Birger Langkjer).
 - If you disconnect (/discon, /quit...) a server during the reconnect
   delay, it is actually removed now.
 - Added option "Give the userlist style" (DaP).
 - Translation tables support can be turned off (--disable-trans), for
   you minimalist freaks.
 - Added Hebrew support, compile time: --enable-hebrew, run time:
   /set hebrew 0/1 (Dan Aloni).
 - Added new setting, "nick completion character" (Francis Litterio).
 - Added new setting, "Old-style Nickname Completion", which makes it
   act much like 1.4.x (Francis Litterio).
 - Added "Delete Word" function to EditKeyBindings (Francis Litterio).
 - Now using gdk-pixbuf for decoding pictures and tinted transparency.
	(Tints don't seem to work 100% yet). (Andreas Persenius).
 - Added halfop support (mode +h). This includes support in the
   userlist, /hop, /dehop, /mdehop and new textevents (Elizandro G. Roos).

***

## 1.5.1 -> 1.5.2

 - --disable-gnome should work again.
 - Fixed a bug in right-click nick menu.
 - Should compile with glibc 2.1.3 (no more 'struct user' errors).
 - Added Romanian translation (Dan Damian).
 - CTCP flood protection won't kick in for ACTIONs.
 - Removed the theme code.
 - Made pixmaps.c, all code to decode/free/etc pixmaps is in here.
 - WM\_HINTS icon is set for the app.
 - Removed the "-c" flag (it's automatic now).

***

## 1.5.0 -> 1.5.1

 - Shell tabs are now delinkable.
 - Added a "show/hide topic bar" button (bottom right), I didn't know
   where else to put this.
 - Hidding the userlist is saved and any new tabs/windows open will
   have the userlist hidden.
 - You can now turn off/on perl warnings with /set perlwarnings 0/1.
 - Tab-key nick completion even more like GNU readline (Gerard Daubar).
 - Rewrote the function that handles %variables in userlist buttons,
   user commands and ctcp replies (all use the same function now),
   please report any bugs (especially if someone can overflow you from
   remote ;) - as a consequence, you can use % and & (word/word\_eol)
   for ctcp replies now. Also added %m for machine info.
 - Nickname-popup-menu, URLmenu and Usermenu all use the same code now
   (it means you can make submenus in all 3).
 - Double eval back in perl.c
 - Dialogs/querys also have a toolbox button (just for consistancy).
 - Added lagometer (/set lagometer 0 to turn it off), this isn't quiet
   finished yet (and doesn't work on IRCNet because it refuses to
   reply to pings correctly).

***

## 1.4.2 -> 1.5.0

 - Some changes & cleanups to the parser code (inbound/outbound).
 - Ran all source through indent, using:
           indent -bli0 -bls -ce -ts3 -i3
    (please use this in your patches, I used GNU indent 2.2.4).
 - If you send a message (channel or query window) longer than 512
   bytes (maximum allowed by the ircd) it will be split into two
   smaller messages instead of being truncated.
 - Some gui touchups and changes.
 - You can now enable/disable the output throttle with /set throttle.
 - Added /timer.
 - Overhauled the ChannelList window (Joshua Gough).
 - Added proxy traversal support for socks and wingate, no gui yet so
   use /set proxy\_host, proxy\_port, proxy\_type (1=socks, 2=wingate).
 - Added /userlist.
 - Opaque-window-move used to be slow on some windowmanagers even
   with transparency turned off - fixed.
 - Tab-key completion is more like GNU readline (Wes Peters).
 - Now possible to use modules in perl scripts (Andreas Scherbaum).
 - irc::get\_info(4) returns the current xchat dir (Mike Guidero).
 - Added irc::get\_prefs() (returns a /set variable) (Leo Cacciari).
 - /set <wildcard> is now possible.
 - Added Show-Userhost-in-Userlist option (Nicolas Dimitrijevic).
 - Build tree cleaned up so 'make dist' can work.
 - Added flood protection from CTCP and mass-dialogs-opening (Bruj0)
   rdiazleven@ubp.edu.ar. (see variables *\_limit).

***

## 1.4.1 -> 1.4.2

 - Compilation fixes for IRIX (David Kaelbling).
 - Compilation fixes for AIX (Rodrigo Barbosa).
 - Compilation fixes for OpenBSD.
 - Should now compile with certain beta/alpha versions of Perl.
 - "Scrollbar snapping to top" bug fixed.
 - Corrected some text marking behaviour.
 - Made use of fnmatch(), if available (for chanlist, ignore etc).
 - Configure script is now generated with a sane version of autoconf.
 - Alt-minus and Alt-plus now wrap around (AGL).

***

## 1.4.0 -> 1.4.1

 - Fixed a bug that could make new text not appear while marking text.
 - xtext: Further improved performance when double buffering is turned
          off (marking text & URL hilights are almost flicker free).
 - xtext: Double buffer is now freed at each render operation, this
          should reduce memory usage if you have many tabs open.
 - If you closed a server while it was in the reconnect-delay, xchat
   would crash - fixed.
 - No more zombies when doing /discon while connection in progress.
 - Added "/clear all" command (Paul de Regt).
 - Hilights only work on full word matches now (Brendan O'Dea).
 - Some Solaris compilation fixes (David Morgan).
 - Danish translation updated (Birger Langkjer).
 - Italian translation updated (Stefano Fava).
 - Greek translation added (Fanis Dokianakis).
 - Dutch translation upated (Arjan Scherpenisse).
 - Removed some very old translations: fr\_CA, no, pl, ru and sv.
   (If someone wants to update these, you're welcome to).
 - Channel mode "+h nick" (half Op) is now reported correctly (still
   not supported in the userlist though).
 - Having indent nicks OFF in channel windows and ON in dialog windows
   didn't work - fixed.
 - Sometimes ignores wouldn't save - fixed.


[http://www.xchat.org](http://www.xchat.org)
