{-# OPTIONS_HADDOCK hide #-}
{-# LANGUAGE CPP #-}
-- -*-haskell-*-
-- -------------------- automatically generated file - do not edit ----------
--  Object hierarchy for the GIMP Toolkit (GTK) Binding for Haskell
--
--  Author : Axel Simon
--
--  Copyright (C) 2001-2005 Axel Simon
--
--  This library is free software; you can redistribute it and/or
--  modify it under the terms of the GNU Lesser General Public
--  License as published by the Free Software Foundation; either
--  version 2.1 of the License, or (at your option) any later version.
--
--  This library is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
--  Lesser General Public License for more details.
--
-- #hide

-- |
-- Maintainer  : gtk2hs-users@lists.sourceforge.net
-- Stability   : provisional
-- Portability : portable (depends on GHC)
--
-- This file reflects the Gtk+ object hierarchy in terms of Haskell classes.
--
-- Note: the mk... functions were originally meant to simply be an alias
-- for the constructor. However, in order to communicate the destructor
-- of an object to objectNew, the mk... functions are now a tuple containing
-- Haskell constructor and the destructor function pointer. This hack avoids
-- changing all modules that simply pass mk... to objectNew.
--
module Media.Streaming.GStreamer.Core.MiniHierarchy (

  module Media.Streaming.GStreamer.Core.MiniHierarchyBase,
  Buffer(Buffer), BufferClass,
  toBuffer, 
  mkBuffer, unBuffer,
  castToBuffer, gTypeBuffer,
  Event(Event), EventClass,
  toEvent, 
  mkEvent, unEvent,
  castToEvent, gTypeEvent,
  Message(Message), MessageClass,
  toMessage, 
  mkMessage, unMessage,
  castToMessage, gTypeMessage,
  Query(Query), QueryClass,
  toQuery, 
  mkQuery, unQuery,
  castToQuery, gTypeQuery
  ) where

import Foreign.ForeignPtr (ForeignPtr, castForeignPtr, unsafeForeignPtrToPtr)
import Foreign.C.Types    (CULong(..), CUInt(..))
import System.Glib.GType  (GType, typeInstanceIsA)
{#import Media.Streaming.GStreamer.Core.MiniHierarchyBase#}

{# context lib="gstreamer" prefix="gst" #}

-- The usage of foreignPtrToPtr should be safe as the evaluation will only be
-- forced if the object is used afterwards
--
castTo :: (MiniObjectClass obj, MiniObjectClass obj') => GType -> String
                                                -> (obj -> obj')
castTo gtype objTypeName obj =
  case toMiniObject obj of
    gobj@(MiniObject objFPtr)
      | typeInstanceIsA ((unsafeForeignPtrToPtr.castForeignPtr) objFPtr) gtype
                  -> unsafeCastMiniObject gobj
      | otherwise -> error $ "Cannot cast object to " ++ objTypeName


-- ********************************************************************* Buffer

{#pointer *Buffer foreign newtype #} deriving (Eq,Ord)

mkBuffer = (Buffer, miniObjectUnref)
unBuffer (Buffer o) = o

class MiniObjectClass o => BufferClass o
toBuffer :: BufferClass o => o -> Buffer
toBuffer = unsafeCastMiniObject . toMiniObject

instance BufferClass Buffer
instance MiniObjectClass Buffer where
  toMiniObject = MiniObject . castForeignPtr . unBuffer
  unsafeCastMiniObject = Buffer . castForeignPtr . unMiniObject

castToBuffer :: MiniObjectClass obj => obj -> Buffer
castToBuffer = castTo gTypeBuffer "Buffer"

gTypeBuffer :: GType
gTypeBuffer =
  {# call fun unsafe gst_buffer_get_type #}

-- ********************************************************************** Event

{#pointer *Event foreign newtype #} deriving (Eq,Ord)

mkEvent = (Event, miniObjectUnref)
unEvent (Event o) = o

class MiniObjectClass o => EventClass o
toEvent :: EventClass o => o -> Event
toEvent = unsafeCastMiniObject . toMiniObject

instance EventClass Event
instance MiniObjectClass Event where
  toMiniObject = MiniObject . castForeignPtr . unEvent
  unsafeCastMiniObject = Event . castForeignPtr . unMiniObject

castToEvent :: MiniObjectClass obj => obj -> Event
castToEvent = castTo gTypeEvent "Event"

gTypeEvent :: GType
gTypeEvent =
  {# call fun unsafe gst_event_get_type #}

-- ******************************************************************** Message

{#pointer *Message foreign newtype #} deriving (Eq,Ord)

mkMessage = (Message, miniObjectUnref)
unMessage (Message o) = o

class MiniObjectClass o => MessageClass o
toMessage :: MessageClass o => o -> Message
toMessage = unsafeCastMiniObject . toMiniObject

instance MessageClass Message
instance MiniObjectClass Message where
  toMiniObject = MiniObject . castForeignPtr . unMessage
  unsafeCastMiniObject = Message . castForeignPtr . unMiniObject

castToMessage :: MiniObjectClass obj => obj -> Message
castToMessage = castTo gTypeMessage "Message"

gTypeMessage :: GType
gTypeMessage =
  {# call fun unsafe gst_message_get_type #}

-- ********************************************************************** Query

{#pointer *Query foreign newtype #} deriving (Eq,Ord)

mkQuery = (Query, miniObjectUnref)
unQuery (Query o) = o

class MiniObjectClass o => QueryClass o
toQuery :: QueryClass o => o -> Query
toQuery = unsafeCastMiniObject . toMiniObject

instance QueryClass Query
instance MiniObjectClass Query where
  toMiniObject = MiniObject . castForeignPtr . unQuery
  unsafeCastMiniObject = Query . castForeignPtr . unMiniObject

castToQuery :: MiniObjectClass obj => obj -> Query
castToQuery = castTo gTypeQuery "Query"

gTypeQuery :: GType
gTypeQuery =
  {# call fun unsafe gst_query_get_type #}

