/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2009 Christian Schallhart <christian@schallhart.net>,
 *                    Michael Tautschnig <tautschnig@forsyte.de>
 *               2008 model.in.tum.de group, FORSYTE group
 *               2006-2007 model.in.tum.de group
 *               2002-2005 Christian Schallhart
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/dummy_test_case.ts.hpp
 *
 * $Id$
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] @ref
 * ::diagnostics::unittest::testing::Dummy_Test_Case and @ref
 * ::diagnostics::unittest::testing::Stupid_Test_Case
 *
 * @test none
 */

#ifndef DIAGNOSTICS__UTIL__DUMMY_TEST_CASE_TS_HPP__INCLUDE_GUARD
#define DIAGNOSTICS__UTIL__DUMMY_TEST_CASE_TS_HPP__INCLUDE_GUARD

#include <diagnostics/unittest.hpp>
#include <diagnostics/unittest/std_test_case.hpp>

DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;
TEST_NAMESPACE_BEGIN;

class Dummy_Test_Case :
    public ::diagnostics::unittest::Std_Test_Case
{
    typedef ::diagnostics::unittest::Std_Test_Case Super;
public:
    Dummy_Test_Case(::std::string const & name,
					int const timeout,
					bool const is_rerunable,
					bool const testable_at_prod,
					bool const testable_at_debug,
					bool const testable_at_audit,
					bool const invalid=false,
					bool const failure=false);
    
    virtual void run(::diagnostics::unittest::Test_Data & test_data) const;
    
    inline int run_count() 
    {
		return m_run_count;
    }
    
private:
    mutable int m_run_count;
	bool const m_invalid;
	bool const m_failure;
};

class Stupid_Test_Case :
    public Dummy_Test_Case
{
    typedef Dummy_Test_Case Super;
public:
    Stupid_Test_Case(::std::string const & name);
};


TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;


#endif
// vim:ts=4:sw=4
