#!/bin/sh

if test "$#" -ne 2; then
	echo "$(basename "$0") takes two positional arguments: architecture and release" 1>&2
	exit 1
fi
ARCHITECTURE=$1
RELEASE=$2
SSH_KEYPATH=ssh_id
IMAGE=test.img

set -eux

. "$(dirname "$0")/test_common.sh"

cleanup() {
	rm -f "$SSH_KEYPATH" "$SSH_KEYPATH.pub" "$IMAGE"
}

trap cleanup EXIT INT TERM QUIT

ssh-keygen -f "$SSH_KEYPATH" -N ''
set -- --
if test -z "$RELEASE"; then
	# The ordering of maybe-merged-usr and
	# copy-host-apt-sources-and-preferences is unfortunately the wrong way
	# round. Therefore, we make debvm-create skip it and pass it ourselves.
	# The final empty string is the mirror specification.
	set -- \
		--skip=usrmerge \
		"$@" \
		--hook-dir=/usr/share/mmdebstrap/hooks/copy-host-apt-sources-and-preferences \
		--hook-dir=/usr/share/mmdebstrap/hooks/file-mirror-automount \
		--hook-dir=/usr/share/mmdebstrap/hooks/maybe-merged-usr \
		""
fi
debefivm-create -k "$SSH_KEYPATH.pub" -o "$IMAGE" -r "$RELEASE" -a "$ARCHITECTURE" "$@"

# Work around qemu #1106792
export OMP_THREAD_LIMIT=1

SSH_PORT=2222
timeout 600s debefivm-run -s "$SSH_PORT" -i "$IMAGE" &
set -- localhost
debvm-waitssh -t 540 "$SSH_PORT"
run_ssh "$@" poweroff
wait

"$(dirname "$0")/shell_interaction.expect" -- debefivm-run -i "$IMAGE"
