/*

  Author:  Bob Dean
  Copyright (c) 1999, 2000


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#ifdef __cplusplus
extern "C"
{
#endif

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <limits.h>
#include <fcntl.h>
#include <signal.h>
#include <stdarg.h>
#include <sys/shm.h>
#include <glib.h>
#include <math.h>
#include <dbsoundcard.h>
#include <dbchannel.h>
#include <dbdebug.h>
#include <dbaudiolib.h>

#include "prototypes.h"

	/* variables to access DBMix channels shared memory */
	extern  int shmid, sysshmid;
	extern dbfsd_data * sysdata;
	extern local_channel * local_channels;
	/* static local_channel * cue_channels; */
	extern local_channel * ch;
	
	extern int errno;
	extern int debug_level; /* declared in debug module */
	
	extern float local_pitch;

	extern int num_channels;
	extern int format;

	/*
	  DBAudio_Get_Bufsize - 
	 */

	int DBAudio_Get_Bufsize(int input_bufsize)
	{
		int format_multiplier;
		int stereo_multiplier;
	    int output_bufsize, difference;
		float bufsize;
		
		errno = ERROR_NOT_IMPLEMENTED;
		return FAILURE;

		if(ch == NULL) {errno = ERROR_NOT_INITIALIZED; return FAILURE;}
		
		if(input_bufsize == 0) {input_bufsize = PIPE_BUF;}
		
		local_pitch = (ch->base_pitch / 100.0) * (ch->user_pitch / 100.0);
		
		switch(num_channels)
		{
		case 1: stereo_multiplier = 2; break;
		case 2: stereo_multiplier = 1; break;
		default: errno = ERROR_BAD_NUMCH; return FAILURE;
		}
		
		switch(format)
		{
		case AFMT_U8: format_multiplier = 2; break;
		case AFMT_S8: format_multiplier = 2; break;
		case AFMT_S16_LE: format_multiplier = 1; break;
		case AFMT_S16_BE: format_multiplier = 1; break;
		default: errno = ERROR_BAD_FORMAT; return FAILURE;
		}
		
		
		
		bufsize = ((float) input_bufsize * (float) stereo_multiplier 
				   * (float)format_multiplier) / local_pitch;
		output_bufsize = ceil(bufsize);
		
/* 		printf("bufsize si %f\n",bufsize); */

		/* check to see if there is too much data to fit in the output buffer */
		if(output_bufsize > OUTPUT_BUFSIZE)
		{
			difference = (int)ceil(((float)(output_bufsize - OUTPUT_BUFSIZE) * local_pitch) 
								   / (float)(stereo_multiplier * format_multiplier));
			
			printf("too much data. difference is %d suggested is %d\n",difference,input_bufsize - difference);
			
			return input_bufsize - difference;
		}

		/* check to see if there is too little data for dbfsd to handle*/
		if(local_pitch > 1.0)
		{
			if(output_bufsize < PIPE_BUF)
			{
				difference = (int)ceil(((float)(PIPE_BUF - output_bufsize) * local_pitch) 
							  / (float)(stereo_multiplier * format_multiplier));
			  
				printf("%d is too little data. difference is %d suggested is %d\n",input_bufsize,difference,input_bufsize + difference);

				return input_bufsize + difference;
			}
		}

		return input_bufsize;
	}



#ifdef __cplusplus
}
#endif
