//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Beam/GrazingScanItem.h
//! @brief     Declares the class GrazingScanItem
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_BEAM_GRAZINGSCANITEM_H
#define BORNAGAIN_GUI_MODEL_BEAM_GRAZINGSCANITEM_H

#include "GUI/Model/Beam/BeamDistributionItem.h"

class BasicAxisItem;
class Scale;
class ICoordSystem;
class PointwiseAxisItem;

//! BeamInclinationAxisItem contains inclination angle axis for specular/off-specular
//! simulations and also provides distribution functionality.
//! Considering distribution, differs from BeamInclinationAngleItem
//! by any distribution mean value being always zero.

class GrazingScanItem : public BeamDistributionItem {
public:
    explicit GrazingScanItem();

    void writeTo(QXmlStreamWriter* w) const override;
    void readFrom(QXmlStreamReader* r) override;

    double scaleFactor() const override;

    int nBins() const;

    //! The currently selected axis
    BasicAxisItem* alphaAxisItem() const;

    //! True if a pointwise axis was defined.
    //!
    //! It still is no necessarily the selected axis!
    //! Not to be confused with pointwiseAlphaAxisSelected
    bool pointwiseAlphaAxisDefined() const;

    //! True if pointwise axis is selected.
    //!
    //! Not to be confused with pointwiseAlphaAxisDefined
    bool pointwiseAlphaAxisSelected() const;

    //! True if uniform axis is selected.
    bool uniformAlphaAxisSelected() const;

    void selectUniformAxis();
    void selectListScan();

    void initUniformAxis(const Scale& axis);
    void initListScan(const Scale& axis, QString units, const ICoordSystem& converter);

private:
    std::unique_ptr<BasicAxisItem> m_uniformAlphaAxis;
    std::unique_ptr<PointwiseAxisItem> m_pointwiseAlphaAxis;
    bool m_currentAxisIsUniformAxis;
};

#endif // BORNAGAIN_GUI_MODEL_BEAM_GRAZINGSCANITEM_H
