// ServerConnection.C  -*- C++ -*-
// Copyright (c) 1997, 1998 Etienne BERNARD
// Copyright (C) 2002 Clinton Ebadi

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#include <ctime>

#include "ServerConnection.H"
#include "Parser.H"
#include "Bot.H"

ServerConnection::ServerConnection(Bot *b, Server *s, String localIP)
  : Connection(s->getHostName(),
               s->getPort(), localIP),
    server(s),
    bot(b),
    queue(new ServerQueue(&socket, b->debug)),
    pingTime(0), lag(0), serverLastSpoken(time(0)),
    debug(b->debug)
{
  b->connected = false;
}

ServerConnection::~ServerConnection()
{
  delete queue;
}

bool
ServerConnection::connect()
{
  if (!socket.connect())
    return false;

  socket.setNonBlocking();

  if (server->getPassword().length() != 0)
    queue->sendPass(server->getPassword());
  queue->sendNick(bot->wantedNickName);
  queue->sendUser(bot->userName, bot->ircName);

  queue->flush();
 
  return true;
}

bool
ServerConnection::handleInput()
{
  String line = socket.readLine();

  if (line.length() == 0)
    return true;
  
  if (bot->debug)
    std::cout << line << "\n";
  
  serverLastSpoken = time(0);
  
  Parser::parseLine(this, line);
  
  return false;
}
