/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitabconverter.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import yuku.alkitab.model.XrefEntry;
import yuku.alkitab.util.Ari;
import yuku.alkitabconverter.util.DesktopVerseFinder;
import yuku.alkitabconverter.util.DesktopVerseParser;
import yuku.alkitabconverter.util.IntArrayList;
import yuku.alkitabconverter.util.KjvUtils;
import yuku.bintex.BintexWriter;

public class XrefDb {
    Map<Integer, List<XrefEntry>> map = new TreeMap<Integer, List<XrefEntry>>();
    public static XrefProcessor defaultShiftTbProcessor = new XrefProcessor(){

        @Override
        public void process(XrefEntry xe, int ari_location, int entryIndex) {
            final ArrayList pairs = new ArrayList();
            DesktopVerseFinder.findInText(xe.content, new DesktopVerseFinder.DetectorListener(){

                @Override
                public boolean onVerseDetected(int start, int end, String verse) {
                    pairs.add(new int[]{start, end});
                    return true;
                }

                @Override
                public void onNoMoreDetected() {
                }
            });
            String target = xe.content;
            for (int i = pairs.size() - 1; i >= 0; --i) {
                int[] pair = (int[])pairs.get(i);
                String verse = target.substring(pair[0], pair[1]);
                IntArrayList ariRanges = DesktopVerseParser.verseStringToAriWithShiftTb(verse);
                if (ariRanges == null || ariRanges.size() == 0) {
                    throw new RuntimeException("verse cannot be parsed: " + verse);
                }
                boolean isStart = true;
                for (int j = 0; j < ariRanges.size(); ++j) {
                    int ari2 = ariRanges.get(j);
                    if (Ari.toVerse(ari2) == 0) {
                        if (isStart) {
                            ari2 = Ari.encodeWithBc(Ari.toBookChapter(ari2), 1);
                        } else {
                            int lastVerse_1 = KjvUtils.getVerseCount(Ari.toBook(ari2), Ari.toChapter(ari2));
                            ari2 = Ari.encodeWithBc(Ari.toBookChapter(ari2), lastVerse_1);
                        }
                    }
                    ariRanges.set(j, ari2);
                    isStart = !isStart;
                }
                StringBuilder ariRanges_s = new StringBuilder();
                boolean isStart2 = true;
                boolean endWritten = false;
                for (int j = 0; j < ariRanges.size(); ++j) {
                    String enc_value;
                    int ari_target = ariRanges.get(j);
                    int lid = KjvUtils.ariToLid(ari_target);
                    if (lid <= 0) {
                        throw new RuntimeException(String.format("invalid ari found 0x%06x", ari_target));
                    }
                    if (isStart2) {
                        endWritten = false;
                        int ari_end = ariRanges.get(j + 1);
                        enc_value = this.ariToString(ari_target);
                        if (ari_end == ari_target) {
                            endWritten = true;
                        }
                    } else {
                        enc_value = endWritten ? null : this.ariToString(ari_target);
                    }
                    if (isStart2) {
                        if (ariRanges_s.length() != 0) {
                            ariRanges_s.append(",");
                        }
                        ariRanges_s.append(enc_value);
                    } else if (enc_value != null) {
                        ariRanges_s.append("-").append(enc_value);
                    }
                    isStart2 = !isStart2;
                }
                target = target.substring(0, pair[0]) + "@<ta:" + ariRanges_s + "@>" + verse + "@/" + target.substring(pair[1]);
            }
            xe.content = target;
        }

        private String ariToString(int ari) {
            String ari_target_hex = "0x" + Integer.toHexString(ari);
            String ari_target_dec = Integer.toString(ari);
            return ari_target_hex.length() <= ari_target_dec.length() ? ari_target_hex : ari_target_dec;
        }
    };

    public XrefDb() {
    }

    public XrefDb(LinkedHashMap<Integer, XrefEntry> xrefEntries) {
        for (Map.Entry<Integer, XrefEntry> entry : new TreeMap<Integer, XrefEntry>(xrefEntries).entrySet()) {
            int arif = entry.getKey();
            int ari = arif >> 8;
            List<XrefEntry> xes = this.map.get(ari);
            if (xes == null) {
                xes = new ArrayList<XrefEntry>();
                this.map.put(ari, xes);
            }
            XrefEntry xe = entry.getValue();
            xes.add(xe);
        }
    }

    public LinkedHashMap<Integer, XrefEntry> toEntries() {
        final LinkedHashMap<Integer, XrefEntry> res = new LinkedHashMap<Integer, XrefEntry>();
        this.processEach(new XrefProcessor(){

            @Override
            public void process(XrefEntry xe, int ari, int entryIndex) {
                res.put(ari << 8 | entryIndex + 1, xe);
            }
        });
        return res;
    }

    public int addBegin(int ari) {
        List<XrefEntry> list = this.map.get(ari);
        if (list == null) {
            list = new ArrayList<XrefEntry>();
            this.map.put(ari, list);
        }
        XrefEntry xe = new XrefEntry();
        list.add(xe);
        return list.size() - 1;
    }

    public void appendText(int ari, String text) {
        List<XrefEntry> list = this.map.get(ari);
        if (list == null) {
            throw new RuntimeException("Must be after addBegin (1)");
        }
        XrefEntry xe = list.get(list.size() - 1);
        xe.content = xe.content == null ? text : xe.content + text;
    }

    public int addComplete(int ari, String content) {
        String target = content.matches("[a-zA-Z+-]\\s.*") ? content.substring(2) : content;
        List<XrefEntry> list = this.map.get(ari);
        if (list == null) {
            list = new ArrayList<XrefEntry>();
            this.map.put(ari, list);
        }
        XrefEntry xe = new XrefEntry();
        list.add(xe);
        xe.content = target;
        return list.size() - 1;
    }

    public void dump() {
        for (Map.Entry<Integer, List<XrefEntry>> e : this.map.entrySet()) {
            List<XrefEntry> xes = e.getValue();
            for (int i = 0; i < xes.size(); ++i) {
                XrefEntry xe = xes.get(i);
                System.out.printf("xref 0x%06x(%d): [%s]%n", e.getKey(), i + 1, xe.content);
            }
        }
    }

    public void processEach(XrefProcessor processor) {
        for (Map.Entry<Integer, List<XrefEntry>> e : this.map.entrySet()) {
            List<XrefEntry> xes = e.getValue();
            for (int i = 0; i < xes.size(); ++i) {
                XrefEntry xe = xes.get(i);
                processor.process(xe, e.getKey(), i);
            }
        }
    }

    public static void writeXrefEntriesTo(LinkedHashMap<Integer, XrefEntry> xrefEntries, BintexWriter bw) throws IOException {
        bw.writeUint8(1);
        bw.writeInt(xrefEntries.size());
        for (Map.Entry<Integer, XrefEntry> entry : xrefEntries.entrySet()) {
            bw.writeInt(entry.getKey());
        }
        ByteArrayOutputStream contents = new ByteArrayOutputStream();
        BintexWriter contentsBw = new BintexWriter(contents);
        for (Map.Entry<Integer, XrefEntry> entry : xrefEntries.entrySet()) {
            bw.writeInt(contentsBw.getPos());
            contentsBw.writeValueString(entry.getValue().content);
        }
        bw.writeRaw(contents.toByteArray());
    }

    public static interface XrefProcessor {
        public void process(XrefEntry var1, int var2, int var3);
    }
}

