/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitab.yes2.io;

import java.io.IOException;
import yuku.alkitab.yes2.io.RandomOutputStream;

public class MemoryRandomOutputStream
extends RandomOutputStream {
    public static final String TAG = MemoryRandomOutputStream.class.getSimpleName();
    private int length = 0;
    private int pos = 0;
    private byte[] buf = new byte[16];

    void expandBufTo(int newLen) {
        if (this.buf.length < newLen) {
            byte[] buf2 = new byte[newLen];
            System.arraycopy(this.buf, 0, buf2, 0, this.buf.length);
            this.buf = buf2;
        }
    }

    @Override
    public void write(int oneByte) throws IOException {
        if (this.pos >= this.buf.length) {
            this.expandBufTo((int)((double)this.length * 1.5) + 1);
        }
        this.buf[this.pos++] = (byte)oneByte;
        if (this.pos >= this.length) {
            this.length = this.pos;
        }
    }

    @Override
    public void write(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        int to = byteOffset + byteCount;
        for (int i = byteOffset; i < to; ++i) {
            this.write(buffer[i]);
        }
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.pos;
    }

    @Override
    public void seek(long offset) throws IOException {
        this.pos = (int)offset;
    }

    @Override
    public void close() throws IOException {
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getBufferOffset() {
        return 0;
    }

    public int getBufferLength() {
        return this.length;
    }
}

