// Global.cs
// 
// Copyright (C) 2010, 2011 Patrick Ulbrich
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
using System;

namespace Basenji
{
	// global settings
	public static class Global
	{
#if DEBUG
		private static bool enableDebugging = true;
#else
		private static bool enableDebugging = false;
#endif
		
		public static bool EnableDebugging {
			get {
				return enableDebugging;
			}
			
			set {
				enableDebugging = value;
			}
		}
		
		public static void EnforceCulture(string name) {
			S.SetCulture(name);
		}
	}
}
