// Geometric Tools, LLC
// Copyright (c) 1998-2014
// Distributed under the Boost Software License, Version 1.0.
// http://www.boost.org/LICENSE_1_0.txt
// http://www.geometrictools.com/License/Boost/LICENSE_1_0.txt
//
// File Version: 5.0.0 (2010/01/01)

#ifndef WM5CORE_H
#define WM5CORE_H

// Assert
#include "Wm5Assert.h"

// DataTypes
#include "Wm5MinHeap.h"
#include "Wm5Tuple.h"

// InputOutput
#include "Wm5BufferIO.h"
#include "Wm5Endian.h"
#include "Wm5Environment.h"
#include "Wm5FileIO.h"

// Memory
#include "Wm5Memory.h"
#include "Wm5SmartPointer.h"

// ObjectSystems
#include "Wm5InitTerm.h"
#include "Wm5InStream.h"
#include "Wm5Names.h"
#include "Wm5Object.h"
#include "Wm5OutStream.h"
#include "Wm5Rtti.h"
#include "Wm5Stream.h"

// Threading
#include "Wm5Mutex.h"
#include "Wm5MutexType.h"
#include "Wm5ScopedCS.h"
#include "Wm5Thread.h"
#include "Wm5ThreadType.h"

// Time
#include "Wm5Time.h"

#endif
