A reference to a local variable was returned.

Erroneous code example:

```compile_fail,E0515
fn get_dangling_reference() -> &'static i32 {
    let x = 0;
    &x
}
```

```compile_fail,E0515
use std::slice::Iter;
fn get_dangling_iterator<'a>() -> Iter<'a, i32> {
    let v = vec![1, 2, 3];
    v.iter()
}
```

Local variables, function parameters and temporaries are all dropped before
the end of the function body. A returned reference (or struct containing a
reference) to such a dropped value would immediately be invalid. Therefore
it is not allowed to return such a reference.

Consider returning a value that takes ownership of local data instead of
referencing it:

```
use std::vec::IntoIter;

fn get_integer() -> i32 {
    let x = 0;
    x
}

fn get_owned_iterator() -> IntoIter<i32> {
    let v = vec![1, 2, 3];
    v.into_iter()
}
```
