// asUintN test specialised when the input is an Int64 value.

const tests = [
  [-0x8000000000000000n, 0, 0n],
  [-0x7fffffffffffffffn, 0, 0n],
  [-0x7ffffffffffffffen, 0, 0n],
  [-0x100000001n, 0, 0n],
  [-0x100000000n, 0, 0n],
  [-0xffffffffn, 0, 0n],
  [-0xfffffffen, 0, 0n],
  [-0x80000001n, 0, 0n],
  [-0x80000000n, 0, 0n],
  [-0x7fffffffn, 0, 0n],
  [-0x7ffffffen, 0, 0n],
  [-9n, 0, 0n],
  [-8n, 0, 0n],
  [-7n, 0, 0n],
  [-6n, 0, 0n],
  [-5n, 0, 0n],
  [-4n, 0, 0n],
  [-3n, 0, 0n],
  [-2n, 0, 0n],
  [-1n, 0, 0n],
  [0n, 0, 0n],
  [1n, 0, 0n],
  [2n, 0, 0n],
  [3n, 0, 0n],
  [4n, 0, 0n],
  [5n, 0, 0n],
  [6n, 0, 0n],
  [7n, 0, 0n],
  [8n, 0, 0n],
  [9n, 0, 0n],
  [0x7ffffffen, 0, 0n],
  [0x7fffffffn, 0, 0n],
  [0x80000000n, 0, 0n],
  [0x80000001n, 0, 0n],
  [0xfffffffen, 0, 0n],
  [0xffffffffn, 0, 0n],
  [0x100000000n, 0, 0n],
  [0x100000001n, 0, 0n],
  [0x7ffffffffffffffen, 0, 0n],
  [0x7fffffffffffffffn, 0, 0n],
  [-0x8000000000000000n, 1, 0n],
  [-0x7fffffffffffffffn, 1, 1n],
  [-0x7ffffffffffffffen, 1, 0n],
  [-0x100000001n, 1, 1n],
  [-0x100000000n, 1, 0n],
  [-0xffffffffn, 1, 1n],
  [-0xfffffffen, 1, 0n],
  [-0x80000001n, 1, 1n],
  [-0x80000000n, 1, 0n],
  [-0x7fffffffn, 1, 1n],
  [-0x7ffffffen, 1, 0n],
  [-9n, 1, 1n],
  [-8n, 1, 0n],
  [-7n, 1, 1n],
  [-6n, 1, 0n],
  [-5n, 1, 1n],
  [-4n, 1, 0n],
  [-3n, 1, 1n],
  [-2n, 1, 0n],
  [-1n, 1, 1n],
  [0n, 1, 0n],
  [1n, 1, 1n],
  [2n, 1, 0n],
  [3n, 1, 1n],
  [4n, 1, 0n],
  [5n, 1, 1n],
  [6n, 1, 0n],
  [7n, 1, 1n],
  [8n, 1, 0n],
  [9n, 1, 1n],
  [0x7ffffffen, 1, 0n],
  [0x7fffffffn, 1, 1n],
  [0x80000000n, 1, 0n],
  [0x80000001n, 1, 1n],
  [0xfffffffen, 1, 0n],
  [0xffffffffn, 1, 1n],
  [0x100000000n, 1, 0n],
  [0x100000001n, 1, 1n],
  [0x7ffffffffffffffen, 1, 0n],
  [0x7fffffffffffffffn, 1, 1n],
  [-0x8000000000000000n, 2, 0n],
  [-0x7fffffffffffffffn, 2, 1n],
  [-0x7ffffffffffffffen, 2, 2n],
  [-0x100000001n, 2, 3n],
  [-0x100000000n, 2, 0n],
  [-0xffffffffn, 2, 1n],
  [-0xfffffffen, 2, 2n],
  [-0x80000001n, 2, 3n],
  [-0x80000000n, 2, 0n],
  [-0x7fffffffn, 2, 1n],
  [-0x7ffffffen, 2, 2n],
  [-9n, 2, 3n],
  [-8n, 2, 0n],
  [-7n, 2, 1n],
  [-6n, 2, 2n],
  [-5n, 2, 3n],
  [-4n, 2, 0n],
  [-3n, 2, 1n],
  [-2n, 2, 2n],
  [-1n, 2, 3n],
  [0n, 2, 0n],
  [1n, 2, 1n],
  [2n, 2, 2n],
  [3n, 2, 3n],
  [4n, 2, 0n],
  [5n, 2, 1n],
  [6n, 2, 2n],
  [7n, 2, 3n],
  [8n, 2, 0n],
  [9n, 2, 1n],
  [0x7ffffffen, 2, 2n],
  [0x7fffffffn, 2, 3n],
  [0x80000000n, 2, 0n],
  [0x80000001n, 2, 1n],
  [0xfffffffen, 2, 2n],
  [0xffffffffn, 2, 3n],
  [0x100000000n, 2, 0n],
  [0x100000001n, 2, 1n],
  [0x7ffffffffffffffen, 2, 2n],
  [0x7fffffffffffffffn, 2, 3n],
  [-0x8000000000000000n, 31, 0n],
  [-0x7fffffffffffffffn, 31, 1n],
  [-0x7ffffffffffffffen, 31, 2n],
  [-0x100000001n, 31, 0x7fffffffn],
  [-0x100000000n, 31, 0n],
  [-0xffffffffn, 31, 1n],
  [-0xfffffffen, 31, 2n],
  [-0x80000001n, 31, 0x7fffffffn],
  [-0x80000000n, 31, 0n],
  [-0x7fffffffn, 31, 1n],
  [-0x7ffffffen, 31, 2n],
  [-9n, 31, 0x7ffffff7n],
  [-8n, 31, 0x7ffffff8n],
  [-7n, 31, 0x7ffffff9n],
  [-6n, 31, 0x7ffffffan],
  [-5n, 31, 0x7ffffffbn],
  [-4n, 31, 0x7ffffffcn],
  [-3n, 31, 0x7ffffffdn],
  [-2n, 31, 0x7ffffffen],
  [-1n, 31, 0x7fffffffn],
  [0n, 31, 0n],
  [1n, 31, 1n],
  [2n, 31, 2n],
  [3n, 31, 3n],
  [4n, 31, 4n],
  [5n, 31, 5n],
  [6n, 31, 6n],
  [7n, 31, 7n],
  [8n, 31, 8n],
  [9n, 31, 9n],
  [0x7ffffffen, 31, 0x7ffffffen],
  [0x7fffffffn, 31, 0x7fffffffn],
  [0x80000000n, 31, 0n],
  [0x80000001n, 31, 1n],
  [0xfffffffen, 31, 0x7ffffffen],
  [0xffffffffn, 31, 0x7fffffffn],
  [0x100000000n, 31, 0n],
  [0x100000001n, 31, 1n],
  [0x7ffffffffffffffen, 31, 0x7ffffffen],
  [0x7fffffffffffffffn, 31, 0x7fffffffn],
  [-0x8000000000000000n, 32, 0n],
  [-0x7fffffffffffffffn, 32, 1n],
  [-0x7ffffffffffffffen, 32, 2n],
  [-0x100000001n, 32, 0xffffffffn],
  [-0x100000000n, 32, 0n],
  [-0xffffffffn, 32, 1n],
  [-0xfffffffen, 32, 2n],
  [-0x80000001n, 32, 0x7fffffffn],
  [-0x80000000n, 32, 0x80000000n],
  [-0x7fffffffn, 32, 0x80000001n],
  [-0x7ffffffen, 32, 0x80000002n],
  [-9n, 32, 0xfffffff7n],
  [-8n, 32, 0xfffffff8n],
  [-7n, 32, 0xfffffff9n],
  [-6n, 32, 0xfffffffan],
  [-5n, 32, 0xfffffffbn],
  [-4n, 32, 0xfffffffcn],
  [-3n, 32, 0xfffffffdn],
  [-2n, 32, 0xfffffffen],
  [-1n, 32, 0xffffffffn],
  [0n, 32, 0n],
  [1n, 32, 1n],
  [2n, 32, 2n],
  [3n, 32, 3n],
  [4n, 32, 4n],
  [5n, 32, 5n],
  [6n, 32, 6n],
  [7n, 32, 7n],
  [8n, 32, 8n],
  [9n, 32, 9n],
  [0x7ffffffen, 32, 0x7ffffffen],
  [0x7fffffffn, 32, 0x7fffffffn],
  [0x80000000n, 32, 0x80000000n],
  [0x80000001n, 32, 0x80000001n],
  [0xfffffffen, 32, 0xfffffffen],
  [0xffffffffn, 32, 0xffffffffn],
  [0x100000000n, 32, 0n],
  [0x100000001n, 32, 1n],
  [0x7ffffffffffffffen, 32, 0xfffffffen],
  [0x7fffffffffffffffn, 32, 0xffffffffn],
  [-0x8000000000000000n, 33, 0n],
  [-0x7fffffffffffffffn, 33, 1n],
  [-0x7ffffffffffffffen, 33, 2n],
  [-0x100000001n, 33, 0xffffffffn],
  [-0x100000000n, 33, 0x100000000n],
  [-0xffffffffn, 33, 0x100000001n],
  [-0xfffffffen, 33, 0x100000002n],
  [-0x80000001n, 33, 0x17fffffffn],
  [-0x80000000n, 33, 0x180000000n],
  [-0x7fffffffn, 33, 0x180000001n],
  [-0x7ffffffen, 33, 0x180000002n],
  [-9n, 33, 0x1fffffff7n],
  [-8n, 33, 0x1fffffff8n],
  [-7n, 33, 0x1fffffff9n],
  [-6n, 33, 0x1fffffffan],
  [-5n, 33, 0x1fffffffbn],
  [-4n, 33, 0x1fffffffcn],
  [-3n, 33, 0x1fffffffdn],
  [-2n, 33, 0x1fffffffen],
  [-1n, 33, 0x1ffffffffn],
  [0n, 33, 0n],
  [1n, 33, 1n],
  [2n, 33, 2n],
  [3n, 33, 3n],
  [4n, 33, 4n],
  [5n, 33, 5n],
  [6n, 33, 6n],
  [7n, 33, 7n],
  [8n, 33, 8n],
  [9n, 33, 9n],
  [0x7ffffffen, 33, 0x7ffffffen],
  [0x7fffffffn, 33, 0x7fffffffn],
  [0x80000000n, 33, 0x80000000n],
  [0x80000001n, 33, 0x80000001n],
  [0xfffffffen, 33, 0xfffffffen],
  [0xffffffffn, 33, 0xffffffffn],
  [0x100000000n, 33, 0x100000000n],
  [0x100000001n, 33, 0x100000001n],
  [0x7ffffffffffffffen, 33, 0x1fffffffen],
  [0x7fffffffffffffffn, 33, 0x1ffffffffn],
  [-0x8000000000000000n, 63, 0n],
  [-0x7fffffffffffffffn, 63, 1n],
  [-0x7ffffffffffffffen, 63, 2n],
  [-0x100000001n, 63, 0x7ffffffeffffffffn],
  [-0x100000000n, 63, 0x7fffffff00000000n],
  [-0xffffffffn, 63, 0x7fffffff00000001n],
  [-0xfffffffen, 63, 0x7fffffff00000002n],
  [-0x80000001n, 63, 0x7fffffff7fffffffn],
  [-0x80000000n, 63, 0x7fffffff80000000n],
  [-0x7fffffffn, 63, 0x7fffffff80000001n],
  [-0x7ffffffen, 63, 0x7fffffff80000002n],
  [-9n, 63, 0x7ffffffffffffff7n],
  [-8n, 63, 0x7ffffffffffffff8n],
  [-7n, 63, 0x7ffffffffffffff9n],
  [-6n, 63, 0x7ffffffffffffffan],
  [-5n, 63, 0x7ffffffffffffffbn],
  [-4n, 63, 0x7ffffffffffffffcn],
  [-3n, 63, 0x7ffffffffffffffdn],
  [-2n, 63, 0x7ffffffffffffffen],
  [-1n, 63, 0x7fffffffffffffffn],
  [0n, 63, 0n],
  [1n, 63, 1n],
  [2n, 63, 2n],
  [3n, 63, 3n],
  [4n, 63, 4n],
  [5n, 63, 5n],
  [6n, 63, 6n],
  [7n, 63, 7n],
  [8n, 63, 8n],
  [9n, 63, 9n],
  [0x7ffffffen, 63, 0x7ffffffen],
  [0x7fffffffn, 63, 0x7fffffffn],
  [0x80000000n, 63, 0x80000000n],
  [0x80000001n, 63, 0x80000001n],
  [0xfffffffen, 63, 0xfffffffen],
  [0xffffffffn, 63, 0xffffffffn],
  [0x100000000n, 63, 0x100000000n],
  [0x100000001n, 63, 0x100000001n],
  [0x7ffffffffffffffen, 63, 0x7ffffffffffffffen],
  [0x7fffffffffffffffn, 63, 0x7fffffffffffffffn],
  [0n, 64, 0n],
  [1n, 64, 1n],
  [2n, 64, 2n],
  [3n, 64, 3n],
  [4n, 64, 4n],
  [5n, 64, 5n],
  [6n, 64, 6n],
  [7n, 64, 7n],
  [8n, 64, 8n],
  [9n, 64, 9n],
  [0x7ffffffen, 64, 0x7ffffffen],
  [0x7fffffffn, 64, 0x7fffffffn],
  [0x80000000n, 64, 0x80000000n],
  [0x80000001n, 64, 0x80000001n],
  [0xfffffffen, 64, 0xfffffffen],
  [0xffffffffn, 64, 0xffffffffn],
  [0x100000000n, 64, 0x100000000n],
  [0x100000001n, 64, 0x100000001n],
  [0x7ffffffffffffffen, 64, 0x7ffffffffffffffen],
  [0x7fffffffffffffffn, 64, 0x7fffffffffffffffn],
];

function f(tests) {
  for (let test of tests) {
    let input = test[0], bits = test[1], expected = test[2];

    assertEq(BigInt.asUintN(bits, input), expected);
  }
}

for (let i = 0; i < 10; ++i) {
  f(tests);
}
