/*
 * // Copyright (c) Radzivon Bartoshyk 7/2025. All rights reserved.
 * //
 * // Redistribution and use in source and binary forms, with or without modification,
 * // are permitted provided that the following conditions are met:
 * //
 * // 1.  Redistributions of source code must retain the above copyright notice, this
 * // list of conditions and the following disclaimer.
 * //
 * // 2.  Redistributions in binary form must reproduce the above copyright notice,
 * // this list of conditions and the following disclaimer in the documentation
 * // and/or other materials provided with the distribution.
 * //
 * // 3.  Neither the name of the copyright holder nor the names of its
 * // contributors may be used to endorse or promote products derived from
 * // this software without specific prior written permission.
 * //
 * // THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * // AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * // IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * // DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * // FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * // DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * // SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * // CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * // OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * // OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
use crate::dyadic_float::{DyadicFloat128, DyadicSign};

pub(crate) static POW_INVERSE: [u64; 182] = [
    0x3ff6900000000000,
    0x3ff6700000000000,
    0x3ff6500000000000,
    0x3ff6300000000000,
    0x3ff6100000000000,
    0x3ff5f00000000000,
    0x3ff5e00000000000,
    0x3ff5c00000000000,
    0x3ff5a00000000000,
    0x3ff5800000000000,
    0x3ff5600000000000,
    0x3ff5400000000000,
    0x3ff5300000000000,
    0x3ff5100000000000,
    0x3ff4f00000000000,
    0x3ff4e00000000000,
    0x3ff4c00000000000,
    0x3ff4a00000000000,
    0x3ff4800000000000,
    0x3ff4700000000000,
    0x3ff4500000000000,
    0x3ff4400000000000,
    0x3ff4200000000000,
    0x3ff4000000000000,
    0x3ff3f00000000000,
    0x3ff3d00000000000,
    0x3ff3c00000000000,
    0x3ff3a00000000000,
    0x3ff3900000000000,
    0x3ff3700000000000,
    0x3ff3600000000000,
    0x3ff3400000000000,
    0x3ff3300000000000,
    0x3ff3200000000000,
    0x3ff3000000000000,
    0x3ff2f00000000000,
    0x3ff2d00000000000,
    0x3ff2c00000000000,
    0x3ff2b00000000000,
    0x3ff2900000000000,
    0x3ff2800000000000,
    0x3ff2700000000000,
    0x3ff2500000000000,
    0x3ff2400000000000,
    0x3ff2300000000000,
    0x3ff2100000000000,
    0x3ff2000000000000,
    0x3ff1f00000000000,
    0x3ff1e00000000000,
    0x3ff1c00000000000,
    0x3ff1b00000000000,
    0x3ff1a00000000000,
    0x3ff1900000000000,
    0x3ff1700000000000,
    0x3ff1600000000000,
    0x3ff1500000000000,
    0x3ff1400000000000,
    0x3ff1300000000000,
    0x3ff1200000000000,
    0x3ff1000000000000,
    0x3ff0f00000000000,
    0x3ff0e00000000000,
    0x3ff0d00000000000,
    0x3ff0c00000000000,
    0x3ff0b00000000000,
    0x3ff0a00000000000,
    0x3ff0900000000000,
    0x3ff0800000000000,
    0x3ff0700000000000,
    0x3ff0600000000000,
    0x3ff0500000000000,
    0x3ff0400000000000,
    0x3ff0300000000000,
    0x3ff0200000000000,
    0x3ff0000000000000,
    0x3ff0000000000000,
    0x3fefd00000000000,
    0x3fefb00000000000,
    0x3fef900000000000,
    0x3fef700000000000,
    0x3fef500000000000,
    0x3fef300000000000,
    0x3fef100000000000,
    0x3fef000000000000,
    0x3feee00000000000,
    0x3feec00000000000,
    0x3feea00000000000,
    0x3fee800000000000,
    0x3fee600000000000,
    0x3fee500000000000,
    0x3fee300000000000,
    0x3fee100000000000,
    0x3fedf00000000000,
    0x3fedd00000000000,
    0x3fedc00000000000,
    0x3feda00000000000,
    0x3fed800000000000,
    0x3fed700000000000,
    0x3fed500000000000,
    0x3fed300000000000,
    0x3fed200000000000,
    0x3fed000000000000,
    0x3fece00000000000,
    0x3fecd00000000000,
    0x3fecb00000000000,
    0x3fec900000000000,
    0x3fec800000000000,
    0x3fec600000000000,
    0x3fec500000000000,
    0x3fec300000000000,
    0x3fec200000000000,
    0x3fec000000000000,
    0x3febf00000000000,
    0x3febd00000000000,
    0x3febc00000000000,
    0x3feba00000000000,
    0x3feb900000000000,
    0x3feb700000000000,
    0x3feb600000000000,
    0x3feb400000000000,
    0x3feb300000000000,
    0x3feb100000000000,
    0x3feb000000000000,
    0x3feae00000000000,
    0x3fead00000000000,
    0x3feac00000000000,
    0x3feaa00000000000,
    0x3fea900000000000,
    0x3fea700000000000,
    0x3fea600000000000,
    0x3fea500000000000,
    0x3fea300000000000,
    0x3fea200000000000,
    0x3fea100000000000,
    0x3fe9f00000000000,
    0x3fe9e00000000000,
    0x3fe9d00000000000,
    0x3fe9c00000000000,
    0x3fe9a00000000000,
    0x3fe9900000000000,
    0x3fe9800000000000,
    0x3fe9600000000000,
    0x3fe9500000000000,
    0x3fe9400000000000,
    0x3fe9300000000000,
    0x3fe9100000000000,
    0x3fe9000000000000,
    0x3fe8f00000000000,
    0x3fe8e00000000000,
    0x3fe8d00000000000,
    0x3fe8b00000000000,
    0x3fe8a00000000000,
    0x3fe8900000000000,
    0x3fe8800000000000,
    0x3fe8700000000000,
    0x3fe8600000000000,
    0x3fe8400000000000,
    0x3fe8300000000000,
    0x3fe8200000000000,
    0x3fe8100000000000,
    0x3fe8000000000000,
    0x3fe7f00000000000,
    0x3fe7e00000000000,
    0x3fe7c00000000000,
    0x3fe7b00000000000,
    0x3fe7a00000000000,
    0x3fe7900000000000,
    0x3fe7800000000000,
    0x3fe7700000000000,
    0x3fe7600000000000,
    0x3fe7500000000000,
    0x3fe7400000000000,
    0x3fe7300000000000,
    0x3fe7200000000000,
    0x3fe7100000000000,
    0x3fe7000000000000,
    0x3fe6f00000000000,
    0x3fe6e00000000000,
    0x3fe6d00000000000,
    0x3fe6c00000000000,
    0x3fe6b00000000000,
    0x3fe6a00000000000,
];

pub(crate) static POW_LOG_INV: [(u64, u64); 182] = [
    (0xbd2e9e439f105039, 0xbfd5ff3070a79000),
    (0x3cde63af2df7ba69, 0xbfd5a42ab0f4d000),
    (0xbd23167e63081cf7, 0xbfd548a2c3add000),
    (0xbd234d7aaf04d104, 0xbfd4ec9732600000),
    (0x3d38bccffe1a0f8c, 0xbfd4900680401000),
    (0x3d3fb129931715ad, 0xbfd432ef2a04f000),
    (0xbd3f8ef43049f7d3, 0xbfd404308686a000),
    (0xbd37a71cbcd735d0, 0xbfd3a64c55694000),
    (0x3d25594dd4c58092, 0xbfd347dd9a988000),
    (0x3d267b1e99b72bd8, 0xbfd2e8e2bae12000),
    (0xbd3a8d7ad24c13f0, 0xbfd2895a13de8000),
    (0x3d3a6976f5eb0963, 0xbfd22941fbcf8000),
    (0xbd27946c040cbe77, 0xbfd1f8ff9e48a000),
    (0xbd2b7b3a7a361c9a, 0xbfd1980d2dd42000),
    (0x3d3d3e8499d67123, 0xbfd136870293b000),
    (0x3d34ab9d817d52cd, 0xbfd1058bf9ae5000),
    (0xbd0c6bee7ef4030e, 0xbfd0a324e2739000),
    (0xbcf036b89ef42d7f, 0xbfd0402594b4d000),
    (0x3d0d572aab993c87, 0xbfcfb9186d5e4000),
    (0x3d2323e3a09202fe, 0xbfcf550a564b8000),
    (0x3d26805b80e8e6ff, 0xbfce8c0252aa6000),
    (0x3d3a342c2af0003c, 0xbfce27076e2b0000),
    (0x3d21ba91bbca681b, 0xbfcd5c216b4fc000),
    (0x3d27794f689f8434, 0xbfcc8ff7c79aa000),
    (0x3d2cfd73dee38a40, 0xbfcc2968558c2000),
    (0x3d34b722ec011f31, 0xbfcb5b519e8fc000),
    (0x3cba4e633fcd9066, 0xbfcaf3c94e80c000),
    (0x3d3539cd91dc9f0b, 0xbfca23bc1fe2c000),
    (0x3d21f2a8a1ce0ffc, 0xbfc9bb362e7e0000),
    (0xbd3a8154b13d72d5, 0xbfc8e928de886000),
    (0xbd322120401202fc, 0xbfc87fa06520c000),
    (0x3d2bdb9072534a58, 0xbfc7ab890210e000),
    (0x3d30b66c99018aa1, 0xbfc740f8f5404000),
    (0x3d3bc6e557134767, 0xbfc6d60fe719e000),
    (0x3d38586f183bebf2, 0xbfc5ff3070a7a000),
    (0xbcf0ba68b7555d4a, 0xbfc59338d9982000),
    (0x3d34354bb3f219e5, 0xbfc4ba36f39a6000),
    (0x3d170cc16135783c, 0xbfc44d2b6ccb8000),
    (0xbd28a72a62b8c13f, 0xbfc3dfc2b0ecc000),
    (0x3cd680b5ce3ecb05, 0xbfc303d718e48000),
    (0x3d35b967f4471dfc, 0xbfc29552f8200000),
    (0x3d24d20ab840e7f6, 0xbfc2266f190a6000),
    (0xbd1563451027c750, 0xbfc1478584674000),
    (0xbd3cb2cd2ee2f482, 0xbfc0d77e7cd08000),
    (0x3d2a47579cdc0a3d, 0xbfc0671512ca6000),
    (0x3d3d599e83368e91, 0xbfbf0a30c0118000),
    (0x3d2a342c2af0003c, 0xbfbe27076e2b0000),
    (0x3d29454379135713, 0xbfbd4313d66cc000),
    (0xbd1d0c57585fbe06, 0xbfbc5e548f5bc000),
    (0xbd3563650bd22a9c, 0xbfba926d3a4ac000),
    (0x3d28a64826787061, 0xbfb9ab4246204000),
    (0xbd3b20f5acb42a66, 0xbfb8c345d6318000),
    (0xbd32cc844480c89b, 0xbfb7da766d7b0000),
    (0xbd30c3b1dee9c4f8, 0xbfb60658a9374000),
    (0xbd383f69278e686a, 0xbfb51b073f060000),
    (0xbd1bc0eeea7c9acd, 0xbfb42edcbea64000),
    (0xbd31d09299837610, 0xbfb341d7961bc000),
    (0xbd3416f8fb69a701, 0xbfb253f62f0a0000),
    (0x3d147c5e768fa309, 0xbfb16536eea38000),
    (0x3d2d599e83368e91, 0xbfaf0a30c0118000),
    (0xbd16a423c78a64b0, 0xbfad276b8adb0000),
    (0x3d1c827ae5d6704c, 0xbfab42dd71198000),
    (0x3d2c148297c5feb8, 0xbfa95c830ec90000),
    (0x3d3181dce586af09, 0xbfa77458f6330000),
    (0x3d2b2b739570ad39, 0xbfa58a5bafc90000),
    (0xbd3eafd480ad9015, 0xbfa39e87b9fe8000),
    (0x3d33401e9ae889bb, 0xbfa1b0d989240000),
    (0xbd2980267c7e09e4, 0xbf9f829b0e780000),
    (0x3d3b9a010ae6922a, 0xbf9b9fc027b00000),
    (0x3d33b955b602ace4, 0xbf97b91b07d60000),
    (0x3d36a2c432d6a40b, 0xbf93cea443470000),
    (0xbcdf1e7cf6d3a69c, 0xbf8fc0a8b0fc0000),
    (0x3d3eb1245b5da1f5, 0xbf87dc475f820000),
    (0xbd19e23f0dda40e4, 0xbf7fe02a6b100000),
    (0x0000000000000000, 0x0000000000000000),
    (0x0000000000000000, 0x0000000000000000),
    (0x3d1ad50382973f27, 0x3f78121214580000),
    (0x3d1977c755d01368, 0x3f841929f9680000),
    (0xbd341f33fcefb9fe, 0x3f8c317384c80000),
    (0x3d2713e3284991fe, 0x3f9228fb1fea0000),
    (0x3d07abf389596542, 0x3f963d6178690000),
    (0xbd2de0709f2d03c9, 0x3f9a55f548c60000),
    (0xbd28d75149774d47, 0x3f9e72bf28140000),
    (0xbd3dddc7f461c516, 0x3fa0415d89e78000),
    (0x3d283e9ae021b67b, 0x3fa252f32f8d0000),
    (0xbd2c167375bdfd28, 0x3fa466aed42e0000),
    (0x3d3dac20827cca0c, 0x3fa67c94f2d48000),
    (0x3d39a19a8be97661, 0x3fa894aa149f8000),
    (0x3d20fc1a353bb42e, 0x3faaaef2d0fb0000),
    (0xbd17bf868c317c2a, 0x3fabbcebfc690000),
    (0xbd21b1ac64d9e42f, 0x3fadda8adc680000),
    (0x3d23008c98381a8f, 0x3faffa6911ab8000),
    (0xbd37cf69284a3465, 0x3fb10e45b3cb0000),
    (0x3d349d8cfc10c7bf, 0x3fb2207b5c784000),
    (0x3d37a48ba8b1cb41, 0x3fb2aa04a4470000),
    (0xbd319bd0ad125895, 0x3fb3bdf5a7d20000),
    (0xbcf53a2582f4e1ef, 0x3fb4d3115d208000),
    (0x3d0c1d740c53c72e, 0x3fb55e10050e0000),
    (0x3d3a79994c9d3302, 0x3fb674f089364000),
    (0x3d069b5794b69fb7, 0x3fb78d02263d8000),
    (0xbd3c0fe460d20041, 0x3fb8197e2f410000),
    (0x3d23115c3abd47da, 0x3fb9335e5d594000),
    (0xbd0e42b6b94407c8, 0x3fba4e7640b1c000),
    (0xbd3573b209c31904, 0x3fbadc77ee5b0000),
    (0x3d24218c8d824283, 0x3fbbf968769fc000),
    (0x3d336433b5efbeed, 0x3fbd179788218000),
    (0x3d1a89401fa71733, 0x3fbda72763844000),
    (0x3d311fcba80cdd10, 0x3fbec739830a0000),
    (0x3d176a6c9ea8b04e, 0x3fbf57bc7d900000),
    (0x3d381a9cf169fc5c, 0x3fc03cdc0a51e000),
    (0xbd27e5dd7009902c, 0x3fc08598b59e4000),
    (0x3d21ef78ce2d07f2, 0x3fc1178e8227e000),
    (0x3d2ec2d2a9009e3d, 0x3fc160c8024b2000),
    (0xbd15f74e9b083633, 0x3fc1f3b925f26000),
    (0x3d100d238fd3df5c, 0x3fc23d712a49c000),
    (0x3d039d6ccb81b4a1, 0x3fc2d1610c868000),
    (0x3d3f098ee3a50810, 0x3fc31b994d3a4000),
    (0xbd3aade8f29320fb, 0x3fc3b08b67580000),
    (0x3d319713c0cae559, 0x3fc3fb45a5992000),
    (0xbd353e43558124c4, 0x3fc4913d8333c000),
    (0x3d0c79b60ae1ff0f, 0x3fc4dc7b897bc000),
    (0x3d39baa7a6b887f6, 0x3fc5737cc9018000),
    (0xbd127023eb68981c, 0x3fc5bf406b544000),
    (0xbd398c1d34f0f462, 0x3fc6574ebe8c2000),
    (0xbd38f934e66a15a6, 0x3fc6a399dabbe000),
    (0x3d3577390d31ef0f, 0x3fc6f0128b756000),
    (0x3d38e67be3dbaf3f, 0x3fc7898d85444000),
    (0xbd24c06b17c301d7, 0x3fc7d6903caf6000),
    (0x3d3328eb42f9af75, 0x3fc871213750e000),
    (0xbd073d54aae92cd1, 0x3fc8beafeb390000),
    (0xbd1935f57718d7ca, 0x3fc90c6db9fcc000),
    (0x3d3470fa3efec390, 0x3fc9a8778deba000),
    (0xbd3337d94bcd3f43, 0x3fc9f6c40708a000),
    (0x3d360a77c81f7171, 0x3fca454082e6a000),
    (0x3d37a8d5ae54f550, 0x3fcae2ca6f672000),
    (0x3d3c794e562a63cb, 0x3fcb31d8575bc000),
    (0x3d1e90683b9cd768, 0x3fcb811730b82000),
    (0xbd2d4bc4595412b6, 0x3fcbd087383be000),
    (0x3d3ee138d3a69d43, 0x3fcc6ffbc6f00000),
    (0xbd1d6d585d57aff9, 0x3fccc000c9db4000),
    (0xbd084a7e75b6f6e4, 0x3fcd1037f2656000),
    (0x3d32806a847527e6, 0x3fcdb13db0d48000),
    (0xbd252b00adb91424, 0x3fce020cc6236000),
    (0xbd3fdbdbb13f7c18, 0x3fce530effe72000),
    (0x3d35e91663732a36, 0x3fcea4449f04a000),
    (0xbd3bae49f1df7b5e, 0x3fcf474b134e0000),
    (0xbd390d04cd7cc834, 0x3fcf991c6cb3c000),
    (0x3d2f3418de00938b, 0x3fcfeb2233ea0000),
    (0x3d3a43dcfade85ae, 0x3fd01eae5626c000),
    (0x3d2dbdf10d397f3c, 0x3fd047e60cde8000),
    (0x3d3b50a1e1734342, 0x3fd09aa572e6c000),
    (0x3d27188b163ceae9, 0x3fd0c42d67616000),
    (0x3d0019b52d8435f5, 0x3fd0edd060b78000),
    (0x3d31ef78ce2d07f2, 0x3fd1178e8227e000),
    (0x3d3e0c07824daaf5, 0x3fd14167ef367000),
    (0xbd323299042d74bf, 0x3fd16b5ccbad0000),
    (0xbd31ac89575c2125, 0x3fd1bf99635a7000),
    (0xbd382eaed3c8b65e, 0x3fd1e9e16788a000),
    (0xbd3caf0428b728a3, 0x3fd214456d0ec000),
    (0xbd36dbe448a2e522, 0x3fd23ec5991ec000),
    (0xbd31b61f10522625, 0x3fd269621134e000),
    (0xbd3210c2b730e28b, 0x3fd2941afb187000),
    (0x3d2a9cfa4a5004f4, 0x3fd2bef07cdc9000),
    (0xbd28e27ad3213cb8, 0x3fd314f1e1d36000),
    (0xbd317c73556e291d, 0x3fd3401e12aed000),
    (0x3d116ecdb0f177c8, 0x3fd36b6776be1000),
    (0xbd05839c5663663d, 0x3fd396ce359bc000),
    (0x3d183b54b606bd5c, 0x3fd3c25277333000),
    (0xbd3f067c297f2c3f, 0x3fd3edf463c17000),
    (0xbd3ce379226de3ec, 0x3fd419b423d5f000),
    (0xbd06e95892923d88, 0x3fd44591e053a000),
    (0x3d306c18fb4c14c5, 0x3fd4718dc271c000),
    (0x3d307b334daf4b9a, 0x3fd49da7f3bcc000),
    (0xbd2e20891b0ad8a4, 0x3fd4c9e09e173000),
    (0xbd3fc158cb3124b9, 0x3fd4f637ebbaa000),
    (0x3d2ebe708164c759, 0x3fd522ae0738a000),
    (0x3d1a8954c0910952, 0x3fd54f431b7be000),
    (0x3d1fadedee5d40ef, 0x3fd57bf753c8d000),
    (0xbcf7c79b0af7ecf8, 0x3fd5a8cadbbee000),
    (0xbd0a0b2a08a465dc, 0x3fd5d5bddf596000),
    (0x3d1ebe9176df3f65, 0x3fd602d08af09000),
    (0xbd2db623e731ae00, 0x3fd630030b3ab000),
];

pub(crate) static EXP2_MID1: [(u64, u64); 64] = [
    (0x0000000000000000, 0x3ff0000000000000),
    (0xbc719083535b085d, 0x3ff02c9a3e778061),
    (0x3c8d73e2a475b465, 0x3ff059b0d3158574),
    (0x3c6186be4bb284ff, 0x3ff0874518759bc8),
    (0x3c98a62e4adc610b, 0x3ff0b5586cf9890f),
    (0x3c403a1727c57b53, 0x3ff0e3ec32d3d1a2),
    (0xbc96c51039449b3a, 0x3ff11301d0125b51),
    (0xbc932fbf9af1369e, 0x3ff1429aaea92de0),
    (0xbc819041b9d78a76, 0x3ff172b83c7d517b),
    (0x3c8e5b4c7b4968e4, 0x3ff1a35beb6fcb75),
    (0x3c9e016e00a2643c, 0x3ff1d4873168b9aa),
    (0x3c8dc775814a8495, 0x3ff2063b88628cd6),
    (0x3c99b07eb6c70573, 0x3ff2387a6e756238),
    (0x3c82bd339940e9d9, 0x3ff26b4565e27cdd),
    (0x3c8612e8afad1255, 0x3ff29e9df51fdee1),
    (0x3c90024754db41d5, 0x3ff2d285a6e4030b),
    (0x3c86f46ad23182e4, 0x3ff306fe0a31b715),
    (0x3c932721843659a6, 0x3ff33c08b26416ff),
    (0xbc963aeabf42eae2, 0x3ff371a7373aa9cb),
    (0xbc75e436d661f5e3, 0x3ff3a7db34e59ff7),
    (0x3c8ada0911f09ebc, 0x3ff3dea64c123422),
    (0xbc5ef3691c309278, 0x3ff4160a21f72e2a),
    (0x3c489b7a04ef80d0, 0x3ff44e086061892d),
    (0x3c73c1a3b69062f0, 0x3ff486a2b5c13cd0),
    (0x3c7d4397afec42e2, 0x3ff4bfdad5362a27),
    (0xbc94b309d25957e3, 0x3ff4f9b2769d2ca7),
    (0xbc807abe1db13cad, 0x3ff5342b569d4f82),
    (0x3c99bb2c011d93ad, 0x3ff56f4736b527da),
    (0x3c96324c054647ad, 0x3ff5ab07dd485429),
    (0x3c9ba6f93080e65e, 0x3ff5e76f15ad2148),
    (0xbc9383c17e40b497, 0x3ff6247eb03a5585),
    (0xbc9bb60987591c34, 0x3ff6623882552225),
    (0xbc9bdd3413b26456, 0x3ff6a09e667f3bcd),
    (0xbc6bbe3a683c88ab, 0x3ff6dfb23c651a2f),
    (0xbc816e4786887a99, 0x3ff71f75e8ec5f74),
    (0xbc90245957316dd3, 0x3ff75feb564267c9),
    (0xbc841577ee04992f, 0x3ff7a11473eb0187),
    (0x3c705d02ba15797e, 0x3ff7e2f336cf4e62),
    (0xbc9d4c1dd41532d8, 0x3ff82589994cce13),
    (0xbc9fc6f89bd4f6ba, 0x3ff868d99b4492ed),
    (0x3c96e9f156864b27, 0x3ff8ace5422aa0db),
    (0x3c85cc13a2e3976c, 0x3ff8f1ae99157736),
    (0xbc675fc781b57ebc, 0x3ff93737b0cdc5e5),
    (0xbc9d185b7c1b85d1, 0x3ff97d829fde4e50),
    (0x3c7c7c46b071f2be, 0x3ff9c49182a3f090),
    (0xbc9359495d1cd533, 0x3ffa0c667b5de565),
    (0xbc9d2f6edb8d41e1, 0x3ffa5503b23e255d),
    (0x3c90fac90ef7fd31, 0x3ffa9e6b5579fdbf),
    (0x3c97a1cd345dcc81, 0x3ffae89f995ad3ad),
    (0xbc62805e3084d708, 0x3ffb33a2b84f15fb),
    (0xbc75584f7e54ac3b, 0x3ffb7f76f2fb5e47),
    (0x3c823dd07a2d9e84, 0x3ffbcc1e904bc1d2),
    (0x3c811065895048dd, 0x3ffc199bdd85529c),
    (0x3c92884dff483cad, 0x3ffc67f12e57d14b),
    (0x3c7503cbd1e949db, 0x3ffcb720dcef9069),
    (0xbc9cbc3743797a9c, 0x3ffd072d4a07897c),
    (0x3c82ed02d75b3707, 0x3ffd5818dcfba487),
    (0x3c9c2300696db532, 0x3ffda9e603db3285),
    (0xbc91a5cd4f184b5c, 0x3ffdfc97337b9b5f),
    (0x3c839e8980a9cc8f, 0x3ffe502ee78b3ff6),
    (0xbc9e9c23179c2893, 0x3ffea4afa2a490da),
    (0x3c9dc7f486a4b6b0, 0x3ffefa1bee615a27),
    (0x3c99d3e12dd8a18b, 0x3fff50765b6e4540),
    (0x3c874853f3a5931e, 0x3fffa7c1819e90d8),
];

/* for 0 <= i < 64, T1_2[i] is a 128-bit nearest approximation of 2^(i/64),
with error bounded by 2^-128 (both absolutely and relatively). */
#[rustfmt::skip]
pub(crate) static EXP_T1_2_DYADIC: [DyadicFloat128; 64] = [
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8000_0000_0000_0000_0000_0000_0000_0000_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8164_d1f3_bc03_0773_7be5_6527_bd14_def5_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x82cd_8698_ac2b_a1d7_3e2a_475b_4652_0bff_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x843a_28c3_acde_4046_1af9_2eca_13fd_1582_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x85aa_c367_cc48_7b14_c5c9_5b8c_2154_c1b2_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x871f_6196_9e8d_1010_3a17_27c5_7b52_a956_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8898_0e80_92da_8527_5df8_d76c_98c6_7563_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8a14_d575_496e_fd9a_080c_a1d9_2c36_80c2_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8b95_c1e3_ea8b_d6e6_fbe4_6287_58a5_3c90_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8d1a_df5b_7e5b_a9e5_b4c7_b496_8e41_ad36_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8ea4_398b_45cd_53c0_2dc0_144c_8783_d4c6_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x9031_dc43_1466_b1dc_7758_14a8_494e_87e2_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x91c3_d373_ab11_c336_0fd6_d8e0_ae5a_c9d8_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x935a_2b2f_13e6_e92b_d339_940e_9d92_4ee7_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x94f4_efa8_fef7_0961_2e8a_fad1_2551_de54_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x9694_2d37_2018_5a00_48ea_9b68_3a9c_22c5_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x9837_f051_8db8_a96f_46ad_2318_2e42_f6f6_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x99e0_4593_20b7_fa64_e430_86cb_34b5_fcaf_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x9b8d_39b9_d54e_5538_a2a8_17a2_a3cc_3f1f_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x9d3e_d9a7_2cff_b750_de49_4cf0_50e9_9b0b_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x9ef5_3260_91a1_11ad_a091_1f09_ebb9_fdd1_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xa0b0_510f_b971_4fc2_192d_c79e_db0f_d9a9_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xa270_4303_0c49_6818_9b7a_04ef_80cf_dea8_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xa435_15ae_09e6_809e_0d1d_b483_1781_e1ef_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xa5fe_d6a9_b151_38ea_1cbd_7f62_1710_701b_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xa7cd_93b4_e965_3569_9ec5_b4d5_039f_72af_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xa9a1_5ab4_ea7c_0ef8_541e_24ec_3531_fa73_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xab7a_39b5_a93e_d337_6580_23b2_759e_0079_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xad58_3eea_42a1_4ac6_4980_a8c8_f59a_2ec4_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xaf3b_78ad_690a_4374_df26_101c_cbb3_5033_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xb123_f581_d2ac_258f_87d0_37e9_6d21_5d8e_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xb311_c412_a911_2489_3ecf_14dc_798a_519c_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xb504_f333_f9de_6484_597d_89b3_754a_be9f_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xb6fd_91e3_28d1_7791_0716_5f0d_dd54_1a5a_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xb8fb_af47_62fb_9ee9_1b87_9778_566b_65a2_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xbaff_5ab2_133e_45fb_74d5_19d2_4593_838c_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xbd08_a39f_580c_36be_a881_1fb6_6d0f_af7a_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xbf17_99b6_7a73_1082_e815_d0ab_cbf0_b851_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xc12c_4cca_6670_9456_7c45_7d59_a500_87b5_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xc346_ccda_2497_6407_20ec_8561_28b8_3a42_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xc567_2a11_5506_dadd_3e2a_d0c9_64dd_9f37_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xc78d_74c8_abb9_b15c_c13a_2e39_76c0_277e_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xc9b9_bd86_6e2f_27a2_80e1_f92a_0511_697e_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xcbec_14fe_f272_7c5c_f490_7c8f_45eb_f6dd_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xce24_8c15_1f84_80e3_e235_838f_95f2_c6ed_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xd063_33da_ef2b_2594_d6d4_5c65_59a4_d502_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xd2a8_1d91_f12a_e45a_1224_8e57_c3de_4028_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xd4f3_5aab_cfed_fa1f_5921_deff_a626_2c5b_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xd744_fcca_d69d_6af4_39a6_8bb9_902d_3fde_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xd99d_15c2_78af_d7b5_fe87_3dec_a3e1_2bac_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xdbfb_b797_daf2_3755_3d84_0d5a_9e29_aa64_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xde60_f482_5e0e_9123_dd07_a2d9_e846_6859_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xe0cc_deec_2a94_e111_0658_9504_8dd3_33ca_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xe33f_8972_be8a_5a51_09bf_e907_9598_0eed_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xe5b9_06e7_7c83_48a8_1e5e_8f4a_4edb_b0ed_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xe839_6a50_3c4b_dc68_7917_90d0_ac70_c7de_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xeac0_c6e7_dd24_392e_d02d_75b3_706e_54fb_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xed4f_301e_d994_2b84_600d_2db6_a64b_fb12_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xefe4_b99b_dcda_f5cb_4656_1cf6_948d_b913_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xf281_773c_59ff_b139_e898_0a9c_c8f4_7a4b_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xf525_7d15_2486_cc2c_7b9d_0c7a_ed98_0fc3_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xf7d0_df73_0ad1_3bb8_fe90_d496_d60f_b6eb_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xfa83_b2db_722a_033a_7c25_bb14_315d_7fcd_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0xfd3e_0c0c_f486_c174_853f_3a59_31e0_ee03_u128,
    },
];

/* for 0 <= i < 64, T2_2[i] is a 128-bit nearest approximation of 2^(i/2^12),
with error bounded by 2^-128 (both absolutely and relatively). */
#[rustfmt::skip]
pub(crate) static EXP_T2_2_DYADIC: [DyadicFloat128; 64] = [
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8000_0000_0000_0000_0000_0000_0000_0000_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8005_8baf_7fee_3b5d_1c71_8b38_e549_cb93_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x800b_179c_8202_8fd0_945e_54e2_ae18_f2f0_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8010_a3c7_08e7_3282_2b96_d62d_51c1_5a07_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8016_302f_1746_7628_3690_dfe4_4d11_d008_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x801b_bcd4_afca_cb08_e23a_986b_d3e6_26f0_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8021_49b7_d51e_befb_7bdb_adbc_888a_eb29_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8026_d6d8_89ec_fd69_b904_bbfb_40d3_a2b7_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x802c_6436_d0e0_4f50_ff8c_e94a_6797_b3ce_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8031_f1d2_aca3_9b43_ad9d_b772_901d_96b6_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8037_7fac_1fe1_e56a_61cd_0bff_d7cf_c683_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x803d_0dc3_2d46_4f85_4345_6f71_b96a_ffd4_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8042_9c17_d77c_18ed_49fc_841a_fba9_c3c6_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8048_2aaa_212e_9e95_86f7_b54f_6c45_c85e_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x804d_b97a_0d09_5b0c_6c9f_1f7d_1efc_fe68_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8053_4887_9db7_e67d_171e_b1ce_ef1d_1f28_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8058_d7d2_d5e5_f6b0_94d5_89f6_08ee_4aa2_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x805e_675b_b83f_5f0f_2ed3_8ab8_472b_2144_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8063_f722_4770_10a1_b165_2de1_378a_f1a1_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8069_8726_8624_1a12_b4ad_9233_a039_0cad_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x806f_1768_7707_a7af_e54e_c5f9_66eb_1872_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8074_a7e8_1cc7_036b_4d20_4ecf_c11f_4aab_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x807a_38a5_7a0e_94dc_9bf3_ef4d_9be2_d1e4_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x807f_c9a0_918a_e142_7068_ab22_3058_5d13_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8085_5ad9_65e8_8b83_a0cc_0a49_c10e_a66b_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x808a_ec4f_f9d4_5430_8409_9bf6_830f_2768_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8090_7e04_4ffb_1984_3aa8_b9cb_bc65_a8ab_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8096_0ff6_6b09_d765_f7d8_8c09_28ba_3947_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x809b_a226_4dad_a76a_4a8a_4f44_bb70_3db6_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x80a1_3493_fa93_c0d4_6699_dc50_dd96_b774_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x80a6_c73f_7469_7897_6e04_72ed_4ccf_a2e0_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x80ac_5a28_bddc_4157_ba2d_c7e0_c72e_51ba_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x80b1_ed4f_d999_ab6c_2533_5719_b6e6_fd20_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x80b7_80b4_ca4f_64df_534d_fa74_1784_6aa4_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x80bd_1457_92ab_3970_fc41_c5c2_d533_6ccc_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x80c2_a838_355b_1297_34dc_28ba_ed8f_3fde_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x80c8_3c56_b50c_f77f_b880_575e_a035_48c1_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x80cd_d0b3_146f_0d11_32c1_f987_0442_8c71_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x80d3_654d_562f_95ec_890e_222a_5eb9_5372_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x80d8_fa25_7cfc_f26e_2462_8efd_9ca9_d59b_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x80de_8f3b_8b85_a0af_3b13_310f_5ad5_7fb1_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x80e4_248f_8478_3c87_1a9d_fefa_eb61_6564_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x80e9_ba21_6a83_7f8c_718d_1151_d109_bf98_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x80ef_4ff1_4056_4116_9967_09da_2e25_f04c_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x80f4_e5ff_089f_763e_e0ad_c640_acaa_6b0b_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x80fa_7c4a_c60e_31e1_d4eb_5edc_6b34_1283_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8100_12d4_7b51_a4a0_8ccd_7223_8207_19e3_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8105_a99c_2b19_1ce1_f24e_bd6e_b9ca_4292_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x810b_40a1_d814_06d4_0cef_03ab_14a6_6550_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8110_d7e5_84f1_ec6d_4bf9_4297_d151_9822_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8116_6f67_3462_756d_d0d8_372f_966c_f15e_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x811c_0726_e915_6760_b979_31db_7b7b_e2ec_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8121_9f24_a5ba_a59d_6abd_3b0e_ab9c_7048_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8127_3760_6d02_3148_daf8_88e9_6508_151a_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x812c_cfda_419c_2956_dc80_4682_1f46_122e_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8132_6892_2638_ca8b_6846_ad73_a8d9_027f_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8138_0188_1d88_6f7b_e885_724f_1413_1287_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x813d_9abc_2a3b_9090_8376_8490_519d_f895_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8143_342e_4f02_c405_661b_22b4_5e25_de18_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8148_cdde_8e8e_bdec_0f11_430f_ef78_c6ee_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x814e_67cc_eb90_502c_9977_5205_944e_adc4_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8154_01f9_68b8_6a87_07de_463a_40d1_8261_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x8159_9c64_08b8_1a94_8f4a_0b67_48df_7960_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -127,
        mantissa: 0x815f_370c_ce40_8bc8_e240_4468_cfe5_ab9f_u128,
    },
];
