/*
 * // Copyright (c) Radzivon Bartoshyk 6/2025. All rights reserved.
 * //
 * // Redistribution and use in source and binary forms, with or without modification,
 * // are permitted provided that the following conditions are met:
 * //
 * // 1.  Redistributions of source code must retain the above copyright notice, this
 * // list of conditions and the following disclaimer.
 * //
 * // 2.  Redistributions in binary form must reproduce the above copyright notice,
 * // this list of conditions and the following disclaimer in the documentation
 * // and/or other materials provided with the distribution.
 * //
 * // 3.  Neither the name of the copyright holder nor the names of its
 * // contributors may be used to endorse or promote products derived from
 * // this software without specific prior written permission.
 * //
 * // THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * // AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * // IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * // DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * // FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * // DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * // SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * // CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * // OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * // OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
use crate::dyadic_float::{DyadicFloat128, DyadicSign};

// Logarithm range reduction - Step 3:
//   s(k) = 2^-21 round( 2^21 / (1 + k*2^-21) ) - 1 for k = -69 .. 69
// Output range:
//   [-0x1.012bb800000800114p-22, 0x1p-22 ]
pub(crate) static LOG1P_S3: [u64; 139] = [
    0x3f01400000000000,
    0x3f01000000000000,
    0x3f00c00000000000,
    0x3f00800000000000,
    0x3f00400000000000,
    0x3f00000000000000,
    0x3eff800000000000,
    0x3eff000000000000,
    0x3efe800000000000,
    0x3efe000000000000,
    0x3efd800000000000,
    0x3efd000000000000,
    0x3efc800000000000,
    0x3efc000000000000,
    0x3efb800000000000,
    0x3efb000000000000,
    0x3efa800000000000,
    0x3efa000000000000,
    0x3ef9800000000000,
    0x3ef9000000000000,
    0x3ef8800000000000,
    0x3ef8000000000000,
    0x3ef7800000000000,
    0x3ef7000000000000,
    0x3ef6800000000000,
    0x3ef6000000000000,
    0x3ef5800000000000,
    0x3ef5000000000000,
    0x3ef4800000000000,
    0x3ef4000000000000,
    0x3ef3800000000000,
    0x3ef3000000000000,
    0x3ef2800000000000,
    0x3ef2000000000000,
    0x3ef1800000000000,
    0x3ef1000000000000,
    0x3ef0800000000000,
    0x3ef0000000000000,
    0x3eef000000000000,
    0x3eee000000000000,
    0x3eed000000000000,
    0x3eec000000000000,
    0x3eeb000000000000,
    0x3eea000000000000,
    0x3ee9000000000000,
    0x3ee8000000000000,
    0x3ee7000000000000,
    0x3ee6000000000000,
    0x3ee5000000000000,
    0x3ee4000000000000,
    0x3ee3000000000000,
    0x3ee2000000000000,
    0x3ee1000000000000,
    0x3ee0000000000000,
    0x3ede000000000000,
    0x3edc000000000000,
    0x3eda000000000000,
    0x3ed8000000000000,
    0x3ed6000000000000,
    0x3ed4000000000000,
    0x3ed2000000000000,
    0x3ed0000000000000,
    0x3ecc000000000000,
    0x3ec8000000000000,
    0x3ec4000000000000,
    0x3ec0000000000000,
    0x3eb8000000000000,
    0x3eb0000000000000,
    0x3ea0000000000000,
    0x0000000000000000,
    0xbea0000000000000,
    0xbeb0000000000000,
    0xbeb8000000000000,
    0xbec0000000000000,
    0xbec4000000000000,
    0xbec8000000000000,
    0xbecc000000000000,
    0xbed0000000000000,
    0xbed2000000000000,
    0xbed4000000000000,
    0xbed6000000000000,
    0xbed8000000000000,
    0xbeda000000000000,
    0xbedc000000000000,
    0xbede000000000000,
    0xbee0000000000000,
    0xbee1000000000000,
    0xbee2000000000000,
    0xbee3000000000000,
    0xbee4000000000000,
    0xbee5000000000000,
    0xbee6000000000000,
    0xbee7000000000000,
    0xbee8000000000000,
    0xbee9000000000000,
    0xbeea000000000000,
    0xbeeb000000000000,
    0xbeec000000000000,
    0xbeed000000000000,
    0xbeee000000000000,
    0xbeef000000000000,
    0xbef0000000000000,
    0xbef0800000000000,
    0xbef1000000000000,
    0xbef1800000000000,
    0xbef2000000000000,
    0xbef2800000000000,
    0xbef3000000000000,
    0xbef3800000000000,
    0xbef4000000000000,
    0xbef4800000000000,
    0xbef5000000000000,
    0xbef5800000000000,
    0xbef6000000000000,
    0xbef6800000000000,
    0xbef7000000000000,
    0xbef7800000000000,
    0xbef8000000000000,
    0xbef8800000000000,
    0xbef9000000000000,
    0xbef9800000000000,
    0xbefa000000000000,
    0xbefa800000000000,
    0xbefb000000000000,
    0xbefb800000000000,
    0xbefc000000000000,
    0xbefc800000000000,
    0xbefd000000000000,
    0xbefd800000000000,
    0xbefe000000000000,
    0xbefe800000000000,
    0xbeff000000000000,
    0xbeff800000000000,
    0xbf00000000000000,
    0xbf00400000000000,
    0xbf00800000000000,
    0xbf00c00000000000,
    0xbf01000000000000,
    0xbf01400000000000,
];

// Logarithm range reduction - Step 2:
//   s(k) = 2^-18 round( 2^18 / (1 + k*2^-14) ) - 1 for k = -91 .. 96
// Output range:
//   [-0x1.1037c00000040271p-15 , 0x1.108480000008096cp-15]
pub(crate) static LOG1P_S2: [u64; 188] = [
    0x3f76e00000000000,
    0x3f76a00000000000,
    0x3f76600000000000,
    0x3f76200000000000,
    0x3f75dc0000000000,
    0x3f759c0000000000,
    0x3f755c0000000000,
    0x3f751c0000000000,
    0x3f74dc0000000000,
    0x3f749c0000000000,
    0x3f74580000000000,
    0x3f74180000000000,
    0x3f73d80000000000,
    0x3f73980000000000,
    0x3f73580000000000,
    0x3f73180000000000,
    0x3f72d80000000000,
    0x3f72940000000000,
    0x3f72540000000000,
    0x3f72140000000000,
    0x3f71d40000000000,
    0x3f71940000000000,
    0x3f71540000000000,
    0x3f71140000000000,
    0x3f70d00000000000,
    0x3f70900000000000,
    0x3f70500000000000,
    0x3f70100000000000,
    0x3f6fa00000000000,
    0x3f6f200000000000,
    0x3f6ea00000000000,
    0x3f6e200000000000,
    0x3f6d980000000000,
    0x3f6d180000000000,
    0x3f6c980000000000,
    0x3f6c180000000000,
    0x3f6b980000000000,
    0x3f6b180000000000,
    0x3f6a980000000000,
    0x3f6a180000000000,
    0x3f69980000000000,
    0x3f69100000000000,
    0x3f68900000000000,
    0x3f68100000000000,
    0x3f67900000000000,
    0x3f67100000000000,
    0x3f66900000000000,
    0x3f66100000000000,
    0x3f65900000000000,
    0x3f65100000000000,
    0x3f64900000000000,
    0x3f64100000000000,
    0x3f63880000000000,
    0x3f63080000000000,
    0x3f62880000000000,
    0x3f62080000000000,
    0x3f61880000000000,
    0x3f61080000000000,
    0x3f60880000000000,
    0x3f60080000000000,
    0x3f5f100000000000,
    0x3f5e100000000000,
    0x3f5d100000000000,
    0x3f5c100000000000,
    0x3f5b100000000000,
    0x3f5a100000000000,
    0x3f59100000000000,
    0x3f58100000000000,
    0x3f57100000000000,
    0x3f56000000000000,
    0x3f55000000000000,
    0x3f54000000000000,
    0x3f53000000000000,
    0x3f52000000000000,
    0x3f51000000000000,
    0x3f50000000000000,
    0x3f4e000000000000,
    0x3f4c000000000000,
    0x3f4a000000000000,
    0x3f48000000000000,
    0x3f46000000000000,
    0x3f44000000000000,
    0x3f42000000000000,
    0x3f40000000000000,
    0x3f3c000000000000,
    0x3f38000000000000,
    0x3f34000000000000,
    0x3f30000000000000,
    0x3f28000000000000,
    0x3f20000000000000,
    0x3f10000000000000,
    0x0000000000000000,
    0xbf10000000000000,
    0xbf20000000000000,
    0xbf28000000000000,
    0xbf30000000000000,
    0xbf34000000000000,
    0xbf38000000000000,
    0xbf3c000000000000,
    0xbf40000000000000,
    0xbf42000000000000,
    0xbf44000000000000,
    0xbf46000000000000,
    0xbf48000000000000,
    0xbf4a000000000000,
    0xbf4c000000000000,
    0xbf4e000000000000,
    0xbf50000000000000,
    0xbf51000000000000,
    0xbf52000000000000,
    0xbf53000000000000,
    0xbf54000000000000,
    0xbf55000000000000,
    0xbf56000000000000,
    0xbf56f00000000000,
    0xbf57f00000000000,
    0xbf58f00000000000,
    0xbf59f00000000000,
    0xbf5af00000000000,
    0xbf5bf00000000000,
    0xbf5cf00000000000,
    0xbf5df00000000000,
    0xbf5ef00000000000,
    0xbf5ff00000000000,
    0xbf60780000000000,
    0xbf60f80000000000,
    0xbf61780000000000,
    0xbf61f80000000000,
    0xbf62780000000000,
    0xbf62f80000000000,
    0xbf63780000000000,
    0xbf63f00000000000,
    0xbf64700000000000,
    0xbf64f00000000000,
    0xbf65700000000000,
    0xbf65f00000000000,
    0xbf66700000000000,
    0xbf66f00000000000,
    0xbf67700000000000,
    0xbf67f00000000000,
    0xbf68700000000000,
    0xbf68f00000000000,
    0xbf69680000000000,
    0xbf69e80000000000,
    0xbf6a680000000000,
    0xbf6ae80000000000,
    0xbf6b680000000000,
    0xbf6be80000000000,
    0xbf6c680000000000,
    0xbf6ce80000000000,
    0xbf6d680000000000,
    0xbf6de00000000000,
    0xbf6e600000000000,
    0xbf6ee00000000000,
    0xbf6f600000000000,
    0xbf6fe00000000000,
    0xbf70300000000000,
    0xbf70700000000000,
    0xbf70b00000000000,
    0xbf70f00000000000,
    0xbf712c0000000000,
    0xbf716c0000000000,
    0xbf71ac0000000000,
    0xbf71ec0000000000,
    0xbf722c0000000000,
    0xbf726c0000000000,
    0xbf72ac0000000000,
    0xbf72e80000000000,
    0xbf73280000000000,
    0xbf73680000000000,
    0xbf73a80000000000,
    0xbf73e80000000000,
    0xbf74280000000000,
    0xbf74640000000000,
    0xbf74a40000000000,
    0xbf74e40000000000,
    0xbf75240000000000,
    0xbf75640000000000,
    0xbf75a40000000000,
    0xbf75e00000000000,
    0xbf76200000000000,
    0xbf76600000000000,
    0xbf76a00000000000,
    0xbf76e00000000000,
    0xbf77200000000000,
    0xbf775c0000000000,
    0xbf779c0000000000,
    0xbf77dc0000000000,
];

//def format_hex(value):
//     l = hex(value)[2:]
//     n = 8
//     x = [l[i:i + n] for i in range(0, len(l), n)]
//     return "0x" + "_".join(x) + "_u128"
// for i in range(129):
//     r = 2^-8 * round( 2^8 / (1 + i*2^(-7)) );
//     s, m, e = RealField(128)(r).log().sign_mantissa_exponent();
//     print("DyadicFloat {sign: DyadicDyadicSign::Pos, exponent: ", e, ",mantissa:", format_hex(m), "},");
#[rustfmt::skip]
pub(crate) static LOG1P_R1: [DyadicFloat128; 129] = [
DyadicFloat128 {sign: DyadicSign::Pos,exponent: 0,   mantissa: 0_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -134,mantissa: 0x8080abac_46f38946_662d417c_ed007a46_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -133,mantissa: 0x8102b2c4_9ac23a4f_91d082dc_e3ddcd38_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -133,mantissa: 0xc2492946_4655f45c_da5f3cc0_b3251dbd_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -132,mantissa: 0x820aec4f_3a222380_b9e3aea6_c444ef07_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -132,mantissa: 0xa33576a1_6f1f4c64_521016bd_904dc968_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -132,mantissa: 0xb3e4a796_a5dac208_27cca0bc_c06c2f92_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -132,mantissa: 0xd5779687_d887e0d1_a9dda170_56e45ed5_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -132,mantissa: 0xf7518e00_35c3dd83_606d8909_3278a939_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -131,mantissa: 0x8cb9de8a_32ab368a_a7c98595_30a45153_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -131,mantissa: 0x9defad3e_8f73217a_976d3b5b_45f6ca0b_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -131,mantissa: 0xa6988ae9_03f562ed_3e858f08_597b3a69_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -131,mantissa: 0xb8069857_560707a3_6a677b4c_8bec22e1_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -131,mantissa: 0xc99af2ea_ca4c4570_eaf51f66_692844ba_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -131,mantissa: 0xd273b205_8de1bd49_46bbf837_b4d320c6_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -131,mantissa: 0xe442c00d_e2591b47_196ab34c_e0bccd12_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -131,mantissa: 0xed393b1c_22351280_3f4e2e66_0317d55f_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -131,mantissa: 0xff4489ce_deab2ca6_c17bd40d_8d9291ec_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0x88bc7411_3f23def1_9c5a0fe3_96f40f1e_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0x8d515bf1_1fb94f1c_88713268_840cbcc0_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0x968b0864_3409ceb6_65c0da50_6a088484_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0x9b2fe580_ac80b17d_411a5b94_4aca8708_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0xa489ec19_9dab06f2_a9fb6cf0_ecb411b7_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0xa93f2f25_0dac67d1_cad2fb8d_48054ae0_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0xadfa035a_a1ed8fdc_149767e4_10316d2c_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0xb780945b_ab55dce4_34c7bc3d_32750fde_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0xbc4c6c2a_226399ef_8f6ebcfb_2016a439_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0xc5f57f59_c7f46155_aa8b6997_a402bf30_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0xcad2d6e7_b80bf914_2c507fb7_a3d0bf6a_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0xcfb62038_44b3209a_d0cb02f3_3f79c16c_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0xd98ec2ba_de71e539_58a98f2a_d65bee9b_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0xde8439c1_dec56877_4d57da94_5b5d0aaa_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0xe37fde37_807b84e3_4e9a750b_6b68781d_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0xe881bf93_2af3dac0_c524848e_3443e040_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0xf29877ff_38809091_3b020fa1_820c9492_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0xf7ad6f26_e7ff2ef7_54d2238f_75f969b1_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -130,mantissa: 0xfcc8e365_9d9bcbec_ca0cdf30_1431b60f_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0x80f572b1_363487b9_f5bd0b5b_3479d5f4_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0x86216b3b_0b17188b_163ceae8_8f720f1e_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0x88bc7411_3f23def1_9c5a0fe3_96f40f1e_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0x8b5ae65d_67db9acd_f7a51681_26a58b9a_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0x8dfccb1a_d35ca6ed_5147bdb6_ddcaf59c_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0x90a22b68_75c6a1f7_ae91aeba_609c8877_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0x934b1089_a6dc93c1_df5bb3b6_0554e152_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0x95f783e6_e49a9cfa_4a5004f3_ef063313_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0x9b5b3bb5_f088b766_d878bbe3_d392be25_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0x9e1293b9_998c1daa_5b035eae_273a855f_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xa0cda11e_af46390d_bb243827_3918db7e_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xa38c6e13_8e20d831_f698298a_dddd7f32_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xa64f04f0_b961df76_e4f5275c_2d15c21f_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xa9157039_c51ebe70_8164c759_686a2209_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xabdfba9e_468fd6f6_f72ea077_49ce6bd3_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xaeadeefa_caf97d35_7dd6e688_ebb13b03_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xb1801859_d56249dc_18ce51ff_f99479cd_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xb45641f4_e350a0d3_2756eba0_0bc33978_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xb7307735_78cb90b2_be1116c3_466beb6d_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xba0ec3b6_33dd8b09_49dc60b2_b059a60b_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xbcf13343_e7d9ec7d_2efd1778_1bb3afec_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xbfd7d1de_c0a8df6f_37eda996_244bccb0_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xc2c2abbb_6e5fd56f_33337789_d592e296_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xc5b1cd44_596fa51e_1a18fb8f_9f9ef280_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xc8a5431a_dfb44ca5_688ce7c1_a75e341a_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xcb9d1a18_9ab56e76_2d7e9307_c70c0668_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xcb9d1a18_9ab56e76_2d7e9307_c70c0668_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xce995f50_af69d861_ef2f3f4f_861ad6a9_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xd19a2011_27d3c645_7f9d79f5_1dcc7301_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xd49f69e4_56cf1b79_5f53bd2e_406e66e7_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xd7a94a92_466e833a_ad88bba7_d0cee8e0_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xdab7d022_31484a92_96c20cca_6efe2ac5_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xddcb08dc_0717d85b_f40a666c_87842843_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xe0e30349_fd1cec80_7fe8e180_2aba24d6_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xe0e30349_fd1cec80_7fe8e180_2aba24d6_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xe3ffce3a_2aa64922_3eadb651_b49ac53a_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xe72178c0_323a1a0f_304e1653_e71d9973_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xea481236_f7d35baf_e9a767a8_0d6d97e8_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xed73aa42_64b0ade9_4f91cf4b_33e42998_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xed73aa42_64b0ade9_4f91cf4b_33e42998_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xf0a450d1_39366ca6_fc66eb64_08ff6433_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xf3da161e_ed6b9aaf_ac8d42f7_8d3e65d3_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xf7150ab5_a09f27f4_5a470250_d40ebe90_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xf7150ab5_a09f27f4_5a470250_d40ebe90_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xfa553f70_18c966f2_b780a545_a1b54dcf_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -129,mantissa: 0xfd9ac57b_d244217e_8f05924d_258c14c5_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x8072d72d_903d588b_89d1b09c_70c4010a_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x8072d72d_903d588b_89d1b09c_70c4010a_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x821b05f3_b01d6774_030d58c3_f7e2ea1f_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x83c5f829_9e2b4091_20f6fafe_8fbb68b9_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x8573b716_82a7d21a_e21f9f89_c1ab80b2_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x8573b716_82a7d21a_e21f9f89_c1ab80b2_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x87244c30_8e670a66_01e005d0_6dbfa8f8_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x88d7c11e_3ad53cdc_223111a7_07b6de2c_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x88d7c11e_3ad53cdc_223111a7_07b6de2c_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x8a8e1fb7_94b09134_2eb628db_a173c82d_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x8c477207_91e53313_be2ad194_15fe25a5_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x8c477207_91e53313_be2ad194_15fe25a5_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x8e03c24d_73003959_bddae1cc_ce247838_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x8fc31afe_30b2c6de_9b00bf16_7e95da67_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x8fc31afe_30b2c6de_9b00bf16_7e95da67_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x918586c5_f5e4bf01_9b92199e_d1a4bab1_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x934b1089_a6dc93c1_df5bb3b6_0554e152_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x934b1089_a6dc93c1_df5bb3b6_0554e152_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x9513c368_76083695_f3cbc416_a2418012_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x96dfaabd_86fa1646_be1188fb_c94e2f15_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x96dfaabd_86fa1646_be1188fb_c94e2f15_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x98aed221_a03458b6_1d2f8932_1647b358_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x98aed221_a03458b6_1d2f8932_1647b358_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x9a81456c_ec642e0f_e549f9aa_ea3cb5e1_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x9c5710b8_cbb73a42_a2554b2d_d4619e63_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x9c5710b8_cbb73a42_a2554b2d_d4619e63_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x9e304061_b5fda919_30603d87_b6df81ad_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0x9e304061_b5fda919_30603d87_b6df81ad_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0xa00ce109_2e5498c3_67879c5a_30cd1242_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0xa00ce109_2e5498c3_67879c5a_30cd1242_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0xa1ecff97_c91e267b_0b7efae0_8e597e16_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0xa3d0a93f_45169a4a_83594fab_088c0d65_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0xa3d0a93f_45169a4a_83594fab_088c0d65_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0xa5b7eb7c_b860fb88_af6a62a0_dec6e073_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0xa5b7eb7c_b860fb88_af6a62a0_dec6e073_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0xa7a2d41a_d270c9d7_49362382_a768847a_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0xa7a2d41a_d270c9d7_49362382_a768847a_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0xa9917134_33c2b998_8ba4aea6_14d05701_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0xa9917134_33c2b998_8ba4aea6_14d05701_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0xab83d135_dc633301_7fe6607b_a902ef3c_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0xab83d135_dc633301_7fe6607b_a902ef3c_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0xad7a02e1_b24efd31_d60864fd_949b4bd3_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0xad7a02e1_b24efd31_d60864fd_949b4bd3_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0xaf741551_20c9011c_066d235e_e63073dd_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: -128,mantissa: 0xaf741551_20c9011c_066d235e_e63073dd_u128},
DyadicFloat128 {sign: DyadicSign::Pos,exponent: 0,   mantissa: 0_u128}
];

// -log(r) for the second step, generated by SageMath with:
// def format_hex(value):
//     l = hex(value)[2:]
//     n = 8
//     x = [l[i:i + n] for i in range(0, len(l), n)]
//     return "0x" + "_".join(x) + "_u128"
// for i in range(-91, 97):
//   r = 2^-18 * round( 2^18 / (1 + i*2^(-14)) );
//   s, m, e = RealField(128)(r).log().sign_mantissa_exponent();
//   print("{sign: DyadicDyadicSign::Pos," if (s == -1) else "{sign: DyadicDyadicSign::Neg, exponent: ", e, ", mantissa: "
//         format_hex(m), "},");
#[rustfmt::skip]
pub(crate) static LOG1P_R2: [DyadicFloat128; 188] = [
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0xb67dab2a_1a5742a4_a0e061c5_f7431c5e_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0xb4807f24_af682939_5d5bfe7b_969ed6ec_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0xb2834b35_b4d54d5f_4d08702d_dfabc23f_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0xb0860f5c_eba9be95_d4d36650_8b9953df_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0xae68f71a_a09e8847_ac18a289_f8f214a9_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0xac6baaee_d676e8f1_d5b42054_abb88c45_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0xaa6e56d8_7cd632d6_09809d58_ee484964_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0xa870fad7_54bb8791_b9e6fc7c_72f06d73_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0xa67396eb_1f231892_6f78d6d0_105c00e2_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0xa4762b13_9d0626e7_028f7126_29209148_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0xa258dfd1_0aedaa67_c98d898e_f172df02_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0xa05b63a3_73e60a83_fcc37c3c_3062bfa1_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0x9e5ddf89_cf42f501_3eb450db_05763c36_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0x9c605383_ddf1b88c_7146a86f_d458b775_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0x9a62bf91_60dcb286_c20a0c92_81474436_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0x986523b2_18eb4ed6_cdc57316_ec4aebc3_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0x96677fe5_c70207b9_c060dad7_4cef4273_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0x9449f92d_2ff44633_ed8def1a_3e433499_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0x924c4507_3220b5e0_3ce7a1f8_5c27b4fc_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0x904e88f3_68fea63f_f2ca8934_49f7f2cb_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0x8e50c4f1_956699ed_8d77d9fa_bd2853cf_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0x8c52f901_782e20ec_93e828d7_5b58ded4_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0x8a552522_d227d87a_9f9605b0_53c5acf0_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0x88574955_64236ae0_62a14939_3bca7241_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0x86398719_b66bac7c_aea6b56c_e89203d4_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0x843b9aef_044e4dcc_0242bd86_d00609b2_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0x823da6d4_c89c6927_daabf927_74bac84e_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -135, mantissa: 0x803faaca_c419abf2_a1c6f3fc_242ef8d0_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xfc834da1_6f0d9f57_a225ebc0_2e6d9dd4_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xf88735cc_c7433381_c33f6ad3_40ae18a9_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xf48b0e17_1249b6bc_70b2a4d3_8a242244_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xf08ed67f_d190e280_1d548190_48b811b0_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xec52ca07_ed95f236_9c21b650_afe9ede0_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xe85671ad_ecd28aac_935519c9_6d30e463_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xe45a0970_dc912ca7_ba88f6f2_e2672cfe_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xe05d9150_3e298bc8_0b1a8b84_657ae069_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xdc61094b_92ed70ef_ea3bff8d_197b20a1_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xd8647162_5c28b9e5_cdbb931d_6fecc249_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xd467c994_1b2158f5_d971d560_d5f00820_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xd06b11e0_51175493_75563561_244c090b_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xcc6e4a46_7f44c6fa_dc393c9a_3f3b380f_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xc831a4c6_f6fa709d_e6abe6e9_e4ee2096_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xc434bc61_24a0f16e_3ce3c822_8583a66e_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xc037c413_c61bfd93_b96a79f5_c5a4963a_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xbc3abbde_5c8d9bde_aaef2733_7008679f_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xb83da3c0_6911e509_a49a3fca_ddc8bc5a_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xb4407bb9_6cbf035a_e0254feb_785362fa_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xb04343c8_e8a53245_9893a4e2_5ab9dc95_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xac45fbee_5dcebe0b_5d8b0f40_a3708915_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xa848a429_4d40035d_5f4c11c2_c7a58c69_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xa44b3c79_37f76efd_b348cc5d_f706ffba_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0xa04dc4dd_9eed7d60_9159f2c5_5a18befd_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0x9c106456_3058bef3_bdfdee41_fe6a5a02_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0x9812cbe3_46475a24_4580ddf8_9853254d_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0x94152383_53489ffb_ac75e10d_61fc3ee8_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0x90176b35_d83ce8e2_cad9b30b_29736155_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0x8c19a2fa_55fe9b14_6f881deb_98fc45f3_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0x881bcad0_4d622a3e_70a04b63_b7248c96_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0x841de2b7_3f361722_b4823fb4_8035eddd_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -136, mantissa: 0x801feaae_ac42ef38_3364ccb5_b13cd47f_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -137, mantissa: 0xf843c56c_2a969897_e306977b_049f0ad5_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -137, mantissa: 0xf0479599_f617a843_e3c4d9e9_619bc045_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -137, mantissa: 0xe84b45e5_bc76702c_4356d525_b5e6432d_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -137, mantissa: 0xe04ed64e_7f14697a_7839dcd7_989339ab_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -137, mantissa: 0xd85246d3_3f47230b_4e21f045_ecb76f23_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -137, mantissa: 0xd0559772_fe5840b0_902e248d_d4ba9b28_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -137, mantissa: 0xc858c82c_bd857a72_a4444906_7ef92e01_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -137, mantissa: 0xc05bd8ff_7e009bd2_17926207_cc22e4e6_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -137, mantissa: 0xb85ec9ea_40ef8309_1c349622_f3fa5d82_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -137, mantissa: 0xafe1c6ec_e1a058dd_97fa2fd0_c9dc723e_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -137, mantissa: 0xa7e47606_048b1a65_983e8089_7cf1e60f_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -137, mantissa: 0x9fe70534_1d236102_7199cd06_ae5d39b3_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -137, mantissa: 0x97e97476_2c5e8f58_43cd18a7_2a051a96_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -137, mantissa: 0x8febc3cb_332616ff_7b6d1248_c3e1fd40_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -137, mantissa: 0x87edf332_325777c5_f5572a88_14c703af_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -138, mantissa: 0xffe00554_55887de0_26828c92_649a3a39_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -138, mantissa: 0xefe3e464_3a640cf3_82c550bd_1216d82a_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -138, mantissa: 0xdfe78392_14b4e8ae_da6959f7_f0e01bf0_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -138, mantissa: 0xcfeae2db_e5d6736d_da93e2fa_85a8f214_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -138, mantissa: 0xbfee023f_af0c2480_b47505bf_a5a03b06_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -138, mantissa: 0xaff0e1bb_718186ad_b1475a51_80a43520_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -138, mantissa: 0x9ff3814d_2e4a36b2_a8740b91_c95df537_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -138, mantissa: 0x8ff5e0f2_e661e1c6_57d895d3_5921b59c_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -139, mantissa: 0xfff00155_35588833_3c56c598_c659c2a3_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -139, mantissa: 0xdff3c0e4_97ea4eb1_2ef8ec33_ed9d782a_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -139, mantissa: 0xbff7008f_f5e0c257_379eba7e_6465ff63_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -139, mantissa: 0x9ff9c053_5073a370_3f972b78_3fcab757_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -140, mantissa: 0xfff80055_51558885_de026e27_1ee0549d_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -140, mantissa: 0xbffb8023_febc0c25_eceb47ea_01f6c632_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -141, mantissa: 0xfffc0015_54d55888_7333c578_57e1ed52_u128},
    DyadicFloat128 { sign: DyadicSign::Neg, exponent: -142, mantissa: 0xfffe0005_55455588_87dde026_fa704374_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: 0,    mantissa: 0_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -141, mantissa: 0x80010002_aab2aac4_44999abe_2fe2cc65_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -140, mantissa: 0x8002000a_aaeaac44_4eef3815_81464ccb_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -140, mantissa: 0xc0048024_01440c26_dfeb4850_85f6f454_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -139, mantissa: 0x8004002a_acaac445_99abe3be_3a1c6e93_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -139, mantissa: 0xa0064053_5a37a37a_6bc1e20e_ac8448b4_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -139, mantissa: 0xc0090090_0a20c275_979eedc0_64c242fd_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -139, mantissa: 0xe00c40e4_bd6e4efd_c72446cc_1bf728bd_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -138, mantissa: 0x800800aa_baac446e_f381b821_bbb569e5_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -138, mantissa: 0x900a20f3_19a3e273_569b26aa_a485ea5c_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -138, mantissa: 0xa00c814d_7c6a37f8_2dcf56c8_3c80b028_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -138, mantissa: 0xb00f21bb_e3e388ee_5f697682_84463b9b_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -138, mantissa: 0xc0120240_510c284c_b48ea6c0_5e2773a1_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -138, mantissa: 0xd01522dc_c4f87991_14d9d761_96d8043a_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -138, mantissa: 0xe0188393_40d4f241_e016a611_a4415d72_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -138, mantissa: 0xf01c2465_c5e61b6f_661e135f_49a47c40_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -137, mantissa: 0x801002ab_2ac4499a_be6bf0fa_435e8383_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -137, mantissa: 0x88121333_7898871e_9a31ba0c_bc030353_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -137, mantissa: 0x901443cc_cd362c9f_54b57dfe_0c4c840f_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -137, mantissa: 0x98169478_296fad41_7ad1e9c3_15328f7e_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -137, mantissa: 0xa0190536_8e2389b3_1f3f686c_f3d6be22_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -137, mantissa: 0xa81b9608_fc3c50ec_f105b66e_c4703ede_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -137, mantissa: 0xb01e46f0_74b0a0f3_610848c6_8df4d233_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -137, mantissa: 0xb7a0e9ed_7613acb0_2e0efddf_33a20464_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -137, mantissa: 0xbfa3d900_8e042ffb_c2cdb3c7_50f127b4_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -137, mantissa: 0xc7a6e82b_a36a7073_bd953378_6d3f4c49_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -137, mantissa: 0xcfaa176f_b76c8eb1_82e237c9_a4d450e3_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -137, mantissa: 0xd7ad66cd_cb3cbe14_c00b46a4_d0e3dfd0_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -137, mantissa: 0xdfb0d646_e0194584_ea999c0d_f8546710_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -137, mantissa: 0xe7b465db_f74c8032_cec6c2a9_ad974f4f_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -137, mantissa: 0xefb8158e_122cde5a_2d2045da_1570a07c_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -137, mantissa: 0xf7bbe55e_321ce603_6752e9b2_381e3edc_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -137, mantissa: 0xffbfd54d_588b33c5_3c1ed527_28e00e40_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0x83e1f2ae_43793dc3_493b0d87_3fb9a340_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0x87e40ac6_5f6cc4a0_29e38750_c9d26893_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0x8be632ef_80e9a0df_aab9e832_7258ac3f_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0x8fe86b2a_28bf51b3_28bc403d_8a5f3c63_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0x93eab376_d7c36377_f720c1c9_7227fcdc_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0x97ed0bd6_0ed17018_6ad9a3e3_d11b66c1_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0x9bef7448_4ecb1f6c_edb27b79_c90b4019_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0x9fb1c4cd_27012e19_a092a0d7_ab21722a_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xa3b44c65_b71c2d85_535d52f0_939a4d02_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xa7b6e412_cadcb3dc_90a57e11_edc1864e_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xabb98bd4_e33c4381_68e9c901_60031159_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xafbc43ac_813a6ea3_bf60594f_929adeb8_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xb3bf0b9a_25dcd7a2_8a421588_86775205_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xb7c1e39e_522f316d_1ab45417_663dee9e_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xbbc4cbb9_87433fe4_6c51ae3c_e1aea68a_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xbfc7c3ec_4630d83c_7c52ae8b_40ebabb7_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xc3cacc37_1015e15d_a857126f_7cfaaa67_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xc7cde49a_66165446_14d05662_cd29464a_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xcb90da16_44d29bb7_8379db06_ef3cd6bb_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xcf9411aa_99ddb7de_9025f4c6_7dd38bb6_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xd3975958_f681086d_d6f8a61c_892032ee_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xd79ab121_dbf8714c_9a2f20b4_e2332d47_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xdb9e1905_cb85ea59_3c767d61_f51d375b_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xdfa19105_46717fca_d4b2bd65_bb25493c_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xe3a51920_ce095292_c96c1254_a30ef91f_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xe7a8b158_e3a198be_73e324ce_0946b214_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xebac59ae_08949dd8_cacd125a_12bac62c_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xef6fd620_b2b7a503_cafdc272_27b71eaa_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xf3739daf_959aaafc_688d4282_f6026aa3_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xf777755d_03f4e0b6_e54e9e38_04464cdd_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xfb7b5d29_7f388a12_cb78b383_f4b59dce_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -136, mantissa: 0xff7f5515_88de024f_ee055fc5_15062c04_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0x81c1ae90_d131de38_207812b4_3382acdd_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0x83c3baa7_26a721cc_dc90c4c4_b61f3a87_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0x85c5cece_05941dbc_1a03f13f_b2c978b1_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0x87c7eb05_aec1304f_b36f282e_83a7dc36_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0x89a9eccd_56a980c0_d82a4661_6d4c393f_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0x8bac18a6_40185360_bc6ff847_13c9babd_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0x8dae4c90_b22574f4_9f7942a5_16fc2d8a_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0x8fb0888c_eda546ab_15e50cfd_9b29b427_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0x91b2cc9b_336f3718_9f465296_ae7dd49a_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0x93b518bb_c45dc268_b49c1eb9_b348e6e4_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0x95b76cee_e14e728e_daa320cd_64c9d9c7_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0x9799a333_de49b963_75a91950_ffe1e3b5_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0x999c070b_a32068cd_5c6abcbf_43f03f14_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0x9b9e72f6_b295ad4f_5a9e7f26_5d1ed157_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0x9da0e6f5_4d9318fd_efeb98d0_2a195c17_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0x9fa36307_b5054ca8_2aa503a3_110ab5a7_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0xa1a5e72e_29dbf808_d0fe7e05_869eb825_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0xa3884a68_a750cb10_e80a28f4_e1e500d2_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0xa58ade36_aeef9f0b_53106415_1ca6e30b_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0xa78d7a19_82c4b08f_27c01ffa_8e2e3c4b_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0xa9901e11_63cbbbf5_7ba9408d_c857d568_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0xab92ca1e_93038d76_104d1e33_31d3b4fa_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0xad957e41_516e0158_9343c846_fcdf9137_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0xaf780e79_b2514889_3977e89a_ec59bfa2_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0xb17ad246_ef3713bc_913d4e3d_c55c3e6e_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0xb37d9e2a_7a56b09d_777b52a9_e70d8bcc_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0xb5807224_94be0c91_55de916f_d30591de_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0xb7834e35_7f7e2600_e79cfb37_be2861e4_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0xb986325d_7bab0c89_90983104_d3805389_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0xbb68ef9c_254aa378_59e3b2ec_71ce64f4_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0xbd6be371_8c77636f_e83183bf_3dd612ef_u128},
    DyadicFloat128 { sign: DyadicSign::Pos, exponent: -135, mantissa: 0xbf6edf5e_c44d9d35_c4e3b0ac_2fd52b7f_u128},
];

// -log(r) for the third step, generated by SageMath with:
//
// for i in range(-69, 70):
//   r = 2^-21 * round( 2^21 / (1 + i*2^(-21)) );
//   s, m, e = RealField(128)(r).log().sign_mantissa_exponent();
//   print("{sign: DyadicDyadicSign::Pos," if (s == -1) else "{sign: DyadicDyadicSign::Neg, exponent: ", e, ", mantissa:"
//         format_hex(m), "},");
#[rustfmt::skip]
pub(crate) static LOGP1_R3: [DyadicFloat128; 139] =[
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -142, mantissa: 0x89ff6b38_d5de2622_e39d3faf_42340ed7_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -142, mantissa: 0x87ff6f80_ccb40f16_7ff33266_82c02485_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -142, mantissa: 0x85ff73b8_c3cdf731_5caf4fbe_343cf928_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -142, mantissa: 0x83ff77e0_bb2ade79_cdb6e554_348f7fe8_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -142, mantissa: 0x81ff7bf8_b2c9c4f6_0ef009c2_457de25d_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xffff0001_55535558_8883333c_57b57c74_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xfbff07f1_45931f44_f32668f3_9c70d183_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xf7ff0fc1_3650e7bd_459a73c6_a6486fe3_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xf3ff1771_278aaecd_37b18cca_7dd3a29f_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xefff1f01_193e7480_513f610d_21bcfc78_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xebff2671_0b6a38e1_ea190b95_c0690b7b_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xe7ff2dc0_fe0bfbfd_2a150f64_f0ad1743_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xe3ff34f0_f121bddd_090b5174_e995e9d1_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xdfff3c00_e4a97e8c_4ed512b9_b93ea2bf_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xdbff42f0_d8a13e15_934cea21_7ab794a2_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xd7ff49c0_cd06fc83_3e4ebe94_8afd2c76_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xd3ff5070_c1d8b9df_87b7c0f5_bcfee2e1_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xcfff5700_b7147634_77666622_8cb6371b_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xcbff5d70_acb8318b_e53a60f3_514db358_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xc7ff63c0_a2c1ebef_79149c3b_6e57fa86_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xc3ff69f0_992fa568_aad734c9_8416df2a_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xbfff7000_8fff5e00_c2657367_9ed28334_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xbbff75f0_872f15c0_d7a3c6db_6540809f_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xb7ff7bc0_7ebcccb1_d277bde6_45fb1aad_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xb3ff8170_76a682dc_6ac80145_a4087793_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xafff8700_6eea3849_287c4db3_0271e265_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xabff8c70_6785ed00_637d6de4_2eeb151e_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xa7ff91c0_6077a10a_43b5348b_6b898a8c_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0xa3ff96f0_59bd546e_c10e7657_978bd7f6_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0x9fff9c00_53550735_a37503f4_57310e59_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0x9bffa0f0_4d3cb966_82d5a40a_3aa022ff_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0x97ffa5c0_47726b08_c71e0d3e_e3df5f4d_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0x93ffaa70_41f41c23_a83ce035_2bdbd79b_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0x8fffaf00_3cbfccbe_2e21a18d_4680e8e4_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0x8bffb370_37d37cdf_30bcb3e4_e5dfbd28_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0x87ffb7c0_332d2c8d_57ff51d7_5c66d64a_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -143, mantissa: 0x83ffbbf0_2ecadbcf_1bdb87fd_be299f43_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -144, mantissa: 0xffff8000_55551555_88885dde_02700703_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -144, mantissa: 0xf7ff87e0_4d94724c_d259ca80_3a0c1870_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -144, mantissa: 0xefff8f80_464fce8f_e5141308_51c7070a_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -144, mantissa: 0xe7ff96e0_3f832a2a_30a16898_f3073a64_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -144, mantissa: 0xdfff9e00_392a8526_c4ed6451_7b2949ce_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -144, mantissa: 0xd7ffa4e0_3341df90_51e4fb4e_32cf6350_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -144, mantissa: 0xcfffab80_2dc53971_277672a8_8350bcce_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -144, mantissa: 0xc7ffb1e0_28b092d3_35915377_2a490f06_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -144, mantissa: 0xbfffb800_23ffebc0_0c265ece_6b481a0e_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -144, mantissa: 0xb7ffbde0_1faf4440_db2781c0_3fa132f6_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -144, mantissa: 0xafffc380_1bba9c5e_7287c95c_845ada33_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -144, mantissa: 0xa7ffc8e0_181df421_423b56b1_263e5a77_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -144, mantissa: 0x9fffce00_14d54b91_5a3752ca_4c076fa3_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -144, mantissa: 0x97ffd2e0_11dca2b6_6a71e2b2_7eb3f573_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -144, mantissa: 0x8fffd780_0f2ff997_c2e21b72_cff39d8f_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -144, mantissa: 0x87ffdbe0_0ccb503c_537ff612_feb7ac9e_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -145, mantissa: 0xffffc000_15554d55_58888733_33c57c18_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -145, mantissa: 0xefffc7c0_1193f9d1_fa514218_42311c42_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -145, mantissa: 0xdfffcf00_0e4aa5fa_2c4ed6de_475b942c_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -145, mantissa: 0xcfffd5c0_0b7151d8_ce77678c_bb6fcb88_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -145, mantissa: 0xbfffdc00_08fffd78_00c26629_a679ed3b_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -145, mantissa: 0xafffe1c0_06eea8e1_23287cb9_d3072728_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -145, mantissa: 0x9fffe700_0535541c_d5a37540_fd057315_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -145, mantissa: 0x8fffebc0_03cbff32_f82e21c1_fce36810_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -146, mantissa: 0xffffe000_05555455_5588887d_dde02702_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -146, mantissa: 0xdfffe780_0392aa14_9ac4ed72_adf5b295_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -146, mantissa: 0xbfffee00_023fffaf_000c2664_8066b482_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -146, mantissa: 0x9ffff380_014d552e_455a3754_b292c077_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -147, mantissa: 0xfffff000_01555535_55588888_33333c58_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -147, mantissa: 0xbffff700_008ffff5_e000c266_5736679f_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -148, mantissa: 0xfffff800_00555551_55558888_85ddde02_u128},
   DyadicFloat128 {sign: DyadicSign::Neg, exponent: -149, mantissa: 0xfffffc00_00155554_d5555888_88733334_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: 0,    mantissa: 0_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -148, mantissa: 0x80000200_000aaaaa_eaaaac44_444eeeef_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -147, mantissa: 0x80000400_002aaaac_aaaac444_459999ac_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -147, mantissa: 0xc0000900_0090000a_2000c266_7596679f_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -146, mantissa: 0x80000800_00aaaaba_aaac4444_6eeef381_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -146, mantissa: 0xa0000c80_014d557c_655a3755_f81815cc_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -146, mantissa: 0xc0001200_02400051_000c2668_4c66b482_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -146, mantissa: 0xe0001880_0392ab40_bac4ed7c_40fb07eb_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -145, mantissa: 0x80001000_02aaab2a_aac44449_999abe2c_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -145, mantissa: 0x90001440_03cc00cd_082e21d7_9cbb6812_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -145, mantissa: 0xa0001900_0535568d_d5a37569_adb01dc3_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -145, mantissa: 0xb0001e40_06eeac74_33287d01_e8c9d1d9_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -145, mantissa: 0xc0002400_09000288_00c266a3_2679ed48_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -145, mantissa: 0xd0002a40_0b7158d1_de776851_22b2764b_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -145, mantissa: 0xe0003100_0e4aaf5b_2c4ed810_a8063f03_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -145, mantissa: 0xf0003840_1194062e_0a5143e7_be891c8f_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -144, mantissa: 0x80002000_0aaaaeaa_ac4444ee_ef3813a1_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -144, mantissa: 0x88002420_0ccb5a6e_5b7ff7fe_1339025b_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -144, mantissa: 0x90002880_0f300668_42e21e26_caf39e33_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -144, mantissa: 0x98002d20_11dcb29e_f271e66f_a5554bc6_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -144, mantissa: 0xa0003200_14d55f19_5a3757e0_615cc676_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -144, mantissa: 0xa8003720_181e0bde_ca3b5d82_10ca5cab_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -144, mantissa: 0xb0003c80_1bbab8f6_f287d25f_3cb032bb_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -144, mantissa: 0xb8004220_1faf6669_e3278d84_0be28cdb_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -144, mantissa: 0xc0004800_24001440_0c266dfe_6b482076_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -144, mantissa: 0xc8004e20_28b0c282_3d9166de_380a6d3d_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -144, mantissa: 0xd0005480_2dc57139_a7768b35_6ba61e4b_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -144, mantissa: 0xd8005b20_3342206f_d9e51a18_49db73c1_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -144, mantissa: 0xe0006200_392ad02e_c4ed8a9d_907eb521_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -144, mantissa: 0xe8006920_3f838080_b8a197de_a928acd7_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -144, mantissa: 0xf0007080_46503170_65144cf7_dcc72d3b_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -144, mantissa: 0xf8007820_4d94e308_da5a1108_890d9f6a_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0x80004000_2aaacaaa_c4445999_abe2ce2c_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0x84004410_2ecb2431_1fdbbb4f_3bffc832_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0x88004840_332d7e1d_97ff8f39_ec91b4ee_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0x8c004c90_37d3d876_74bcfcf0_b3f0a95d_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0x90005100_3cc03342_2e21f80c_a6813aff_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0x94005590_41f48e87_6c3d4629_170ce87f_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0x98005a40_4772ea4d_071e84e3_b80a8881_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0x9c005f10_4d3d469a_06d62fdc_bdd6bec3_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xa0006400_5355a375_a375a6b7_01dc77c0_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xa4006910_59be00e7_450f3318_26ad6b05_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xa8006e40_60785ef6_83b60ea8_bd0aa459_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xac007390_6786bdab_277e6914_69dd13f5_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xb0007900_6eeb1d0d_287d6e0a_0d1e25eb_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xb4007e90_76a77d24_aec94b3b_e9b060f5_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xb8008440_7ebdddfa_1279365f_ce280cce_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xbc008a10_87303f95_dba5732f_3e83e04a_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xc0009000_9000a200_c2675967_9ed5b754_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xc4009610_99310543_aed95aca_5edb5109_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xc8009c40_a2c36967_b917091d_2687160f_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xcc00a290_acb9ce76_293d1c2a_0378e75d_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xd000a900_b7163478_776977bf_9766f5a7_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xd400af90_c1da9b78_4bbb31b1_4776a18b_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xd800b640_cd09037f_7e5297d7_6c8564ba_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xdc00bd10_d8a36c98_1751360f_8461c447_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xe000c400_e4abd6cc_4ed9dc3c_63f44c41_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xe400cb10_f1244226_8d10a446_6a5894d5_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xe800d240_fe0eaeb1_6a1af81b_b4e6510e_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xec00d991_0b6d1c77_ae1f97b0_542a677a_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xf000e101_19418b84_51469efe_81d014cc_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xf400e891_278dfbe2_7bb98c06_d77a18b4_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xf800f041_36546d9d_85a344d0_868bed17_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -143, mantissa: 0xfc00f811_4596e0c0_f7301d69_90e307cc_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -142, mantissa: 0x80008000_aaabaaac_4446eef3_8140138f_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -142, mantissa: 0x82008408_b2cbe5b8_10f5e432_96105497_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -142, mantissa: 0x84008820_bb2d2189_edbd4f83_ef63f730_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -142, mantissa: 0x86008c48_c3d05e27_feb654fd_541c638e_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -142, mantissa: 0x88009080_ccb69b98_7ffadeb8_882f7674_u128},
   DyadicFloat128 {sign: DyadicSign::Pos, exponent: -142, mantissa: 0x8a0094c8_d5e0d9e1_c5a59fd3_6bd44397_u128},
];
