/* <<< Start of information >>>                                             */
/* This file is part of the xplot program, a plot program for               */
/* tabulated functions which works under X.                                 */
/*                                                                          */
/* Copyright (c) ICCE / Karel Kubat 1995. All rights reserved.              */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */

#include "xplot.h"

void redraw (FL_OBJECT *plobj, FL_FORM *plform)
{
    register int
	points,
	p,
	i;
    float
	dummy = 0;
    static char
	oldtitlestring [256];

    fl_freeze_form (plform);			    /* don't plot now */

    for (i = 0; i < ndata; i++)			    /* delete all datasets */ 
	fl_delete_xyplot_overlay (plobj, i + 1);

    fl_set_xyplot_xbounds (plobj, curminx, curmaxx); /* new boundaries */ 
    fl_set_xyplot_ybounds (plobj, curminy, curmaxy);

    /* plot dummy as `main' function */
    fl_set_xyplot_data (plobj, &dummy, &dummy, 1, "", "", "");
    
    for (i = 0; i < ndata; i++)
    {
	if (! data [i].active)			    /* add dummy for nonact */
	{
	    fl_add_xyplot_overlay (plobj, i + 1, &dummy, &dummy, 1,
				   data [i].color);
	    continue;
	}
						    /* add active dataset */
	fl_add_xyplot_overlay (plobj, i + 1, data [i].x, data [i].y,
			       data [i].npoints, data [i].color);

	if (linetype == LINETYPE_GUESS)		    /* determine linestyle */ 
	{
	    points = 0;
	    for (p = 0; p < data [i].npoints; p++)
	    {
		if (data [i].x [p] >= curminx &&
		    data [i].x [p] <= curmaxx
		   )
		{
		    points++;
		    if (points > 20)
		    {
			fl_set_xyplot_overlay_type (plobj, i + 1,
						    FL_NORMAL_XYPLOT);
			break;
		    }
		}
	    }
	    if (points < 20)
		fl_set_xyplot_overlay_type (plobj, i + 1, FL_CIRCLE_XYPLOT);
	}
	else
	    fl_set_xyplot_overlay_type (plobj, i + 1, linetype);
    }

    /* add title if any */
    if (oldtitlestring [0])
	fl_delete_xyplot_text (plobj, oldtitlestring);
    
    if (titlestring [0])
	fl_add_xyplot_text (plobj,
			    (curminx + curmaxx) / 2, curmaxy,
			    titlestring,
			    FL_ALIGN_BOTTOM, FL_BLACK);
    strcpy (oldtitlestring, titlestring);
    
    fl_unfreeze_form (plform);			    /* plot it now */
}
